/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.definitions.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobManagerConstants;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;

/**
 * Implements the handling of HTTP requests to retrieve a data object type definition. <br>
 * 
 * URL pattern: <code>smila/jobmanager/dataobjecttypes/-dotname-/</code> <br>
 * 
 * Methods allowed: <code>GET</code>
 */
public class DataObjectTypeHandler extends AJobManagerHandler {

  /**
   * {@inheritDoc}
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord) throws Exception {
    final String name = getName(requestUri);
    boolean returnDetails = false;
    final DefinitionPersistence defPersistence = getDefinitionPersistence();
    if (inputRecord != null && inputRecord.getMetadata().containsKey(JobManagerConstants.KEY_RETURN_DETAILS)) {
      returnDetails =
        inputRecord.getMetadata().getBooleanValue(JobManagerConstants.KEY_RETURN_DETAILS).booleanValue();
    }
    final DataObjectTypeDefinition dot = defPersistence.getDataObjectType(name);
    if (dot == null) {
      throw new ConfigNotFoundException("Data object type '" + name + "' not found.");
    }
    return dot.toAny(returnDetails);
  }

  /**
   * Gets the DataObjectType name from the requestUri.
   * 
   * @param requestUri
   *          the request URI.
   * @return he DataObjectType name from the requestUri.
   */
  private String getName(final String requestUri) {
    final List<String> uriParts = getDynamicUriParts(requestUri);
    if (uriParts.size() > 0) {
      return uriParts.get(0);
    }
    throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + getUriPattern() + "'.");
  }

}
