/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client;

import java.util.Map;

import org.apache.http.entity.mime.content.ContentBody;

/**
 * To add attachments to requests using the {@link RestClient}, use an object that implements this interface.
 * Some implementations can be found in package <tt>org.eclipse.smila.http.client.attachments</tt>.
 * 
 * See <a href="http://hc.apache.org/httpcomponents-client-ga/httpmime/apidocs/index.html">HttpMime Javadoc</a> for
 * details on the underlying Apache HttpClient classes used to implement requests with attachments.
 */
public interface Attachments {
  /** MIME type of attachments. */
  String MIMETYPE_ATTACHMENT = "application/octet-stream";

  /**
   * Get attachments parts to add to a multipart request. The keys of the returned map are the attachment names. The
   * values can wrap different kinds of attachment objects, for example simple <tt>byte{]</tt> objects or
   * <tt>java.io.InputStream</tt>s.
   * 
   * @return map of attachment names and values.
   */
  Map<String, ContentBody> getAttachmentParts();

}
