/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.httphandler;

import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;

public class PipelinesHandler
extends JsonRequestHandler {
    public static final String EXCEPTION_MESSAGE = "There is no definition for given pipeline";
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private WorkflowProcessor _processor;

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        String requestHost = this.getRequestHost(exchange);
        if ("POST".equals(method)) {
            return this.definePipeline(requestHost, requestUri, inputRecord);
        }
        return this.getPipelineList(requestHost, requestUri);
    }

    private Object getPipelineList(String requestHost, String requestUri) throws MalformedURLException {
        AnyMap result = FACTORY.createAnyMap();
        AnySeq pipelines = FACTORY.createAnySeq();
        List<String> names = this._processor.getWorkflowNames();
        for (String name : names) {
            AnyMap pipeline = FACTORY.createAnyMap();
            pipeline.put("name", name);
            pipeline.put("url", URLCreator.create((String)requestHost, (String)requestUri, (String)name).toString());
            pipelines.add((Object)pipeline);
        }
        result.put("pipelines", (Any)pipelines);
        return result;
    }

    private Object definePipeline(String requestHost, String requestUri, Record inputRecord) throws ProcessingException, MalformedURLException {
        if (inputRecord == null) {
            throw new IllegalArgumentException("Empty request not allowed.");
        }
        AnyMap definition = inputRecord.getMetadata();
        String workflowName = definition.getStringValue("name");
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Adding/Updating pipeline: " + workflowName));
        }
        this._processor.setWorkflowDefinition(workflowName, definition);
        AnyMap result = DataFactory.DEFAULT.createAnyMap();
        result.put("name", workflowName);
        if (definition.containsKey((Object)"timestamp")) {
            result.put("timestamp", (Any)definition.get((Object)"timestamp"));
        }
        result.put("url", URLCreator.create((String)requestHost, (String)requestUri, (String)workflowName).toExternalForm());
        return result;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof ProcessingException) {
            return ((ProcessingException)((Object)ex)).isRecoverable() ? 500 : 400;
        }
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        if ("POST".equals(method)) {
            return 201;
        }
        return super.getSuccessStatus(method, requestUri);
    }

    public void setProcessor(WorkflowProcessor processor) {
        this._processor = processor;
    }

    public void unsetProcessor(WorkflowProcessor processor) {
        if (this._processor == processor) {
            this._processor = null;
        }
    }
}

