/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;

abstract class DocSetBase
implements DocSet {
    DocSetBase() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocSet)) {
            return false;
        }
        DocSet other = (DocSet)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this instanceof DocList && other instanceof DocList) {
            DocIterator i1 = this.iterator();
            DocIterator i2 = other.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (i1.nextDoc() == i2.nextDoc()) continue;
                return false;
            }
            return true;
        }
        return this.getBits().equals((Object)other.getBits());
    }

    public void add(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    public void addUnique(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    public OpenBitSet getBits() {
        OpenBitSet bits = new OpenBitSet();
        DocIterator iter = this.iterator();
        while (iter.hasNext()) {
            bits.set((long)iter.nextDoc());
        }
        return bits;
    }

    public DocSet intersection(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersection(this);
        }
        OpenBitSet newbits = (OpenBitSet)this.getBits().clone();
        newbits.and(other.getBits());
        return new BitDocSet(newbits);
    }

    public DocSet union(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.getBits().clone();
        newbits.or(other.getBits());
        return new BitDocSet(newbits);
    }

    public int intersectionSize(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersectionSize(this);
        }
        return this.intersection(other).size();
    }

    public int unionSize(DocSet other) {
        return this.size() + other.size() - this.intersectionSize(other);
    }

    public DocSet andNot(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.getBits().clone();
        newbits.andNot(other.getBits());
        return new BitDocSet(newbits);
    }

    public int andNotSize(DocSet other) {
        return this.size() - this.intersectionSize(other);
    }

    public Filter getTopFilter() {
        final OpenBitSet bs = this.getBits();
        return new Filter(){

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                int offset = 0;
                SolrIndexReader r = (SolrIndexReader)reader;
                while (r.getParent() != null) {
                    offset += r.getBase();
                    r = r.getParent();
                }
                if (r == reader) {
                    return bs;
                }
                final int base = offset;
                int maxDoc = reader.maxDoc();
                final int max = base + maxDoc;
                return new DocIdSet(){

                    public DocIdSetIterator iterator() throws IOException {
                        return new DocIdSetIterator(){
                            int pos;
                            int adjustedDoc;
                            {
                                this.pos = base - 1;
                                this.adjustedDoc = -1;
                            }

                            public int docID() {
                                return this.adjustedDoc;
                            }

                            public int nextDoc() throws IOException {
                                this.pos = bs.nextSetBit(this.pos + 1);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }

                            public int advance(int target) throws IOException {
                                if (target == Integer.MAX_VALUE) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.pos = bs.nextSetBit(target + base);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }
                        };
                    }

                    public boolean isCacheable() {
                        return true;
                    }
                };
            }
        };
    }
}

