/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.epr;

import java.util.HashMap;
import java.util.Map;
import org.apache.ode.il.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class URLEndpoint
implements MutableEndpoint {
    private String _url;

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String string) {
        this._url = string;
    }

    public boolean accept(Node node) {
        if (node.getNodeType() == 3) {
            return true;
        }
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if (element.getLocalName().equals("address") && element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
                return true;
            }
            if (element.getLocalName().equals("service-ref") && (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || element.getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/serviceref"))) {
                if (DOMUtils.getFirstChildElement((Element)element) == null) {
                    return true;
                }
                if ((element = DOMUtils.getFirstChildElement((Element)element)).getLocalName().equals("address") && element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
                    return true;
                }
            }
        }
        return false;
    }

    public void set(Node node) {
        if (node.getNodeType() == 3) {
            this._url = ((Text)node).getWholeText();
        } else if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
                this._url = element.getAttribute("location");
            } else if (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || element.getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/serviceref")) {
                if (DOMUtils.getFirstChildElement((Element)element) == null) {
                    this._url = element.getTextContent();
                } else {
                    element = DOMUtils.getFirstChildElement((Element)element);
                    this._url = element.getAttribute("location");
                }
            }
        }
    }

    public Document toXML() {
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        document.appendChild(element);
        Text text = document.createTextNode(this._url);
        element.appendChild(text);
        return document;
    }

    public Map toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("address", this._url);
        return hashMap;
    }

    public void fromMap(Map map) {
        this._url = (String)map.get("address");
    }
}

