/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;

public final class SQLDecimal
extends NumberDataType
implements VariableSizeDataValue {
    private static final BigDecimal ZERO;
    private static final BigDecimal ONE;
    static final BigDecimal MAXLONG_PLUS_ONE;
    static final BigDecimal MINLONG_MINUS_ONE;
    private BigDecimal value;
    private byte[] rawData;
    private int rawScale;
    private static final int BASE_MEMORY_USAGE;
    private static final int BIG_DECIMAL_MEMORY_USAGE;
    private static final Method toPlainString;
    private static final Method bdPrecision;

    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += BIG_DECIMAL_MEMORY_USAGE + (this.value.unscaledValue().bitLength() + 8) / 8;
        }
        if (null != this.rawData) {
            sz += this.rawData.length;
        }
        return sz;
    }

    public SQLDecimal() {
    }

    public SQLDecimal(BigDecimal val) {
        this.value = val;
    }

    public SQLDecimal(BigDecimal val, int nprecision, int scale) throws StandardException {
        this.value = val;
        if (this.value != null && scale >= 0) {
            this.value = this.value.setScale(scale, 1);
        }
    }

    public SQLDecimal(String val) {
        this.value = new BigDecimal(val);
    }

    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                return (int)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "INTEGER");
    }

    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -128L && lv <= 127L) {
                return (byte)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "TINYINT");
    }

    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -32768L && lv <= 32767L) {
                return (short)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "SMALLINT");
    }

    public long getLong() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return 0L;
        }
        if (localValue.compareTo(MINLONG_MINUS_ONE) == 1 && localValue.compareTo(MAXLONG_PLUS_ONE) == -1) {
            return localValue.longValue();
        }
        throw StandardException.newException("22003", "BIGINT");
    }

    public float getFloat() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return 0.0f;
        }
        float value = NumberDataType.normalizeREAL(localValue.floatValue());
        return value;
    }

    public double getDouble() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return 0.0;
        }
        double value = NumberDataType.normalizeDOUBLE(localValue.doubleValue());
        return value;
    }

    private BigDecimal getBigDecimal() {
        if (this.value == null && this.rawData != null) {
            this.value = new BigDecimal(new BigInteger(this.rawData), this.rawScale);
        }
        return this.value;
    }

    public int typeToBigDecimal() {
        return 3;
    }

    public boolean getBoolean() {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return false;
        }
        return localValue.compareTo(ZERO) != 0;
    }

    public String getString() {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return null;
        }
        if (toPlainString == null) {
            return localValue.toString();
        }
        try {
            return (String)toPlainString.invoke((Object)localValue, null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError("toPlainString");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IncompatibleClassChangeError("toPlainString");
        }
    }

    public Object getObject() {
        return this.getBigDecimal();
    }

    void setObject(Object theValue) throws StandardException {
        this.setValue((BigDecimal)theValue);
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setCoreValue(SQLDecimal.getBigDecimal(theValue));
    }

    public int getLength() {
        return this.getDecimalValuePrecision();
    }

    public String getTypeName() {
        return "DECIMAL";
    }

    public int getTypeFormatId() {
        return 200;
    }

    public boolean isNull() {
        return this.value == null && this.rawData == null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] byteArray;
        int scale;
        SanityManager.ASSERT(!this.isNull());
        if (this.value != null) {
            scale = this.value.scale();
            if (scale < 0) {
                scale = 0;
                this.value = this.value.setScale(0);
            }
            BigInteger bi = this.value.unscaledValue();
            byteArray = bi.toByteArray();
        } else {
            scale = this.rawScale;
            byteArray = this.rawData;
        }
        if (scale < 0) {
            SanityManager.THROWASSERT("DECIMAL scale at writeExternal is negative " + scale + " value " + this.toString());
        }
        out.writeByte(scale);
        out.writeByte(byteArray.length);
        out.write(byteArray);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.value = null;
        this.rawScale = in.readUnsignedByte();
        int size = in.readUnsignedByte();
        if (this.rawData == null || size != this.rawData.length) {
            this.rawData = new byte[size];
        }
        in.readFully(this.rawData);
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = null;
        this.rawScale = in.readUnsignedByte();
        int size = in.readUnsignedByte();
        if (this.rawData == null || size != this.rawData.length) {
            this.rawData = new byte[size];
        }
        in.readFully(this.rawData);
    }

    public void restoreToNull() {
        this.value = null;
        this.rawData = null;
    }

    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        BigDecimal otherValue = SQLDecimal.getBigDecimal(arg);
        return this.getBigDecimal().compareTo(otherValue);
    }

    public DataValueDescriptor getClone() {
        return new SQLDecimal(this.getBigDecimal());
    }

    public DataValueDescriptor getNewNull() {
        return new SQLDecimal();
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getBigDecimal(colNumber);
        this.rawData = null;
    }

    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 3);
            return;
        }
        ps.setBigDecimal(position, this.getBigDecimal());
    }

    public void setValue(String theValue) throws StandardException {
        this.rawData = null;
        if (theValue == null) {
            this.value = null;
        } else {
            try {
                theValue = theValue.trim();
                this.value = new BigDecimal(theValue);
                this.rawData = null;
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
        }
    }

    public void setValue(double theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(theValue));
    }

    public void setValue(float theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(theValue));
    }

    public void setValue(long theValue) {
        this.value = BigDecimal.valueOf(theValue);
        this.rawData = null;
    }

    public void setValue(int theValue) {
        this.setValue((long)theValue);
    }

    public void setBigDecimal(Number theValue) throws StandardException {
        this.setCoreValue((BigDecimal)theValue);
    }

    public void setValue(Number theValue) throws StandardException {
        if (theValue != null && !(theValue instanceof BigDecimal) && !(theValue instanceof Long)) {
            SanityManager.THROWASSERT("SQLDecimal.setValue(Number) passed a " + theValue.getClass());
        }
        if (theValue instanceof BigDecimal || theValue == null) {
            this.setCoreValue((BigDecimal)theValue);
        } else {
            this.setValue(theValue.longValue());
        }
    }

    public void setValue(boolean theValue) {
        this.setCoreValue(theValue ? ONE : ZERO);
    }

    public int typePrecedence() {
        return 70;
    }

    private void setCoreValue(BigDecimal theValue) {
        this.value = theValue;
        this.rawData = null;
    }

    private void setCoreValue(double theValue) {
        this.value = new BigDecimal(Double.toString(theValue));
        this.rawData = null;
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredScale = desiredType.getScale();
        int desiredPrecision = desiredType.getPrecision();
        this.setFrom(source);
        this.setWidth(desiredPrecision, desiredScale, true);
    }

    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(addend1).add(SQLDecimal.getBigDecimal(addend2)));
        return result;
    }

    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(left).subtract(SQLDecimal.getBigDecimal(right)));
        return result;
    }

    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(left).multiply(SQLDecimal.getBigDecimal(right)));
        return result;
    }

    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        return this.divide(dividend, divisor, result, -1);
    }

    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result, int scale) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        BigDecimal divisorBigDecimal = SQLDecimal.getBigDecimal(divisor);
        if (divisorBigDecimal.compareTo(ZERO) == 0) {
            throw StandardException.newException("22012");
        }
        BigDecimal dividendBigDecimal = SQLDecimal.getBigDecimal(dividend);
        result.setBigDecimal(dividendBigDecimal.divide(divisorBigDecimal, scale > -1 ? scale : Math.max(dividendBigDecimal.scale() + SQLDecimal.getWholeDigits(divisorBigDecimal) + 1, 4), 1));
        return result;
    }

    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(this.getBigDecimal().negate());
        return result;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.getBigDecimal().compareTo(ZERO) == -1;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getString();
    }

    public int hashCode() {
        long longVal;
        double doubleVal;
        BigDecimal localValue = this.getBigDecimal();
        double d = doubleVal = localValue != null ? localValue.doubleValue() : 0.0;
        if (Double.isInfinite(doubleVal)) {
            longVal = localValue.longValue();
        } else {
            longVal = (long)doubleVal;
            if ((double)longVal != doubleVal) {
                longVal = Double.doubleToLongBits(doubleVal);
            }
        }
        return (int)(longVal ^ longVal >> 32);
    }

    public void setWidth(int desiredPrecision, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (desiredPrecision != -1 && desiredPrecision - desiredScale < SQLDecimal.getWholeDigits(this.getBigDecimal())) {
            throw StandardException.newException("22003", "DECIMAL/NUMERIC(" + desiredPrecision + "," + desiredScale + ")");
        }
        this.value = this.value.setScale(desiredScale, 1);
        this.rawData = null;
    }

    public int getDecimalValuePrecision() {
        if (this.isNull()) {
            return 0;
        }
        BigDecimal localValue = this.getBigDecimal();
        return SQLDecimal.getWholeDigits(localValue) + this.getDecimalValueScale();
    }

    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        if (this.value == null) {
            return this.rawScale;
        }
        int scale = this.value.scale();
        if (scale >= 0) {
            return scale;
        }
        return 0;
    }

    public static BigDecimal getBigDecimal(DataValueDescriptor value) throws StandardException {
        if (value.isNull()) {
            SanityManager.THROWASSERT("NULL value passed to SQLDecimal.getBigDecimal");
        }
        switch (value.typeToBigDecimal()) {
            case 3: {
                return (BigDecimal)value.getObject();
            }
            case 1: {
                try {
                    return new BigDecimal(value.getString().trim());
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", "java.math.BigDecimal");
                }
            }
            case -5: {
                return BigDecimal.valueOf(value.getLong());
            }
        }
        SanityManager.THROWASSERT("invalid return from " + value.getClass() + ".typeToBigDecimal() " + value.typeToBigDecimal());
        return null;
    }

    private static int getWholeDigits(BigDecimal decimalValue) {
        if (ONE.compareTo(decimalValue = decimalValue.abs()) == 1) {
            return 0;
        }
        if (bdPrecision != null) {
            try {
                int precision = (Integer)bdPrecision.invoke((Object)decimalValue, null);
                return precision - decimalValue.scale();
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError("precision");
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IncompatibleClassChangeError("precision");
            }
        }
        String s = decimalValue.toString();
        return decimalValue.scale() == 0 ? s.length() : s.indexOf(46);
    }

    static {
        Method m;
        ZERO = BigDecimal.valueOf(0L);
        ONE = BigDecimal.valueOf(1L);
        MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(ONE);
        MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(ONE);
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDecimal.class);
        BIG_DECIMAL_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(BigDecimal.class);
        try {
            m = BigDecimal.class.getMethod("toPlainString", null);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        toPlainString = m;
        try {
            m = BigDecimal.class.getMethod("precision", null);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        bdPrecision = m;
    }
}

