/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.io.StorageFile;

public final class DataStore {
    private static final char SEP = PathUtil.SEP;
    private static final String[] EMPTY_STR_ARR = new String[0];
    private final Object LOCK = new Object();
    private final Object TMP_COUNTER_LOCK = new Object();
    private final Map files = new HashMap(80);
    private final String databaseName;
    private long tmpFileCounter = 0L;

    public DataStore(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreEntry createEntry(String iPath, boolean isDir) {
        String nPath = new File(iPath).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.files.containsKey(nPath)) {
                return null;
            }
            String[] parents = this.getParentList(nPath);
            for (int i = parents.length - 1; i >= 0; --i) {
                DataStoreEntry entry = (DataStoreEntry)this.files.get(parents[i]);
                if (entry == null) {
                    return null;
                }
                if (entry.isDirectory()) continue;
                return null;
            }
            DataStoreEntry newEntry = new DataStoreEntry(nPath, isDir);
            this.files.put(nPath, newEntry);
            return newEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createAllParents(String path) {
        String nPath = new File(path).getPath();
        String[] parents = this.getParentList(nPath);
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = parents.length - 1; i >= 0; --i) {
                String subPath = parents[i];
                DataStoreEntry entry = (DataStoreEntry)this.files.get(subPath);
                if (entry == null) {
                    this.createEntry(subPath, true);
                    continue;
                }
                if (entry.isDirectory()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(String iPath) {
        DataStoreEntry entry;
        String nPath = new File(iPath).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            entry = (DataStoreEntry)this.files.remove(nPath);
            if (entry != null) {
                String[] children;
                if (entry.isDirectory() && (children = this.listChildren(nPath)).length > 0) {
                    this.files.put(nPath, entry);
                    return false;
                }
                entry.release();
            }
        }
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreEntry getEntry(String iPath) {
        Object object = this.LOCK;
        synchronized (object) {
            return (DataStoreEntry)this.files.get(new File(iPath).getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAll(String iPath) {
        String nPath = new File(iPath).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            DataStoreEntry entry = (DataStoreEntry)this.files.remove(nPath);
            if (entry == null) {
                return false;
            }
            if (entry.isDirectory()) {
                return this._deleteAll(nPath);
            }
            entry.release();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listChildren(String iPath) {
        if (iPath.equals("")) {
            throw new IllegalArgumentException("The empty string is not a valid path");
        }
        String nPath = new File(iPath).getPath();
        if (nPath.charAt(nPath.length() - 1) != SEP) {
            nPath = nPath + SEP;
        }
        ArrayList<String> children = new ArrayList<String>();
        Object object = this.LOCK;
        synchronized (object) {
            Iterator paths = this.files.keySet().iterator();
            while (paths.hasNext()) {
                String candidate = (String)paths.next();
                if (!candidate.startsWith(nPath)) continue;
                children.add(candidate.substring(nPath.length()));
            }
        }
        return children.toArray(EMPTY_STR_ARR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(StorageFile currentFile, StorageFile newFile) {
        String currentPath = new File(currentFile.getPath()).getPath();
        String newPath = new File(newFile.getPath()).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.files.containsKey(newPath)) {
                return false;
            }
            DataStoreEntry current = (DataStoreEntry)this.files.remove(currentPath);
            if (current == null) {
                return false;
            }
            this.files.put(newPath, current);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this.LOCK;
        synchronized (object) {
            Iterator fileIter = this.files.values().iterator();
            while (fileIter.hasNext()) {
                ((DataStoreEntry)fileIter.next()).release();
            }
            this.files.clear();
        }
    }

    private boolean _deleteAll(String prefixPath) {
        if (prefixPath.charAt(prefixPath.length() - 1) != SEP) {
            prefixPath = prefixPath + SEP;
        }
        ArrayList<String> toDelete = new ArrayList<String>();
        Iterator paths = this.files.keySet().iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            if (!path.startsWith(prefixPath)) continue;
            toDelete.add(path);
        }
        Iterator keys = toDelete.iterator();
        while (keys.hasNext()) {
            DataStoreEntry entry = (DataStoreEntry)this.files.remove((String)keys.next());
            entry.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTempFileCounter() {
        Object object = this.TMP_COUNTER_LOCK;
        synchronized (object) {
            return ++this.tmpFileCounter;
        }
    }

    private String[] getParentList(String path) {
        ArrayList<String> parents = new ArrayList<String>();
        String parent = path;
        while ((parent = new File(parent).getParent()) != null) {
            parents.add(parent);
        }
        return parents.toArray(new String[parents.size()]);
    }
}

