/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.objectstore.StoreExistsException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.StoreOutputStream;

public final class ObjectStoreRetryUtil {
    private static final int MAX_RETRY_ON_IOERROR = 3;
    private static final int RETRY_WAIT = 10;
    private static final Log LOG = LogFactory.getLog(ObjectStoreRetryUtil.class);

    private ObjectStoreRetryUtil() {
    }

    public static InputStream retryReadObject(ObjectStoreService objectStore, String storeName, String objectId) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                return objectStore.readObject(storeName, objectId);
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static StoreOutputStream retryWriteObject(ObjectStoreService objectStore, String storeName, String objectId) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                return objectStore.writeObject(storeName, objectId);
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static void retryPutObject(ObjectStoreService objectStore, String storeName, String objectId, byte[] data) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                objectStore.putObject(storeName, objectId, data);
                return;
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static byte[] retryGetObject(ObjectStoreService objectStore, String storeName, String objectId) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                return objectStore.getObject(storeName, objectId);
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static void retryCreateStore(ObjectStoreService objectStore, String storeName, AnyMap storeProperties, boolean storeExistsException) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                objectStore.createStore(storeName, storeProperties);
                return;
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
            }
            catch (StoreExistsException e) {
                if (storeExistsException) {
                    throw e;
                }
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void retryEnsureStore(ObjectStoreService objectStore, String storeName) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                objectStore.ensureStore(storeName);
                return;
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static boolean retryExistsStore(ObjectStoreService objectStore, String storeName) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                return objectStore.existsStore(storeName);
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static Collection<StoreObject> retryGetStoreObjectInfos(ObjectStoreService objectStore, String storeName, String objectIdPrefix) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                return objectStore.getStoreObjectInfos(storeName, objectIdPrefix);
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static boolean retryExistsObject(ObjectStoreService objectStore, String storeName, String objectId) throws ObjectStoreException {
        int retryCount = 0;
        while (true) {
            try {
                return objectStore.existsObject(storeName, objectId);
            }
            catch (ServiceUnavailableException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public static void retryClose(StoreOutputStream storeOutputStream) throws IOException {
        int retryCount = 0;
        while (true) {
            try {
                storeOutputStream.close();
                return;
            }
            catch (IOException e) {
                if (retryCount++ >= 3) {
                    throw e;
                }
                LOG.warn((Object)"commit failed, will retry...", (Throwable)e);
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }
}

