/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.xml.stax;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.eclipse.smila.utils.xml.stax.XmlSnippetHandler;
import org.eclipse.smila.utils.xml.stax.XmlSnippetSplitter;

public class SimpleTagExtractor {
    private boolean _removeTags;

    public SimpleTagExtractor(boolean removeTags) {
        this._removeTags = removeTags;
    }

    public synchronized List<String> getTags(String tagName, InputStream inputStream) throws XMLStreamException {
        final ArrayList<String> tags = new ArrayList<String>();
        new XmlSnippetSplitter(new XmlSnippetHandler(){

            @Override
            public void handleSnippet(byte[] snippet) {
                try {
                    String tag = new String(snippet, "UTF-8");
                    if (SimpleTagExtractor.this._removeTags) {
                        tag = tag.substring(tag.indexOf(">") + 1, tag.lastIndexOf("</"));
                    }
                    tags.add(tag);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, new QName(tagName), new QName(tagName)).read(inputStream);
        return tags;
    }
}

