/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.SourceType;
import org.eclipse.smila.utils.file.EncodingHelper;

public abstract class ATransformationPipelet
implements Pipelet {
    public static final String PROP_INPUT_TYPE = "inputType";
    public static final String PROP_OUTPUT_TYPE = "outputType";
    public static final String PROP_OUTPUT_VALUE_TYPE = "outputValueType";
    public static final String PROP_INPUT_NAME = "inputName";
    public static final String PROP_OUTPUT_NAME = "outputName";
    public static final String ENCODING_ATTACHMENT = "utf-8";
    public static final Charset ENCODING_CHARSET = Charset.forName("utf-8");
    protected final Log _log = LogFactory.getLog(ATransformationPipelet.class);
    protected AnyMap _config;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._config = configuration;
    }

    public SourceType getInputType(ParameterAccessor paramAccessor) throws MissingParameterException {
        return SourceType.valueOf(paramAccessor.getRequiredParameter(PROP_INPUT_TYPE));
    }

    public String getInputName(ParameterAccessor paramAccessor) throws MissingParameterException {
        return paramAccessor.getRequiredParameter(PROP_INPUT_NAME);
    }

    public SourceType getOutputType(ParameterAccessor paramAccessor) throws MissingParameterException {
        return SourceType.valueOf(paramAccessor.getRequiredParameter(PROP_OUTPUT_TYPE));
    }

    public Any.ValueType getOutputValueType(ParameterAccessor paramAccessor) throws MissingParameterException {
        String valTypeStr = paramAccessor.getParameter(PROP_OUTPUT_VALUE_TYPE, null);
        if (valTypeStr != null) {
            return Any.ValueType.valueOf((String)valTypeStr);
        }
        return null;
    }

    public String getOutputName(ParameterAccessor paramAccessor) throws MissingParameterException {
        return paramAccessor.getRequiredParameter(PROP_OUTPUT_NAME);
    }

    public boolean isReadFromAttribute(SourceType inputType) {
        return SourceType.ATTRIBUTE.equals((Object)inputType);
    }

    public boolean isStoreInAttribute(SourceType outputType) {
        return SourceType.ATTRIBUTE.equals((Object)outputType);
    }

    protected void storeResult(Blackboard blackboard, String id, String result, ParameterAccessor paramAccessor) throws ProcessingException {
        if (this.isStoreInAttribute(this.getOutputType(paramAccessor))) {
            try {
                Any.ValueType outputValueType = this.getOutputValueType(paramAccessor);
                Value value = blackboard.getDataFactory().parseFromString(result, outputValueType == null ? Any.ValueType.STRING : outputValueType);
                blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), (Any)value);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not set attribute " + this.getOutputName(paramAccessor) + " of record " + id, (Throwable)e);
            }
        }
        try {
            InputStream stringStream = IOUtils.toInputStream((String)result, (String)ENCODING_ATTACHMENT);
            blackboard.setAttachmentFromStream(id, this.getOutputName(paramAccessor), stringStream);
        }
        catch (Exception e) {
            throw new ProcessingException("Could not set attachment " + this.getOutputName(paramAccessor) + " of record " + id, (Throwable)e);
        }
    }

    protected void storeResult(Blackboard blackboard, String id, InputStream resultStream, ParameterAccessor paramAccessor) throws ProcessingException {
        block25: {
            if (this.isStoreInAttribute(this.getOutputType(paramAccessor))) {
                try {
                    Any.ValueType outputValueType = this.getOutputValueType(paramAccessor);
                    Throwable throwable = null;
                    Object var7_11 = null;
                    try (InputStreamReader reader = new InputStreamReader(resultStream, ENCODING_CHARSET);){
                        StringBuilder builder = new StringBuilder();
                        Throwable throwable2 = null;
                        Object var11_17 = null;
                        try (BufferedReader in = new BufferedReader(reader);){
                            int ch;
                            while ((ch = ((Reader)in).read()) > -1) {
                                builder.append((char)ch);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        Value value = blackboard.getDataFactory().parseFromString(builder.toString(), outputValueType == null ? Any.ValueType.STRING : outputValueType);
                        blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), (Any)value);
                        break block25;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new ProcessingException("Could not set attribute " + this.getOutputName(paramAccessor) + " of record " + id, (Throwable)e);
                }
            }
            try {
                InputStream stringStream = resultStream;
                blackboard.setAttachmentFromStream(id, this.getOutputName(paramAccessor), stringStream);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not set attachment " + this.getOutputName(paramAccessor) + " of record " + id, (Throwable)e);
            }
        }
    }

    protected void storeResults(Blackboard blackboard, String id, Collection<String> results, ParameterAccessor paramAccessor) throws ProcessingException, BlackboardAccessException {
        if (!results.isEmpty()) {
            if (this.isStoreInAttribute(this.getOutputType(paramAccessor))) {
                if (results.size() == 1) {
                    blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), results.iterator().next());
                } else {
                    AnySeq valueSeq = DataFactory.DEFAULT.createAnySeq();
                    for (String result : results) {
                        valueSeq.add(result);
                    }
                    blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), (Any)valueSeq);
                }
            } else {
                this.storeResult(blackboard, id, results.iterator().next(), paramAccessor);
            }
        }
    }

    protected void storeResult(Blackboard blackboard, String id, byte[] bytes, ParameterAccessor paramAccessor) throws MissingParameterException, BlackboardAccessException {
        if (this.isStoreInAttribute(this.getOutputType(paramAccessor))) {
            blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), new String(bytes, ENCODING_CHARSET));
        } else {
            blackboard.setAttachment(id, this.getOutputName(paramAccessor), bytes);
        }
    }

    protected byte[] readInput(Blackboard blackboard, String id, ParameterAccessor paramAccessor) throws BlackboardAccessException, MissingParameterException {
        byte[] bytes = null;
        if (this.isReadFromAttribute(this.getInputType(paramAccessor))) {
            String value;
            Any inputAny = (Any)blackboard.getMetadata(id).get((Object)this.getInputName(paramAccessor));
            if (inputAny != null && inputAny.isValue() && (value = ((Value)inputAny).asString()) != null) {
                bytes = value.getBytes(ENCODING_CHARSET);
            }
        } else if (blackboard.hasAttachment(id, this.getInputName(paramAccessor))) {
            bytes = blackboard.getAttachmentAsBytes(id, this.getInputName(paramAccessor));
        }
        return bytes;
    }

    protected String readStringInput(Blackboard blackboard, String id, ParameterAccessor paramAccessor) throws BlackboardAccessException, MissingParameterException {
        byte[] bytes;
        String string = null;
        if (this.isReadFromAttribute(this.getInputType(paramAccessor))) {
            Any inputAny = (Any)blackboard.getMetadata(id).get((Object)this.getInputName(paramAccessor));
            if (inputAny != null && inputAny.isValue()) {
                string = ((Value)inputAny).asString();
            }
        } else if (blackboard.hasAttachment(id, this.getInputName(paramAccessor)) && (bytes = blackboard.getAttachmentAsBytes(id, this.getInputName(paramAccessor))) != null && bytes.length > 0) {
            Charset charset = this.detectCharset(bytes);
            string = new String(bytes, charset);
        }
        return string;
    }

    private Charset detectCharset(byte[] bytes) {
        Charset charset = ENCODING_CHARSET;
        try {
            String detectedEncoding = EncodingHelper.getEncoding((byte[])bytes);
            if (detectedEncoding != null) {
                charset = Charset.forName(detectedEncoding);
            }
        }
        catch (IOException | IllegalCharsetNameException | UnsupportedCharsetException exception) {}
        return charset;
    }

    protected InputStream getInputStream(Blackboard blackboard, String id, ParameterAccessor paramAccessor) throws BlackboardAccessException, MissingParameterException {
        InputStream bytesStream = null;
        if (this.isReadFromAttribute(this.getInputType(paramAccessor))) {
            String value;
            Any inputAny = (Any)blackboard.getMetadata(id).get((Object)this.getInputName(paramAccessor));
            if (inputAny != null && inputAny.isValue() && (value = ((Value)inputAny).asString()) != null) {
                bytesStream = new ByteArrayInputStream(value.getBytes(ENCODING_CHARSET));
            }
        } else if (blackboard.hasAttachment(id, this.getInputName(paramAccessor))) {
            bytesStream = blackboard.getAttachmentAsStream(id, this.getInputName(paramAccessor));
        }
        return bytesStream;
    }
}

