/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.utils.service.ServiceUtils;

public class PushRecordsPipelet
implements Pipelet {
    public static final String JOB_NAME_PROPERTY = "job";
    private String _job;
    private BulkbuilderService _bulkBuilder;

    public void configure(AnyMap config) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(config);
        this._job = paramAccessor.getRequiredParameter(JOB_NAME_PROPERTY);
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        Record[] records = new Record[recordIds.length];
        int i = 0;
        while (i < recordIds.length) {
            try {
                records[i] = blackboard.getRecord(recordIds[i]);
            }
            catch (BlackboardAccessException e) {
                throw new ProcessingException(this.getClass() + ": Could not access record: " + recordIds[i], (Throwable)e);
            }
            ++i;
        }
        try {
            Record[] recordArray = records;
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                Record record = recordArray[n2];
                this.getBulkbuilderService().addRecord(this._job, record);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ProcessingException(this.getClass() + ": Could not send all records to job: " + this._job, (Throwable)e);
        }
        return recordIds;
    }

    private BulkbuilderService getBulkbuilderService() throws ProcessingException {
        if (this._bulkBuilder == null) {
            try {
                this._bulkBuilder = (BulkbuilderService)ServiceUtils.getService(BulkbuilderService.class);
            }
            catch (InterruptedException e) {
                throw new ProcessingException("Could not retrieve BulkbuilderService.", (Throwable)e);
            }
        }
        return this._bulkBuilder;
    }

    public void setBulkbuilderService(BulkbuilderService bulkBuilder) {
        this._bulkBuilder = bulkBuilder;
    }
}

