/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rapi.OdeRTInstanceContext;
import org.apache.ode.bpel.rtrep.v1.ACTIVITYGUARD;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.w3c.dom.Element;

public abstract class BpelJacobRunnable
extends JacobRunnable {
    private static final Log __log = LogFactory.getLog(BpelJacobRunnable.class);

    protected OdeInternalInstance getBpelRuntime() {
        OdeInternalInstance odeInternalInstance = (OdeInternalInstance)JacobVPU.activeJacobThread().getExtension(OdeRTInstanceContext.class);
        assert (odeInternalInstance != null);
        return odeInternalInstance;
    }

    protected Log log() {
        return __log;
    }

    protected final FaultData createFault(QName qName, Element element, OVarType oVarType, OBase oBase) {
        return new FaultData(qName, element, oVarType, oBase);
    }

    protected final FaultData createFault(QName qName, OBase oBase, String string) {
        return new FaultData(qName, oBase, string);
    }

    protected final FaultData createFault(QName qName, OBase oBase) {
        return this.createFault(qName, oBase, null);
    }

    protected JacobRunnable createChild(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        return new ACTIVITYGUARD(activityInfo, scopeFrame, linkFrame);
    }

    protected void initializeCorrelation(CorrelationSetInstance correlationSetInstance, VariableInstance variableInstance) throws FaultException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Initializing correlation set " + correlationSetInstance.declaration.name));
        }
        if (this.getBpelRuntime().isCorrelationInitialized(correlationSetInstance)) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("OCorrelation set " + correlationSetInstance + " is already set: ignoring"));
            }
            return;
        }
        String[] stringArray = new String[correlationSetInstance.declaration.properties.size()];
        String[] stringArray2 = new String[correlationSetInstance.declaration.properties.size()];
        for (int i = 0; i < correlationSetInstance.declaration.properties.size(); ++i) {
            OProcess.OProperty oProperty = correlationSetInstance.declaration.properties.get(i);
            stringArray2[i] = this.getBpelRuntime().readProperty(variableInstance, oProperty);
            stringArray[i] = oProperty.name.toString();
            if (!__log.isDebugEnabled()) continue;
            __log.debug((Object)("Setting correlation property " + stringArray[i] + "=" + stringArray2[i]));
        }
        CorrelationKey correlationKey = new CorrelationKey(correlationSetInstance.declaration.getId(), stringArray2);
        correlationKey.setUnique(correlationSetInstance.declaration.isUnique());
        this.getBpelRuntime().writeCorrelation(correlationSetInstance, correlationKey);
    }

    protected long genMonotonic() {
        return this.getBpelRuntime().genId();
    }
}

