/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.helper.ResultAccessor;

public class ResultBuilder
extends ResultAccessor {
    public ResultBuilder(String workflowName, Record result) {
        super(workflowName, result);
        this._result.getMetadata().getSeq("records", true);
    }

    public AnyMap addResultItem(String id, Double score) {
        AnyMap resultItem = this.getResultRecords().getFactory().createAnyMap();
        this.getResultRecords().add((Object)resultItem);
        resultItem.put("_recordid", id);
        resultItem.put("_weight", (Number)score);
        return resultItem;
    }

    public void addHighlightText(AnyMap resultItem, String attribute, String text) {
        if (text == null) {
            throw new NullArgumentException("text");
        }
        AnyMap highlight = this._result.getFactory().createAnyMap();
        highlight.put("text", text);
        this.addHighlight(resultItem, attribute, highlight);
    }

    public void addHighlightText(AnyMap resultItem, String attribute, List<String> text) {
        if (text == null) {
            throw new NullArgumentException("text");
        }
        AnyMap highlight = this._result.getFactory().createAnyMap();
        highlight.getSeq("text", true).addAll((Collection)AnyUtil.objectToAny(text).asSeq());
        this.addHighlight(resultItem, attribute, highlight);
    }

    public void addHighlight(AnyMap resultItem, String attribute, AnyMap highlight) {
        if (attribute == null) {
            throw new NullArgumentException("attribute");
        }
        if (highlight == null) {
            throw new NullArgumentException("highlight");
        }
        resultItem.getMap("_highlight", true).put(attribute, (Any)highlight);
    }

    public void setCount(Long count) {
        this._result.getMetadata().put("count", (Number)count);
    }

    public void setRuntime(Long millis) {
        this._result.getMetadata().put("runtime", (Number)millis);
    }

    public AnySeq addFacet(String facetName) {
        AnyMap facets = this._result.getMetadata().getMap("facets", true);
        return facets.getSeq(facetName, true);
    }

    public AnyMap addFacetValue(AnySeq facet, Any value, Long count) {
        if (facet == null) {
            throw new NullArgumentException("facet");
        }
        if (value == null) {
            throw new NullArgumentException("value");
        }
        AnyMap facetValue = facet.getFactory().createAnyMap();
        facetValue.put("value", value);
        if (count != null) {
            facetValue.put("count", (Number)count);
        }
        facet.add((Object)facetValue);
        return facetValue;
    }

    public AnyMap addFacetValue(AnySeq facet, Object value, Long count) {
        Value autoConvertValue = facet.getFactory().autoConvertValue(value);
        return this.addFacetValue(facet, (Any)autoConvertValue, count);
    }

    public AnyMap addFacetValue(AnySeq facet, String value, Any.ValueType valueType, Long count) {
        Value autoConvertValue = facet.getFactory().parseFromString(value, valueType);
        return this.addFacetValue(facet, (Any)autoConvertValue, count);
    }

    public AnySeq addGroup(String groupName, String groupCommand) {
        return this.getGoupsMap().getMap(groupName, true).getSeq(groupCommand, true);
    }

    public AnySeq addGroup(String groupCommand) {
        return this.getGoupsMap().getSeq(groupCommand, true);
    }

    private AnyMap getGoupsMap() {
        return this._result.getMetadata().getMap("groups", true);
    }

    public AnyMap addGroupResults(AnySeq group, Any value, Long count, AnySeq results) {
        AnyMap map = this.addToGroup(group, value, count);
        map.put("results", (Any)results);
        return map;
    }

    public AnyMap addNestedGroup(AnySeq group, Any value, Long count, AnyMap nestedGroup) {
        AnyMap map = this.addToGroup(group, value, count);
        map.put("groups", (Any)nestedGroup);
        return map;
    }

    private AnyMap addToGroup(AnySeq group, Any value, Long count) {
        if (group == null) {
            throw new NullArgumentException("group");
        }
        if (value == null) {
            throw new NullArgumentException("value");
        }
        AnyMap map = group.getFactory().createAnyMap();
        map.put("value", value);
        if (count != null) {
            map.put("count", (Number)count);
        }
        group.add((Object)map);
        return map;
    }
}

