/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.workermanager.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.taskworker.DefaultTaskLogFactory;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.TaskLog;
import org.eclipse.smila.taskworker.TaskLogFactory;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.internal.TaskContextImpl;
import org.eclipse.smila.taskworker.util.Counters;
import org.eclipse.smila.workermanager.ScaleUpControl;
import org.eclipse.smila.workermanager.TaskKeepAliveListener;
import org.eclipse.smila.workermanager.WorkerManager;
import org.eclipse.smila.workermanager.internal.WorkerPool;
import org.eclipse.smila.workermanager.internal.WorkerRunner;
import org.eclipse.smila.workermanager.keepalive.TaskKeepAlive;
import org.osgi.service.component.ComponentContext;

public class WorkerManagerImpl
implements WorkerManager,
TaskKeepAliveListener {
    private static final long TASK_LOOP_INITIAL_DELAY = 50L;
    private static final long TASK_LOOP_PERIODIC_DELAY = 5L;
    private final Log _log = LogFactory.getLog(this.getClass());
    private DefinitionPersistence _defPersistence;
    private TaskManager _taskManager;
    private ObjectStoreService _objectStore;
    private ClusterConfigService _clusterConfigService;
    private String _localhost;
    private final Queue<String> _workerNames = new ConcurrentLinkedQueue<String>();
    private final Map<String, Worker> _workers = new ConcurrentHashMap<String, Worker>();
    private final Map<String, WorkerDefinition> _workerDefinitions = new ConcurrentHashMap<String, WorkerDefinition>();
    private final Map<String, Map<String, Number>> _internalWorkerCounters = new ConcurrentHashMap<String, Map<String, Number>>();
    private ScaleUpControl _scaleUpControl;
    private WorkerPool _workerPool;
    private TaskLogFactory _taskLogFactory = new DefaultTaskLogFactory();
    private TaskKeepAlive _keepAliveRunner;
    private final Map<String, TaskContext> _currentlyProcessedTasks = new ConcurrentHashMap<String, TaskContext>();
    private ScheduledExecutorService _keepAliveExecutor = Executors.newScheduledThreadPool(1);
    private final ScheduledExecutorService _taskLoopExecutor = Executors.newScheduledThreadPool(1);
    private final Runnable _taskLoopRunner = new Runnable(){

        @Override
        public void run() {
            boolean haveChanges = WorkerManagerImpl.this.startAndFinishTasks();
            if (!haveChanges) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    };

    public boolean startAndFinishTasks() {
        boolean haveChanges = false;
        if (!this._workerNames.isEmpty()) {
            haveChanges |= this.getAndStartTasks();
            this._workerNames.add(this._workerNames.poll());
            haveChanges |= this.finishCompletedTasks();
        }
        return haveChanges;
    }

    public boolean getAndStartTasks() {
        boolean newTaskStarted = false;
        for (String workerName : this._workerNames) {
            try {
                newTaskStarted |= this.getAndStartTask(workerName);
            }
            catch (Exception ex) {
                this._log.warn((Object)("Unexpected exception when trying to get a task for worker " + workerName), (Throwable)ex);
            }
        }
        return newTaskStarted;
    }

    public boolean finishCompletedTasks() {
        boolean finishedTask = false;
        for (WorkerRunner taskWorker : this._workerPool.getCompleted()) {
            try {
                this.finishTask(taskWorker);
                finishedTask = true;
            }
            catch (Exception ex) {
                this._log.warn((Object)("Unexpected exception when trying to finish task " + taskWorker.getTask()), (Throwable)ex);
            }
        }
        return finishedTask;
    }

    public boolean getAndStartTask(String worker) {
        WorkerDefinition workerDef = this.getWorkerDefinition(worker);
        if (workerDef == null) {
            if (this._workerNames.contains(worker)) {
                this._log.error((Object)("Cannot find worker definition for worker '" + worker + "', please check jobmanager configuration files."));
                this._log.error((Object)("Removing worker '" + worker + "' from operation. " + "Please amend the worker configuration and restart the system to make this worker operational."));
                this.removeWorker(this._workers.get(worker));
            }
            return false;
        }
        boolean isRunAlways = workerDef.getModes().contains(WorkerDefinition.Mode.RUNALWAYS);
        if (this._scaleUpControl.canGetTask(worker, isRunAlways)) {
            try {
                String workerHost = isRunAlways ? null : this._localhost;
                Task task = this._taskManager.getTask(worker, workerHost);
                if (task != null) {
                    TaskLog taskLog = this._taskLogFactory.getTaskLog(task);
                    TaskContextImpl taskContext = new TaskContextImpl(task, taskLog, this._objectStore, workerDef.getOutputModes());
                    WorkerRunner taskWorker = new WorkerRunner(this._workers.get(worker), (TaskContext)taskContext);
                    this._currentlyProcessedTasks.put(task.getTaskId(), (TaskContext)taskContext);
                    this._keepAliveRunner.addTask(task);
                    this._workerPool.submit(taskWorker);
                    this._scaleUpControl.incTaskCounter(worker);
                    return true;
                }
            }
            catch (TaskmanagerException e) {
                this._log.info((Object)("Error getting task for worker '" + worker + "', will retry later."), (Throwable)e);
            }
        }
        return false;
    }

    public WorkerDefinition getWorkerDefinition(String worker) {
        WorkerDefinition workerDef = this._workerDefinitions.get(worker);
        if (workerDef == null && this._defPersistence != null) {
            workerDef = this._defPersistence.getWorker(worker);
        }
        if (workerDef == null && this.isInternalWorker(worker)) {
            workerDef = this.createWorkerDefinitionForInternalWorker(worker);
        }
        if (workerDef != null) {
            this._workerDefinitions.put(worker, workerDef);
            try {
                this._taskManager.addTaskQueue(worker);
            }
            catch (TaskmanagerException ex) {
                this._log.info((Object)("Failed to initialize task queue for worker '" + worker + "'. This is probably a temporary problem only."), (Throwable)ex);
            }
        }
        return workerDef;
    }

    public void finishTask(WorkerRunner taskWorker) {
        String workerName = taskWorker.getWorkerName();
        try {
            try {
                this._keepAliveRunner.removeTask(taskWorker.getTask());
                this._currentlyProcessedTasks.remove(taskWorker.getTask().getTaskId());
                if (this.isInternalWorker(workerName)) {
                    this.addInternalWorkerCounters(workerName, taskWorker.getResult().getCounters());
                }
                if (!taskWorker.getTaskContext().isCanceled()) {
                    this._taskManager.finishTask(workerName, taskWorker.getTask().getTaskId(), taskWorker.getResult());
                }
            }
            catch (TaskmanagerException e) {
                this._log.error((Object)"TaskManager exception while finishing task", (Throwable)e);
                this._scaleUpControl.decTaskCounter(workerName);
            }
        }
        finally {
            this._scaleUpControl.decTaskCounter(workerName);
        }
    }

    protected void activate(ComponentContext context) {
        this.setScaleUpControl(new ScaleUpControl(this._clusterConfigService));
        this._workerPool = new WorkerPool();
        this._keepAliveRunner = new TaskKeepAlive(this._taskManager);
        this._keepAliveRunner.addKeepAliveFailureListener(this);
        this._keepAliveExecutor.scheduleWithFixedDelay(this._keepAliveRunner, 2000L, 2000L, TimeUnit.MILLISECONDS);
        this._taskLoopExecutor.scheduleWithFixedDelay(this._taskLoopRunner, 50L, 5L, TimeUnit.MILLISECONDS);
    }

    protected void deactivate(ComponentContext context) {
        if (this._taskLoopExecutor != null) {
            this._taskLoopExecutor.shutdown();
        }
        if (this._keepAliveExecutor != null) {
            this._keepAliveExecutor.shutdown();
        }
        if (this._workerPool != null) {
            this._workerPool.close();
        }
    }

    public void addWorker(Worker worker) {
        this._workerNames.add(worker.getName());
        this._workers.put(worker.getName(), worker);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Added worker " + worker.getName() + " to WorkerManager."));
        }
    }

    public void removeWorker(Worker worker) {
        this._workerNames.remove(worker.getName());
        this._workers.remove(worker.getName());
        this._workerDefinitions.remove(worker.getName());
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Removed worker " + worker.getName() + " from WorkerManager."));
        }
    }

    @Override
    public boolean containsWorker(String worker) {
        return this._workerNames.contains(worker);
    }

    @Override
    public void addKeepAliveListener(TaskKeepAliveListener listener) {
        this._keepAliveRunner.addKeepAliveFailureListener(listener);
    }

    @Override
    public void removeKeepAliveListener(TaskKeepAliveListener listener) {
        this._keepAliveRunner.removeKeepAliveFailureListener(listener);
    }

    @Override
    public void addKeepAliveTask(Task task) {
        this._keepAliveRunner.addTask(task);
    }

    @Override
    public void removeKeepAliveTask(Task task) {
        this._keepAliveRunner.removeTask(task);
    }

    @Override
    public void removedTask(Task task) {
        TaskContext taskContext = this._currentlyProcessedTasks.get(task.getTaskId());
        if (taskContext != null) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Marked TaskContext of task '" + task.getTaskId() + "' as canceled."));
            }
            taskContext.cancel();
        }
    }

    @Override
    public void setKeepAliveInterval(long keepAliveCheckMillis, long keepAliveSendSeconds) {
        Collection<TaskKeepAliveListener> listeners = this._keepAliveRunner.getKeepAliveFailureListeners();
        this._keepAliveExecutor.shutdown();
        this._keepAliveRunner = new TaskKeepAlive(this._taskManager, keepAliveSendSeconds);
        this._keepAliveRunner.addKeepAliveFailureListeners(listeners);
        this._keepAliveExecutor = Executors.newScheduledThreadPool(1);
        this._keepAliveExecutor.scheduleAtFixedRate(this._keepAliveRunner, keepAliveCheckMillis, keepAliveCheckMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setScaleUpControl(ScaleUpControl scaleUpControl) {
        this._scaleUpControl = scaleUpControl;
    }

    @Override
    public AnyMap getInfo() {
        DataFactory dataFactory = DataFactory.DEFAULT;
        AnyMap info = dataFactory.createAnyMap();
        info.put("host", this._localhost);
        info.put("currentlyProcessedTasks", (Number)this._currentlyProcessedTasks.size());
        AnySeq workersSection = dataFactory.createAnySeq();
        for (WorkerDefinition workerDef : this._workerDefinitions.values()) {
            AnyMap worker = dataFactory.createAnyMap();
            String workerName = workerDef.getName();
            worker.put("name", workerName);
            worker.put("runAlways", Boolean.valueOf(workerDef.getModes().contains(WorkerDefinition.Mode.RUNALWAYS)));
            worker.put("scaleUpLimit", (Number)this._scaleUpControl.getScaleUpLimit(workerName));
            worker.put("scaleUpCurrent", (Number)this._scaleUpControl.getTaskCounter(workerName));
            Map<String, Number> counters = this._internalWorkerCounters.get(workerName);
            if (counters != null) {
                AnyMap counterInfo = dataFactory.createAnyMap();
                for (String key : new TreeSet<String>(counters.keySet())) {
                    counterInfo.put(key, counters.get(key));
                }
                worker.put("counter", (Any)counterInfo);
            }
            workersSection.add((Object)worker);
        }
        info.put("workers", (Any)workersSection);
        AnyMap workerPoolSection = dataFactory.createAnyMap();
        ExecutorService threadPool = this._workerPool.getThreadPool();
        if (threadPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)threadPool;
            workerPoolSection.put("activeCount", (Number)tpe.getActiveCount());
            workerPoolSection.put("corePoolSize", (Number)tpe.getCorePoolSize());
            workerPoolSection.put("poolSize", (Number)tpe.getPoolSize());
            workerPoolSection.put("largestPoolSize", (Number)tpe.getLargestPoolSize());
            workerPoolSection.put("queueSize", (Number)tpe.getQueue().size());
            workerPoolSection.put("taskCount", (Number)tpe.getTaskCount());
        }
        info.put("workerPool", (Any)workerPoolSection);
        return info;
    }

    @Override
    public boolean hasWorker(String worker) {
        return this._workers.containsKey(worker);
    }

    public void setClusterConfigService(ClusterConfigService ccs) {
        this._clusterConfigService = ccs;
        this._localhost = ccs.getLocalHost();
    }

    public void unsetClusterConfigService(ClusterConfigService ccs) {
        if (this._clusterConfigService == ccs) {
            this._clusterConfigService = null;
        }
    }

    public void setDefinitionPersistence(DefinitionPersistence defPersistence) {
        this._defPersistence = defPersistence;
    }

    public void unsetDefinitionPersistence(DefinitionPersistence defPersistence) {
        if (this._defPersistence == defPersistence) {
            this._defPersistence = null;
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }

    public void setTaskLogFactory(TaskLogFactory taskLogFactory) {
        this._taskLogFactory = taskLogFactory;
    }

    public void unsetTaskLogFactory(TaskLogFactory taskLogFactory) {
        if (this._taskLogFactory == taskLogFactory) {
            this._taskLogFactory = new DefaultTaskLogFactory();
        }
    }

    public void setObjectStoreService(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }

    private boolean isInternalWorker(String worker) {
        return worker.startsWith("_");
    }

    private WorkerDefinition createWorkerDefinitionForInternalWorker(String worker) {
        AnyMap workerDefAny = DataFactory.DEFAULT.createAnyMap();
        AnySeq modesAny = DataFactory.DEFAULT.createAnySeq();
        modesAny.add(WorkerDefinition.Mode.RUNALWAYS.name());
        workerDefAny.put("name", worker);
        workerDefAny.put("modes", (Any)modesAny);
        try {
            return new WorkerDefinition(workerDefAny);
        }
        catch (InvalidDefinitionException invalidDefinitionException) {
            this._log.error((Object)("Error while creating internal worker definition for worker " + worker));
            return null;
        }
    }

    private void addInternalWorkerCounters(String workerName, Map<String, Number> counters) {
        if (counters != null && !counters.isEmpty()) {
            Map<String, Number> currentCounters = this._internalWorkerCounters.get(workerName);
            if (currentCounters == null) {
                this._internalWorkerCounters.put(workerName, counters);
            } else {
                Counters.addAll(currentCounters, counters);
            }
        }
    }
}

