/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.workermanager.internal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.eclipse.smila.taskworker.PostponeTaskException;
import org.eclipse.smila.taskworker.RecoverableTaskException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.util.Counters;
import org.eclipse.smila.utils.MaybeRecoverableException;

public class WorkerRunner
implements Callable<WorkerRunner> {
    private final TaskContext _taskContext;
    private final Worker _worker;
    private ResultDescription _result;

    public WorkerRunner(Worker worker, TaskContext taskContext) {
        this._worker = worker;
        this._taskContext = taskContext;
    }

    @Override
    public WorkerRunner call() throws Exception {
        block10: {
            long start = this._taskContext.getTimestamp();
            try {
                try {
                    this._worker.perform(this._taskContext);
                    long endPerform = this._taskContext.getTimestamp();
                    if (this._taskContext.isCanceled()) {
                        this._result = new ResultDescription(TaskCompletionStatus.OBSOLETE, null, null, null);
                        this._taskContext.getOutputs().abortAll();
                        break block10;
                    }
                    this._taskContext.getOutputs().commitAll();
                    long endCommit = this._taskContext.getTimestamp();
                    Map<String, Number> taskCounters = this.getCounters(start, endPerform, endCommit);
                    this._result = new ResultDescription(TaskCompletionStatus.SUCCESSFUL, null, null, taskCounters);
                }
                catch (Throwable e) {
                    this._taskContext.getOutputs().abortAll();
                    if (this.isRecoverableException(e)) {
                        String errorMessage = "Error while executing task " + this._taskContext.getTask().getTaskId() + " in worker " + this._worker + ": " + e.getMessage();
                        this._result = new ResultDescription(TaskCompletionStatus.RECOVERABLE_ERROR, "TaskWorker", errorMessage, null);
                        this._taskContext.getLog().warn(errorMessage, e);
                    } else if (this.isPostponeException(e)) {
                        String errorMessage = "Error while executing task " + this._taskContext.getTask().getTaskId() + " in worker " + this._worker + ": " + e.getMessage();
                        this._result = new ResultDescription(TaskCompletionStatus.POSTPONE, "TaskWorker", errorMessage, null);
                        this._taskContext.getLog().warn(errorMessage, e);
                    } else {
                        String errorMessage = "Error while executing task " + this._taskContext.getTask().getTaskId() + " in worker " + this._worker + ": " + e.getMessage();
                        this._result = new ResultDescription(TaskCompletionStatus.FATAL_ERROR, "TaskWorker", errorMessage, null);
                        this._taskContext.getLog().error(errorMessage, e);
                    }
                    this._taskContext.getInputs().closeAll();
                }
            }
            finally {
                this._taskContext.getInputs().closeAll();
            }
        }
        return this;
    }

    private boolean isRecoverableException(Throwable e) {
        if (e instanceof RecoverableTaskException || e instanceof IOException || e instanceof ServiceUnavailableException) {
            return true;
        }
        if (e instanceof MaybeRecoverableException) {
            return ((MaybeRecoverableException)e).isRecoverable();
        }
        return false;
    }

    private boolean isPostponeException(Throwable e) {
        return e instanceof PostponeTaskException;
    }

    private Map<String, Number> getCounters(long startTime, long endPerformTime, long endTime) {
        Map taskCounters = this._taskContext.getFinalCounters();
        long durationPerform = endPerformTime - startTime;
        long durationTotal = endTime - startTime;
        Counters.addDuration((Map)taskCounters, (String)"duration", (long)durationTotal);
        Counters.addDuration((Map)taskCounters, (String)"duration.perform", (long)durationPerform);
        Number durationIoDataOpen = (Number)taskCounters.get("duration.iodata.open");
        if (durationIoDataOpen != null) {
            Counters.add((Map)taskCounters, (String)"duration.perform", (double)(-durationIoDataOpen.doubleValue()));
        }
        return taskCounters;
    }

    public String getWorkerName() {
        return this._worker.getName();
    }

    public TaskContext getTaskContext() {
        return this._taskContext;
    }

    public Task getTask() {
        return this._taskContext.getTask();
    }

    public ResultDescription getResult() {
        return this._result;
    }
}

