/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.soapbinding;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.Properties;
import org.apache.ode.axis2.soapbinding.AuthenticationHelper;
import org.apache.ode.axis2.soapbinding.SoapMessageConverter;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.il.OMUtils;
import org.apache.ode.il.epr.EndpointFactory;
import org.apache.ode.il.epr.MutableEndpoint;
import org.apache.ode.il.epr.WSAEndpoint;
import org.apache.ode.utils.AxisUtils;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.WatchDog;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.ode.utils.uuid.UUID;
import org.apache.ode.utils.wsdl.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapExternalService
implements ExternalService,
PartnerRoleChannel {
    private static final Log __log = LogFactory.getLog(ExternalService.class);
    private static final int EXPIRE_SERVICE_CLIENT = 30000;
    private static ThreadLocal<ServiceClient> _cachedClients = new ThreadLocal();
    private WatchDog<Map, OptionsObserver> _axisOptionsWatchDog;
    private WatchDog<Long, ServiceFileObserver> _axisServiceWatchDog;
    private ConfigurationContext _configContext;
    private static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    private Definition _definition;
    private QName _serviceName;
    private String _portName;
    protected WSAEndpoint endpointReference;
    private AxisConfiguration _axisConfig;
    private SoapMessageConverter _converter;
    private ProcessConf _pconf;

    public SoapExternalService(Definition definition, QName qName, String string, AxisConfiguration axisConfiguration, ProcessConf processConf) throws AxisFault {
        this._definition = definition;
        this._serviceName = qName;
        this._portName = string;
        this._axisConfig = axisConfiguration;
        this._converter = new SoapMessageConverter(definition, qName, string);
        this._pconf = processConf;
        File file = new File(this._pconf.getBaseURI().resolve(this._serviceName.getLocalPart() + ".axis2"));
        this._axisServiceWatchDog = WatchDog.watchFile((File)file, (WatchDog.Observer)new ServiceFileObserver(file));
        this._axisOptionsWatchDog = new WatchDog((WatchDog.Mutable)new EndpointPropertiesMutable(), (WatchDog.Observer)new OptionsObserver());
        this._configContext = new ConfigurationContext(this._axisConfig);
        Element element = ODEService.genEPRfromWSDL(this._definition, qName, string);
        if (element == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(qName, string));
        }
        this.endpointReference = EndpointFactory.convertToWSA((MutableEndpoint)ODEService.createServiceRef(element));
    }

    public void invoke(PartnerRoleMessageExchange partnerRoleMessageExchange) {
        block8: {
            boolean bl = partnerRoleMessageExchange.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
            try {
                ServiceClient serviceClient = this.getServiceClient();
                MessageContext messageContext = new MessageContext();
                messageContext.getOptions().setParent(serviceClient.getOptions());
                this.writeHeader(messageContext, partnerRoleMessageExchange);
                this._converter.createSoapRequest(messageContext, partnerRoleMessageExchange.getRequest(), partnerRoleMessageExchange.getOperation());
                SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
                EndpointReference endpointReference = new EndpointReference(((MutableEndpoint)partnerRoleMessageExchange.getEndpointReference()).getUrl());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Axis2 sending message to " + endpointReference.getAddress() + " using MEX " + partnerRoleMessageExchange));
                    __log.debug((Object)("Message: " + sOAPEnvelope));
                }
                OperationClient operationClient = serviceClient.createClient(bl ? ServiceClient.ANON_OUT_IN_OP : ServiceClient.ANON_OUT_ONLY_OP);
                operationClient.addMessageContext(messageContext);
                Options options = operationClient.getOptions();
                AuthenticationHelper.setHttpAuthentication(partnerRoleMessageExchange, options);
                options.setAction(messageContext.getSoapAction());
                options.setTo(endpointReference);
                if (bl) {
                    Operation operation = partnerRoleMessageExchange.getOperation();
                    try {
                        operationClient.execute(true);
                        MessageContext messageContext2 = operationClient.getMessageContext("In");
                        MessageContext messageContext3 = operationClient.getMessageContext("Fault");
                        if (messageContext2 != null && __log.isDebugEnabled()) {
                            __log.debug((Object)("Service response:\n" + messageContext2.getEnvelope().toString()));
                        }
                        if (messageContext3 != null) {
                            this.reply(partnerRoleMessageExchange, operation, messageContext3, true);
                            break block8;
                        }
                        this.reply(partnerRoleMessageExchange, operation, messageContext2, messageContext2.isFault());
                    }
                    catch (Throwable throwable) {
                        String string = "Error sending message to Axis2 for ODE mex " + partnerRoleMessageExchange;
                        __log.error((Object)string, throwable);
                        this.replyWithFailure(partnerRoleMessageExchange, MessageExchange.FailureType.COMMUNICATION_ERROR, string, null);
                    }
                    break block8;
                }
                operationClient.execute(false);
                partnerRoleMessageExchange.replyOneWayOk();
            }
            catch (AxisFault axisFault) {
                String string = "Error sending message to Axis2 for ODE mex " + partnerRoleMessageExchange;
                __log.error((Object)string, (Throwable)axisFault);
                partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, string, null);
            }
        }
    }

    private ServiceClient getServiceClient() throws AxisFault {
        try {
            this._axisServiceWatchDog.check();
            this._axisOptionsWatchDog.check();
        }
        catch (RuntimeException runtimeException) {
            throw AxisFault.makeFault((Throwable)(runtimeException.getCause() != null ? runtimeException.getCause() : runtimeException));
        }
        ServiceClient serviceClient = _cachedClients.get();
        if (serviceClient == null) {
            serviceClient = new ServiceClient(this._configContext, null);
            _cachedClients.set(serviceClient);
        }
        AxisService axisService = ((ServiceFileObserver)this._axisServiceWatchDog.getObserver()).anonymousService;
        serviceClient.setAxisService(axisService);
        serviceClient.setOptions(((OptionsObserver)this._axisOptionsWatchDog.getObserver()).options);
        this.applySecuritySettings(serviceClient);
        return serviceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySecuritySettings(ServiceClient serviceClient) throws AxisFault {
        Options options = serviceClient.getOptions();
        if (options.getProperty("security.policy") != null) {
            String string = (String)options.getProperty("security.policy");
            URI uRI = FileUtils.isRelative((String)string) ? this._pconf.getBaseURI().resolve(string) : new File(string).toURI();
            try {
                InputStream inputStream = uRI.toURL().openStream();
                try {
                    Policy policy = PolicyEngine.getPolicy((InputStream)inputStream);
                    options.setProperty("rampartPolicy", (Object)policy);
                    if (!serviceClient.getAxisService().getAxisConfiguration().isEngaged("rampart") && !serviceClient.getAxisService().isEngaged("rampart")) {
                        serviceClient.engageModule("rampart");
                    }
                    if (!serviceClient.getAxisService().getAxisConfiguration().isEngaged("metadataExchange") && !serviceClient.getAxisService().isEngaged("metadataExchange")) {
                        serviceClient.engageModule("metadataExchange");
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Exception while parsing policy: " + uRI, iOException);
            }
        }
    }

    private String getAction(String string) {
        String string2 = this._converter.getWSAInputAction(string);
        if (string2 == null || "".equals(string2)) {
            string2 = this._converter.getSoapAction(string);
        }
        return string2;
    }

    private void writeHeader(MessageContext messageContext, PartnerRoleMessageExchange partnerRoleMessageExchange) {
        Object object;
        Options options = messageContext.getOptions();
        WSAEndpoint wSAEndpoint = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)partnerRoleMessageExchange.getEndpointReference()));
        WSAEndpoint wSAEndpoint2 = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)partnerRoleMessageExchange.getMyRoleEndpointReference()));
        WSAEndpoint wSAEndpoint3 = new WSAEndpoint(wSAEndpoint);
        String string = partnerRoleMessageExchange.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        String string2 = partnerRoleMessageExchange.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (string != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Partner session identifier found for WSA endpoint: " + string));
            }
            wSAEndpoint3.setSessionId(string);
        }
        options.setProperty("targetSessionEndpoint", (Object)wSAEndpoint3);
        if (wSAEndpoint2 != null) {
            object = new WSAEndpoint(wSAEndpoint2);
            if (string2 != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("MyRole session identifier found for myrole (callback) WSA endpoint: " + string2));
                }
                object.setSessionId(string2);
            }
            options.setProperty("callbackSessionEndpoint", object);
        } else {
            __log.debug((Object)"My-Role EPR not specified, SEP will not be used.");
        }
        object = this.getAction(partnerRoleMessageExchange.getOperationName());
        messageContext.setSoapAction((String)object);
        if (MessageExchange.MessageExchangePattern.REQUEST_RESPONSE == partnerRoleMessageExchange.getMessageExchangePattern()) {
            EndpointReference endpointReference = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
            messageContext.setReplyTo(endpointReference);
            messageContext.setMessageID("uuid:" + new UUID().toString());
        }
    }

    public org.apache.ode.bpel.iapi.EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void close() {
    }

    public String getPortName() {
        return this._portName;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    private void replyWithFailure(PartnerRoleMessageExchange partnerRoleMessageExchange, MessageExchange.FailureType failureType, String string, Element element) {
        try {
            partnerRoleMessageExchange.replyWithFailure(failureType, string, element);
        }
        catch (Exception exception) {
            String string2 = "Error executing replyWithFailure; reply will be lost.";
            __log.error((Object)string2, (Throwable)exception);
        }
    }

    private void reply(PartnerRoleMessageExchange partnerRoleMessageExchange, Operation operation, MessageContext messageContext, boolean bl) {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Received response for MEX " + partnerRoleMessageExchange));
            }
            if (bl) {
                Document document = DOMUtils.newDocument();
                Element element = document.createElementNS(null, "message");
                document.appendChild(element);
                Fault fault = this._converter.parseSoapFault(element, messageContext.getEnvelope(), operation);
                if (fault != null) {
                    if (__log.isWarnEnabled()) {
                        __log.warn((Object)("Fault response: faultName=" + fault.getName() + " faultType=" + fault.getMessage().getQName() + "\n" + DOMUtils.domToString((Node)element)));
                    }
                    QName qName = fault.getMessage().getQName();
                    QName qName2 = new QName(this._definition.getTargetNamespace(), fault.getName());
                    Message message = partnerRoleMessageExchange.createMessage(qName);
                    message.setMessage(element);
                    partnerRoleMessageExchange.replyWithFault(qName2, message);
                } else {
                    if (__log.isWarnEnabled()) {
                        __log.warn((Object)("Fault response: faultType=(unkown)\n" + messageContext.getEnvelope().toString()));
                    }
                    partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.OTHER, messageContext.getEnvelope().getBody().getFault().getText(), OMUtils.toDOM((OMElement)messageContext.getEnvelope().getBody()));
                }
            } else {
                Message message = partnerRoleMessageExchange.createMessage(partnerRoleMessageExchange.getOperation().getOutput().getMessage().getQName());
                this._converter.parseSoapResponse(message, messageContext.getEnvelope(), operation);
                if (__log.isInfoEnabled()) {
                    __log.info((Object)("Response:\n" + (message.getMessage() != null ? DOMUtils.domToString((Node)message.getMessage()) : "empty")));
                }
                partnerRoleMessageExchange.reply(message);
            }
        }
        catch (Exception exception) {
            String string = "Unable to process response: " + exception.getMessage();
            __log.error((Object)string, (Throwable)exception);
            partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.OTHER, string, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EndpointPropertiesMutable
    implements WatchDog.Mutable<Map> {
        private EndpointPropertiesMutable() {
        }

        public boolean exists() {
            return true;
        }

        public boolean hasChangedSince(Map map) {
            Map map2 = this.lastModified();
            return !CollectionUtils.equals((Map)map2, (Map)map);
        }

        public Map lastModified() {
            return SoapExternalService.this._pconf.getEndpointProperties((org.apache.ode.bpel.iapi.EndpointReference)SoapExternalService.this.endpointReference);
        }

        public String toString() {
            return "Properties for Endpoint: " + SoapExternalService.this.endpointReference;
        }
    }

    private class OptionsObserver
    extends WatchDog.DefaultObserver {
        Options options;

        private OptionsObserver() {
        }

        public boolean isInitialized() {
            return this.options != null;
        }

        public void init() {
            this.options = new Options();
            this.options.setExceptionToBeThrownOnSOAPFault(false);
            this.options.setTimeOutInMilliSeconds(60000L);
        }

        public void onUpdate() {
            this.init();
            Map map = SoapExternalService.this._pconf.getEndpointProperties((org.apache.ode.bpel.iapi.EndpointReference)SoapExternalService.this.endpointReference);
            Properties.Axis2.translate(map, this.options);
        }
    }

    private class ServiceFileObserver
    extends WatchDog.DefaultObserver {
        String serviceName = "anonymous_service_" + new GUID().toString();
        AxisService anonymousService;
        File file;

        private ServiceFileObserver(File file) {
            this.file = file;
        }

        public boolean isInitialized() {
            return this.anonymousService != null;
        }

        public void init() {
            this.anonymousService = new AxisService(this.serviceName);
            this.anonymousService.setParent((AxisDescription)SoapExternalService.this._axisConfig);
            OutOnlyAxisOperation outOnlyAxisOperation = new OutOnlyAxisOperation(ServiceClient.ANON_OUT_ONLY_OP);
            this.anonymousService.addOperation((AxisOperation)outOnlyAxisOperation);
            OutInAxisOperation outInAxisOperation = new OutInAxisOperation(ServiceClient.ANON_OUT_IN_OP);
            this.anonymousService.addOperation((AxisOperation)outInAxisOperation);
        }

        public void onUpdate() {
            this.init();
            try {
                AxisUtils.configureService((ConfigurationContext)SoapExternalService.this._configContext, (AxisService)this.anonymousService, (URL)this.file.toURI().toURL());
                this.anonymousService.setName(this.serviceName);
            }
            catch (Exception exception) {
                if (__log.isWarnEnabled()) {
                    __log.warn((Object)("Exception while configuring service: " + SoapExternalService.this._serviceName), (Throwable)exception);
                }
                throw new RuntimeException("Exception while configuring service: " + SoapExternalService.this._serviceName, exception);
            }
        }
    }
}

