/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;
import org.eclipse.smila.importing.crawler.file.internal.FileToRecordConverter;
import org.eclipse.smila.importing.util.PropertyNameMapper;
import org.eclipse.smila.taskworker.TaskContext;

public class FileCrawlerServiceImpl
implements FileCrawlerService {
    private final Set<String> _filePropertyNames = new HashSet<String>();

    public FileCrawlerServiceImpl() {
        this._filePropertyNames.add("fileName");
        this._filePropertyNames.add("filePath");
        this._filePropertyNames.add("fileFolder");
        this._filePropertyNames.add("fileSize");
        this._filePropertyNames.add("fileLastModified");
        this._filePropertyNames.add("fileExtension");
        this._filePropertyNames.add("fileContent");
    }

    @Override
    public Collection<Path> listFiles(Path directory) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, new FileFilter());){
            Iterator<Path> iter = directoryStream.iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    @Override
    public Collection<Path> listDirectories(Path directory) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, new DirectoryFilter());){
            Iterator<Path> iter = directoryStream.iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    @Override
    public Collection<Path> list(Path directory) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            Iterator<Path> iter = directoryStream.iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    @Override
    public Record fileToRecord(Path file, String dataSource, boolean withContent) throws IOException {
        FileToRecordConverter converter = new FileToRecordConverter(DataFactory.DEFAULT);
        return converter.fileToRecord(file, dataSource, withContent);
    }

    @Override
    public void addAttachment(Record record, String pathAttribute, String attachmentName) throws IOException {
        FileToRecordConverter converter = new FileToRecordConverter(DataFactory.DEFAULT);
        converter.addAttachment(record, pathAttribute, attachmentName);
    }

    @Override
    public Record dirToRecord(Path directory, String dataSource) throws IOException {
        FileToRecordConverter converter = new FileToRecordConverter(DataFactory.DEFAULT);
        return converter.dirToRecord(directory, dataSource);
    }

    public InputStream getContent(Record record, TaskContext taskContext) throws ImportingException {
        PropertyNameMapper mapper = PropertyNameMapper.createFrom((TaskContext)taskContext);
        String path = record.getMetadata().getStringValue((String)mapper.get("filePath").get(0));
        if (path == null) {
            throw new IllegalArgumentException("Record '" + record.getId() + "' does not contain attribute '" + (String)mapper.get("filePath").get(0) + "'");
        }
        Path file = Paths.get(path, new String[0]);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new ImportingException("File '" + file + "' is not a file with content.");
        }
        try {
            return Files.newInputStream(file, StandardOpenOption.READ);
        }
        catch (IOException ex) {
            throw new ImportingException("File '" + file + "' does not exist or is not readable.", (Throwable)ex, false);
        }
    }

    @Override
    public Set<String> getFilePropertyNames() {
        return this._filePropertyNames;
    }

    private static class DirectoryFilter
    implements DirectoryStream.Filter<Path> {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isDirectory(entry, new LinkOption[0]);
        }
    }

    private static class FileFilter
    implements DirectoryStream.Filter<Path> {
        private FileFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isRegularFile(entry, new LinkOption[0]);
        }
    }
}

