/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.importing.util.FilePathNormalizer;

public final class FileToRecordConverter {
    private final DataFactory _factory;

    public FileToRecordConverter(DataFactory factory) {
        this._factory = factory;
    }

    public Record fileToRecord(Path file, String dataSource, boolean withContent) throws IOException {
        if (Files.isDirectory(file, new LinkOption[0])) {
            throw new IllegalArgumentException("parameter file is a directory");
        }
        Record record = this.createRecord(file, dataSource);
        this.addFileProperties(file, record);
        record.getMetadata().put("_deltaHash", Long.toString(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
        if (withContent) {
            this.addAttachment(record, "filePath", "fileContent");
        }
        return record;
    }

    public Record dirToRecord(Path directory, String dataSource) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("parameter directory is not a directory");
        }
        Record record = this.createRecord(directory, dataSource);
        record.getMetadata().put("fileFolder", directory.toRealPath(new LinkOption[0]).toString());
        return record;
    }

    public void addAttachment(Record record, String pathAttribute, String attachmentName) throws IOException {
        String path = record.getMetadata().getStringValue(pathAttribute);
        if (path == null) {
            throw new IllegalArgumentException("Record '" + record.getId() + "' does not contain attribute '" + pathAttribute + "'");
        }
        record.setAttachment(attachmentName, Files.readAllBytes(Paths.get(path, new String[0])));
    }

    private Record createRecord(Path file, String dataSource) throws IOException {
        return this._factory.createRecord(String.valueOf(dataSource) + ":" + file.toRealPath(new LinkOption[0]), dataSource);
    }

    private void addFileProperties(Path file, Record record) throws IOException {
        record.getMetadata().put("fileName", file.getFileName().toString());
        record.getMetadata().put("filePath", FilePathNormalizer.getNormalizedPath((Path)file.toRealPath(new LinkOption[0])));
        if (file.getParent() != null) {
            record.getMetadata().put("fileFolder", FilePathNormalizer.getNormalizedPath((Path)file.getParent()));
        }
        record.getMetadata().put("fileSize", (Number)Files.size(file));
        Value lastModifiedDate = this._factory.createDateTimeValue(new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
        record.getMetadata().put("fileLastModified", (Any)lastModifiedDate);
        record.getMetadata().put("fileExtension", FilenameUtils.getExtension((String)file.getFileName().toString()));
    }
}

