/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1.xpath10.jaxp;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.v1.CompilerContext;
import org.apache.ode.bpel.compiler.v1.ExpressionCompiler;
import org.apache.ode.bpel.compiler.v1.xpath10.jaxp.JaxpFunctionResolver;
import org.apache.ode.bpel.compiler.v1.xpath10.jaxp.JaxpVariableResolver;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxpXPath10ExpressionCompilerImpl
implements ExpressionCompiler {
    private static final Log __log = LogFactory.getLog(JaxpXPath10ExpressionCompilerImpl.class);
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    protected CompilerContext _compilerContext;
    private String _bpelNsURI;
    protected QName _qnFnGetVariableData;
    protected QName _qnFnGetVariableProperty;
    protected QName _qnFnGetLinkStatus;
    protected Map<String, String> _properties = new HashMap<String, String>();

    public JaxpXPath10ExpressionCompilerImpl(String string) {
        this._bpelNsURI = string;
        this._qnFnGetVariableData = new QName(this._bpelNsURI, "getVariableData");
        this._qnFnGetVariableProperty = new QName(this._bpelNsURI, "getVariableProperty");
        this._qnFnGetLinkStatus = new QName(this._bpelNsURI, "getLinkStatus");
        this._properties.put("runtime-class", "org.apache.ode.bpel.rtrep.v1.xpath10.jaxp.JaxpXPath10ExpressionRuntime");
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    protected void doJaxpCompile(OXPath10Expression oXPath10Expression, Expression expression) throws CompilationException {
        Node node = expression.getExpression();
        if (node == null) {
            throw new IllegalStateException("XPath string and xpath node are both null");
        }
        String string = node.getNodeValue();
        if ((string = string.trim()).length() == 0) {
            throw new CompilationException(__msgs.errXPathSyntax(string));
        }
        try {
            __log.debug((Object)("JAXP compile: xpath = " + string));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            __log.debug((Object)("JAXP compile: XPathFactory impl = " + xPathFactory.getClass()));
            XPath xPath = xPathFactory.newXPath();
            xPath.setXPathFunctionResolver(new JaxpFunctionResolver(this._compilerContext, oXPath10Expression, expression.getNamespaceContext(), this._bpelNsURI));
            xPath.setXPathVariableResolver(new JaxpVariableResolver(this._compilerContext, oXPath10Expression));
            xPath.setNamespaceContext((NamespaceContext)expression.getNamespaceContext());
            XPathExpression xPathExpression = xPath.compile(string);
            xPathExpression.evaluate(DOMUtils.newDocument());
            oXPath10Expression.xpath = string;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CompilationException(__msgs.errUnexpectedCompilationError(xPathExpressionException.getMessage()), (Throwable)xPathExpressionException);
        }
    }
}

