/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: T. Menzel (brox) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.datamodel.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;

/**
 * immutable decorator for an AnyMap.
 */
public class ImmutableAnyMapImpl implements AnyMap {

  /** The underlying anymap. */
  private final AnyMap _anyMap;

  /** The underlying map, as immutable. */
  private final Map<String, Any> _immutable;

  /**
   * @param createAnyMap
   */
  public ImmutableAnyMapImpl(AnyMap map) {
    _anyMap = map;
    _immutable = Collections.unmodifiableMap(map);
  }

  /**
   * @param key
   * @param value
   * @see org.eclipse.smila.datamodel.AnyMap#add(java.lang.String, org.eclipse.smila.datamodel.Any)
   */
  public void add(String key, Any value) {
    throw new UnsupportedOperationException();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#asMap()
   */
  public AnyMap asMap() {
    return _anyMap.asMap();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#asSeq()
   */
  public AnySeq asSeq() {
    return _anyMap.asSeq();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#asValue()
   */
  public Value asValue() {
    return _anyMap.asValue();
  }

  /**
   * 
   * @see java.util.Map#clear()
   */
  public void clear() {
    _immutable.clear();
  }

  /**
   * @param key
   * @return
   * @see java.util.Map#containsKey(java.lang.Object)
   */
  public boolean containsKey(Object key) {
    return _immutable.containsKey(key);
  }

  /**
   * @param value
   * @return
   * @see java.util.Map#containsValue(java.lang.Object)
   */
  public boolean containsValue(Object value) {
    return _immutable.containsValue(value);
  }

  /**
   * @return
   * @see java.util.Map#entrySet()
   */
  public Set<java.util.Map.Entry<String, Any>> entrySet() {
    return _immutable.entrySet();
  }

  /**
   * @param o
   * @return
   * @see java.util.Map#equals(java.lang.Object)
   */
  public boolean equals(Object o) {
    return _immutable.equals(o);
  }

  /**
   * @param key
   * @return
   * @see java.util.Map#get(java.lang.Object)
   */
  public Any get(Object key) {
    return _immutable.get(key);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getBooleanValue(java.lang.String)
   */
  public Boolean getBooleanValue(String key) {
    return _anyMap.getBooleanValue(key);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getDateTimeValue(java.lang.String)
   */
  public Date getDateTimeValue(String key) {
    return _anyMap.getDateTimeValue(key);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getDateValue(java.lang.String)
   */
  public Date getDateValue(String key) {
    return _anyMap.getDateValue(key);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getDoubleValue(java.lang.String)
   */
  public Double getDoubleValue(String key) {
    return _anyMap.getDoubleValue(key);
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#getFactory()
   */
  public DataFactory getFactory() {
    return _anyMap.getFactory();
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getLongValue(java.lang.String)
   */
  public Long getLongValue(String key) {
    return _anyMap.getLongValue(key);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getMap(java.lang.String)
   */
  public AnyMap getMap(String key) {
    return _anyMap.getMap(key);
  }

  /**
   * @param key
   * @param create
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getMap(java.lang.String, boolean)
   */
  public AnyMap getMap(String key, boolean create) {
    return _anyMap.getMap(key, create);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getSeq(java.lang.String)
   */
  public AnySeq getSeq(String key) {
    return _anyMap.getSeq(key);
  }

  /**
   * @param key
   * @param create
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getSeq(java.lang.String, boolean)
   */
  public AnySeq getSeq(String key, boolean create) {
    return _anyMap.getSeq(key, create);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getStringValue(java.lang.String)
   */
  public String getStringValue(String key) {
    return _anyMap.getStringValue(key);
  }

  /**
   * @param key
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#getValue(java.lang.String)
   */
  public Value getValue(String key) {
    return _anyMap.getValue(key);
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#getValueType()
   */
  public ValueType getValueType() {
    return _anyMap.getValueType();
  }

  /**
   * @return
   * @see java.util.Map#hashCode()
   */
  public int hashCode() {
    return _immutable.hashCode();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isBoolean()
   */
  public boolean isBoolean() {
    return _anyMap.isBoolean();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isDate()
   */
  public boolean isDate() {
    return _anyMap.isDate();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isDateTime()
   */
  public boolean isDateTime() {
    return _anyMap.isDateTime();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isDouble()
   */
  public boolean isDouble() {
    return _anyMap.isDouble();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isEmpty()
   */
  public boolean isEmpty() {
    return _immutable.isEmpty();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isLong()
   */
  public boolean isLong() {
    return _anyMap.isLong();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isMap()
   */
  public boolean isMap() {
    return _anyMap.isMap();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isNumber()
   */
  public boolean isNumber() {
    return _anyMap.isNumber();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isSeq()
   */
  public boolean isSeq() {
    return _anyMap.isSeq();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isString()
   */
  public boolean isString() {
    return _anyMap.isString();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#isValue()
   */
  public boolean isValue() {
    return _anyMap.isValue();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#iterator()
   */
  public Iterator<Any> iterator() {
    return _anyMap.iterator();
  }

  /**
   * @return
   * @see java.util.Map#keySet()
   */
  public Set<String> keySet() {
    return _immutable.keySet();
  }

  /**
   * @param key
   * @param value
   * @return
   * @see java.util.Map#put(java.lang.Object, java.lang.Object)
   */
  public Any put(String key, Any value) {
    throw new UnsupportedOperationException();
  }

  /**
   * @param key
   * @param value
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#put(java.lang.String, java.lang.Boolean)
   */
  public Any put(String key, Boolean value) {
    throw new UnsupportedOperationException();
  }

  /**
   * @param key
   * @param value
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#put(java.lang.String, java.lang.Number)
   */
  public Any put(String key, Number value) {
    throw new UnsupportedOperationException();
  }

  /**
   * @param key
   * @param value
   * @return
   * @see org.eclipse.smila.datamodel.AnyMap#put(java.lang.String, java.lang.String)
   */
  public Any put(String key, String value) {
    throw new UnsupportedOperationException();
  }

  /**
   * @param m
   * @see java.util.Map#putAll(java.util.Map)
   */
  public void putAll(Map<? extends String, ? extends Any> m) {
    throw new UnsupportedOperationException();
  }

  /**
   * @param key
   * @return
   * @see java.util.Map#remove(java.lang.Object)
   */
  public Any remove(Object key) {
    throw new UnsupportedOperationException();
  }

  /**
   * @return
   * @see org.eclipse.smila.datamodel.Any#size()
   */
  public int size() {
    return _immutable.size();
  }

  /**
   * @return
   * @see java.util.Map#values()
   */
  public Collection<Any> values() {
    return _immutable.values();
  }

}
