/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.solr.admin;

import org.eclipse.smila.management.LocatedManagementAgentBase;

public class SolrAdministrationAgent extends LocatedManagementAgentBase {

  /**
   * The jmx category.
   */
  private static final String CATEGORY = "Solr";

  /**
   * The agent name.
   */
  private static final String NAME = "SolrAdmin";

  private static final String OK = "OK";

  /**
   * The SolrAdmin.
   */
  private final SolrAdministration _administration;

  /**
   * Constructor.
   * 
   * @param solrAdmin
   *          the SolrAdmin.
   */
  public SolrAdministrationAgent(SolrAdministration administration) {
    _administration = administration;
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.management.LocatedManagementAgentBase#getCategory()
   */
  @Override
  protected String getCategory() {
    return CATEGORY;
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.management.LocatedManagementAgentBase#getName()
   */
  @Override
  protected String getName() {
    return NAME;
  }

  /**
   * Execute create action.
   * 
   * @param core
   *          the core name.
   * @param intanceDir
   *          the instance directory.
   * @param dataDir
   *          the data directory.
   * @return the response message.
   */
  public String create(final String core, final String intanceDir) {
    try {
      _administration.create(core, intanceDir);
      return OK;
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute reload action.
   * 
   * @param core
   *          the core name.
   * @return the response message.
   */
  public String reload(final String core) {
    try {
      _administration.reload(core);
      return OK;
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute rename action.
   * 
   * @param core
   *          the core name.
   * @param other
   *          the new core name.
   * @return the response message.
   */
  public String rename(final String core, final String other) {
    try {
      _administration.rename(core, other);
      return OK;
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute unload action.
   * 
   * @param core
   *          the core name.
   * @return the response message.
   */
  public String unload(final String core) {
    try {
      _administration.unload(core);
      return OK;
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute getCoreNames action.
   * 
   * @return either a list of core names, or an error message.
   */
  public Object getCoreNames() {
    try {
      return _administration.getCoreNames();
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute getFieldNames action.
   * 
   * @param coreName
   *          the core name.
   * @return either a list of field names, or an error message.
   */
  public Object getFieldNames(final String coreName) {
    try {
      return _administration.getFieldNames(coreName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /** clear internal caches after external admin operations. */
  public void clearCoreCaches() {
    _administration.clearCoreCaches();
  }

  /** remove internal data about the given core because it was removed or changed and the caches should be updated. */
  public void clearCoreCache(String coreName) {
    _administration.clearCoreCache(coreName);
  }

}
