/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ProcessingConstants;
import org.eclipse.smila.processing.util.ResultCollector;

/**
 * Simple pipelet to remove an attribute.
 * 
 * @author jschumacher
 */
public class RemoveAttributePipelet implements Pipelet {

  /** config property name for attribute name to add values to. */
  private static final String PARAM_ATTRIBUTE = "removeAttribute";

  /** my logger. */
  private final Log _log = LogFactory.getLog(getClass());

  /** the pipelet configuration. */
  private AnyMap _configuration;

  /**
   * remove configured attribute.
   * 
   * {@inheritDoc}
   */
  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    final ParameterAccessor parameters = new ParameterAccessor(blackboard, _configuration);
    final ResultCollector resultCollector =
      new ResultCollector(parameters, _log, ProcessingConstants.DROP_ON_ERROR_DEFAULT);
    if (recordIds != null && recordIds.length > 0) {
      for (final String id : recordIds) {
        try {
          final AnyMap record = blackboard.getMetadata(id);
          if (record != null) {
            parameters.setCurrentRecord(id);
            final String removeAttribute = parameters.getParameter(PARAM_ATTRIBUTE, null);
            if (removeAttribute != null) {
              blackboard.getMetadata(id).remove(removeAttribute);
            }
          }
          resultCollector.addResult(id);
        } catch (final Exception ex) {
          resultCollector.addFailedResult(id, ex);
        }
      }
    }
    return resultCollector.getResultIds();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    _configuration = configuration;
  }
}
