/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.impl;

import org.apache.http.conn.ClientConnectionManager;
import org.eclipse.smila.http.client.impl.base.RestClientBase;
import org.eclipse.smila.http.client.util.HttpClientUtil;

/** Default implementation of {@link org.eclipse.smila.http.client.RestClient}. */
public class DefaultRestClient extends RestClientBase {

  /** Talk to a SMILA server on the same host on default port: http://localhost:8080. */
  public DefaultRestClient() {
    this(DEFAULT_HOSTANDPORT);
  }

  /**
   * Talk to the given SMILA server.
   * 
   * @param hostAndPort
   *          host and port of a SMILA service, in format "host:port". Don't include a trailing slash ("/").
   */
  public DefaultRestClient(final String hostAndPort) {
    this(hostAndPort, HttpClientUtil.createThreadSafeConnectionManager());
  }

  /**
   * Talk to the given SMILA server, using a non-default connection configuration.
   * 
   * @param hostAndPort
   *          host and port of a SMILA service, in format "host:port". Don't include a trailing slash ("/").
   * @param maxTotalConnections
   *          maximum number of total HTTP connections
   * @param maxConnectionsPerHost
   *          maximum number of connections per host
   */
  public DefaultRestClient(final String hostAndPort, final int maxTotalConnections, final int maxConnectionsPerHost) {
    this(hostAndPort, HttpClientUtil.createThreadSafeConnectionManager(maxTotalConnections, maxConnectionsPerHost));
  }

  /**
   * Talk to given SMILA server, using a given connection manager.
   * 
   * @param hostAndPort
   *          host and port of a SMILA service, in format "host:port". Don't include a trailing slash ("/").
   * @param connectionManager
   *          an initialized Apache HttpClient connection manager.
   */
  public DefaultRestClient(final String hostAndPort, final ClientConnectionManager connectionManager) {
    super(connectionManager, new DefaultHttpRequestFactory(), new DefaultHttpRequestExecutor(hostAndPort),
      new DefaultHttpResultHandler());
  }
}
