/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.impl.base;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpParams;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.http.client.Attachments;
import org.eclipse.smila.http.client.HttpMethod;

/**
 * Factory that prepares Apache HTTP client related objects for the {@link org.eclipse.smila.http.client.RestClient}.
 * The interface has been defined to be able to modify details of the HTTP requests created by the
 * {@link org.eclipse.smila.http.client.RestClient} for special use cases. Usually the default implementation provided
 * by this bundle is completely sufficient, so a standard user does not need to care about these things.
 */
public interface HttpRequestFactory {

  /** MIME type of JSON. */
  String MIMETYPE_JSON = "application/json";

  /** Default encoding for char-to-byte conversion. */
  String ENCODING = "UTF-8";

  /** Content-Type header value for JSON with UTF-8 charset. */
  String CONTENTTYPE_JSON = HttpRequestFactory.MIMETYPE_JSON + "; charset=" + ENCODING;

  /** Default charset for char-to-byte conversion. */
  Charset CHARSET = Charset.forName(ENCODING);

  /** Create request object for method and url. */
  HttpUriRequest getHttpMethod(final HttpMethod method, final String url);

  /** Create request object for method and URL and set optional parameters. */
  HttpUriRequest getHttpMethod(final HttpMethod method, final String url, final HttpParams methodParams);

  /** Write parameters to JSON and wrap as an {@link HttpEntity}. */
  HttpEntity createJsonEntity(final Any parameters) throws IOException;

  /** Wrap an UTF-8-JSON input stream as an {@link HttpEntity}. */
  HttpEntity createJsonEntity(final InputStream inputStream) throws IOException;

  /** Wrap an input stream with any content type as an {@link HttpEntity}. */
  HttpEntity createEntity(final InputStream inputStream, String contentType) throws IOException;

  /** Create an HTTP entity from the input data. */
  HttpEntity createHttpEntity(final Any parameters, final Attachments attachments) throws IOException;

  /** Create a multipart entity for a JSON metadata body and attachments. */
  HttpEntity createMultipartEntity(final Any parameters, final Attachments attachments) throws IOException;

}
