/*******************************************************************************
 * Copyright (c) 2009 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (empolis GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.ontology.activator;

import org.eclipse.smila.ontology.SesameOntologyManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/**
 * create a service tracker for SesameOntologyManager services.
 * 
 * @author jschumacher
 * 
 */
public class Activator implements BundleActivator {
  /** singleton instance. */
  private static Activator s_instance;

  /**
   * my service tracker.
   */
  private ServiceTracker<?, SesameOntologyManager> _tracker;

  /**
   * Get activator instance.
   * 
   * @return the activator instance.
   */
  public static Activator getInstance() {
    return s_instance;
  }

  /** set instance for access via {@link #getInstance()}. */
  private static void setInstance(final Activator instance) {
    s_instance = instance;
  }

  /**
   * 
   * @return the current SesameOntologyManager service instance.
   */
  public SesameOntologyManager getService() {
    if (_tracker == null) {
      return null;
    }
    return _tracker.getService();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
   */
  @Override
  public void start(final BundleContext context) throws Exception {
    setInstance(this);
    _tracker = new ServiceTracker<>(context, SesameOntologyManager.class.getName(), null);
    _tracker.open();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
   */
  @Override
  public void stop(final BundleContext context) throws Exception {
    _tracker.close();
    _tracker = null;
    setInstance(null);
  }

}
