/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing.crawler.web.extractor;

import java.io.InputStream;
import java.util.Collection;

import org.eclipse.smila.common.logging.MessageCollector;
import org.eclipse.smila.datamodel.AnyMap;

/**
 * Extracts links from HTML Content.
 */
public interface LinkExtractorHtml {

  /** @return links extracted from (HTML) input. */
  Collection<String> extractLinks(final InputStream input, final AnyMap parameters,
    final MessageCollector messageCollector) throws Exception;
}
