/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.web.producer;

import java.util.Arrays;
import java.util.Collection;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ImportingConstants;
import org.eclipse.smila.importing.crawler.web.RecordProducer;
import org.eclipse.smila.importing.crawler.web.WebCrawlerConstants;
import org.eclipse.smila.importing.crawler.web.WebCrawlerException;
import org.eclipse.smila.importing.crawler.web.WebCrawlingContext;
import org.eclipse.smila.importing.crawler.web.utils.DeltaHash;

/** Really simple implementation of RecordProducer that just returns the unchanged input. */
public class DefaultRecordProducer implements RecordProducer {

  @Override
  public Collection<Record> produceRecords(final Record record, final WebCrawlingContext context)
    throws WebCrawlerException {
    final String url = record.getMetadata().getStringValue(WebCrawlerConstants.ATTRIBUTE_URL);
    final String source = context.getTaskParameters().getStringValue(ImportingConstants.TASK_PARAM_DATA_SOURCE);
    record.setId(source + ":" + url);
    record.setSource(source);

    DeltaHash.calculate(record);
    return Arrays.asList(record);
  }
}
