/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.exceptions;

/**
 * unchecked exception thrown when the specified task generator could not be retrieved.
 */
public class NoSuchTaskGeneratorException extends IllegalArgumentException {

  /** is serializable. */
  private static final long serialVersionUID = 1L;

  /** constructs a new instance. */
  public NoSuchTaskGeneratorException() {
    super();
  }

  /** constructs a new instance. */
  public NoSuchTaskGeneratorException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** constructs a new instance. */
  public NoSuchTaskGeneratorException(final String s) {
    super(s);
  }

  /** constructs a new instance. */
  public NoSuchTaskGeneratorException(final Throwable cause) {
    super(cause);
  }

}
