/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudUtil {
    protected static Logger log = LoggerFactory.getLogger(CloudUtil.class);

    public static void checkSharedFSFailoverReplaced(CoreContainer cc, CoreDescriptor desc) {
        ZkController zkController = cc.getZkController();
        String thisCnn = zkController.getCoreNodeName(desc);
        String thisBaseUrl = zkController.getBaseUrl();
        log.debug("checkSharedFSFailoverReplaced running for coreNodeName={} baseUrl={}", (Object)thisCnn, (Object)thisBaseUrl);
        Map slicesMap = zkController.getClusterState().getSlicesMap(desc.getCloudDescriptor().getCollectionName());
        if (slicesMap != null) {
            for (Slice slice : slicesMap.values()) {
                for (Replica replica : slice.getReplicas()) {
                    String cnn = replica.getName();
                    String baseUrl = replica.getStr("base_url");
                    log.debug("compare against coreNodeName={} baseUrl={}", (Object)cnn, (Object)baseUrl);
                    if (thisCnn == null || !thisCnn.equals(cnn) || thisBaseUrl.equals(baseUrl)) continue;
                    if (cc.getCoreNames().contains(desc.getName())) {
                        cc.unload(desc.getName());
                    }
                    File instanceDir = new File(desc.getInstanceDir());
                    try {
                        FileUtils.deleteDirectory((File)instanceDir);
                    }
                    catch (IOException e) {
                        SolrException.log((Logger)log, (String)("Failed to delete instance dir for core:" + desc.getName() + " dir:" + instanceDir.getAbsolutePath()));
                    }
                    log.error("", (Throwable)new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Will not load SolrCore " + desc.getName() + " because it has been replaced due to failover."));
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Will not load SolrCore " + desc.getName() + " because it has been replaced due to failover.");
                }
            }
        }
    }
}

