/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryStrategy
extends Thread
implements ClosableThread {
    private static final int MAX_RETRIES = 500;
    private static final int INTERRUPTED = 501;
    private static final int STARTING_RECOVERY_DELAY = 1000;
    private static final String REPLICATION_HANDLER = "/replication";
    private static Logger log = LoggerFactory.getLogger(RecoveryStrategy.class);
    private volatile boolean close = false;
    private RecoveryListener recoveryListener;
    private ZkController zkController;
    private String baseUrl;
    private String coreZkNodeName;
    private ZkStateReader zkStateReader;
    private volatile String coreName;
    private int retries;
    private boolean recoveringAfterStartup;
    private CoreContainer cc;
    private volatile HttpUriRequest prevSendPreRecoveryHttpUriRequest;

    public RecoveryStrategy(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
        this.cc = cc;
        this.coreName = cd.getName();
        this.recoveryListener = recoveryListener;
        this.setName("RecoveryThread");
        this.zkController = cc.getZkController();
        this.zkStateReader = this.zkController.getZkStateReader();
        this.baseUrl = this.zkController.getBaseUrl();
        this.coreZkNodeName = cd.getCloudDescriptor().getCoreNodeName();
    }

    public void setRecoveringAfterStartup(boolean recoveringAfterStartup) {
        this.recoveringAfterStartup = recoveringAfterStartup;
    }

    public void close() {
        this.close = true;
        try {
            this.prevSendPreRecoveryHttpUriRequest.abort();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        log.warn("Stopping recovery for core={} coreNodeName={}", (Object)this.coreName, (Object)this.coreZkNodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoveryFailed(SolrCore core, ZkController zkController, String baseUrl, String shardZkNodeName, CoreDescriptor cd) throws KeeperException, InterruptedException {
        SolrException.log((Logger)log, (String)("Recovery failed - I give up. core=" + this.coreName));
        try {
            zkController.publish(cd, "recovery_failed");
        }
        finally {
            this.close();
            this.recoveryListener.failed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicate(String nodeName, SolrCore core, ZkNodeProps leaderprops) throws SolrServerException, IOException {
        boolean success;
        ReplicationHandler replicationHandler;
        ZkCoreNodeProps leaderCNodeProps = new ZkCoreNodeProps(leaderprops);
        String leaderUrl = leaderCNodeProps.getCoreUrl();
        log.info("Attempting to replicate from " + leaderUrl + ". core=" + this.coreName);
        this.commitOnLeader(leaderUrl);
        SolrRequestHandler handler = core.getRequestHandler(REPLICATION_HANDLER);
        if (handler instanceof RequestHandlers.LazyRequestHandlerWrapper) {
            handler = ((RequestHandlers.LazyRequestHandlerWrapper)handler).getWrappedHandler();
        }
        if ((replicationHandler = (ReplicationHandler)handler) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Skipping recovery, no /replication handler found");
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("masterUrl", new String[]{leaderUrl});
        if (this.isClosed()) {
            this.retries = 501;
        }
        if (!(success = replicationHandler.doFetch((SolrParams)solrParams, false))) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replication for recovery failed.");
        }
        if (log.isDebugEnabled()) {
            try {
                RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                SolrIndexSearcher searcher = searchHolder.get();
                Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.META_DATA, null);
                try {
                    log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " replicated " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits + " from " + leaderUrl + " gen:" + core.getDeletionPolicy().getLatestCommit().getGeneration() + " data:" + core.getDataDir() + " index:" + core.getIndexDir() + " newIndex:" + core.getNewIndexDir() + " files:" + Arrays.asList(dir.listAll()));
                }
                finally {
                    core.getDirectoryFactory().release(dir);
                    searchHolder.decref();
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitOnLeader(String leaderUrl) throws SolrServerException, IOException {
        HttpSolrServer server = new HttpSolrServer(leaderUrl);
        try {
            server.setConnectionTimeout(30000);
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.getParams().set("commit_end_point", true);
            ureq.getParams().set("openSearcher", false);
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true).process((SolrServer)server);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (SolrCore core = this.cc.getCore(this.coreName);){
            if (core == null) {
                SolrException.log((Logger)log, (String)("SolrCore not found - cannot recover:" + this.coreName));
                return;
            }
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            log.info("Starting recovery process.  core=" + this.coreName + " recoveringAfterStartup=" + this.recoveringAfterStartup);
            try {
                this.doRecovery(core);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        finally {
            SolrRequestInfo.clearRequestInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecovery(SolrCore core) throws KeeperException, InterruptedException {
        List<Long> recentVersions;
        boolean replayed = false;
        boolean successfulRecovery = false;
        UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            SolrException.log((Logger)log, (String)("No UpdateLog found - cannot recover. core=" + this.coreName));
            this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
            return;
        }
        boolean firstTime = true;
        try (UpdateLog.RecentUpdates recentUpdates = null;){
            recentUpdates = ulog.getRecentUpdates();
            recentVersions = recentUpdates.getVersions(ulog.numRecordsToKeep);
        }
        List<Long> startingVersions = ulog.getStartingVersions();
        if (startingVersions != null && this.recoveringAfterStartup) {
            try {
                int oldIdx;
                long firstStartingVersion;
                long l = firstStartingVersion = startingVersions.size() > 0 ? startingVersions.get(0) : 0L;
                for (oldIdx = 0; oldIdx < recentVersions.size() && recentVersions.get(oldIdx) != firstStartingVersion; ++oldIdx) {
                }
                if (oldIdx > 0) {
                    log.info("####### Found new versions added after startup: num=" + oldIdx);
                    log.info("###### currentVersions=" + recentVersions);
                }
                log.info("###### startupVersions=" + startingVersions);
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Error getting recent versions. core=" + this.coreName), (Throwable)e);
                recentVersions = new ArrayList<Long>(0);
            }
        }
        if (this.recoveringAfterStartup) {
            recentVersions = startingVersions;
            try {
                if ((ulog.getStartingOperation() & 0x10) != 0) {
                    log.info("Looks like a previous replication recovery did not complete - skipping peer sync. core=" + this.coreName);
                    firstTime = false;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Error trying to get ulog starting operation. core=" + this.coreName), (Throwable)e);
                firstTime = false;
            }
        }
        while (!(successfulRecovery || this.isInterrupted() || this.isClosed())) {
            try {
                CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
                Replica leaderprops = this.zkStateReader.getLeaderRetry(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                String leaderBaseUrl = leaderprops.getStr("base_url");
                String leaderCoreName = leaderprops.getStr("core");
                String leaderUrl = ZkCoreNodeProps.getCoreUrl((String)leaderBaseUrl, (String)leaderCoreName);
                String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
                boolean isLeader = leaderUrl.equals(ourUrl);
                if (isLeader && !cloudDesc.isLeader()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                }
                if (cloudDesc.isLeader()) {
                    log.warn("We have not yet recovered - but we are now the leader! core=" + this.coreName);
                    log.info("Finished recovery process. core=" + this.coreName);
                    this.zkController.publish(core.getCoreDescriptor(), "active");
                    return;
                }
                log.info("Publishing state of core " + core.getName() + " as recovering, leader is " + leaderUrl + " and I am " + ourUrl);
                this.zkController.publish(core.getCoreDescriptor(), "recovering");
                Slice slice = this.zkStateReader.getClusterState().getSlice(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                try {
                    this.prevSendPreRecoveryHttpUriRequest.abort();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (this.isClosed()) {
                    log.info("Recovery was cancelled");
                    break;
                }
                this.sendPrepRecoveryCmd(leaderBaseUrl, leaderCoreName, slice);
                if (this.isClosed()) {
                    log.info("Recovery was cancelled");
                    break;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (firstTime) {
                    firstTime = false;
                    log.info("Attempting to PeerSync from " + leaderUrl + " core=" + this.coreName + " - recoveringAfterStartup=" + this.recoveringAfterStartup);
                    PeerSync peerSync = new PeerSync(core, Collections.singletonList(leaderUrl), ulog.numRecordsToKeep, false, false);
                    peerSync.setStartingVersions(recentVersions);
                    boolean syncSuccess = peerSync.sync();
                    if (syncSuccess) {
                        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                        core.getUpdateHandler().commit(new CommitUpdateCommand(req, false));
                        log.info("PeerSync Recovery was successful - registering as Active. core=" + this.coreName);
                        if (log.isDebugEnabled()) {
                            try {
                                RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                                SolrIndexSearcher searcher = searchHolder.get();
                                try {
                                    log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " synched " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                                }
                                finally {
                                    searchHolder.decref();
                                }
                            }
                            catch (Exception e) {
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
                            }
                        }
                        this.zkController.publish(core.getCoreDescriptor(), "active");
                        successfulRecovery = true;
                        this.close = true;
                        return;
                    }
                    log.info("PeerSync Recovery was not successful - trying replication. core=" + this.coreName);
                }
                if (this.isClosed()) {
                    log.info("Recovery was cancelled");
                    break;
                }
                log.info("Starting Replication Recovery. core=" + this.coreName);
                log.info("Begin buffering updates. core=" + this.coreName);
                ulog.bufferUpdates();
                replayed = false;
                try {
                    this.replicate(this.zkController.getNodeName(), core, (ZkNodeProps)leaderprops);
                    if (this.isClosed()) {
                        log.info("Recovery was cancelled");
                        break;
                    }
                    this.replay(core);
                    replayed = true;
                    if (this.isClosed()) {
                        log.info("Recovery was cancelled");
                        break;
                    }
                    log.info("Replication Recovery was successful - registering as Active. core=" + this.coreName);
                    this.zkController.publish(core.getCoreDescriptor(), "active");
                    this.close = true;
                    successfulRecovery = true;
                    this.recoveryListener.recovered();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Recovery was interrupted", (Throwable)e);
                    this.retries = 501;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"Error while trying to recover", (Throwable)e);
                }
                finally {
                    if (!replayed) {
                        try {
                            ulog.dropBufferedUpdates();
                        }
                        catch (Exception e) {
                            SolrException.log((Logger)log, (String)"", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Error while trying to recover. core=" + this.coreName), (Throwable)e);
            }
            if (successfulRecovery) continue;
            try {
                log.error("Recovery failed - trying again... (" + this.retries + ") core=" + this.coreName);
                if (this.isClosed()) {
                    this.retries = 501;
                }
                ++this.retries;
                if (this.retries >= 500) {
                    if (this.retries >= 501) {
                        SolrException.log((Logger)log, (String)("Recovery failed - interrupted. core=" + this.coreName));
                        try {
                            this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
                        }
                        catch (Exception e) {
                            SolrException.log((Logger)log, (String)"Could not publish that recovery failed", (Throwable)e);
                        }
                        break;
                    }
                    SolrException.log((Logger)log, (String)("Recovery failed - max retries exceeded (" + this.retries + "). core=" + this.coreName));
                    try {
                        this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)log, (String)"Could not publish that recovery failed", (Throwable)e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("core=" + this.coreName), (Throwable)e);
            }
            try {
                double loopCount = Math.min(Math.pow(2.0, this.retries), 600.0);
                log.info("Wait {} seconds before trying to recover again ({})", (Object)loopCount, (Object)this.retries);
                int i = 0;
                while ((double)i < loopCount && !this.isClosed()) {
                    Thread.sleep(1000L);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Recovery was interrupted. core=" + this.coreName, (Throwable)e);
                this.retries = 501;
            }
        }
        log.info("Finished recovery process. core=" + this.coreName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<UpdateLog.RecoveryInfo> replay(SolrCore core) throws InterruptedException, ExecutionException {
        Future<UpdateLog.RecoveryInfo> future = core.getUpdateHandler().getUpdateLog().applyBufferedUpdates();
        if (future == null) {
            log.info("No replay needed. core=" + this.coreName);
        } else {
            log.info("Replaying buffered documents. core=" + this.coreName);
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                SolrException.log((Logger)log, (String)"Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
        }
        if (log.isDebugEnabled()) {
            try {
                RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                SolrIndexSearcher searcher = searchHolder.get();
                try {
                    log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " replayed " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                }
                finally {
                    searchHolder.decref();
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
            }
        }
        return future;
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPrepRecoveryCmd(String leaderBaseUrl, String leaderCoreName, Slice slice) throws SolrServerException, IOException, InterruptedException, ExecutionException {
        HttpSolrServer server = new HttpSolrServer(leaderBaseUrl);
        try {
            server.setConnectionTimeout(30000);
            CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
            prepCmd.setCoreName(leaderCoreName);
            prepCmd.setNodeName(this.zkController.getNodeName());
            prepCmd.setCoreNodeName(this.coreZkNodeName);
            prepCmd.setState("recovering");
            prepCmd.setCheckLive(Boolean.valueOf(true));
            prepCmd.setOnlyIfLeader(true);
            if (!Slice.CONSTRUCTION.equals(slice.getState()) && !Slice.RECOVERY.equals(slice.getState())) {
                prepCmd.setOnlyIfLeaderActive(true);
            }
            HttpSolrServer.HttpUriRequestResponse mrr = server.httpUriRequest((SolrRequest)prepCmd);
            this.prevSendPreRecoveryHttpUriRequest = mrr.httpUriRequest;
            log.info("Sending prep recovery command to {}; {}", (Object)leaderBaseUrl, (Object)prepCmd.toString());
            mrr.future.get();
        }
        finally {
            server.shutdown();
        }
    }

    public static interface RecoveryListener {
        public void recovered();

        public void failed();
    }
}

