/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.Config;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.FastLRUCache;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.RegexFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SolrConfig
extends Config {
    public static final Logger log = LoggerFactory.getLogger(SolrConfig.class);
    public static final String DEFAULT_CONF_FILE = "solrconfig.xml";
    private int multipartUploadLimitKB;
    private int formUploadLimitKB;
    private boolean enableRemoteStreams;
    private boolean handleSelect;
    private boolean addHttpRequestToContext;
    private final SolrRequestParsers solrRequestParsers;
    public final int booleanQueryMaxClauseCount;
    public final CacheConfig filterCacheConfig;
    public final CacheConfig queryResultCacheConfig;
    public final CacheConfig documentCacheConfig;
    public final CacheConfig fieldValueCacheConfig;
    public final CacheConfig[] userCacheConfigs;
    public final boolean useFilterForSortedQuery;
    public final int queryResultWindowSize;
    public final int queryResultMaxDocsCached;
    public final boolean enableLazyFieldLoading;
    public final boolean nrtMode;
    public final float hashSetInverseLoadFactor;
    public final int hashDocSetMaxSize;
    @Deprecated
    public final SolrIndexConfig defaultIndexConfig;
    @Deprecated
    public final SolrIndexConfig mainIndexConfig;
    public final SolrIndexConfig indexConfig;
    protected UpdateHandlerInfo updateHandlerInfo;
    private Map<String, List<PluginInfo>> pluginStore = new LinkedHashMap<String, List<PluginInfo>>();
    public final int maxWarmingSearchers;
    public final boolean unlockOnStartup;
    public final boolean useColdSearcher;
    public final Version luceneMatchVersion;
    protected String dataDir;
    public final JmxConfiguration jmxConfig;
    private final HttpCachingConfig httpCachingConfig;

    public SolrConfig() throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, DEFAULT_CONF_FILE, (InputSource)null);
    }

    public SolrConfig(String name) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, (InputSource)null);
    }

    public SolrConfig(String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, is);
    }

    public SolrConfig(String instanceDir, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this(new SolrResourceLoader(instanceDir), name, is);
    }

    public static SolrConfig readFromResourceLoader(SolrResourceLoader loader, String name) {
        try {
            return new SolrConfig(loader, name, null);
        }
        catch (Exception e) {
            String resource = loader.getConfigDir() + name;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading solr config from " + resource, (Throwable)e);
        }
    }

    public SolrConfig(SolrResourceLoader loader, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        super(loader, name, is, "/config/");
        String indexConfigPrefix;
        boolean hasNewIndexConfig;
        this.initLibs();
        this.luceneMatchVersion = this.getLuceneVersion("luceneMatchVersion");
        boolean hasDeprecatedIndexConfig = this.getNode("indexDefaults", false) != null || this.getNode("mainIndex", false) != null;
        boolean bl = hasNewIndexConfig = this.getNode("indexConfig", false) != null;
        if (hasDeprecatedIndexConfig) {
            if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_0_0_ALPHA)) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "<indexDefaults> and <mainIndex> configuration sections are discontinued. Use <indexConfig> instead.");
            }
            if (hasNewIndexConfig) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Cannot specify both <indexDefaults>, <mainIndex> and <indexConfig> at the same time. Please use <indexConfig> only.");
            }
            log.warn("<indexDefaults> and <mainIndex> configuration sections are deprecated and will fail for luceneMatchVersion=LUCENE_4_0_0 and later. Please use <indexConfig> instead.");
            this.defaultIndexConfig = new SolrIndexConfig(this, "indexDefaults", null);
            this.mainIndexConfig = new SolrIndexConfig(this, "mainIndex", this.defaultIndexConfig);
            indexConfigPrefix = "mainIndex";
        } else {
            this.mainIndexConfig = null;
            this.defaultIndexConfig = null;
            indexConfigPrefix = "indexConfig";
        }
        this.nrtMode = this.getBool(indexConfigPrefix + "/nrtMode", true);
        this.indexConfig = new SolrIndexConfig(this, "indexConfig", this.mainIndexConfig);
        this.booleanQueryMaxClauseCount = this.getInt("query/maxBooleanClauses", BooleanQuery.getMaxClauseCount());
        log.info("Using Lucene MatchVersion: " + this.luceneMatchVersion);
        if (this.get("query/boolTofilterOptimizer", null) != null) {
            log.warn("solrconfig.xml: <boolTofilterOptimizer> is currently not implemented and has no effect.");
        }
        if (this.get("query/HashDocSet", null) != null) {
            log.warn("solrconfig.xml: <HashDocSet> is deprecated and no longer recommended used.");
        }
        this.useFilterForSortedQuery = this.getBool("query/useFilterForSortedQuery", false);
        this.queryResultWindowSize = Math.max(1, this.getInt("query/queryResultWindowSize", 1));
        this.queryResultMaxDocsCached = this.getInt("query/queryResultMaxDocsCached", Integer.MAX_VALUE);
        this.enableLazyFieldLoading = this.getBool("query/enableLazyFieldLoading", false);
        this.filterCacheConfig = CacheConfig.getConfig(this, "query/filterCache");
        this.queryResultCacheConfig = CacheConfig.getConfig(this, "query/queryResultCache");
        this.documentCacheConfig = CacheConfig.getConfig(this, "query/documentCache");
        CacheConfig conf = CacheConfig.getConfig(this, "query/fieldValueCache");
        if (conf == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", "fieldValueCache");
            args.put("size", "10000");
            args.put("initialSize", "10");
            args.put("showItems", "-1");
            conf = new CacheConfig(FastLRUCache.class, args, null);
        }
        this.fieldValueCacheConfig = conf;
        this.unlockOnStartup = this.getBool(indexConfigPrefix + "/unlockOnStartup", false);
        this.useColdSearcher = this.getBool("query/useColdSearcher", false);
        this.dataDir = this.get("dataDir", null);
        if (this.dataDir != null && this.dataDir.length() == 0) {
            this.dataDir = null;
        }
        this.userCacheConfigs = CacheConfig.getMultipleConfigs(this, "query/cache");
        SolrIndexSearcher.initRegenerators(this);
        this.hashSetInverseLoadFactor = 1.0f / this.getFloat("//HashDocSet/@loadFactor", 0.75f);
        this.hashDocSetMaxSize = this.getInt("//HashDocSet/@maxSize", 3000);
        this.httpCachingConfig = new HttpCachingConfig(this);
        Node jmx = this.getNode("jmx", false);
        this.jmxConfig = jmx != null ? new JmxConfiguration(true, this.get("jmx/@agentId", null), this.get("jmx/@serviceUrl", null), this.get("jmx/@rootName", null)) : new JmxConfiguration(false, null, null, null);
        this.maxWarmingSearchers = this.getInt("query/maxWarmingSearchers", Integer.MAX_VALUE);
        this.loadPluginInfo(SolrRequestHandler.class, "requestHandler", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK);
        this.loadPluginInfo(QParserPlugin.class, "queryParser", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK);
        this.loadPluginInfo(QueryResponseWriter.class, "queryResponseWriter", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK);
        this.loadPluginInfo(ValueSourceParser.class, "valueSourceParser", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK);
        this.loadPluginInfo(TransformerFactory.class, "transformer", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK);
        this.loadPluginInfo(SearchComponent.class, "searchComponent", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK);
        this.loadPluginInfo(QueryConverter.class, "queryConverter", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS);
        this.loadPluginInfo(SolrEventListener.class, "//listener", PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK);
        this.loadPluginInfo(DirectoryFactory.class, "directoryFactory", PluginOpts.REQUIRE_CLASS);
        this.loadPluginInfo(IndexDeletionPolicy.class, indexConfigPrefix + "/deletionPolicy", PluginOpts.REQUIRE_CLASS);
        this.loadPluginInfo(CodecFactory.class, "codecFactory", PluginOpts.REQUIRE_CLASS);
        this.loadPluginInfo(IndexReaderFactory.class, "indexReaderFactory", PluginOpts.REQUIRE_CLASS);
        this.loadPluginInfo(UpdateRequestProcessorChain.class, "updateRequestProcessorChain", PluginOpts.MULTI_OK);
        this.loadPluginInfo(UpdateLog.class, "updateHandler/updateLog", new PluginOpts[0]);
        this.loadPluginInfo(IndexSchemaFactory.class, "schemaFactory", PluginOpts.REQUIRE_CLASS);
        this.loadPluginInfo(RestManager.class, "restManager", new PluginOpts[0]);
        this.updateHandlerInfo = this.loadUpdatehandlerInfo();
        this.multipartUploadLimitKB = this.getInt("requestDispatcher/requestParsers/@multipartUploadLimitInKB", 2048);
        this.formUploadLimitKB = this.getInt("requestDispatcher/requestParsers/@formdataUploadLimitInKB", 2048);
        this.enableRemoteStreams = this.getBool("requestDispatcher/requestParsers/@enableRemoteStreaming", false);
        this.handleSelect = this.getBool("requestDispatcher/@handleSelect", true);
        this.addHttpRequestToContext = this.getBool("requestDispatcher/requestParsers/@addHttpRequestToContext", false);
        this.solrRequestParsers = new SolrRequestParsers(this);
        Config.log.info("Loaded SolrConfig: " + name);
    }

    protected UpdateHandlerInfo loadUpdatehandlerInfo() {
        return new UpdateHandlerInfo(this.get("updateHandler/@class", null), this.getInt("updateHandler/autoCommit/maxDocs", -1), this.getInt("updateHandler/autoCommit/maxTime", -1), this.getBool("updateHandler/indexWriter/closeWaitsForMerges", true), this.getBool("updateHandler/autoCommit/openSearcher", true), this.getInt("updateHandler/commitIntervalLowerBound", -1), this.getInt("updateHandler/autoSoftCommit/maxDocs", -1), this.getInt("updateHandler/autoSoftCommit/maxTime", -1), this.getBool("updateHandler/commitWithin/softCommit", true));
    }

    private void loadPluginInfo(Class clazz, String tag, PluginOpts ... opts) {
        boolean requireClass;
        EnumSet<PluginOpts[]> options = EnumSet.of(PluginOpts.NOOP, opts);
        boolean requireName = options.contains((Object)PluginOpts.REQUIRE_NAME);
        List<PluginInfo> result = this.readPluginInfos(tag, requireName, requireClass = options.contains((Object)PluginOpts.REQUIRE_CLASS));
        if (1 < result.size() && !options.contains((Object)PluginOpts.MULTI_OK)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Found " + result.size() + " configuration sections when at most " + "1 is allowed matching expression: " + tag);
        }
        if (!result.isEmpty()) {
            this.pluginStore.put(clazz.getName(), result);
        }
    }

    public List<PluginInfo> readPluginInfos(String tag, boolean requireName, boolean requireClass) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        NodeList nodes = (NodeList)this.evaluate(tag, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            PluginInfo pluginInfo = new PluginInfo(nodes.item(i), "[solrconfig.xml] " + tag, requireName, requireClass);
            if (!pluginInfo.isEnabled()) continue;
            result.add(pluginInfo);
        }
        return result;
    }

    public SolrRequestParsers getRequestParsers() {
        return this.solrRequestParsers;
    }

    public HttpCachingConfig getHttpCachingConfig() {
        return this.httpCachingConfig;
    }

    public UpdateHandlerInfo getUpdateHandlerInfo() {
        return this.updateHandlerInfo;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public List<PluginInfo> getPluginInfos(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        return result == null ? Collections.emptyList() : result;
    }

    public PluginInfo getPluginInfo(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (1 == result.size()) {
            return result.get(0);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple plugins configured for type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLibs() {
        NodeList nodes = (NodeList)this.evaluate("lib", XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        log.info("Adding specified lib dirs to ClassLoader");
        SolrResourceLoader loader = this.getResourceLoader();
        try {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String baseDir = DOMUtil.getAttr(node, "dir");
                String path = DOMUtil.getAttr(node, "path");
                if (null != baseDir) {
                    String regex = DOMUtil.getAttr(node, "regex");
                    RegexFileFilter filter = null == regex ? null : new RegexFileFilter(regex);
                    loader.addToClassLoader(baseDir, filter, false);
                    continue;
                }
                if (null != path) {
                    final File file = FileUtils.resolvePath(new File(loader.getInstanceDir()), path);
                    loader.addToClassLoader(file.getParent(), new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.equals(file);
                        }
                    }, false);
                    continue;
                }
                throw new RuntimeException("lib: missing mandatory attributes: 'dir' or 'path'");
            }
        }
        finally {
            loader.reloadLuceneSPI();
        }
    }

    public int getMultipartUploadLimitKB() {
        return this.multipartUploadLimitKB;
    }

    public int getFormUploadLimitKB() {
        return this.formUploadLimitKB;
    }

    public boolean isHandleSelect() {
        return this.handleSelect;
    }

    public boolean isAddHttpRequestToContext() {
        return this.addHttpRequestToContext;
    }

    public boolean isEnableRemoteStreams() {
        return this.enableRemoteStreams;
    }

    public static class UpdateHandlerInfo {
        public final String className;
        public final int autoCommmitMaxDocs;
        public final int autoCommmitMaxTime;
        public final int commitIntervalLowerBound;
        public final int autoSoftCommmitMaxDocs;
        public final int autoSoftCommmitMaxTime;
        public final boolean indexWriterCloseWaitsForMerges;
        public final boolean openSearcher;
        public final boolean commitWithinSoftCommit;

        public UpdateHandlerInfo(String className, int autoCommmitMaxDocs, int autoCommmitMaxTime, boolean indexWriterCloseWaitsForMerges, boolean openSearcher, int commitIntervalLowerBound, int autoSoftCommmitMaxDocs, int autoSoftCommmitMaxTime, boolean commitWithinSoftCommit) {
            this.className = className;
            this.autoCommmitMaxDocs = autoCommmitMaxDocs;
            this.autoCommmitMaxTime = autoCommmitMaxTime;
            this.indexWriterCloseWaitsForMerges = indexWriterCloseWaitsForMerges;
            this.openSearcher = openSearcher;
            this.commitIntervalLowerBound = commitIntervalLowerBound;
            this.autoSoftCommmitMaxDocs = autoSoftCommmitMaxDocs;
            this.autoSoftCommmitMaxTime = autoSoftCommmitMaxTime;
            this.commitWithinSoftCommit = commitWithinSoftCommit;
        }
    }

    public static class HttpCachingConfig {
        private static final String CACHE_PRE = "requestDispatcher/httpCaching/";
        private static final Pattern MAX_AGE = Pattern.compile("\\bmax-age=(\\d+)");
        private final boolean never304;
        private final String etagSeed;
        private final String cacheControlHeader;
        private final Long maxAge;
        private final LastModFrom lastModFrom;

        private HttpCachingConfig(SolrConfig conf) {
            this.never304 = conf.getBool("requestDispatcher/httpCaching/@never304", false);
            this.etagSeed = conf.get("requestDispatcher/httpCaching/@etagSeed", "Solr");
            this.lastModFrom = LastModFrom.parse(conf.get("requestDispatcher/httpCaching/@lastModFrom", "openTime"));
            this.cacheControlHeader = conf.get("requestDispatcher/httpCaching/cacheControl", null);
            Long tmp = null;
            if (null != this.cacheControlHeader) {
                try {
                    Matcher ttlMatcher = MAX_AGE.matcher(this.cacheControlHeader);
                    String ttlStr = ttlMatcher.find() ? ttlMatcher.group(1) : null;
                    tmp = null != ttlStr && !"".equals(ttlStr) ? Long.valueOf(ttlStr) : null;
                }
                catch (Exception e) {
                    log.warn("Ignoring exception while attempting to extract max-age from cacheControl config: " + this.cacheControlHeader, (Throwable)e);
                }
            }
            this.maxAge = tmp;
        }

        public boolean isNever304() {
            return this.never304;
        }

        public String getEtagSeed() {
            return this.etagSeed;
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public Long getMaxAge() {
            return this.maxAge;
        }

        public LastModFrom getLastModFrom() {
            return this.lastModFrom;
        }

        public static enum LastModFrom {
            OPENTIME,
            DIRLASTMOD,
            BOGUS;


            public static LastModFrom parse(String s) {
                try {
                    return LastModFrom.valueOf(s.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    log.warn("Unrecognized value for lastModFrom: " + s, (Throwable)e);
                    return BOGUS;
                }
            }
        }
    }

    public static class JmxConfiguration {
        public boolean enabled = false;
        public String agentId;
        public String serviceUrl;
        public String rootName;

        public JmxConfiguration(boolean enabled, String agentId, String serviceUrl, String rootName) {
            this.enabled = enabled;
            this.agentId = agentId;
            this.serviceUrl = serviceUrl;
            this.rootName = rootName;
            if (agentId != null && serviceUrl != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Incorrect JMX Configuration in solrconfig.xml, both agentId and serviceUrl cannot be specified at the same time");
            }
        }
    }

    static enum PluginOpts {
        MULTI_OK,
        REQUIRE_NAME,
        REQUIRE_CLASS,
        NOOP;

    }
}

