/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrDeletionPolicy;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.SnapPuller;
import org.apache.solr.handler.SnapShooter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.PropertiesInputStream;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger LOG = LoggerFactory.getLogger((String)ReplicationHandler.class.getName());
    SolrCore core;
    private SnapPuller snapPuller;
    private ReentrantLock snapPullLock = new ReentrantLock();
    private String includeConfFiles;
    private NamedList<String> confFileNameAlias = new NamedList();
    private boolean isMaster = false;
    private boolean isSlave = false;
    private boolean replicateOnOptimize = false;
    private boolean replicateOnCommit = false;
    private boolean replicateOnStart = false;
    private int numberBackupsToKeep = 0;
    private int numTimesReplicated = 0;
    private final Map<String, FileInfo> confFileInfoCache = new HashMap<String, FileInfo>();
    private Integer reserveCommitDuration = SnapPuller.readInterval("00:00:10");
    volatile IndexCommit indexCommitPoint;
    volatile NamedList<Object> snapShootDetails;
    private AtomicBoolean replicationEnabled = new AtomicBoolean(true);
    private volatile SnapPuller tempSnapPuller;
    public static final String MASTER_URL = "masterUrl";
    public static final String STATUS = "status";
    public static final String COMMAND = "command";
    public static final String CMD_DETAILS = "details";
    public static final String CMD_BACKUP = "backup";
    public static final String CMD_FETCH_INDEX = "fetchindex";
    public static final String CMD_ABORT_FETCH = "abortfetch";
    public static final String CMD_GET_FILE_LIST = "filelist";
    public static final String CMD_GET_FILE = "filecontent";
    public static final String CMD_DISABLE_POLL = "disablepoll";
    public static final String CMD_DISABLE_REPL = "disablereplication";
    public static final String CMD_ENABLE_REPL = "enablereplication";
    public static final String CMD_ENABLE_POLL = "enablepoll";
    public static final String CMD_INDEX_VERSION = "indexversion";
    public static final String CMD_SHOW_COMMITS = "commits";
    public static final String CMD_DELETE_BACKUP = "deletebackup";
    public static final String GENERATION = "generation";
    public static final String OFFSET = "offset";
    public static final String LEN = "len";
    public static final String FILE = "file";
    public static final String NAME = "name";
    public static final String SIZE = "size";
    public static final String CONF_FILE_SHORT = "cf";
    public static final String CHECKSUM = "checksum";
    public static final String ALIAS = "alias";
    public static final String CONF_CHECKSUM = "confchecksum";
    public static final String CONF_FILES = "confFiles";
    public static final String REPLICATE_AFTER = "replicateAfter";
    public static final String FILE_STREAM = "filestream";
    public static final int PACKET_SZ = 0x100000;
    public static final String RESERVE = "commitReserveDuration";
    public static final String COMPRESSION = "compression";
    public static final String EXTERNAL = "external";
    public static final String INTERNAL = "internal";
    public static final String ERR_STATUS = "ERROR";
    public static final String OK_STATUS = "OK";
    public static final String NEXT_EXECUTION_AT = "nextExecutionAt";
    public static final String NUMBER_BACKUPS_TO_KEEP_REQUEST_PARAM = "numberToKeep";
    public static final String NUMBER_BACKUPS_TO_KEEP_INIT_PARAM = "maxNumberOfBackups";
    public static final String WAIT = "wait";

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.setHttpCaching(false);
        SolrParams solrParams = req.getParams();
        String command = solrParams.get(COMMAND);
        if (command == null) {
            rsp.add(STATUS, OK_STATUS);
            rsp.add("message", "No command");
            return;
        }
        if (command.equals(CMD_INDEX_VERSION)) {
            IndexCommit commitPoint = this.indexCommitPoint;
            if (commitPoint == null) {
                commitPoint = this.core.getDeletionPolicy().getLatestCommit();
            }
            if (commitPoint != null && this.replicationEnabled.get()) {
                this.core.getDeletionPolicy().setReserveDuration(commitPoint.getGeneration(), this.reserveCommitDuration.intValue());
                rsp.add(CMD_INDEX_VERSION, IndexDeletionPolicyWrapper.getCommitTimestamp(commitPoint));
                rsp.add(GENERATION, commitPoint.getGeneration());
            } else {
                rsp.add(CMD_INDEX_VERSION, 0L);
                rsp.add(GENERATION, 0L);
            }
        } else if (command.equals(CMD_GET_FILE)) {
            this.getFileStream(solrParams, rsp);
        } else if (command.equals(CMD_GET_FILE_LIST)) {
            this.getFileList(solrParams, rsp);
        } else if (command.equalsIgnoreCase(CMD_BACKUP)) {
            this.doSnapShoot((SolrParams)new ModifiableSolrParams(solrParams), rsp, req);
            rsp.add(STATUS, OK_STATUS);
        } else if (command.equalsIgnoreCase(CMD_DELETE_BACKUP)) {
            this.deleteSnapshot(new ModifiableSolrParams(solrParams), rsp, req);
            rsp.add(STATUS, OK_STATUS);
        } else if (command.equalsIgnoreCase(CMD_FETCH_INDEX)) {
            String masterUrl = solrParams.get(MASTER_URL);
            if (!this.isSlave && masterUrl == null) {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured or no 'masterUrl' Specified");
                return;
            }
            ModifiableSolrParams paramsCopy = new ModifiableSolrParams(solrParams);
            Thread puller = new Thread("explicit-fetchindex-cmd", (SolrParams)paramsCopy){
                final /* synthetic */ SolrParams val$paramsCopy;
                {
                    this.val$paramsCopy = solrParams;
                    super(x0);
                }

                @Override
                public void run() {
                    ReplicationHandler.this.doFetch(this.val$paramsCopy, false);
                }
            };
            puller.start();
            if (solrParams.getBool(WAIT, false)) {
                puller.join();
            }
            rsp.add(STATUS, OK_STATUS);
        } else if (command.equalsIgnoreCase(CMD_DISABLE_POLL)) {
            if (this.snapPuller != null) {
                this.snapPuller.disablePoll();
                rsp.add(STATUS, OK_STATUS);
            } else {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured");
            }
        } else if (command.equalsIgnoreCase(CMD_ENABLE_POLL)) {
            if (this.snapPuller != null) {
                this.snapPuller.enablePoll();
                rsp.add(STATUS, OK_STATUS);
            } else {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured");
            }
        } else if (command.equalsIgnoreCase(CMD_ABORT_FETCH)) {
            SnapPuller temp = this.tempSnapPuller;
            if (temp != null) {
                temp.abortPull();
                rsp.add(STATUS, OK_STATUS);
            } else {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured");
            }
        } else if (command.equals(CMD_SHOW_COMMITS)) {
            rsp.add(CMD_SHOW_COMMITS, this.getCommits());
        } else if (command.equals(CMD_DETAILS)) {
            rsp.add(CMD_DETAILS, this.getReplicationDetails(solrParams.getBool("slave", true)));
            RequestHandlerUtils.addExperimentalFormatWarning(rsp);
        } else if (CMD_ENABLE_REPL.equalsIgnoreCase(command)) {
            this.replicationEnabled.set(true);
            rsp.add(STATUS, OK_STATUS);
        } else if (CMD_DISABLE_REPL.equalsIgnoreCase(command)) {
            this.replicationEnabled.set(false);
            rsp.add(STATUS, OK_STATUS);
        }
    }

    private void deleteSnapshot(ModifiableSolrParams params, SolrQueryResponse rsp, SolrQueryRequest req) {
        String name = params.get(NAME);
        if (name == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing mandatory param: name");
        }
        SnapShooter snapShooter = new SnapShooter(this.core, params.get("location"), params.get(NAME));
        snapShooter.validateDeleteSnapshot();
        snapShooter.deleteSnapAsync(this);
    }

    private List<NamedList<Object>> getCommits() {
        Map<Long, IndexCommit> commits = this.core.getDeletionPolicy().getCommits();
        ArrayList<NamedList<Object>> l = new ArrayList<NamedList<Object>>();
        for (IndexCommit c : commits.values()) {
            try {
                NamedList nl = new NamedList();
                nl.add("indexVersion", (Object)IndexDeletionPolicyWrapper.getCommitTimestamp(c));
                nl.add(GENERATION, (Object)c.getGeneration());
                ArrayList commitList = new ArrayList(c.getFileNames().size());
                commitList.addAll(c.getFileNames());
                Collections.sort(commitList);
                nl.add(CMD_GET_FILE_LIST, commitList);
                l.add((NamedList<Object>)nl);
            }
            catch (IOException e) {
                LOG.warn("Exception while reading files for commit " + c, (Throwable)e);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Long getCheckSum(Checksum checksum, File f) {
        Long l;
        FileInputStream fis = null;
        checksum.reset();
        byte[] buffer = new byte[0x100000];
        try {
            int bytesRead;
            fis = new FileInputStream(f);
            while ((bytesRead = fis.read(buffer)) >= 0) {
                checksum.update(buffer, 0, bytesRead);
            }
            l = checksum.getValue();
        }
        catch (Exception e) {
            try {
                LOG.warn("Exception in finding checksum of " + f, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return null;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doFetch(SolrParams solrParams, boolean forceReplication) {
        String masterUrl;
        String string = masterUrl = solrParams == null ? null : solrParams.get(MASTER_URL);
        if (!this.snapPullLock.tryLock()) {
            return false;
        }
        try {
            this.tempSnapPuller = this.snapPuller;
            if (masterUrl != null) {
                NamedList nl = solrParams.toNamedList();
                nl.remove("pollInterval");
                this.tempSnapPuller = new SnapPuller(nl, this, this.core);
            }
            boolean nl = this.tempSnapPuller.fetchLatestIndex(this.core, forceReplication);
            return nl;
        }
        catch (Exception e) {
            SolrException.log((Logger)LOG, (String)"SnapPull failed ", (Throwable)e);
        }
        finally {
            if (this.snapPuller != null) {
                this.tempSnapPuller = this.snapPuller;
            }
            this.snapPullLock.unlock();
        }
        return false;
    }

    boolean isReplicating() {
        return this.snapPullLock.isLocked();
    }

    private void doSnapShoot(SolrParams params, SolrQueryResponse rsp, SolrQueryRequest req) {
        try {
            IndexDeletionPolicyWrapper delPolicy;
            IndexCommit indexCommit;
            int numberToKeep = params.getInt(NUMBER_BACKUPS_TO_KEEP_REQUEST_PARAM, 0);
            if (numberToKeep > 0 && this.numberBackupsToKeep > 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot use numberToKeep if maxNumberOfBackups was specified in the configuration.");
            }
            if ((numberToKeep = Math.max(numberToKeep, this.numberBackupsToKeep)) < 1) {
                numberToKeep = Integer.MAX_VALUE;
            }
            if ((indexCommit = (delPolicy = this.core.getDeletionPolicy()).getLatestCommit()) == null) {
                indexCommit = req.getSearcher().getIndexReader().getIndexCommit();
            }
            SnapShooter snapShooter = new SnapShooter(this.core, params.get("location"), params.get(NAME));
            snapShooter.validateCreateSnapshot();
            snapShooter.createSnapAsync(indexCommit, numberToKeep, this);
        }
        catch (Exception e) {
            LOG.warn("Exception during creating a snapshot", (Throwable)e);
            rsp.add("exception", e);
        }
    }

    private void getFileStream(SolrParams solrParams, SolrQueryResponse rsp) {
        ModifiableSolrParams rawParams = new ModifiableSolrParams(solrParams);
        rawParams.set("wt", new String[]{FILE_STREAM});
        String cfileName = solrParams.get(CONF_FILE_SHORT);
        if (cfileName != null) {
            rsp.add(FILE_STREAM, new LocalFsFileStream(solrParams));
        } else {
            rsp.add(FILE_STREAM, new DirectoryFileStream(solrParams));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileList(SolrParams solrParams, SolrQueryResponse rsp) {
        String v = solrParams.get(GENERATION);
        if (v == null) {
            rsp.add(STATUS, "no index generation specified");
            return;
        }
        long gen = Long.parseLong(v);
        IndexCommit commit = this.core.getDeletionPolicy().getCommitPoint(gen);
        if (commit == null) {
            rsp.add(STATUS, "invalid index generation");
            return;
        }
        this.core.getDeletionPolicy().setReserveDuration(gen, this.reserveCommitDuration.intValue());
        ArrayList result = new ArrayList();
        Directory dir = null;
        try {
            HashSet files = new HashSet(commit.getFileNames());
            dir = this.core.getDirectoryFactory().get(this.core.getNewIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
            try {
                for (String fileName : files) {
                    if (fileName.endsWith(".lock")) continue;
                    HashMap<String, Object> fileMeta = new HashMap<String, Object>();
                    fileMeta.put(NAME, fileName);
                    fileMeta.put(SIZE, dir.fileLength(fileName));
                    result.add(fileMeta);
                }
            }
            finally {
                this.core.getDirectoryFactory().release(dir);
            }
        }
        catch (IOException e) {
            rsp.add(STATUS, "unable to get file names for given index generation");
            rsp.add("exception", e);
            LOG.error("Unable to get file names for indexCommit generation: " + gen, (Throwable)e);
        }
        rsp.add(CMD_GET_FILE_LIST, result);
        if (this.confFileNameAlias.size() < 1 || this.core.getCoreDescriptor().getCoreContainer().isZooKeeperAware()) {
            return;
        }
        LOG.debug("Adding config files to list: " + this.includeConfFiles);
        rsp.add(CONF_FILES, this.getConfFileInfoFromCache(this.confFileNameAlias, this.confFileInfoCache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Map<String, Object>> getConfFileInfoFromCache(NamedList<String> nameAndAlias, Map<String, FileInfo> confFileInfoCache) {
        ArrayList<Map<String, Object>> confFiles = new ArrayList<Map<String, Object>>();
        Map<String, FileInfo> map = confFileInfoCache;
        synchronized (map) {
            File confDir = new File(this.core.getResourceLoader().getConfigDir());
            Adler32 checksum = null;
            for (int i = 0; i < nameAndAlias.size(); ++i) {
                String cf = nameAndAlias.getName(i);
                File f = new File(confDir, cf);
                if (!f.exists() || f.isDirectory()) continue;
                FileInfo info = confFileInfoCache.get(cf);
                if (info == null || info.lastmodified != f.lastModified() || info.size != f.length()) {
                    if (checksum == null) {
                        checksum = new Adler32();
                    }
                    info = new FileInfo(f.lastModified(), cf, f.length(), ReplicationHandler.getCheckSum(checksum, f));
                    confFileInfoCache.put(cf, info);
                }
                Map<String, Object> m = info.getAsMap();
                if (nameAndAlias.getVal(i) != null) {
                    m.put(ALIAS, nameAndAlias.getVal(i));
                }
                confFiles.add(m);
            }
        }
        return confFiles;
    }

    void disablePoll() {
        if (this.isSlave) {
            this.snapPuller.disablePoll();
        }
    }

    void enablePoll() {
        if (this.isSlave) {
            this.snapPuller.enablePoll();
        }
    }

    boolean isPollingDisabled() {
        if (this.snapPuller == null) {
            return true;
        }
        return this.snapPuller.isPollingDisabled();
    }

    int getTimesReplicatedSinceStartup() {
        return this.numTimesReplicated;
    }

    void setTimesReplicatedSinceStartup() {
        ++this.numTimesReplicated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getIndexSize() {
        long size = 0L;
        try {
            Directory dir = this.core.getDirectoryFactory().get(this.core.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
            try {
                size = DirectoryFactory.sizeOfDirectory(dir);
            }
            finally {
                this.core.getDirectoryFactory().release(dir);
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)LOG, (String)"IO error while trying to get the size of the Directory", (Throwable)e);
        }
        return size;
    }

    @Override
    public String getDescription() {
        return "ReplicationHandler provides replication of index and configuration files from Master to Slaves";
    }

    @Override
    public String getSource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommitVersionInfo getIndexVersion() {
        CommitVersionInfo v = null;
        RefCounted<SolrIndexSearcher> searcher = this.core.getSearcher();
        try {
            v = CommitVersionInfo.build(searcher.get().getIndexReader().getIndexCommit());
        }
        catch (IOException e) {
            LOG.warn("Unable to get index commit: ", (Throwable)e);
        }
        finally {
            searcher.decref();
        }
        return v;
    }

    @Override
    public NamedList getStatistics() {
        NamedList<Object> list = super.getStatistics();
        if (this.core != null) {
            list.add("indexSize", (Object)NumberUtils.readableSize(this.getIndexSize()));
            CommitVersionInfo vInfo = this.getIndexVersion();
            list.add("indexVersion", (Object)(null == vInfo ? 0L : vInfo.version));
            list.add(GENERATION, (Object)(null == vInfo ? 0L : vInfo.generation));
            list.add("indexPath", (Object)this.core.getIndexDir());
            list.add("isMaster", (Object)String.valueOf(this.isMaster));
            list.add("isSlave", (Object)String.valueOf(this.isSlave));
            SnapPuller snapPuller = this.tempSnapPuller;
            if (snapPuller != null) {
                list.add(MASTER_URL, (Object)snapPuller.getMasterUrl());
                if (snapPuller.getPollInterval() != null) {
                    list.add("pollInterval", (Object)snapPuller.getPollInterval());
                }
                list.add("isPollingDisabled", (Object)String.valueOf(this.isPollingDisabled()));
                list.add("isReplicating", (Object)String.valueOf(this.isReplicating()));
                long elapsed = this.getTimeElapsed(snapPuller);
                long val = SnapPuller.getTotalBytesDownloaded(snapPuller);
                if (elapsed > 0L) {
                    list.add("timeElapsed", (Object)elapsed);
                    list.add("bytesDownloaded", (Object)val);
                    list.add("downloadSpeed", (Object)(val / elapsed));
                }
                Properties props = this.loadReplicationProperties();
                this.addVal(list, "previousCycleTimeInSeconds", props, Long.class);
                this.addVal(list, "indexReplicatedAt", props, Date.class);
                this.addVal(list, "confFilesReplicatedAt", props, Date.class);
                this.addVal(list, "replicationFailedAt", props, Date.class);
                this.addVal(list, "timesFailed", props, Integer.class);
                this.addVal(list, "timesIndexReplicated", props, Integer.class);
                this.addVal(list, "lastCycleBytesDownloaded", props, Long.class);
                this.addVal(list, "timesConfigReplicated", props, Integer.class);
                this.addVal(list, "confFilesReplicated", props, String.class);
            }
            if (this.isMaster) {
                if (this.includeConfFiles != null) {
                    list.add("confFilesToReplicate", (Object)this.includeConfFiles);
                }
                list.add(REPLICATE_AFTER, this.getReplicateAfterStrings());
                list.add("replicationEnabled", (Object)String.valueOf(this.replicationEnabled.get()));
            }
        }
        return list;
    }

    private NamedList<Object> getReplicationDetails(boolean showSlaveDetails) {
        NamedList<Object> snapshotStats;
        SnapPuller snapPuller;
        SimpleOrderedMap details = new SimpleOrderedMap();
        SimpleOrderedMap master = new SimpleOrderedMap();
        SimpleOrderedMap slave = new SimpleOrderedMap();
        details.add("indexSize", (Object)NumberUtils.readableSize(this.getIndexSize()));
        details.add("indexPath", (Object)this.core.getIndexDir());
        details.add(CMD_SHOW_COMMITS, this.getCommits());
        details.add("isMaster", (Object)String.valueOf(this.isMaster));
        details.add("isSlave", (Object)String.valueOf(this.isSlave));
        CommitVersionInfo vInfo = this.getIndexVersion();
        details.add("indexVersion", (Object)(null == vInfo ? 0L : vInfo.version));
        details.add(GENERATION, (Object)(null == vInfo ? 0L : vInfo.generation));
        IndexCommit commit = this.indexCommitPoint;
        if (this.isMaster) {
            if (this.includeConfFiles != null) {
                master.add(CONF_FILES, (Object)this.includeConfFiles);
            }
            master.add(REPLICATE_AFTER, this.getReplicateAfterStrings());
            master.add("replicationEnabled", (Object)String.valueOf(this.replicationEnabled.get()));
        }
        if (this.isMaster && commit != null) {
            CommitVersionInfo repCommitInfo = CommitVersionInfo.build(commit);
            master.add("replicableVersion", (Object)repCommitInfo.version);
            master.add("replicableGeneration", (Object)repCommitInfo.generation);
        }
        if ((snapPuller = this.tempSnapPuller) != null) {
            Properties props = this.loadReplicationProperties();
            if (showSlaveDetails) {
                try {
                    NamedList nl = snapPuller.getDetails();
                    slave.add("masterDetails", nl.get(CMD_DETAILS));
                }
                catch (Exception e) {
                    LOG.warn("Exception while invoking 'details' method for replication on master ", (Throwable)e);
                    slave.add(ERR_STATUS, (Object)"invalid_master");
                }
            }
            slave.add(MASTER_URL, (Object)snapPuller.getMasterUrl());
            if (snapPuller.getPollInterval() != null) {
                slave.add("pollInterval", (Object)snapPuller.getPollInterval());
            }
            if (snapPuller.getNextScheduledExecTime() != null && !this.isPollingDisabled()) {
                slave.add(NEXT_EXECUTION_AT, (Object)new Date(snapPuller.getNextScheduledExecTime()).toString());
            } else if (this.isPollingDisabled()) {
                slave.add(NEXT_EXECUTION_AT, (Object)"Polling disabled");
            }
            this.addVal((NamedList<Object>)slave, "indexReplicatedAt", props, Date.class);
            this.addVal((NamedList<Object>)slave, "indexReplicatedAtList", props, List.class);
            this.addVal((NamedList<Object>)slave, "replicationFailedAtList", props, List.class);
            this.addVal((NamedList<Object>)slave, "timesIndexReplicated", props, Integer.class);
            this.addVal((NamedList<Object>)slave, "confFilesReplicated", props, Integer.class);
            this.addVal((NamedList<Object>)slave, "timesConfigReplicated", props, Integer.class);
            this.addVal((NamedList<Object>)slave, "confFilesReplicatedAt", props, Integer.class);
            this.addVal((NamedList<Object>)slave, "lastCycleBytesDownloaded", props, Long.class);
            this.addVal((NamedList<Object>)slave, "timesFailed", props, Integer.class);
            this.addVal((NamedList<Object>)slave, "replicationFailedAt", props, Date.class);
            this.addVal((NamedList<Object>)slave, "previousCycleTimeInSeconds", props, Long.class);
            slave.add("currentDate", (Object)new Date().toString());
            slave.add("isPollingDisabled", (Object)String.valueOf(this.isPollingDisabled()));
            boolean isReplicating = this.isReplicating();
            slave.add("isReplicating", (Object)String.valueOf(isReplicating));
            if (isReplicating) {
                try {
                    long bytesToDownload = 0L;
                    ArrayList<String> filesToDownload = new ArrayList<String>();
                    for (Map<String, Object> file : snapPuller.getFilesToDownload()) {
                        filesToDownload.add((String)file.get(NAME));
                        bytesToDownload += ((Long)file.get(SIZE)).longValue();
                    }
                    for (Map<String, Object> file : snapPuller.getConfFilesToDownload()) {
                        filesToDownload.add((String)file.get(NAME));
                        bytesToDownload += ((Long)file.get(SIZE)).longValue();
                    }
                    slave.add("filesToDownload", filesToDownload);
                    slave.add("numFilesToDownload", (Object)String.valueOf(filesToDownload.size()));
                    slave.add("bytesToDownload", (Object)NumberUtils.readableSize(bytesToDownload));
                    long bytesDownloaded = 0L;
                    ArrayList<String> filesDownloaded = new ArrayList<String>();
                    for (Map<String, Object> file : snapPuller.getFilesDownloaded()) {
                        filesDownloaded.add((String)file.get(NAME));
                        bytesDownloaded += ((Long)file.get(SIZE)).longValue();
                    }
                    for (Map<String, Object> file : snapPuller.getConfFilesDownloaded()) {
                        filesDownloaded.add((String)file.get(NAME));
                        bytesDownloaded += ((Long)file.get(SIZE)).longValue();
                    }
                    Map<String, Object> currentFile = snapPuller.getCurrentFile();
                    String currFile = null;
                    long currFileSize = 0L;
                    long currFileSizeDownloaded = 0L;
                    float percentDownloaded = 0.0f;
                    if (currentFile != null) {
                        currFile = (String)currentFile.get(NAME);
                        currFileSize = (Long)currentFile.get(SIZE);
                        if (currentFile.containsKey("bytesDownloaded")) {
                            currFileSizeDownloaded = (Long)currentFile.get("bytesDownloaded");
                            bytesDownloaded += currFileSizeDownloaded;
                            if (currFileSize > 0L) {
                                percentDownloaded = currFileSizeDownloaded * 100L / currFileSize;
                            }
                        }
                    }
                    slave.add("filesDownloaded", filesDownloaded);
                    slave.add("numFilesDownloaded", (Object)String.valueOf(filesDownloaded.size()));
                    long estimatedTimeRemaining = 0L;
                    if (snapPuller.getReplicationStartTime() > 0L) {
                        slave.add("replicationStartTime", (Object)new Date(snapPuller.getReplicationStartTime()).toString());
                    }
                    long elapsed = this.getTimeElapsed(snapPuller);
                    slave.add("timeElapsed", (Object)(String.valueOf(elapsed) + "s"));
                    if (bytesDownloaded > 0L) {
                        estimatedTimeRemaining = (bytesToDownload - bytesDownloaded) * elapsed / bytesDownloaded;
                    }
                    float totalPercent = 0.0f;
                    long downloadSpeed = 0L;
                    if (bytesToDownload > 0L) {
                        totalPercent = bytesDownloaded * 100L / bytesToDownload;
                    }
                    if (elapsed > 0L) {
                        downloadSpeed = bytesDownloaded / elapsed;
                    }
                    if (currFile != null) {
                        slave.add("currentFile", (Object)currFile);
                    }
                    slave.add("currentFileSize", (Object)NumberUtils.readableSize(currFileSize));
                    slave.add("currentFileSizeDownloaded", (Object)NumberUtils.readableSize(currFileSizeDownloaded));
                    slave.add("currentFileSizePercent", (Object)String.valueOf(percentDownloaded));
                    slave.add("bytesDownloaded", (Object)NumberUtils.readableSize(bytesDownloaded));
                    slave.add("totalPercent", (Object)String.valueOf(totalPercent));
                    slave.add("timeRemaining", (Object)(String.valueOf(estimatedTimeRemaining) + "s"));
                    slave.add("downloadSpeed", (Object)NumberUtils.readableSize(downloadSpeed));
                }
                catch (Exception e) {
                    LOG.error("Exception while writing replication details: ", (Throwable)e);
                }
            }
        }
        if (this.isMaster) {
            details.add("master", (Object)master);
        }
        if (slave.size() > 0) {
            details.add("slave", (Object)slave);
        }
        if ((snapshotStats = this.snapShootDetails) != null) {
            details.add(CMD_BACKUP, snapshotStats);
        }
        return details;
    }

    private void addVal(NamedList<Object> nl, String key, Properties props, Class clzz) {
        String s = props.getProperty(key);
        if (s == null || s.trim().length() == 0) {
            return;
        }
        if (clzz == Date.class) {
            try {
                Long l = Long.parseLong(s);
                nl.add(key, (Object)new Date(l).toString());
            }
            catch (NumberFormatException e) {}
        } else if (clzz == List.class) {
            String[] ss = s.split(",");
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < ss.length; ++i) {
                l.add(new Date(Long.valueOf(ss[i])).toString());
            }
            nl.add(key, l);
        } else {
            nl.add(key, (Object)s);
        }
    }

    private List<String> getReplicateAfterStrings() {
        ArrayList<String> replicateAfter = new ArrayList<String>();
        if (this.replicateOnCommit) {
            replicateAfter.add("commit");
        }
        if (this.replicateOnOptimize) {
            replicateAfter.add("optimize");
        }
        if (this.replicateOnStart) {
            replicateAfter.add("startup");
        }
        return replicateAfter;
    }

    private long getTimeElapsed(SnapPuller snapPuller) {
        long timeElapsed = 0L;
        if (snapPuller.getReplicationStartTime() > 0L) {
            timeElapsed = TimeUnit.SECONDS.convert(System.currentTimeMillis() - snapPuller.getReplicationStartTime(), TimeUnit.MILLISECONDS);
        }
        return timeElapsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Properties loadReplicationProperties() {
        Properties properties;
        IndexInput input;
        Directory dir;
        block14: {
            dir = null;
            dir = this.core.getDirectoryFactory().get(this.core.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.core.getSolrConfig().indexConfig.lockType);
            try {
                input = dir.openInput("replication.properties", IOContext.DEFAULT);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                Properties properties2 = new Properties();
                if (dir != null) {
                    this.core.getDirectoryFactory().release(dir);
                }
                return properties2;
            }
            PropertiesInputStream is = new PropertiesInputStream(input);
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            properties = props;
            input.close();
            if (dir == null) break block14;
            this.core.getDirectoryFactory().release(dir);
        }
        return properties;
        {
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                    {
                        catch (Throwable throwable2) {
                            if (dir != null) {
                                this.core.getDirectoryFactory().release(dir);
                            }
                            throw throwable2;
                        }
                    }
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(SolrCore core) {
        NamedList master;
        boolean enableMaster;
        this.core = core;
        this.registerFileStreamResponseWriter();
        this.registerCloseHook();
        Object nbtk = this.initArgs.get(NUMBER_BACKUPS_TO_KEEP_INIT_PARAM);
        this.numberBackupsToKeep = nbtk != null ? Integer.parseInt(nbtk.toString()) : 0;
        NamedList slave = (NamedList)this.initArgs.get("slave");
        boolean enableSlave = this.isEnabled(slave);
        if (enableSlave) {
            this.tempSnapPuller = this.snapPuller = new SnapPuller(slave, this, core);
            this.isSlave = true;
        }
        if (((enableMaster = this.isEnabled(master = (NamedList)this.initArgs.get("master"))) || enableSlave) && core.getCoreDescriptor().getCoreContainer().getZkController() != null) {
            LOG.warn("SolrCloud is enabled for core " + core.getName() + " but so is old-style replication. Make sure you" + " intend this behavior, it usually indicates a mis-configuration. Master setting is " + Boolean.toString(enableMaster) + " and slave setting is " + Boolean.toString(enableSlave));
        }
        if (!enableSlave && !enableMaster) {
            enableMaster = true;
            master = new NamedList();
        }
        if (enableMaster) {
            String reserve;
            List backup;
            boolean backupOnCommit;
            this.includeConfFiles = (String)master.get(CONF_FILES);
            if (this.includeConfFiles != null && this.includeConfFiles.trim().length() > 0) {
                List<String> files = Arrays.asList(this.includeConfFiles.split(","));
                for (String file : files) {
                    if (file.trim().length() == 0) continue;
                    String[] strs = file.trim().split(":");
                    this.confFileNameAlias.add(strs[0], strs.length > 1 ? strs[1] : null);
                }
                LOG.info("Replication enabled for following config files: " + this.includeConfFiles);
            }
            boolean backupOnOptimize = !(backupOnCommit = (backup = master.getAll("backupAfter")).contains("commit")) && backup.contains("optimize");
            List replicateAfter = master.getAll(REPLICATE_AFTER);
            this.replicateOnCommit = replicateAfter.contains("commit");
            boolean bl = this.replicateOnOptimize = !this.replicateOnCommit && replicateAfter.contains("optimize");
            if (!this.replicateOnCommit && !this.replicateOnOptimize) {
                this.replicateOnCommit = true;
            }
            if (this.replicateOnOptimize) {
                IndexDeletionPolicy policy;
                IndexDeletionPolicyWrapper wrapper = core.getDeletionPolicy();
                IndexDeletionPolicy indexDeletionPolicy = policy = wrapper == null ? null : wrapper.getWrappedDeletionPolicy();
                if (policy instanceof SolrDeletionPolicy) {
                    SolrDeletionPolicy solrPolicy = (SolrDeletionPolicy)policy;
                    if (solrPolicy.getMaxOptimizedCommitsToKeep() < 1) {
                        solrPolicy.setMaxOptimizedCommitsToKeep(1);
                    }
                } else {
                    LOG.warn("Replication can't call setMaxOptimizedCommitsToKeep on " + policy);
                }
            }
            if (this.replicateOnOptimize || backupOnOptimize) {
                core.getUpdateHandler().registerOptimizeCallback(this.getEventListener(backupOnOptimize, this.replicateOnOptimize));
            }
            if (this.replicateOnCommit || backupOnCommit) {
                this.replicateOnCommit = true;
                core.getUpdateHandler().registerCommitCallback(this.getEventListener(backupOnCommit, this.replicateOnCommit));
            }
            if (replicateAfter.contains("startup")) {
                this.replicateOnStart = true;
                RefCounted<SolrIndexSearcher> s = core.getNewestSearcher(false);
                try {
                    DirectoryReader reader;
                    DirectoryReader directoryReader = reader = s == null ? null : s.get().getIndexReader();
                    if (reader != null && reader.getIndexCommit() != null && reader.getIndexCommit().getGeneration() != 1L) {
                        if (this.replicateOnOptimize) {
                            List commits = DirectoryReader.listCommits((Directory)reader.directory());
                            for (IndexCommit ic : commits) {
                                if (ic.getSegmentCount() != 1 || this.indexCommitPoint != null && this.indexCommitPoint.getGeneration() >= ic.getGeneration()) continue;
                                this.indexCommitPoint = ic;
                            }
                        } else {
                            this.indexCommitPoint = reader.getIndexCommit();
                        }
                    }
                    RefCounted<IndexWriter> iw = core.getUpdateHandler().getSolrCoreState().getIndexWriter(core);
                    iw.decref();
                }
                catch (IOException e) {
                    LOG.warn("Unable to get IndexCommit on startup", (Throwable)e);
                }
                finally {
                    if (s != null) {
                        s.decref();
                    }
                }
            }
            if ((reserve = (String)master.get(RESERVE)) != null && !reserve.trim().equals("")) {
                this.reserveCommitDuration = SnapPuller.readInterval(reserve);
            }
            LOG.info("Commits will be reserved for  " + this.reserveCommitDuration);
            this.isMaster = true;
        }
    }

    private boolean isEnabled(NamedList params) {
        if (params == null) {
            return false;
        }
        Object enable = params.get("enable");
        if (enable == null) {
            return true;
        }
        if (enable instanceof String) {
            return StrUtils.parseBool((String)((String)enable));
        }
        return Boolean.TRUE.equals(enable);
    }

    private void registerCloseHook() {
        this.core.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
                if (ReplicationHandler.this.snapPuller != null) {
                    ReplicationHandler.this.snapPuller.destroy();
                }
            }

            @Override
            public void postClose(SolrCore core) {
            }
        });
    }

    private void registerFileStreamResponseWriter() {
        this.core.registerResponseWriter(FILE_STREAM, new BinaryQueryResponseWriter(){

            @Override
            public void write(OutputStream out, SolrQueryRequest request, SolrQueryResponse resp) throws IOException {
                DirectoryFileStream stream = (DirectoryFileStream)resp.getValues().get(ReplicationHandler.FILE_STREAM);
                stream.write(out);
            }

            @Override
            public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) {
                throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
            }

            @Override
            public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
                return "application/octet-stream";
            }

            @Override
            public void init(NamedList args) {
            }
        });
    }

    private SolrEventListener getEventListener(final boolean snapshoot, final boolean getCommit) {
        return new SolrEventListener(){

            @Override
            public void init(NamedList args) {
            }

            @Override
            public void postCommit() {
                IndexCommit currentCommitPoint = ReplicationHandler.this.core.getDeletionPolicy().getLatestCommit();
                if (getCommit) {
                    ReplicationHandler.this.indexCommitPoint = currentCommitPoint;
                }
                if (snapshoot) {
                    try {
                        int numberToKeep = ReplicationHandler.this.numberBackupsToKeep;
                        if (numberToKeep < 1) {
                            numberToKeep = Integer.MAX_VALUE;
                        }
                        SnapShooter snapShooter = new SnapShooter(ReplicationHandler.this.core, null, null);
                        snapShooter.createSnapAsync(currentCommitPoint, numberToKeep, ReplicationHandler.this);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while snapshooting", (Throwable)e);
                    }
                }
            }

            @Override
            public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            }

            @Override
            public void postSoftCommit() {
            }
        };
    }

    private class LocalFsFileStream
    extends DirectoryFileStream {
        public LocalFsFileStream(SolrParams solrParams) {
            super(solrParams);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream out) throws IOException {
            block16: {
                String fileName = this.params.get(ReplicationHandler.FILE);
                String cfileName = this.params.get(ReplicationHandler.CONF_FILE_SHORT);
                String sOffset = this.params.get(ReplicationHandler.OFFSET);
                String sLen = this.params.get(ReplicationHandler.LEN);
                String compress = this.params.get(ReplicationHandler.COMPRESSION);
                String sChecksum = this.params.get(ReplicationHandler.CHECKSUM);
                String sGen = this.params.get(ReplicationHandler.GENERATION);
                if (sGen != null) {
                    this.indexGen = Long.parseLong(sGen);
                }
                this.fos = Boolean.parseBoolean(compress) ? new FastOutputStream((OutputStream)new DeflaterOutputStream(out)) : new FastOutputStream(out);
                FileInputStream inputStream = null;
                int packetsWritten = 0;
                try {
                    long offset = -1L;
                    int len = -1;
                    boolean useChecksum = Boolean.parseBoolean(sChecksum);
                    if (sOffset != null) {
                        offset = Long.parseLong(sOffset);
                    }
                    if (sLen != null) {
                        len = Integer.parseInt(sLen);
                    }
                    if (fileName == null && cfileName == null) {
                        this.writeNothing();
                    }
                    File file = null;
                    file = new File(ReplicationHandler.this.core.getResourceLoader().getConfigDir(), cfileName);
                    if (file.exists() && file.canRead()) {
                        inputStream = new FileInputStream(file);
                        FileChannel channel = inputStream.getChannel();
                        if (offset != -1L) {
                            channel.position(offset);
                        }
                        byte[] buf = new byte[len == -1 || len > 0x100000 ? 0x100000 : len];
                        Adler32 checksum = null;
                        if (useChecksum) {
                            checksum = new Adler32();
                        }
                        ByteBuffer bb = ByteBuffer.wrap(buf);
                        while (true) {
                            bb.clear();
                            long bytesRead = channel.read(bb);
                            if (bytesRead <= 0L) {
                                this.writeNothing();
                                this.fos.close();
                                break block16;
                            }
                            this.fos.writeInt((int)bytesRead);
                            if (useChecksum) {
                                checksum.reset();
                                checksum.update(buf, 0, (int)bytesRead);
                                this.fos.writeLong(checksum.getValue());
                            }
                            this.fos.write(buf, 0, (int)bytesRead);
                            this.fos.flush();
                            if (this.indexGen != null && packetsWritten % 5 == 0) {
                                this.delPolicy.setReserveDuration(this.indexGen, ReplicationHandler.this.reserveCommitDuration.intValue());
                            }
                            ++packetsWritten;
                        }
                    }
                    this.writeNothing();
                }
                catch (IOException e) {
                    LOG.warn("Exception while writing response for params: " + this.params, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(inputStream);
                }
            }
        }
    }

    private class DirectoryFileStream {
        protected SolrParams params;
        protected FastOutputStream fos;
        protected Long indexGen;
        protected IndexDeletionPolicyWrapper delPolicy;

        public DirectoryFileStream(SolrParams solrParams) {
            this.params = solrParams;
            this.delPolicy = ReplicationHandler.this.core.getDeletionPolicy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(OutputStream out) throws IOException {
            String fileName = this.params.get(ReplicationHandler.FILE);
            String cfileName = this.params.get(ReplicationHandler.CONF_FILE_SHORT);
            String sOffset = this.params.get(ReplicationHandler.OFFSET);
            String sLen = this.params.get(ReplicationHandler.LEN);
            String compress = this.params.get(ReplicationHandler.COMPRESSION);
            String sChecksum = this.params.get(ReplicationHandler.CHECKSUM);
            String sGen = this.params.get(ReplicationHandler.GENERATION);
            if (sGen != null) {
                this.indexGen = Long.parseLong(sGen);
            }
            this.fos = Boolean.parseBoolean(compress) ? new FastOutputStream((OutputStream)new DeflaterOutputStream(out)) : new FastOutputStream(out);
            int packetsWritten = 0;
            try (IndexInput in = null;){
                Directory dir;
                long offset = -1L;
                int len = -1;
                boolean useChecksum = Boolean.parseBoolean(sChecksum);
                if (sOffset != null) {
                    offset = Long.parseLong(sOffset);
                }
                if (sLen != null) {
                    len = Integer.parseInt(sLen);
                }
                if (fileName == null && cfileName == null) {
                    this.writeNothing();
                }
                RefCounted<SolrIndexSearcher> sref = ReplicationHandler.this.core.getSearcher();
                try {
                    SolrIndexSearcher searcher = sref.get();
                    dir = searcher.getIndexReader().directory();
                }
                finally {
                    sref.decref();
                }
                in = dir.openInput(fileName, IOContext.READONCE);
                if (offset != -1L) {
                    in.seek(offset);
                }
                byte[] buf = new byte[len == -1 || len > 0x100000 ? 0x100000 : len];
                Adler32 checksum = null;
                if (useChecksum) {
                    checksum = new Adler32();
                }
                long filelen = dir.fileLength(fileName);
                while (true) {
                    offset = offset == -1L ? 0L : offset;
                    int read = (int)Math.min((long)buf.length, filelen - offset);
                    in.readBytes(buf, 0, read);
                    this.fos.writeInt(read);
                    if (useChecksum) {
                        checksum.reset();
                        checksum.update(buf, 0, read);
                        this.fos.writeLong(checksum.getValue());
                    }
                    this.fos.write(buf, 0, read);
                    this.fos.flush();
                    if (this.indexGen != null && packetsWritten % 5 == 0) {
                        this.delPolicy.setReserveDuration(this.indexGen, ReplicationHandler.this.reserveCommitDuration.intValue());
                    }
                    ++packetsWritten;
                    if (read != buf.length) {
                        this.writeNothing();
                        this.fos.close();
                        break;
                    }
                    in.seek(offset += (long)read);
                }
            }
        }

        protected void writeNothing() throws IOException {
            this.fos.writeInt(0);
            this.fos.flush();
        }
    }

    static class FileInfo {
        long lastmodified;
        String name;
        long size;
        long checksum;

        public FileInfo(long lasmodified, String name, long size, long checksum) {
            this.lastmodified = lasmodified;
            this.name = name;
            this.size = size;
            this.checksum = checksum;
        }

        Map<String, Object> getAsMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ReplicationHandler.NAME, this.name);
            map.put(ReplicationHandler.SIZE, this.size);
            map.put(ReplicationHandler.CHECKSUM, this.checksum);
            return map;
        }
    }

    private static final class CommitVersionInfo {
        public final long version;
        public final long generation;

        private CommitVersionInfo(long g, long v) {
            this.generation = g;
            this.version = v;
        }

        public static CommitVersionInfo build(IndexCommit commit) {
            long generation = commit.getGeneration();
            long version = 0L;
            try {
                Map commitData = commit.getUserData();
                String commitTime = (String)commitData.get("commitTimeMSec");
                if (commitTime != null) {
                    try {
                        version = Long.parseLong(commitTime);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Version in commitData was not formated correctly: " + commitTime, (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to get version from commitData, commit: " + commit, (Throwable)e);
            }
            return new CommitVersionInfo(generation, version);
        }
    }
}

