/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.LoggerInfo;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHandler
extends RequestHandlerBase
implements SolrCoreAware {
    static final Logger log = LoggerFactory.getLogger(LoggingHandler.class);
    private LogWatcher watcher;

    public LoggingHandler(CoreContainer cc) {
        this.watcher = cc.getLogging();
    }

    public LoggingHandler() {
    }

    @Override
    public void inform(SolrCore core) {
        if (this.watcher == null) {
            this.watcher = core.getCoreDescriptor().getCoreContainer().getLogging();
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String since;
        String[] set;
        if (this.watcher == null) {
            rsp.add("error", "Logging Not Initalized");
            return;
        }
        rsp.add("watcher", this.watcher.getName());
        SolrParams params = req.getParams();
        if (params.get("threshold") != null) {
            this.watcher.setThreshold(params.get("threshold"));
        }
        if (params.get("test") != null) {
            log.trace("trace message");
            log.debug("debug message");
            log.info("info (with exception)", (Throwable)new RuntimeException("test"));
            log.warn("warn (with exception)", (Throwable)new RuntimeException("test"));
            log.error("error (with exception)", (Throwable)new RuntimeException("test"));
        }
        if ((set = params.getParams("set")) != null) {
            for (String pair : set) {
                String[] split = pair.split(":");
                if (split.length != 2) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid format, expected level:value, got " + pair);
                }
                String category = split[0];
                String level = split[1];
                this.watcher.setLogLevel(category, level);
            }
        }
        if ((since = req.getParams().get("since")) != null) {
            long time = -1L;
            try {
                time = Long.parseLong(since);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid timestamp: " + since);
            }
            AtomicBoolean found = new AtomicBoolean(false);
            SolrDocumentList docs = this.watcher.getHistory(time, found);
            if (docs == null) {
                rsp.add("error", "History not enabled");
                return;
            }
            SimpleOrderedMap info = new SimpleOrderedMap();
            if (time > 0L) {
                info.add("since", (Object)time);
                info.add("found", (Object)found);
            } else {
                info.add("levels", this.watcher.getAllLevels());
            }
            info.add("last", (Object)this.watcher.getLastEvent());
            info.add("buffer", (Object)this.watcher.getHistorySize());
            info.add("threshold", (Object)this.watcher.getThreshold());
            rsp.add("info", info);
            rsp.add("history", docs);
        } else {
            rsp.add("levels", this.watcher.getAllLevels());
            ArrayList<LoggerInfo> loggers = new ArrayList<LoggerInfo>(this.watcher.getAllLoggers());
            Collections.sort(loggers);
            ArrayList info = new ArrayList();
            for (LoggerInfo wrap : loggers) {
                info.add(wrap.getInfo());
            }
            rsp.add("loggers", info);
        }
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "Logging Handler";
    }

    @Override
    public String getSource() {
        return null;
    }
}

