/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.handler.component.PivotFacetValue;

public class PivotFacetFieldValueCollection
implements Iterable<PivotFacetValue> {
    private List<PivotFacetValue> explicitValues = new ArrayList<PivotFacetValue>();
    private PivotFacetValue missingValue;
    private Map<Comparable, PivotFacetValue> valuesMap = new HashMap<Comparable, PivotFacetValue>();
    private boolean dirty = true;
    private final int facetFieldMinimumCount;
    private final int facetFieldOffset;
    private final int facetFieldLimit;
    private final String facetFieldSort;

    public PivotFacetFieldValueCollection(int minCount, int offset, int limit, String fieldSort) {
        this.facetFieldMinimumCount = minCount;
        this.facetFieldOffset = offset;
        this.facetFieldLimit = limit;
        this.facetFieldSort = fieldSort;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public PivotFacetValue getMissingValue() {
        return this.missingValue;
    }

    public List<PivotFacetValue> getExplicitValuesList() {
        return Collections.unmodifiableList(this.explicitValues);
    }

    public int getExplicitValuesListSize() {
        return this.explicitValues.size();
    }

    public int size() {
        return this.getExplicitValuesListSize() + (this.missingValue == null ? 0 : 1);
    }

    public List<PivotFacetValue> getNextLevelValuesToRefine() {
        int numRefinableValues = this.getExplicitValuesListSize();
        if (this.facetFieldOffset < numRefinableValues) {
            int offsetPlusCount = this.facetFieldLimit >= 0 ? Math.min(this.facetFieldLimit + this.facetFieldOffset, numRefinableValues) : numRefinableValues;
            return this.getExplicitValuesList().subList(this.facetFieldOffset, offsetPlusCount);
        }
        return Collections.emptyList();
    }

    public PivotFacetValue get(Comparable value) {
        return this.valuesMap.get(value);
    }

    public PivotFacetValue getAt(int index) {
        return this.explicitValues.get(index);
    }

    public void add(PivotFacetValue pfValue) {
        Comparable val = pfValue.getValue();
        assert (!this.valuesMap.containsKey(val)) : "Must not add duplicate PivotFacetValue with redundent inner value";
        this.dirty = true;
        if (null == val) {
            this.missingValue = pfValue;
        } else {
            this.explicitValues.add(pfValue);
        }
        this.valuesMap.put(val, pfValue);
    }

    public void trim() {
        this.trimNonNullValues();
        this.trimNullValue();
    }

    private void trimNullValue() {
        if (this.missingValue == null) {
            return;
        }
        if (this.missingValue.getCount() >= this.facetFieldMinimumCount) {
            if (null != this.missingValue.getChildPivot()) {
                this.missingValue.getChildPivot().trim();
            }
        } else {
            this.missingValue = null;
        }
    }

    private void trimNonNullValues() {
        if (this.explicitValues != null && this.explicitValues.size() > 0) {
            this.sort();
            ArrayList<PivotFacetValue> trimmedValues = new ArrayList<PivotFacetValue>();
            int facetsSkipped = 0;
            for (PivotFacetValue pivotValue : this.explicitValues) {
                if (pivotValue.getCount() < this.facetFieldMinimumCount) continue;
                if (facetsSkipped >= this.facetFieldOffset) {
                    trimmedValues.add(pivotValue);
                    if (pivotValue.getChildPivot() != null) {
                        pivotValue.getChildPivot().trim();
                    }
                    if (this.facetFieldLimit <= 0 || trimmedValues.size() < this.facetFieldLimit) continue;
                    break;
                }
                ++facetsSkipped;
            }
            this.explicitValues = trimmedValues;
            this.valuesMap.clear();
        }
    }

    public void sort() {
        if (this.dirty) {
            if (this.facetFieldSort.equals("count")) {
                Collections.sort(this.explicitValues, new PivotFacetCountComparator());
            } else if (this.facetFieldSort.equals("index")) {
                Collections.sort(this.explicitValues, new PivotFacetValueComparator());
            }
            this.dirty = false;
        }
        for (PivotFacetValue value : this.explicitValues) {
            if (value.getChildPivot() == null) continue;
            value.getChildPivot().sort();
        }
        if (this.missingValue != null && this.missingValue.getChildPivot() != null) {
            this.missingValue.getChildPivot().sort();
        }
    }

    @Override
    public Iterator<PivotFacetValue> iterator() {
        Iterator<PivotFacetValue> it = new Iterator<PivotFacetValue>(){
            private final Iterator valuesIterator;
            private boolean shouldGiveMissingValue;
            {
                this.valuesIterator = PivotFacetFieldValueCollection.this.explicitValues.iterator();
                this.shouldGiveMissingValue = PivotFacetFieldValueCollection.this.missingValue != null;
            }

            @Override
            public boolean hasNext() {
                return this.valuesIterator.hasNext() || this.shouldGiveMissingValue;
            }

            @Override
            public PivotFacetValue next() {
                if (this.valuesIterator.hasNext()) {
                    return (PivotFacetValue)this.valuesIterator.next();
                }
                if (this.shouldGiveMissingValue) {
                    this.shouldGiveMissingValue = false;
                    return PivotFacetFieldValueCollection.this.missingValue;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove from this iterator");
            }
        };
        return it;
    }

    static int compareWithNullLast(Comparable o1, Comparable o2) {
        if (null == o1) {
            if (null == o2) {
                return 0;
            }
            return 1;
        }
        if (null == o2) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public String toString() {
        return String.format(Locale.ROOT, "Values:%s | Missing:%s ", this.explicitValues, this.missingValue);
    }

    public class PivotFacetValueComparator
    implements Comparator<PivotFacetValue> {
        @Override
        public int compare(PivotFacetValue left, PivotFacetValue right) {
            return PivotFacetFieldValueCollection.compareWithNullLast(left.getValue(), right.getValue());
        }
    }

    public class PivotFacetCountComparator
    implements Comparator<PivotFacetValue> {
        @Override
        public int compare(PivotFacetValue left, PivotFacetValue right) {
            int countCmp = right.getCount() - left.getCount();
            return 0 != countCmp ? countCmp : PivotFacetFieldValueCollection.compareWithNullLast(left.getValue(), right.getValue());
        }
    }
}

