/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class DocValuesStats {
    private DocValuesStats() {
    }

    public static StatsValues getCounts(SolrIndexSearcher searcher, String fieldName, DocSet docs, boolean calcDistinct, String[] facet) throws IOException {
        SortedSetDocValues si;
        SchemaField schemaField = searcher.getSchema().getField(fieldName);
        FieldType ft = schemaField.getType();
        StatsValues res = StatsValuesFactory.createStatsValues(schemaField, calcDistinct);
        FieldFacetStats[] facetStats = new FieldFacetStats[facet.length];
        int upto = 0;
        for (String facetField : facet) {
            SchemaField facetSchemaField = searcher.getSchema().getField(facetField);
            facetStats[upto++] = new FieldFacetStats(searcher, facetField, schemaField, facetSchemaField, calcDistinct);
        }
        boolean multiValued = schemaField.multiValued() || ft.multiValuedFieldCache();
        MultiDocValues.OrdinalMap ordinalMap = null;
        if (multiValued) {
            si = searcher.getAtomicReader().getSortedSetDocValues(fieldName);
            if (si instanceof MultiDocValues.MultiSortedSetDocValues) {
                ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)si).mapping;
            }
        } else {
            SortedDocValues single = searcher.getAtomicReader().getSortedDocValues(fieldName);
            RandomAccessOrds randomAccessOrds = si = single == null ? null : DocValues.singleton((SortedDocValues)single);
            if (single instanceof MultiDocValues.MultiSortedDocValues) {
                ordinalMap = ((MultiDocValues.MultiSortedDocValues)single).mapping;
            }
        }
        if (si == null) {
            si = DocValues.emptySortedSet();
        }
        if (si.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Currently this stats method is limited to 2147483647 unique terms");
        }
        DocSet missing = docs.andNot(searcher.getDocSet((Query)new TermRangeQuery(fieldName, null, null, false, false)));
        int nTerms = (int)si.getValueCount();
        int[] counts = new int[nTerms];
        Filter filter = docs.getTopFilter();
        List leaves = searcher.getTopReaderContext().leaves();
        for (int subIndex = 0; subIndex < leaves.size(); ++subIndex) {
            SortedSetDocValues sub;
            AtomicReaderContext leaf = (AtomicReaderContext)leaves.get(subIndex);
            DocIdSet dis = filter.getDocIdSet(leaf, null);
            DocIdSetIterator disi = null;
            if (dis != null) {
                disi = dis.iterator();
            }
            if (disi == null) continue;
            int docBase = leaf.docBase;
            if (multiValued) {
                SortedDocValues singleton;
                sub = leaf.reader().getSortedSetDocValues(fieldName);
                if (sub == null) {
                    sub = DocValues.emptySortedSet();
                }
                if ((singleton = DocValues.unwrapSingleton((SortedSetDocValues)sub)) != null) {
                    DocValuesStats.accumSingle(counts, docBase, facetStats, singleton, disi, subIndex, ordinalMap);
                    continue;
                }
                DocValuesStats.accumMulti(counts, docBase, facetStats, sub, disi, subIndex, ordinalMap);
                continue;
            }
            sub = leaf.reader().getSortedDocValues(fieldName);
            if (sub == null) {
                sub = DocValues.emptySorted();
            }
            DocValuesStats.accumSingle(counts, docBase, facetStats, (SortedDocValues)sub, disi, subIndex, ordinalMap);
        }
        for (int ord = 0; ord < counts.length; ++ord) {
            int count = counts[ord];
            if (count <= 0) continue;
            BytesRef value = si.lookupOrd((long)ord);
            res.accumulate(value, count);
            for (FieldFacetStats f : facetStats) {
                f.accumulateTermNum(ord, value);
            }
        }
        res.addMissing(missing.size());
        if (facetStats.length > 0) {
            for (FieldFacetStats f : facetStats) {
                Map<String, StatsValues> facetStatsValues = f.facetStatsValues;
                FieldType facetType = searcher.getSchema().getFieldType(f.name);
                for (Map.Entry<String, StatsValues> entry : facetStatsValues.entrySet()) {
                    String termLabel = entry.getKey();
                    int missingCount = searcher.numDocs((Query)new TermQuery(new Term(f.name, facetType.toInternal(termLabel))), missing);
                    entry.getValue().addMissing(missingCount);
                }
                res.addFacet(f.name, facetStatsValues);
            }
        }
        return res;
    }

    static void accumSingle(int[] counts, int docBase, FieldFacetStats[] facetStats, SortedDocValues si, DocIdSetIterator disi, int subIndex, MultiDocValues.OrdinalMap map) throws IOException {
        int doc;
        LongValues ordMap;
        LongValues longValues = ordMap = map == null ? null : map.getGlobalOrds(subIndex);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int term = si.getOrd(doc);
            if (term < 0) continue;
            if (map != null) {
                term = (int)ordMap.get(term);
            }
            int n = term;
            counts[n] = counts[n] + 1;
            for (FieldFacetStats f : facetStats) {
                f.facetTermNum(docBase + doc, term);
            }
        }
    }

    static void accumMulti(int[] counts, int docBase, FieldFacetStats[] facetStats, SortedSetDocValues si, DocIdSetIterator disi, int subIndex, MultiDocValues.OrdinalMap map) throws IOException {
        int doc;
        LongValues ordMap;
        LongValues longValues = ordMap = map == null ? null : map.getGlobalOrds(subIndex);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            long ord;
            si.setDocument(doc);
            while ((ord = si.nextOrd()) != -1L) {
                int term = (int)ord;
                if (map != null) {
                    term = (int)ordMap.get(term);
                }
                int n = term;
                counts[n] = counts[n] + 1;
                for (FieldFacetStats f : facetStats) {
                    f.facetTermNum(docBase + doc, term);
                }
            }
        }
    }
}

