/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.schema.BaseFieldTypeResource;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeResource
extends BaseFieldTypeResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(FieldTypeResource.class);
    private String typeName;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.typeName = (String)this.getRequestAttributes().get("name");
            try {
                this.typeName = null == this.typeName ? "" : FieldTypeResource.urlDecode(this.typeName.trim()).trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException((Throwable)e);
            }
        }
    }

    @Override
    public Representation get() {
        try {
            if (this.typeName.isEmpty()) {
                String message = "Field type name is missing";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field type name is missing");
            }
            FieldType fieldType = this.getSchema().getFieldTypes().get(this.typeName);
            if (null == fieldType) {
                String message = "Field type '" + this.typeName + "' not found.";
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, message);
            }
            this.getSolrResponse().add("fieldType", this.getFieldTypeProperties(fieldType));
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    @Override
    protected List<String> getFieldsWithFieldType(FieldType fieldType) {
        ArrayList<String> fields = new ArrayList<String>();
        for (SchemaField schemaField : this.getSchema().getFields().values()) {
            if (!schemaField.getType().getTypeName().equals(fieldType.getTypeName())) continue;
            fields.add(schemaField.getName());
        }
        Collections.sort(fields);
        return fields;
    }

    @Override
    protected List<String> getDynamicFieldsWithFieldType(FieldType fieldType) {
        ArrayList<String> dynamicFields = new ArrayList<String>();
        for (SchemaField prototype : this.getSchema().getDynamicFieldPrototypes()) {
            if (!prototype.getType().getTypeName().equals(fieldType.getTypeName())) continue;
            dynamicFields.add(prototype.getName());
        }
        return dynamicFields;
    }
}

