/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.LeaderInitiatedRecoveryThread;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedUpdateProcessor
extends UpdateRequestProcessor {
    public static final String DISTRIB_FROM_SHARD = "distrib.from.shard";
    public static final String DISTRIB_FROM_COLLECTION = "distrib.from.collection";
    public static final String DISTRIB_FROM_PARENT = "distrib.from.parent";
    public static final String DISTRIB_FROM = "distrib.from";
    private static final String TEST_DISTRIB_SKIP_SERVERS = "test.distrib.skip.servers";
    public static final Logger log = LoggerFactory.getLogger(DistributedUpdateProcessor.class);
    public static final String COMMIT_END_POINT = "commit_end_point";
    public static final String LOG_REPLAY = "log_replay";
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final UpdateRequestProcessor next;
    public static final String VERSION_FIELD = "_version_";
    private final UpdateHandler updateHandler;
    private final UpdateLog ulog;
    private final VersionInfo vinfo;
    private final boolean versionsStored;
    private boolean returnVersions = true;
    private NamedList addsResponse = null;
    private NamedList deleteResponse = null;
    private NamedList deleteByQueryResponse = null;
    private CharsRef scratch;
    private final SchemaField idField;
    private SolrCmdDistributor cmdDistrib;
    private final boolean zkEnabled;
    private CloudDescriptor cloudDesc;
    private final String collection;
    private final ZkController zkController;
    private boolean isLeader = true;
    private boolean forwardToLeader = false;
    private boolean isSubShardLeader = false;
    private List<SolrCmdDistributor.Node> nodes;
    private UpdateCommand updateCommand;
    private RequestReplicationTracker replicationTracker = null;

    public DistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(next);
        this.rsp = rsp;
        this.next = next;
        this.idField = req.getSchema().getUniqueKeyField();
        this.updateHandler = req.getCore().getUpdateHandler();
        this.ulog = this.updateHandler.getUpdateLog();
        this.vinfo = this.ulog == null ? null : this.ulog.getVersionInfo();
        this.versionsStored = this.vinfo != null && this.vinfo.getVersionField() != null;
        this.returnVersions = req.getParams().getBool("versions", false);
        SolrRequestInfo reqInfo = this.returnVersions ? SolrRequestInfo.getRequestInfo() : null;
        this.req = req;
        CoreDescriptor coreDesc = req.getCore().getCoreDescriptor();
        this.zkEnabled = coreDesc.getCoreContainer().isZooKeeperAware();
        this.zkController = req.getCore().getCoreDescriptor().getCoreContainer().getZkController();
        if (this.zkEnabled) {
            this.cmdDistrib = new SolrCmdDistributor(coreDesc.getCoreContainer().getUpdateShardHandler());
        }
        this.cloudDesc = coreDesc.getCloudDescriptor();
        this.collection = this.cloudDesc != null ? this.cloudDesc.getCollectionName() : null;
    }

    private List<SolrCmdDistributor.Node> setupRequest(String id, SolrInputDocument doc) {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        if (this.zkEnabled) {
            String shardId;
            if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
                this.isLeader = false;
                this.forwardToLeader = false;
                return nodes;
            }
            ClusterState cstate = this.zkController.getClusterState();
            DocCollection coll = cstate.getCollection(this.collection);
            Slice slice = coll.getRouter().getTargetSlice(id, doc, this.req.getParams(), coll);
            if (slice == null && (slice = coll.getSlice(shardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId())) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard " + shardId + " in " + coll);
            }
            DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
            if (DistribPhase.FROMLEADER == phase && !this.couldIbeSubShardLeader(coll) && !this.req.getCore().getCoreDescriptor().getCloudDescriptor().isLeader()) {
                this.isLeader = false;
                this.forwardToLeader = false;
                return nodes;
            }
            String shardId2 = slice.getName();
            try {
                Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId2);
                this.isLeader = leaderReplica.getName().equals(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
                if (!this.isLeader) {
                    this.isSubShardLeader = this.amISubShardLeader(coll, slice, id, doc);
                    if (this.isSubShardLeader) {
                        String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                        slice = coll.getSlice(myShardId);
                        shardId2 = myShardId;
                        leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId);
                        List myReplicas = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId2, leaderReplica.getName(), null, "down");
                    }
                }
                this.doDefensiveChecks(phase);
                String fromCollection = this.updateCommand.getReq().getParams().get(DISTRIB_FROM_COLLECTION);
                if (DistribPhase.FROMLEADER == phase && !this.isSubShardLeader && fromCollection == null) {
                    this.forwardToLeader = false;
                } else if (this.isLeader || this.isSubShardLeader) {
                    this.forwardToLeader = false;
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId2, leaderReplica.getName(), null, "down");
                    if (replicaProps != null) {
                        if (nodes == null) {
                            nodes = new ArrayList(replicaProps.size());
                        }
                        String[] skipList = this.req.getParams().getParams(TEST_DISTRIB_SKIP_SERVERS);
                        HashSet<String> skipListSet = null;
                        if (skipList != null) {
                            skipListSet = new HashSet<String>(skipList.length);
                            skipListSet.addAll(Arrays.asList(skipList));
                            log.info("test.distrib.skip.servers was found and contains:" + skipListSet);
                        }
                        for (ZkCoreNodeProps props : replicaProps) {
                            if (skipList != null) {
                                boolean skip = skipListSet.contains(props.getCoreUrl());
                                log.info("check url:" + props.getCoreUrl() + " against:" + skipListSet + " result:" + skip);
                                if (skip) continue;
                                nodes.add(new SolrCmdDistributor.StdNode(props, this.collection, shardId2));
                                continue;
                            }
                            nodes.add(new SolrCmdDistributor.StdNode(props, this.collection, shardId2));
                        }
                    }
                } else {
                    nodes = new ArrayList<SolrCmdDistributor.StdNode>(1);
                    nodes.add(new SolrCmdDistributor.RetryNode(new ZkCoreNodeProps((ZkNodeProps)leaderReplica), this.zkController.getZkStateReader(), this.collection, shardId2));
                    this.forwardToLeader = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        return nodes;
    }

    private boolean couldIbeSubShardLeader(DocCollection coll) {
        String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
        Slice mySlice = coll.getSlice(myShardId);
        String state = mySlice.getState();
        return Slice.CONSTRUCTION.equals(state) || Slice.RECOVERY.equals(state);
    }

    private boolean amISubShardLeader(DocCollection coll, Slice parentSlice, String id, SolrInputDocument doc) throws InterruptedException {
        Replica myLeader;
        boolean amILeader;
        String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
        Slice mySlice = coll.getSlice(myShardId);
        String state = mySlice.getState();
        if ((Slice.CONSTRUCTION.equals(state) || Slice.RECOVERY.equals(state)) && (amILeader = (myLeader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId)).getName().equals(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName()))) {
            DocRouter.Range myRange = mySlice.getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (parentSlice != null) {
                boolean isSubset = parentSlice.getRange() != null && myRange.isSubsetOf(parentSlice.getRange());
                return isSubset && coll.getRouter().isTargetSlice(id, doc, this.req.getParams(), myShardId, coll);
            }
            return true;
        }
        return false;
    }

    private List<SolrCmdDistributor.Node> getSubShardLeaders(DocCollection coll, String shardId, String docId, SolrInputDocument doc) {
        Collection allSlices = coll.getSlices();
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        for (Slice aslice : allSlices) {
            Replica sliceLeader;
            boolean isSubset;
            if (!Slice.CONSTRUCTION.equals(aslice.getState()) && !Slice.RECOVERY.equals(aslice.getState())) continue;
            DocRouter.Range myRange = coll.getSlice(shardId).getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (!(isSubset = aslice.getRange() != null && aslice.getRange().isSubsetOf(myRange)) || docId != null && (docId == null || !coll.getRouter().isTargetSlice(docId, doc, this.req.getParams(), aslice.getName(), coll)) || (sliceLeader = aslice.getLeader()) == null || !this.zkController.getClusterState().liveNodesContain(sliceLeader.getNodeName())) continue;
            if (nodes == null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>();
            }
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)sliceLeader);
            nodes.add(new SolrCmdDistributor.StdNode(nodeProps, coll.getName(), shardId));
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SolrCmdDistributor.Node> getNodesByRoutingRules(ClusterState cstate, DocCollection coll, String id, SolrInputDocument doc) {
        RoutingRule rule;
        DocRouter router = coll.getRouter();
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        if (!(router instanceof CompositeIdRouter)) return nodes;
        CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
        String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
        Slice slice = coll.getSlice(myShardId);
        Map routingRules = slice.getRoutingRules();
        if (routingRules == null) return nodes;
        if (id == null) {
            for (Map.Entry entry : routingRules.entrySet()) {
                String targetCollectionName = ((RoutingRule)entry.getValue()).getTargetCollectionName();
                Collection activeSlices = cstate.getActiveSlices(targetCollectionName);
                if (activeSlices == null || activeSlices.isEmpty()) continue;
                Slice any = (Slice)activeSlices.iterator().next();
                if (nodes == null) {
                    nodes = new ArrayList<SolrCmdDistributor.StdNode>();
                }
                nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)any.getLeader())));
            }
            return nodes;
        }
        String routeKey = SolrIndexSplitter.getRouteKey(id);
        if (routeKey == null || (rule = (RoutingRule)routingRules.get(routeKey + "!")) == null) return nodes;
        if (rule.getExpireAt() >= System.currentTimeMillis()) {
            List ranges = rule.getRouteRanges();
            if (ranges == null || ranges.isEmpty()) return nodes;
            int hash = compositeIdRouter.sliceHash(id, doc, null, coll);
            for (DocRouter.Range range : ranges) {
                DocCollection targetColl;
                Collection activeSlices;
                if (!range.includes(hash)) continue;
                if (nodes == null) {
                    nodes = new ArrayList();
                }
                if ((activeSlices = (targetColl = cstate.getCollection(rule.getTargetCollectionName())).getRouter().getSearchSlicesSingle(id, null, targetColl)) == null || activeSlices.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No active slices serving " + id + " found for target collection: " + rule.getTargetCollectionName());
                }
                Replica targetLeader = cstate.getLeader(rule.getTargetCollectionName(), ((Slice)activeSlices.iterator().next()).getName());
                nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)targetLeader)));
                return nodes;
            }
            return nodes;
        }
        ReentrantLock ruleExpiryLock = this.req.getCore().getRuleExpiryLock();
        if (ruleExpiryLock.isLocked()) return nodes;
        try {
            if (!ruleExpiryLock.tryLock(10L, TimeUnit.MILLISECONDS)) return nodes;
            log.info("Going to expire routing rule");
            try {
                Map map = ZkNodeProps.makeMap((Object[])new Object[]{"operation", "removeroutingrule", "collection", this.collection, "shard", myShardId, "routeKey", routeKey + "!"});
                SolrZkClient zkClient = this.req.getCore().getCoreDescriptor().getCoreContainer().getZkController().getZkClient();
                DistributedQueue queue = Overseer.getInQueue(zkClient);
                queue.offer(ZkStateReader.toJSON((Object)map));
                return nodes;
            }
            catch (KeeperException e) {
                log.warn("Exception while removing routing rule for route key: " + routeKey, (Throwable)e);
                return nodes;
            }
            catch (Exception e) {
                log.error("Exception while removing routing rule for route key: " + routeKey, (Throwable)e);
                return nodes;
            }
            finally {
                ruleExpiryLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return nodes;
    }

    private void doDefensiveChecks(DistribPhase phase) {
        boolean isReplayOrPeersync;
        boolean bl = isReplayOrPeersync = (this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        if (isReplayOrPeersync) {
            return;
        }
        String from = this.req.getParams().get(DISTRIB_FROM);
        ClusterState clusterState = this.zkController.getClusterState();
        CloudDescriptor cloudDescriptor = this.req.getCore().getCoreDescriptor().getCloudDescriptor();
        Slice mySlice = clusterState.getSlice(this.collection, cloudDescriptor.getShardId());
        boolean localIsLeader = cloudDescriptor.isLeader();
        if (DistribPhase.FROMLEADER == phase && localIsLeader && from != null) {
            String fromShard = this.req.getParams().get(DISTRIB_FROM_PARENT);
            if (fromShard != null) {
                if (Slice.ACTIVE.equals(mySlice.getState())) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but we are in active state");
                }
                Slice fromSlice = this.zkController.getClusterState().getCollection(this.collection).getSlice(fromShard);
                DocRouter.Range parentRange = fromSlice.getRange();
                if (parentRange == null) {
                    parentRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
                if (mySlice.getRange() != null && !mySlice.getRange().isSubsetOf(parentRange)) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but parent hash range is not superset of my range");
                }
            } else {
                String fromCollection = this.req.getParams().get(DISTRIB_FROM_COLLECTION);
                if (fromCollection == null) {
                    log.error("Request says it is coming from leader, but we are the leader: " + this.req.getParamString());
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from leader, but we are the leader");
                }
            }
        }
        if (this.isLeader && !localIsLeader || this.isSubShardLeader && !localIsLeader) {
            log.error("ClusterState says we are the leader, but locally we don't think so");
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "ClusterState says we are the leader (" + this.zkController.getBaseUrl() + "/" + this.req.getCore().getName() + "), but locally we don't think so. Request came from " + from);
        }
    }

    private List<SolrCmdDistributor.Node> setupRequest() {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        String shardId = this.cloudDesc.getShardId();
        try {
            Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId);
            this.isLeader = leaderReplica.getName().equals(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
            this.forwardToLeader = false;
            List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, leaderReplica.getName());
            if (replicaProps != null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>(replicaProps.size());
                for (ZkCoreNodeProps props : replicaProps) {
                    nodes.add(new SolrCmdDistributor.StdNode(props, this.collection, shardId));
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return nodes;
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        this.updateCommand = cmd;
        if (this.zkEnabled) {
            this.zkCheck();
            this.nodes = this.setupRequest(cmd.getHashableId(), cmd.getSolrInputDocument());
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        int minRf = -1;
        if (this.replicationTracker != null) {
            minRf = this.replicationTracker.minRf;
        } else {
            SolrParams rp = cmd.getReq().getParams();
            String distribUpdate = rp.get("update.distrib");
            if (distribUpdate == null || distribUpdate.equals(DistribPhase.TOLEADER.toString())) {
                String minRepFact = rp.get("min_rf");
                if (minRepFact != null) {
                    try {
                        minRf = Integer.parseInt(minRepFact);
                    }
                    catch (NumberFormatException nfe) {
                        minRf = -1;
                    }
                    if (minRf <= 0) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value " + minRepFact + " for " + "min_rf" + "; must be >0 and less than or equal to the collection replication factor.");
                    }
                }
                if (minRf > 1) {
                    String myShardId = this.forwardToLeader ? null : this.cloudDesc.getShardId();
                    this.replicationTracker = new RequestReplicationTracker(myShardId, minRf);
                }
            }
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionAdd(cmd);
        }
        if (dropCmd) {
            return;
        }
        if (this.zkEnabled && this.isLeader && !this.isSubShardLeader) {
            List<SolrCmdDistributor.Node> nodesByRoutingRules;
            DocCollection coll = this.zkController.getClusterState().getCollection(this.collection);
            List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), cmd.getHashableId(), cmd.getSolrInputDocument());
            if (subShardLeaders != null && !subShardLeaders.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_PARENT, new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId()});
                for (SolrCmdDistributor.Node subShardLeader : subShardLeaders) {
                    this.cmdDistrib.distribAdd(cmd, Collections.singletonList(subShardLeader), params, true);
                }
            }
            if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.zkController.getClusterState(), coll, cmd.getHashableId(), cmd.getSolrInputDocument())) != null && !nodesByRoutingRules.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_COLLECTION, new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName()});
                params.set(DISTRIB_FROM_SHARD, new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId()});
                for (SolrCmdDistributor.Node nodesByRoutingRule : nodesByRoutingRules) {
                    this.cmdDistrib.distribAdd(cmd, Collections.singletonList(nodesByRoutingRule), params, true);
                }
            }
        }
        ModifiableSolrParams params = null;
        if (this.nodes != null) {
            params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            if (this.replicationTracker != null && minRf > 1) {
                params.set("min_rf", new String[]{String.valueOf(minRf)});
            }
            this.cmdDistrib.distribAdd(cmd, this.nodes, params, false, this.replicationTracker);
        }
        if (this.returnVersions && this.rsp != null && this.idField != null) {
            if (this.addsResponse == null) {
                this.addsResponse = new NamedList();
                this.rsp.add("adds", this.addsResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRef();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.addsResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    private void doFinish() {
        this.cmdDistrib.finish();
        List<SolrCmdDistributor.Error> errors = this.cmdDistrib.getErrors();
        if (errors.size() > 0) {
            if (errors.get((int)0).req.node instanceof SolrCmdDistributor.RetryNode) {
                this.rsp.setException(errors.get((int)0).e);
            } else if (log.isWarnEnabled()) {
                for (SolrCmdDistributor.Error error : errors) {
                    log.warn("Error sending update", (Throwable)error.e);
                }
            }
        }
        for (SolrCmdDistributor.Error error : errors) {
            DistribPhase phase;
            if (error.req.node instanceof SolrCmdDistributor.RetryNode || (phase = DistribPhase.parseParam(error.req.uReq.getParams().get("update.distrib"))) != DistribPhase.FROMLEADER) continue;
            String replicaUrl = error.req.node.getUrl();
            int maxTries = 1;
            boolean sendRecoveryCommand = true;
            String collection = null;
            String shardId = null;
            if (error.req.node instanceof SolrCmdDistributor.StdNode) {
                SolrCmdDistributor.StdNode stdNode = (SolrCmdDistributor.StdNode)error.req.node;
                collection = stdNode.getCollection();
                shardId = stdNode.getShardId();
                try {
                    sendRecoveryCommand = this.zkController.ensureReplicaInLeaderInitiatedRecovery(collection, shardId, replicaUrl, stdNode.getNodeProps(), false);
                    if (sendRecoveryCommand) {
                        maxTries = 120;
                    }
                }
                catch (Exception e) {
                    log.error("Leader failed to set replica " + error.req.node.getUrl() + " state to DOWN due to: " + e, (Throwable)e);
                }
            }
            if (!sendRecoveryCommand) continue;
            Throwable rootCause = SolrException.getRootCause((Throwable)error.e);
            log.error("Setting up to try to start recovery on replica " + replicaUrl + " after: " + rootCause);
            CoreContainer coreContainer = this.req.getCore().getCoreDescriptor().getCoreContainer();
            LeaderInitiatedRecoveryThread lirThread = new LeaderInitiatedRecoveryThread(this.zkController, coreContainer, collection, shardId, error.req.node.getNodeProps(), maxTries);
            ExecutorService executor = coreContainer.getUpdateShardHandler().getUpdateExecutor();
            executor.execute(lirThread);
        }
        if (this.replicationTracker != null) {
            this.rsp.getResponseHeader().add("rf", (Object)this.replicationTracker.getAchievedRf());
            this.rsp.getResponseHeader().add("min_rf", (Object)this.replicationTracker.minRf);
            this.replicationTracker = null;
        }
    }

    private void doLocalAdd(AddUpdateCommand cmd) throws IOException {
        super.processAdd(cmd);
    }

    private void doLocalDelete(DeleteUpdateCommand cmd) throws IOException {
        super.processDelete(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean versionAdd(AddUpdateCommand cmd) throws IOException {
        idBytes = cmd.getIndexedId();
        if (idBytes == null) {
            super.processAdd(cmd);
            return false;
        }
        if (this.vinfo == null) {
            if (DistributedUpdateProcessor.isAtomicUpdate(cmd)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Atomic document updates are not supported unless <updateLog/> is configured");
            }
            super.processAdd(cmd);
            return false;
        }
        bucketHash = Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
        versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            versionField = cmd.getSolrInputDocument().getField("_version_");
            versionOnUpdate = versionField != null ? ((o = versionField.getValue()) instanceof Number != false ? ((Number)o).longValue() : Long.parseLong(o.toString())) : ((versionOnUpdateS = this.req.getParams().get("_version_")) == null ? 0L : Long.parseLong(versionOnUpdateS));
        }
        isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        leaderLogic = this.isLeader != false && isReplayOrPeersync == false;
        forwardedFromCollection = cmd.getReq().getParams().get("distrib.from.collection") != null;
        bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        var10_11 = bucket;
        synchronized (var10_11) {
            checkDeleteByQueries = false;
            if (!this.versionsStored) break block21;
            bucketVersion = bucket.highest;
            if (!leaderLogic) break block22;
            if (forwardedFromCollection && this.ulog.getState() == UpdateLog.State.ACTIVE) {
                DistributedUpdateProcessor.log.info("Removing version field from doc: " + cmd.getPrintableId());
                cmd.solrDoc.remove((Object)"_version_");
                versionOnUpdate = 0L;
            }
            updated = this.getUpdatedDocument(cmd, versionOnUpdate);
            if (forwardedFromCollection && this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                DistributedUpdateProcessor.log.info("Leader logic applied but update log is buffering: " + cmd.getPrintableId());
                cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                this.ulog.add(cmd);
                var15_18 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 6, 15] lbl38 : MonitorExitStatement: MONITOREXIT : var10_11
                this.vinfo.unlockForUpdate();
                return var15_18;
            }
            if (versionOnUpdate == 0L) break block23;
            lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
            v0 = lastVersion == null ? -1L : lastVersion;
        }
        {
            block21: {
                block22: {
                    block23: {
                        foundVersion = v0;
                        if (versionOnUpdate != foundVersion && (versionOnUpdate >= 0L || foundVersion >= 0L)) {
                            if (versionOnUpdate != 1L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                            if (foundVersion <= 0L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                        }
                    }
                    version = this.vinfo.getNewClock();
                    cmd.setVersion(version);
                    cmd.getSolrInputDocument().setField("_version_", (Object)version);
                    bucket.updateHighest(version);
                    break block21;
                }
                cmd.setVersion(versionOnUpdate);
                if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                    cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                    this.ulog.add(cmd);
                    updated = true;
                    // MONITOREXIT @DISABLED, blocks:[6, 13] lbl61 : MonitorExitStatement: MONITOREXIT : var10_11
                    this.vinfo.unlockForUpdate();
                    return updated;
                }
                if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                    bucket.updateHighest(versionOnUpdate);
                } else {
                    lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                    if (lastVersion != null && Math.abs(lastVersion) >= versionOnUpdate) {
                        var15_21 = true;
                        // MONITOREXIT @DISABLED, blocks:[6, 10, 11] lbl70 : MonitorExitStatement: MONITOREXIT : var10_11
                        this.vinfo.unlockForUpdate();
                        return var15_21;
                    }
                    ** try [egrp 4[TRYBLOCK] [8 : 760->843)] { 
lbl76:
                    // 1 sources

                    checkDeleteByQueries = true;
                }
            }
            willDistrib = this.isLeader != false && this.nodes != null && this.nodes.size() > 0;
            clonedDoc = null;
            if (willDistrib) {
                clonedDoc = cmd.solrDoc.deepCopy();
            }
            this.doLocalAdd(cmd);
            if (willDistrib == false) return false;
            cmd.solrDoc = clonedDoc;
            return false;
lbl86:
            // 1 sources

            finally {
                this.vinfo.unlockForUpdate();
            }
        }
    }

    public static boolean isAtomicUpdate(AddUpdateCommand cmd) {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        for (SolrInputField sif : sdoc.values()) {
            if (!(sif.getValue() instanceof Map)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean getUpdatedDocument(AddUpdateCommand cmd, long versionOnUpdate) throws IOException {
        if (!DistributedUpdateProcessor.isAtomicUpdate(cmd)) {
            return false;
        }
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        BytesRef id = cmd.getIndexedId();
        SolrInputDocument oldDoc = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), id);
        if (oldDoc == null) {
            if (versionOnUpdate > 0L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "Document not found for update.  id=" + cmd.getPrintableId());
            oldDoc = new SolrInputDocument();
        } else {
            oldDoc.remove((Object)VERSION_FIELD);
        }
        IndexSchema schema = cmd.getReq().getSchema();
        for (SolrInputField sif : sdoc.values()) {
            Object val = sif.getValue();
            if (val instanceof Map) {
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    String key = (String)entry.getKey();
                    Object fieldVal = entry.getValue();
                    boolean updateField = false;
                    switch (key) {
                        case "add": {
                            updateField = true;
                            oldDoc.addField(sif.getName(), fieldVal, sif.getBoost());
                            break;
                        }
                        case "set": {
                            updateField = true;
                            oldDoc.setField(sif.getName(), fieldVal, sif.getBoost());
                            break;
                        }
                        case "remove": {
                            updateField = true;
                            this.doRemove(oldDoc, sif, fieldVal);
                            break;
                        }
                        case "inc": {
                            updateField = true;
                            this.doInc(oldDoc, schema, sif, fieldVal);
                            break;
                        }
                        default: {
                            log.warn("Unknown operation for the an atomic update, operation ignored: " + key);
                        }
                    }
                    if (!updateField || !this.idField.getName().equals(sif.getName())) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid update of id field: " + sif);
                }
                continue;
            }
            oldDoc.put(sif.getName(), sif);
        }
        cmd.solrDoc = oldDoc;
        return true;
    }

    private void doInc(SolrInputDocument oldDoc, IndexSchema schema, SolrInputField sif, Object fieldVal) {
        SolrInputField numericField = oldDoc.get((Object)sif.getName());
        if (numericField == null) {
            oldDoc.setField(sif.getName(), fieldVal, sif.getBoost());
        } else {
            String oldValS = numericField.getFirstValue().toString();
            SchemaField sf = schema.getField(sif.getName());
            BytesRef term = new BytesRef();
            sf.getType().readableToIndexed(oldValS, term);
            Object oldVal = sf.getType().toObject(sf, term);
            String fieldValS = fieldVal.toString();
            Number result = oldVal instanceof Long ? (Number)((Long)oldVal + Long.parseLong(fieldValS)) : (Number)(oldVal instanceof Float ? (Number)Float.valueOf(((Float)oldVal).floatValue() + Float.parseFloat(fieldValS)) : (Number)(oldVal instanceof Double ? (Number)((Double)oldVal + Double.parseDouble(fieldValS)) : (Number)((Integer)oldVal + Integer.parseInt(fieldValS))));
            oldDoc.setField(sif.getName(), (Object)result, sif.getBoost());
        }
    }

    private void doRemove(SolrInputDocument oldDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        SolrInputField existingField = oldDoc.get((Object)name);
        if (existingField != null) {
            Collection original = existingField.getValues();
            if (fieldVal instanceof Collection) {
                original.removeAll((Collection)fieldVal);
            } else {
                original.remove(fieldVal);
            }
            oldDoc.setField(name, (Object)original);
        }
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        this.updateCommand = cmd;
        if (!cmd.isDeleteById()) {
            this.doDeleteByQuery(cmd);
            return;
        }
        if (this.zkEnabled) {
            this.zkCheck();
            this.nodes = this.setupRequest(cmd.getId(), null);
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionDelete(cmd);
        }
        if (dropCmd) {
            return;
        }
        if (this.zkEnabled && this.isLeader && !this.isSubShardLeader) {
            List<SolrCmdDistributor.Node> nodesByRoutingRules;
            DocCollection coll = this.zkController.getClusterState().getCollection(this.collection);
            List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), cmd.getId(), null);
            if (subShardLeaders != null && !subShardLeaders.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_PARENT, new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribDelete(cmd, subShardLeaders, params, true);
            }
            if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.zkController.getClusterState(), coll, cmd.getId(), null)) != null && !nodesByRoutingRules.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_COLLECTION, new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName()});
                params.set(DISTRIB_FROM_SHARD, new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId()});
                for (SolrCmdDistributor.Node nodesByRoutingRule : nodesByRoutingRules) {
                    this.cmdDistrib.distribDelete(cmd, Collections.singletonList(nodesByRoutingRule), params, true);
                }
            }
        }
        ModifiableSolrParams params = null;
        if (this.nodes != null) {
            params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            this.cmdDistrib.distribDelete(cmd, this.nodes, params);
        }
        if (this.returnVersions && this.rsp != null && cmd.getIndexedId() != null && this.idField != null) {
            if (this.deleteResponse == null) {
                this.deleteResponse = new NamedList();
                this.rsp.add("deletes", this.deleteResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRef();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.deleteResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    private ModifiableSolrParams filterParams(SolrParams params) {
        ModifiableSolrParams fparams = new ModifiableSolrParams();
        this.passParam(params, fparams, "update.chain");
        this.passParam(params, fparams, TEST_DISTRIB_SKIP_SERVERS);
        return fparams;
    }

    private void passParam(SolrParams params, ModifiableSolrParams fparams, String param) {
        String[] values = params.getParams(param);
        if (values != null) {
            for (String value : values) {
                fparams.add(param, new String[]{value});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean leaderLogic;
        DocCollection coll;
        if (!this.zkEnabled) {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        } else {
            this.zkCheck();
        }
        DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
        DocCollection docCollection = coll = this.zkEnabled ? this.zkController.getClusterState().getCollection(this.collection) : null;
        if (this.zkEnabled && DistribPhase.NONE == phase) {
            boolean leaderForAnyShard = false;
            ModifiableSolrParams outParams = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            outParams.set("update.distrib", new String[]{DistribPhase.TOLEADER.toString()});
            outParams.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            SolrParams params = this.req.getParams();
            String route = params.get("_route_");
            if (route == null) {
                route = params.get("shard.keys");
            }
            Collection slices = coll.getRouter().getSearchSlices(route, params, coll);
            ArrayList<SolrCmdDistributor.Node> leaders = new ArrayList<SolrCmdDistributor.Node>(slices.size());
            for (Slice slice : slices) {
                Replica leader;
                String sliceName = slice.getName();
                try {
                    leader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, sliceName);
                }
                catch (InterruptedException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + sliceName, (Throwable)e);
                }
                ZkCoreNodeProps coreLeaderProps = new ZkCoreNodeProps((ZkNodeProps)leader);
                String leaderCoreNodeName = leader.getName();
                String coreNodeName = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName();
                this.isLeader = coreNodeName.equals(leaderCoreNodeName);
                if (this.isLeader) {
                    leaderForAnyShard = true;
                    continue;
                }
                leaders.add(new SolrCmdDistributor.StdNode(coreLeaderProps, this.collection, sliceName));
            }
            outParams.remove("commit");
            this.cmdDistrib.distribDelete(cmd, leaders, outParams);
            if (!leaderForAnyShard) {
                return;
            }
            phase = DistribPhase.TOLEADER;
        }
        List<SolrCmdDistributor.Node> replicas = null;
        if (this.zkEnabled && DistribPhase.TOLEADER == phase) {
            this.isLeader = true;
            replicas = this.setupRequest();
        } else if (DistribPhase.FROMLEADER == phase) {
            this.isLeader = false;
        }
        if (this.vinfo == null) {
            super.processDelete(cmd);
            return;
        }
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get(VERSION_FIELD);
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean bl = leaderLogic = this.isLeader && !isReplayOrPeersync;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        this.vinfo.blockUpdates();
        try {
            if (this.versionsStored) {
                if (leaderLogic) {
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    this.doLocalDelete(cmd);
                } else {
                    cmd.setVersion(-versionOnUpdate);
                    if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.deleteByQuery(cmd);
                        return;
                    }
                    this.doLocalDelete(cmd);
                }
            }
        }
        finally {
            this.vinfo.unblockUpdates();
        }
        if (this.zkEnabled) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set(VERSION_FIELD, new String[]{Long.toString(cmd.getVersion())});
            params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
            params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            boolean someReplicas = false;
            boolean subShardLeader = false;
            try {
                subShardLeader = this.amISubShardLeader(coll, null, null, null);
                if (subShardLeader) {
                    String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                    Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId);
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, myShardId, leaderReplica.getName(), null, "down");
                    if (replicaProps != null) {
                        ArrayList<SolrCmdDistributor.Node> myReplicas = new ArrayList<SolrCmdDistributor.Node>();
                        for (ZkCoreNodeProps replicaProp : replicaProps) {
                            myReplicas.add(new SolrCmdDistributor.StdNode(replicaProp, this.collection, myShardId));
                        }
                        this.cmdDistrib.distribDelete(cmd, myReplicas, params);
                        someReplicas = true;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            if (leaderLogic) {
                List<SolrCmdDistributor.Node> nodesByRoutingRules;
                List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), null, null);
                if (subShardLeaders != null) {
                    this.cmdDistrib.distribDelete(cmd, subShardLeaders, params, true);
                }
                if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.zkController.getClusterState(), coll, null, null)) != null && !nodesByRoutingRules.isEmpty()) {
                    params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                    params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                    params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                    params.set(DISTRIB_FROM_COLLECTION, new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName()});
                    params.set(DISTRIB_FROM_SHARD, new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId()});
                    this.cmdDistrib.distribDelete(cmd, nodesByRoutingRules, params, true);
                }
                if (replicas != null) {
                    this.cmdDistrib.distribDelete(cmd, replicas, params);
                    someReplicas = true;
                }
            }
            if (someReplicas) {
                this.cmdDistrib.finish();
            }
        }
        if (this.returnVersions && this.rsp != null) {
            if (this.deleteByQueryResponse == null) {
                this.deleteByQueryResponse = new NamedList();
                this.rsp.add("deleteByQuery", this.deleteByQueryResponse);
            }
            this.deleteByQueryResponse.add(cmd.getQuery(), (Object)cmd.getVersion());
        }
    }

    boolean isLeader(UpdateCommand cmd) {
        this.updateCommand = cmd;
        if (this.zkEnabled) {
            this.zkCheck();
            if (cmd instanceof AddUpdateCommand) {
                AddUpdateCommand acmd = (AddUpdateCommand)cmd;
                this.nodes = this.setupRequest(acmd.getHashableId(), acmd.getSolrInputDocument());
            } else if (cmd instanceof DeleteUpdateCommand) {
                DeleteUpdateCommand dcmd = (DeleteUpdateCommand)cmd;
                this.nodes = this.setupRequest(dcmd.getId(), null);
            }
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        return this.isLeader;
    }

    private void zkCheck() {
        if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
            return;
        }
        if (!this.zkController.getZkClient().getConnectionManager().isLikelyExpired()) {
            return;
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot talk to ZooKeeper - Updates are disabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean versionDelete(DeleteUpdateCommand cmd) throws IOException {
        boolean bl;
        long l;
        long bucketVersion;
        boolean forwardedFromCollection;
        BytesRef idBytes = cmd.getIndexedId();
        if (this.vinfo == null || idBytes == null) {
            super.processDelete(cmd);
            return false;
        }
        int bucketHash = Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get(VERSION_FIELD);
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        long signedVersionOnUpdate = versionOnUpdate;
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean leaderLogic = this.isLeader && !isReplayOrPeersync;
        boolean bl2 = forwardedFromCollection = cmd.getReq().getParams().get(DISTRIB_FROM_COLLECTION) != null;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        VersionBucket bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        try {
            VersionBucket versionBucket = bucket;
            synchronized (versionBucket) {
                if (!this.versionsStored) break block18;
                bucketVersion = bucket.highest;
                if (!leaderLogic) break block19;
                if (forwardedFromCollection && this.ulog.getState() == UpdateLog.State.ACTIVE) {
                    log.info("Removing version field from doc: " + cmd.getId());
                    signedVersionOnUpdate = 0L;
                    versionOnUpdate = 0L;
                }
                if (forwardedFromCollection && this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                    log.info("Leader logic applied but update log is buffering: " + cmd.getId());
                    cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                    this.ulog.delete(cmd);
                    boolean bl3 = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 13] lbl34 : MonitorExitStatement: MONITOREXIT : var12_11
                    this.vinfo.unlockForUpdate();
                    return bl3;
                }
                if (signedVersionOnUpdate == 0L) break block20;
                Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                l = lastVersion == null ? -1L : lastVersion;
            }
        }
        catch (Throwable throwable) {
            this.vinfo.unlockForUpdate();
            throw throwable;
        }
        {
            block18: {
                block19: {
                    block20: {
                        long foundVersion = l;
                        if (!(signedVersionOnUpdate == foundVersion || signedVersionOnUpdate < 0L && foundVersion < 0L || signedVersionOnUpdate == 1L && foundVersion > 0L)) {
                            throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getId() + " expected=" + signedVersionOnUpdate + " actual=" + foundVersion);
                        }
                    }
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    bucket.updateHighest(version);
                    break block18;
                }
                cmd.setVersion(-versionOnUpdate);
                if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                    cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                    this.ulog.delete(cmd);
                    boolean version = true;
                    // MONITOREXIT @DISABLED, blocks:[6, 11] lbl56 : MonitorExitStatement: MONITOREXIT : var12_11
                    this.vinfo.unlockForUpdate();
                    return version;
                }
                if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                    bucket.updateHighest(versionOnUpdate);
                } else {
                    Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                    if (lastVersion != null && Math.abs(lastVersion) >= versionOnUpdate) {
                        boolean bl4 = true;
                        // MONITOREXIT @DISABLED, blocks:[6, 8, 9] lbl65 : MonitorExitStatement: MONITOREXIT : var12_11
                        this.vinfo.unlockForUpdate();
                        return bl4;
                    }
                }
            }
            this.doLocalDelete(cmd);
            bl = false;
        }
        this.vinfo.unlockForUpdate();
        return bl;
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        this.updateCommand = cmd;
        List<SolrCmdDistributor.Node> nodes = null;
        boolean singleLeader = false;
        if (this.zkEnabled) {
            this.zkCheck();
            nodes = this.getCollectionUrls(this.req, this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName());
            if (this.isLeader && nodes.size() == 1) {
                singleLeader = true;
            }
        }
        if (!this.zkEnabled || this.req.getParams().getBool(COMMIT_END_POINT, false) || singleLeader) {
            this.doLocalCommit(cmd);
        } else if (this.zkEnabled) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            if (!this.req.getParams().getBool(COMMIT_END_POINT, false)) {
                params.set(COMMIT_END_POINT, true);
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                if (nodes != null) {
                    this.cmdDistrib.distribCommit(cmd, nodes, params);
                    this.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLocalCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.vinfo != null) {
            this.vinfo.lockForUpdate();
        }
        try {
            if (this.ulog == null || this.ulog.getState() == UpdateLog.State.ACTIVE || (cmd.getFlags() & UpdateCommand.REPLAY) != 0) {
                super.processCommit(cmd);
            } else {
                log.info("Ignoring commit while not ACTIVE - state: " + (Object)((Object)this.ulog.getState()) + " replay:" + (cmd.getFlags() & UpdateCommand.REPLAY));
            }
        }
        finally {
            if (this.vinfo != null) {
                this.vinfo.unlockForUpdate();
            }
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.zkEnabled) {
            this.doFinish();
        }
        if (this.next != null && this.nodes == null) {
            this.next.finish();
        }
    }

    private List<SolrCmdDistributor.Node> getCollectionUrls(SolrQueryRequest req, String collection) {
        ClusterState clusterState = req.getCore().getCoreDescriptor().getCoreContainer().getZkController().getClusterState();
        ArrayList<SolrCmdDistributor.Node> urls = new ArrayList<SolrCmdDistributor.Node>();
        Map slices = clusterState.getSlicesMap(collection);
        if (slices == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + clusterState);
        }
        for (Map.Entry sliceEntry : slices.entrySet()) {
            Slice replicas = (Slice)slices.get(sliceEntry.getKey());
            Map shardMap = replicas.getReplicasMap();
            for (Map.Entry entry : shardMap.entrySet()) {
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)entry.getValue());
                if (!clusterState.liveNodesContain(nodeProps.getNodeName())) continue;
                urls.add(new SolrCmdDistributor.StdNode(nodeProps, collection, replicas.getName()));
            }
        }
        if (urls.size() == 0) {
            return null;
        }
        return urls;
    }

    public static boolean getNonZkLeaderAssumption(SolrQueryRequest req) {
        DistribPhase phase = DistribPhase.parseParam(req.getParams().get("update.distrib"));
        return DistribPhase.FROMLEADER != phase;
    }

    public static class RequestReplicationTracker {
        int minRf;
        String onLeaderShardId;
        Map<String, AtomicInteger> nodeErrorTracker;
        Map<String, Integer> otherLeaderRf;

        private RequestReplicationTracker(String shardId, int minRf) {
            this.minRf = minRf;
            this.onLeaderShardId = shardId;
            this.nodeErrorTracker = new HashMap<String, AtomicInteger>(5);
            this.otherLeaderRf = new HashMap<String, Integer>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getAchievedRf() {
            Map<String, Number> map;
            int achievedRf = 1;
            if (this.onLeaderShardId != null) {
                map = this.nodeErrorTracker;
                synchronized (map) {
                    for (AtomicInteger nodeErrors : this.nodeErrorTracker.values()) {
                        if (nodeErrors.get() != 0) continue;
                        ++achievedRf;
                    }
                }
            } else {
                achievedRf = Integer.MAX_VALUE;
            }
            map = this.otherLeaderRf;
            synchronized (map) {
                for (Integer otherRf : this.otherLeaderRf.values()) {
                    if (otherRf >= achievedRf) continue;
                    achievedRf = otherRf;
                }
            }
            return achievedRf == Integer.MAX_VALUE ? 1 : achievedRf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackRequestResult(SolrCmdDistributor.Node node, boolean success, Integer rf) {
            String shardId = node.getShardId();
            if (log.isDebugEnabled()) {
                log.debug("trackRequestResult(" + node + "): success? " + success + " rf=" + rf + ", shardId=" + shardId + " onLeaderShardId=" + this.onLeaderShardId);
            }
            if (this.onLeaderShardId == null || !this.onLeaderShardId.equals(shardId)) {
                Map<String, Integer> map = this.otherLeaderRf;
                synchronized (map) {
                    this.otherLeaderRf.put(shardId, rf != null ? rf : new Integer(1));
                }
                return;
            }
            if (this.onLeaderShardId != null) {
                String nodeUrl = node.getUrl();
                AtomicInteger nodeErrors = null;
                Map<String, AtomicInteger> map = this.nodeErrorTracker;
                synchronized (map) {
                    nodeErrors = this.nodeErrorTracker.get(nodeUrl);
                    if (nodeErrors == null) {
                        nodeErrors = new AtomicInteger(0);
                        this.nodeErrorTracker.put(nodeUrl, nodeErrors);
                    }
                }
                if (!success) {
                    nodeErrors.incrementAndGet();
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("RequestReplicationTracker");
            sb.append(": onLeaderShardId=").append(String.valueOf(this.onLeaderShardId));
            sb.append(", minRf=").append(this.minRf);
            sb.append(", achievedRf=").append(this.getAchievedRf());
            return sb.toString();
        }
    }

    public static enum DistribPhase {
        NONE,
        TOLEADER,
        FROMLEADER;


        public static DistribPhase parseParam(String param) {
            if (param == null || param.trim().isEmpty()) {
                return NONE;
            }
            try {
                return DistribPhase.valueOf(param);
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal value for update.distrib: " + param, (Throwable)e);
            }
        }
    }
}

