/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene3x.Lucene3xCodec;
import org.apache.lucene.codecs.lucene3x.Lucene3xSegmentInfoFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TwoPhaseCommit;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;

public class IndexWriter
implements Closeable,
TwoPhaseCommit,
Accountable {
    public static final int MAX_DOCS = 0x7FFFFF7F;
    private static int actualMaxDocs = 0x7FFFFF7F;
    private static final int UNBOUNDED_MAX_MERGE_SEGMENTS = -1;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String SOURCE = "source";
    public static final String SOURCE_MERGE = "merge";
    public static final String SOURCE_FLUSH = "flush";
    public static final String SOURCE_ADDINDEXES_READERS = "addIndexes(IndexReader...)";
    public static final int MAX_TERM_LENGTH = 32766;
    volatile Throwable tragedy;
    private final Directory directory;
    private final Analyzer analyzer;
    private volatile long changeCount;
    private volatile long lastCommitChangeCount;
    private List<SegmentCommitInfo> rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingCommitChangeCount;
    private Collection<String> filesToCommit;
    final SegmentInfos segmentInfos;
    final FieldInfos.FieldNumbers globalFieldNumberMap;
    private final DocumentsWriter docWriter;
    private final Queue<Event> eventQueue;
    final IndexFileDeleter deleter;
    private Map<SegmentCommitInfo, Boolean> segmentsToMerge;
    private int mergeMaxNumSegments;
    private Lock writeLock;
    private volatile boolean closed;
    private volatile boolean closing;
    private HashSet<SegmentCommitInfo> mergingSegments;
    private final MergeScheduler mergeScheduler;
    private LinkedList<MergePolicy.OneMerge> pendingMerges;
    private Set<MergePolicy.OneMerge> runningMerges;
    private List<MergePolicy.OneMerge> mergeExceptions;
    private long mergeGen;
    private boolean stopMerges;
    private boolean didMessageState;
    final AtomicInteger flushCount;
    final AtomicInteger flushDeletesCount;
    final ReaderPool readerPool;
    final BufferedUpdatesStream bufferedUpdatesStream;
    private volatile boolean poolReaders;
    private final LiveIndexWriterConfig config;
    private long startCommitTime;
    final AtomicLong pendingNumDocs;
    final Codec codec;
    final InfoStream infoStream;
    private final Object commitLock;
    private final Object fullFlushLock;
    private boolean keepFullyDeletedSegments;

    static void setMaxDocs(int maxDocs) {
        if (maxDocs > 0x7FFFFF7F) {
            throw new IllegalArgumentException("maxDocs must be <= IndexWriter.MAX_DOCS=2147483519; got: " + maxDocs);
        }
        actualMaxDocs = maxDocs;
    }

    static int getActualMaxDocs() {
        return actualMaxDocs;
    }

    DirectoryReader getReader() throws IOException {
        return this.getReader(true);
    }

    /*
     * Exception decompiling
     */
    DirectoryReader getReader(boolean applyAllDeletes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.docWriter.ramBytesUsed();
    }

    public int numDeletedDocs(SegmentCommitInfo info) {
        this.ensureOpen(false);
        int delCount = info.getDelCount();
        ReadersAndUpdates rld = this.readerPool.get(info, false);
        if (rld != null) {
            delCount += rld.getPendingDeleteCount();
        }
        return delCount;
    }

    protected final void ensureOpen(boolean failIfClosing) throws AlreadyClosedException {
        if (this.closed || failIfClosing && this.closing) {
            throw new AlreadyClosedException("this IndexWriter is closed", this.tragedy);
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
        block17: {
            block18: {
                this.segmentsToMerge = new HashMap<SegmentCommitInfo, Boolean>();
                this.mergingSegments = new HashSet();
                this.pendingMerges = new LinkedList();
                this.runningMerges = new HashSet<MergePolicy.OneMerge>();
                this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
                this.flushCount = new AtomicInteger();
                this.flushDeletesCount = new AtomicInteger();
                this.readerPool = new ReaderPool();
                this.pendingNumDocs = new AtomicLong();
                this.commitLock = new Object();
                this.fullFlushLock = new Object();
                conf.setIndexWriter(this);
                this.config = conf;
                this.directory = d;
                this.analyzer = this.config.getAnalyzer();
                this.infoStream = this.config.getInfoStream();
                this.mergeScheduler = this.config.getMergeScheduler();
                this.codec = this.config.getCodec();
                this.bufferedUpdatesStream = new BufferedUpdatesStream(this.infoStream);
                this.poolReaders = this.config.getReaderPooling();
                this.writeLock = this.directory.makeLock(WRITE_LOCK_NAME);
                if (!this.writeLock.obtain(this.config.getWriteLockTimeout())) {
                    throw new LockObtainFailedException("Index locked for write: " + this.writeLock);
                }
                boolean success = false;
                try {
                    IndexWriterConfig.OpenMode mode = this.config.getOpenMode();
                    boolean create = mode == IndexWriterConfig.OpenMode.CREATE ? true : (mode == IndexWriterConfig.OpenMode.APPEND ? false : !DirectoryReader.indexExists(this.directory));
                    this.segmentInfos = new SegmentInfos();
                    boolean initialIndexExists = true;
                    if (create) {
                        try {
                            this.segmentInfos.read(this.directory);
                            this.segmentInfos.clear();
                        }
                        catch (IOException e) {
                            initialIndexExists = false;
                        }
                        this.changed();
                    } else {
                        this.segmentInfos.read(this.directory);
                        IndexCommit commit = this.config.getIndexCommit();
                        if (commit != null) {
                            if (commit.getDirectory() != this.directory) {
                                throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory");
                            }
                            SegmentInfos oldInfos = new SegmentInfos();
                            oldInfos.read(this.directory, commit.getSegmentsFileName());
                            this.segmentInfos.replace(oldInfos);
                            this.changed();
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "init: loaded commit \"" + commit.getSegmentsFileName() + "\"");
                            }
                        }
                    }
                    this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                    this.globalFieldNumberMap = this.getFieldNumberMap();
                    this.config.getFlushPolicy().init(this.config);
                    this.docWriter = new DocumentsWriter(this, this.config, this.directory);
                    this.eventQueue = this.docWriter.eventQueue();
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        this.deleter = new IndexFileDeleter(this.directory, this.config.getIndexDeletionPolicy(), this.segmentInfos, this.infoStream, this, initialIndexExists);
                    }
                    if (this.deleter.startingCommitDeleted) {
                        this.changed();
                    }
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "init: create=" + create);
                        this.messageState();
                    }
                    if (success = true) break block17;
                    if (!this.infoStream.isEnabled("IW")) break block18;
                    this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                        }
                        IOUtils.closeWhileHandlingException(this.writeLock);
                        this.writeLock = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(this.writeLock);
            this.writeLock = null;
        }
    }

    private FieldInfos.FieldNumbers getFieldNumberMap() throws IOException {
        FieldInfos.FieldNumbers map = new FieldInfos.FieldNumbers();
        for (SegmentCommitInfo info : this.segmentInfos) {
            for (FieldInfo fi : SegmentReader.readFieldInfos(info)) {
                map.addOrGet(fi.name, fi.number, fi.getDocValuesType());
            }
        }
        return map;
    }

    public LiveIndexWriterConfig getConfig() {
        this.ensureOpen(false);
        return this.config;
    }

    private void messageState() {
        if (this.infoStream.isEnabled("IW") && !this.didMessageState) {
            this.didMessageState = true;
            this.infoStream.message("IW", "\ndir=" + this.directory + "\n" + "index=" + this.segString() + "\n" + "version=" + Version.LATEST.toString() + "\n" + this.config.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean waitForMerges) throws IOException {
        if (this.pendingCommit != null) {
            throw new IllegalStateException("cannot close: prepareCommit was already called with no corresponding call to commit");
        }
        if (this.shouldClose()) {
            boolean success = false;
            try {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "now flush at close");
                }
                this.flush(true, true);
                if (waitForMerges) {
                    this.waitForMerges();
                } else {
                    this.abortMerges();
                }
                this.commitInternal(this.config.getMergePolicy());
                this.rollbackInternal();
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        this.rollbackInternal();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Deprecated
    public void close(boolean waitForMerges) throws IOException {
        this.shutdown(waitForMerges);
    }

    private boolean assertEventQueueAfterClose() {
        if (this.eventQueue.isEmpty()) {
            return true;
        }
        for (Event e : this.eventQueue) {
            assert (e instanceof DocumentsWriter.MergePendingEvent) : e;
        }
        return true;
    }

    private synchronized boolean shouldClose() {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            this.doWait();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void closeInternal(boolean waitForMerges, boolean doFlush) throws IOException {
        boolean interrupted = false;
        try {
            IndexWriter tie222222;
            block58: {
                block56: {
                    if (this.pendingCommit != null) {
                        throw new IllegalStateException("cannot close: prepareCommit was already called with no corresponding call to commit");
                    }
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "now flush at close waitForMerges=" + waitForMerges);
                    }
                    this.docWriter.close();
                    if (doFlush) {
                        this.flush(waitForMerges, true);
                        break block56;
                    }
                    this.docWriter.abort(this);
                }
                try {
                    block57: {
                        interrupted = Thread.interrupted();
                        if (waitForMerges) {
                            try {
                                this.mergeScheduler.merge(this, MergeTrigger.CLOSING, false);
                            }
                            catch (ThreadInterruptedException tie222222) {
                                interrupted = true;
                                if (!this.infoStream.isEnabled("IW")) break block57;
                                this.infoStream.message("IW", "interrupted while waiting for final merges");
                            }
                        }
                    }
                    tie222222 = this;
                    synchronized (tie222222) {
                        while (true) {
                            try {
                                if (waitForMerges && !interrupted) {
                                    this.waitForMerges();
                                    break;
                                }
                                this.abortMerges();
                            }
                            catch (ThreadInterruptedException tie3) {
                                interrupted = true;
                                if (!this.infoStream.isEnabled("IW")) continue;
                                this.infoStream.message("IW", "interrupted while waiting for merges to finish");
                                continue;
                            }
                            break;
                        }
                        this.stopMerges = true;
                        break block58;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException(this.mergeScheduler);
                    throw throwable;
                }
                catch (Throwable throwable) {
                    try {
                        block59: {
                            interrupted = Thread.interrupted();
                            if (waitForMerges) {
                                try {
                                    this.mergeScheduler.merge(this, MergeTrigger.CLOSING, false);
                                }
                                catch (ThreadInterruptedException tie4) {
                                    interrupted = true;
                                    if (!this.infoStream.isEnabled("IW")) break block59;
                                    this.infoStream.message("IW", "interrupted while waiting for final merges");
                                }
                            }
                        }
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            while (true) {
                                try {
                                    if (waitForMerges && !interrupted) {
                                        this.waitForMerges();
                                        break;
                                    }
                                    this.abortMerges();
                                }
                                catch (ThreadInterruptedException tie5) {
                                    interrupted = true;
                                    if (!this.infoStream.isEnabled("IW")) continue;
                                    this.infoStream.message("IW", "interrupted while waiting for merges to finish");
                                    continue;
                                }
                                break;
                            }
                            this.stopMerges = true;
                        }
                    }
                    catch (Throwable throwable2) {
                        IOUtils.closeWhileHandlingException(this.mergeScheduler);
                        throw throwable2;
                    }
                    IOUtils.closeWhileHandlingException(this.mergeScheduler);
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(this.mergeScheduler);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now call final commit()");
            }
            if (doFlush) {
                this.commitInternal(this.config.getMergePolicy());
            }
            this.processEvents(false, true);
            tie222222 = this;
            synchronized (tie222222) {
                this.readerPool.dropAll(true);
                this.deleter.close();
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "at close: " + this.segString());
            }
            if (this.writeLock != null) {
                this.writeLock.close();
                this.writeLock = null;
            }
            tie222222 = this;
            synchronized (tie222222) {
                this.closed = true;
            }
            assert (this.docWriter.perThreadPool.numDeactivatedThreadStates() == this.docWriter.perThreadPool.getMaxThreadStates()) : "" + this.docWriter.perThreadPool.numDeactivatedThreadStates() + " " + this.docWriter.perThreadPool.getMaxThreadStates();
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "closeInternal");
        }
        finally {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.closing = false;
                this.notifyAll();
                if (!this.closed && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception while closing");
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int maxDoc() {
        this.ensureOpen();
        return this.docWriter.getNumDocs() + this.segmentInfos.totalDocCount();
    }

    public synchronized int numDocs() {
        this.ensureOpen();
        int count = this.docWriter.getNumDocs();
        for (SegmentCommitInfo info : this.segmentInfos) {
            count += info.info.getDocCount() - this.numDeletedDocs(info);
        }
        return count;
    }

    public synchronized boolean hasDeletions() {
        this.ensureOpen();
        if (this.bufferedUpdatesStream.any()) {
            return true;
        }
        if (this.docWriter.anyDeletions()) {
            return true;
        }
        if (this.readerPool.anyPendingDeletes()) {
            return true;
        }
        for (SegmentCommitInfo info : this.segmentInfos) {
            if (!info.hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public void addDocument(Iterable<? extends IndexableField> doc) throws IOException {
        this.addDocument(doc, this.analyzer);
    }

    public void addDocument(Iterable<? extends IndexableField> doc, Analyzer analyzer) throws IOException {
        this.updateDocument(null, doc, analyzer);
    }

    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.addDocuments(docs, this.analyzer);
    }

    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, Analyzer analyzer) throws IOException {
        this.updateDocuments(null, docs, analyzer);
    }

    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.updateDocuments(delTerm, docs, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs, Analyzer analyzer) throws IOException {
        this.ensureOpen();
        try {
            boolean success = false;
            try {
                if (this.docWriter.updateDocuments(docs, analyzer, delTerm)) {
                    this.processEvents(true, false);
                }
                success = true;
            }
            finally {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateDocuments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryDeleteDocument(IndexReader readerIn, int docID) throws IOException {
        ReadersAndUpdates rld;
        AtomicReader reader;
        if (readerIn instanceof AtomicReader) {
            reader = (AtomicReader)readerIn;
        } else {
            List<AtomicReaderContext> leaves = readerIn.leaves();
            int subIndex = ReaderUtil.subIndex(docID, leaves);
            reader = leaves.get(subIndex).reader();
            assert ((docID -= leaves.get((int)subIndex).docBase) >= 0);
            assert (docID < reader.maxDoc());
        }
        if (!(reader instanceof SegmentReader)) {
            throw new IllegalArgumentException("the reader must be a SegmentReader or composite reader containing only SegmentReaders");
        }
        SegmentCommitInfo info = ((SegmentReader)reader).getSegmentInfo();
        if (this.segmentInfos.indexOf(info) != -1 && (rld = this.readerPool.get(info, false)) != null) {
            BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
            synchronized (bufferedUpdatesStream) {
                rld.initWritableLiveDocs();
                if (rld.delete(docID)) {
                    int fullDelCount = rld.info.getDelCount() + rld.getPendingDeleteCount();
                    if (fullDelCount == rld.info.info.getDocCount() && !this.mergingSegments.contains(rld.info)) {
                        this.segmentInfos.remove(rld.info);
                        this.readerPool.drop(rld.info);
                        this.checkpoint();
                    }
                    this.changed();
                }
                return true;
            }
        }
        return false;
    }

    public void deleteDocuments(Term ... terms) throws IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteTerms(terms)) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "deleteDocuments(Term..)");
        }
    }

    public void deleteDocuments(Query ... queries) throws IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteQueries(queries)) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "deleteDocuments(Query..)");
        }
    }

    public void updateDocument(Term term, Iterable<? extends IndexableField> doc) throws IOException {
        this.ensureOpen();
        this.updateDocument(term, doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Iterable<? extends IndexableField> doc, Analyzer analyzer) throws IOException {
        this.ensureOpen();
        try {
            boolean success = false;
            try {
                if (this.docWriter.updateDocument(doc, analyzer, term)) {
                    this.processEvents(true, false);
                }
                success = true;
            }
            finally {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateDocument");
        }
    }

    public void updateNumericDocValue(Term term, String field, long value) throws IOException {
        this.ensureOpen();
        if (!this.globalFieldNumberMap.contains(field, FieldInfo.DocValuesType.NUMERIC)) {
            throw new IllegalArgumentException("can only update existing numeric-docvalues fields!");
        }
        try {
            if (this.docWriter.updateDocValues(new DocValuesUpdate.NumericDocValuesUpdate(term, field, value))) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateNumericDocValue");
        }
    }

    public void updateBinaryDocValue(Term term, String field, BytesRef value) throws IOException {
        this.ensureOpen();
        if (value == null) {
            throw new IllegalArgumentException("cannot update a field to a null value: " + field);
        }
        if (!this.globalFieldNumberMap.contains(field, FieldInfo.DocValuesType.BINARY)) {
            throw new IllegalArgumentException("can only update existing binary-docvalues fields!");
        }
        try {
            if (this.docWriter.updateDocValues(new DocValuesUpdate.BinaryDocValuesUpdate(term, field, value))) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateBinaryDocValue");
        }
    }

    public void updateDocValues(Term term, Field ... updates) throws IOException {
        this.ensureOpen();
        DocValuesUpdate[] dvUpdates = new DocValuesUpdate[updates.length];
        block6: for (int i = 0; i < updates.length; ++i) {
            Field f = updates[i];
            FieldInfo.DocValuesType dvType = f.fieldType().docValueType();
            if (dvType == null) {
                throw new IllegalArgumentException("can only update NUMERIC or BINARY fields! field=" + f.name());
            }
            if (!this.globalFieldNumberMap.contains(f.name(), dvType)) {
                throw new IllegalArgumentException("can only update existing docvalues fields! field=" + f.name() + ", type=" + (Object)((Object)dvType));
            }
            switch (dvType) {
                case NUMERIC: {
                    dvUpdates[i] = new DocValuesUpdate.NumericDocValuesUpdate(term, f.name(), (Long)f.numericValue());
                    continue block6;
                }
                case BINARY: {
                    dvUpdates[i] = new DocValuesUpdate.BinaryDocValuesUpdate(term, f.name(), f.binaryValue());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("can only update NUMERIC or BINARY fields: field=" + f.name() + ", type=" + (Object)((Object)dvType));
                }
            }
        }
        try {
            if (this.docWriter.updateDocValues(dvUpdates)) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateDocValues");
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocs();
    }

    final synchronized Collection<String> getIndexFileNames() throws IOException {
        return this.segmentInfos.files(this.directory, true);
    }

    final synchronized int getDocCount(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).info.getDocCount();
        }
        return -1;
    }

    final int getFlushCount() {
        return this.flushCount.get();
    }

    final int getFlushDeletesCount() {
        return this.flushDeletesCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            ++this.changeCount;
            this.segmentInfos.changed();
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void forceMerge(int maxNumSegments) throws IOException {
        this.forceMerge(maxNumSegments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMerge(int maxNumSegments, boolean doWait) throws IOException {
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMerge: index now " + this.segString());
            this.infoStream.message("IW", "now flush at forceMerge");
        }
        this.flush(true, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToMerge.clear();
            for (SegmentCommitInfo info : this.segmentInfos) {
                this.segmentsToMerge.put(info, Boolean.TRUE);
            }
            this.mergeMaxNumSegments = maxNumSegments;
            for (MergePolicy.OneMerge merge : this.pendingMerges) {
                merge.maxNumSegments = maxNumSegments;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
            for (MergePolicy.OneMerge merge : this.runningMerges) {
                merge.maxNumSegments = maxNumSegments;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
        }
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, maxNumSegments);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMerge", this.tragedy);
                    }
                    if (this.mergeExceptions.size() > 0) {
                        int size = this.mergeExceptions.size();
                        for (int i = 0; i < size; ++i) {
                            MergePolicy.OneMerge merge = this.mergeExceptions.get(i);
                            if (merge.maxNumSegments == -1) continue;
                            throw new IOException("background merge hit exception: " + merge.segString(this.directory), merge.getException());
                        }
                    }
                    if (!this.maxNumSegmentsMergesPending()) break;
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean maxNumSegmentsMergesPending() {
        for (MergePolicy.OneMerge merge : this.pendingMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        for (MergePolicy.OneMerge merge : this.runningMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMergeDeletes(boolean doWait) throws IOException {
        MergePolicy.MergeSpecification spec;
        this.ensureOpen();
        this.flush(true, true);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMergeDeletes: index now " + this.segString());
        }
        MergePolicy mergePolicy = this.config.getMergePolicy();
        boolean newMergesFound = false;
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            spec = mergePolicy.findForcedDeletesMerges(this.segmentInfos, this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                int numMerges = spec.merges.size();
                for (int i = 0; i < numMerges; ++i) {
                    this.registerMerge(spec.merges.get(i));
                }
            }
        }
        this.mergeScheduler.merge(this, MergeTrigger.EXPLICIT, newMergesFound);
        if (spec != null && doWait) {
            int numMerges = spec.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                boolean running = true;
                while (running) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMergeDeletes", this.tragedy);
                    }
                    running = false;
                    for (int i = 0; i < numMerges; ++i) {
                        Throwable t;
                        MergePolicy.OneMerge merge = spec.merges.get(i);
                        if (this.pendingMerges.contains(merge) || this.runningMerges.contains(merge)) {
                            running = true;
                        }
                        if ((t = merge.getException()) == null) continue;
                        throw new IOException("background merge hit exception: " + merge.segString(this.directory), t);
                    }
                    if (!running) continue;
                    this.doWait();
                }
            }
        }
    }

    public void forceMergeDeletes() throws IOException {
        this.forceMergeDeletes(true);
    }

    public final void maybeMerge() throws IOException {
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, -1);
    }

    private final void maybeMerge(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        this.ensureOpen(false);
        boolean newMergesFound = this.updatePendingMerges(mergePolicy, trigger, maxNumSegments);
        this.mergeScheduler.merge(this, trigger, newMergesFound);
    }

    private synchronized boolean updatePendingMerges(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        this.messageState();
        assert (maxNumSegments == -1 || maxNumSegments > 0);
        assert (trigger != null);
        if (this.stopMerges) {
            return false;
        }
        if (this.tragedy != null) {
            return false;
        }
        boolean newMergesFound = false;
        if (maxNumSegments != -1) {
            assert (trigger == MergeTrigger.EXPLICIT || trigger == MergeTrigger.MERGE_FINISHED) : "Expected EXPLICT or MERGE_FINISHED as trigger even with maxNumSegments set but was: " + trigger.name();
            spec = mergePolicy.findForcedMerges(this.segmentInfos, maxNumSegments, Collections.unmodifiableMap(this.segmentsToMerge), this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge = spec.merges.get(i);
                    merge.maxNumSegments = maxNumSegments;
                }
            }
        } else {
            spec = mergePolicy.findMerges(trigger, this.segmentInfos, this);
        }
        boolean bl = newMergesFound = spec != null;
        if (newMergesFound) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge(spec.merges.get(i));
            }
        }
        return newMergesFound;
    }

    public synchronized Collection<SegmentCommitInfo> getMergingSegments() {
        return this.mergingSegments;
    }

    public synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge = this.pendingMerges.removeFirst();
        this.runningMerges.add(merge);
        return merge;
    }

    public synchronized boolean hasPendingMerges() {
        return this.pendingMerges.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            if (this.shouldClose()) {
                this.rollbackInternal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        IndexWriter indexWriter;
        boolean success;
        block42: {
            success = false;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "rollback");
            }
            try {
                indexWriter = this;
                synchronized (indexWriter) {
                    this.abortMerges();
                    this.stopMerges = true;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "rollback: done finish merges");
                }
                this.mergeScheduler.close();
                this.bufferedUpdatesStream.clear();
                this.docWriter.close();
                this.docWriter.abort(this);
                indexWriter = this;
                synchronized (indexWriter) {
                    if (this.pendingCommit != null) {
                        this.pendingCommit.rollbackCommit(this.directory);
                        try {
                            this.deleter.decRef(this.pendingCommit);
                        }
                        finally {
                            this.pendingCommit = null;
                            this.notifyAll();
                        }
                    }
                    this.readerPool.dropAll(false);
                    this.segmentInfos.rollbackSegmentInfos(this.rollbackSegments);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "rollback: infos=" + this.segString(this.segmentInfos));
                    }
                    assert (this.testPoint("rollback before checkpoint"));
                    this.deleter.checkpoint(this.segmentInfos, false);
                    this.deleter.refresh();
                    this.lastCommitChangeCount = this.changeCount;
                    this.deleter.refresh();
                    this.deleter.close();
                    IOUtils.close(this.writeLock);
                    this.writeLock = null;
                    assert (this.docWriter.perThreadPool.numDeactivatedThreadStates() == this.docWriter.perThreadPool.getMaxThreadStates()) : "" + this.docWriter.perThreadPool.numDeactivatedThreadStates() + " " + this.docWriter.perThreadPool.getMaxThreadStates();
                }
                success = true;
                if (success) break block42;
            }
            catch (OutOfMemoryError oom) {
                block43: {
                    try {
                        this.tragicEvent(oom, "rollbackInternal");
                        if (success) break block43;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException(this.mergeScheduler);
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            if (!success) {
                                if (this.pendingCommit != null) {
                                    try {
                                        this.pendingCommit.rollbackCommit(this.directory);
                                        this.deleter.decRef(this.pendingCommit);
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    this.pendingCommit = null;
                                }
                                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                                this.writeLock = null;
                            }
                            this.closed = true;
                            this.closing = false;
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(this.mergeScheduler);
                }
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    if (!success) {
                        if (this.pendingCommit != null) {
                            try {
                                this.pendingCommit.rollbackCommit(this.directory);
                                this.deleter.decRef(this.pendingCommit);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.pendingCommit = null;
                        }
                        IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                        this.writeLock = null;
                    }
                    this.closed = true;
                    this.closing = false;
                }
            }
            IOUtils.closeWhileHandlingException(this.mergeScheduler);
        }
        indexWriter = this;
        synchronized (indexWriter) {
            if (!success) {
                if (this.pendingCommit != null) {
                    try {
                        this.pendingCommit.rollbackCommit(this.directory);
                        this.deleter.decRef(this.pendingCommit);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.pendingCommit = null;
                }
                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                this.writeLock = null;
            }
            this.closed = true;
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws IOException {
        this.ensureOpen();
        boolean success = false;
        Object object = this.fullFlushLock;
        synchronized (object) {
            try {
                this.docWriter.lockAndAbortAll(this);
                this.processEvents(false, true);
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    try {
                        this.abortMerges();
                        this.segmentInfos.clear();
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.readerPool.dropAll(false);
                        ++this.changeCount;
                        this.segmentInfos.changed();
                        this.globalFieldNumberMap.clear();
                        success = true;
                    }
                    finally {
                        if (!success && this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during deleteAll");
                        }
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                this.tragicEvent(oom, "deleteAll");
            }
            finally {
                this.docWriter.unlockAllAfterAbortAll(this);
            }
        }
    }

    public synchronized void abortMerges() {
        this.stopMerges = true;
        for (MergePolicy.OneMerge merge : this.pendingMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort pending merge " + this.segString(merge.segments));
            }
            merge.abort();
            this.mergeFinish(merge);
        }
        this.pendingMerges.clear();
        for (MergePolicy.OneMerge merge : this.runningMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort running merge " + this.segString(merge.segments));
            }
            merge.abort();
        }
        while (this.runningMerges.size() > 0) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now wait for " + this.runningMerges.size() + " running merge/s to abort");
            }
            this.doWait();
        }
        this.stopMerges = false;
        this.notifyAll();
        assert (0 == this.mergingSegments.size());
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "all running merges have aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMerges() throws IOException {
        this.mergeScheduler.merge(this, MergeTrigger.CLOSING, false);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges");
            }
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                this.doWait();
            }
            assert (0 == this.mergingSegments.size());
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges done");
            }
        }
    }

    synchronized void checkpoint() throws IOException {
        this.changed();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void checkpointNoSIS() throws IOException {
        ++this.changeCount;
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void changed() {
        ++this.changeCount;
        this.segmentInfos.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void publishFrozenUpdates(FrozenBufferedUpdates packet) {
        assert (packet != null && packet.any());
        BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
        synchronized (bufferedUpdatesStream) {
            this.bufferedUpdatesStream.push(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishFlushedSegment(SegmentCommitInfo newSegment, FrozenBufferedUpdates packet, FrozenBufferedUpdates globalPacket) throws IOException {
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
                synchronized (bufferedUpdatesStream) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publishFlushedSegment");
                    }
                    if (globalPacket != null && globalPacket.any()) {
                        this.bufferedUpdatesStream.push(globalPacket);
                    }
                    long nextGen = packet != null && packet.any() ? this.bufferedUpdatesStream.push(packet) : this.bufferedUpdatesStream.getNextGen();
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publish sets newSegment delGen=" + nextGen + " seg=" + this.segString(newSegment));
                    }
                    newSegment.setBufferedDeletesGen(nextGen);
                    this.segmentInfos.add(newSegment);
                    this.checkpoint();
                }
            }
        }
        finally {
            this.flushCount.incrementAndGet();
            this.doAfterFlush();
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory ... dirs) {
        HashSet<Directory> dups = new HashSet<Directory>();
        for (int i = 0; i < dirs.length; ++i) {
            if (dups.contains(dirs[i])) {
                throw new IllegalArgumentException("Directory " + dirs[i] + " appears more than once");
            }
            if (dirs[i] == this.directory) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            dups.add(dirs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Lock> acquireWriteLocks(Directory ... dirs) throws IOException {
        ArrayList<Lock> locks = new ArrayList<Lock>();
        for (int i = 0; i < dirs.length; ++i) {
            boolean success = false;
            try {
                Lock lock = dirs[i].makeLock(WRITE_LOCK_NAME);
                locks.add(lock);
                lock.obtain(this.config.getWriteLockTimeout());
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(locks);
                }
            }
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(Directory ... dirs) throws IOException {
        this.ensureOpen();
        this.noDupDirs(dirs);
        List<Lock> locks = this.acquireWriteLocks(dirs);
        boolean successTop = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(Directory...)");
            }
            this.flush(false, true);
            ArrayList<SegmentCommitInfo> infos = new ArrayList<SegmentCommitInfo>();
            int totalDocCount = 0;
            boolean success = false;
            try {
                for (Directory dir : dirs) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "addIndexes: process directory " + dir);
                    }
                    SegmentInfos sis = new SegmentInfos();
                    sis.read(dir);
                    HashSet<String> dsFilesCopied = new HashSet<String>();
                    HashMap<String, String> dsNames = new HashMap<String, String>();
                    HashSet<String> copiedFiles = new HashSet<String>();
                    totalDocCount += sis.totalDocCount();
                    for (SegmentCommitInfo info : sis) {
                        assert (!infos.contains(info)) : "dup info dir=" + info.info.dir + " name=" + info.info.name;
                        String newSegName = this.newSegmentName();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "addIndexes: process segment origName=" + info.info.name + " newName=" + newSegName + " info=" + info);
                        }
                        IOContext context = new IOContext(new MergeInfo(info.info.getDocCount(), info.sizeInBytes(), true, -1));
                        for (FieldInfo fi : SegmentReader.readFieldInfos(info)) {
                            this.globalFieldNumberMap.addOrGet(fi.name, fi.number, fi.getDocValuesType());
                        }
                        infos.add(this.copySegmentAsIs(info, newSegName, dsNames, dsFilesCopied, context, copiedFiles));
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    for (SegmentCommitInfo sipc : infos) {
                        for (String file : sipc.files()) {
                            try {
                                this.directory.deleteFile(file);
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                success = false;
                try {
                    this.ensureOpen();
                    this.reserveDocs(totalDocCount);
                    success = true;
                }
                finally {
                    if (!success) {
                        for (SegmentCommitInfo sipc : infos) {
                            for (String file : sipc.files()) {
                                try {
                                    this.directory.deleteFile(file);
                                }
                                catch (Throwable t) {}
                            }
                        }
                    }
                }
                this.segmentInfos.addAll(infos);
                this.checkpoint();
            }
            successTop = true;
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "addIndexes(Directory...)");
        }
        finally {
            if (successTop) {
                IOUtils.close(locks);
            } else {
                IOUtils.closeWhileHandlingException(locks);
            }
        }
        this.maybeMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(IndexReader ... readers) throws IOException {
        this.ensureOpen();
        int numDocs = 0;
        try {
            boolean useCompoundFile;
            MergeState mergeState;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(IndexReader...)");
            }
            this.flush(false, true);
            String mergedName = this.newSegmentName();
            ArrayList<AtomicReader> mergeReaders = new ArrayList<AtomicReader>();
            for (IndexReader indexReader : readers) {
                numDocs += indexReader.numDocs();
                for (AtomicReaderContext ctx : indexReader.leaves()) {
                    mergeReaders.add(ctx.reader());
                }
            }
            this.reserveDocs(numDocs);
            IOContext context = new IOContext(new MergeInfo(numDocs, -1L, true, -1));
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.directory);
            SegmentInfo info = new SegmentInfo(this.directory, Version.LATEST, mergedName, -1, false, this.codec, null);
            SegmentMerger merger = new SegmentMerger(mergeReaders, info, this.infoStream, trackingDir, this.config.getTermIndexInterval(), MergeState.CheckAbort.NONE, this.globalFieldNumberMap, context, this.config.getCheckIntegrityAtMerge());
            if (!merger.shouldMerge()) {
                return;
            }
            boolean success = false;
            try {
                mergeState = merger.merge();
                success = true;
            }
            finally {
                if (!success) {
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        this.deleter.refresh(info.name);
                    }
                }
            }
            SegmentCommitInfo infoPerCommit = new SegmentCommitInfo(info, 0, -1L, -1L, -1L);
            info.setFiles(new HashSet<String>(trackingDir.getCreatedFiles()));
            trackingDir.getCreatedFiles().clear();
            IndexWriter.setDiagnostics(info, SOURCE_ADDINDEXES_READERS);
            MergePolicy mergePolicy = this.config.getMergePolicy();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleter.deleteNewFiles(infoPerCommit.files());
                    return;
                }
                this.ensureOpen();
                useCompoundFile = mergePolicy.useCompoundFile(this.segmentInfos, infoPerCommit, this);
            }
            if (useCompoundFile) {
                Collection<String> filesToDelete = infoPerCommit.files();
                try {
                    IndexWriter.createCompoundFile(this.infoStream, this.directory, MergeState.CheckAbort.NONE, info, context);
                }
                finally {
                    IndexWriter indexWriter2 = this;
                    synchronized (indexWriter2) {
                        this.deleter.deleteNewFiles(filesToDelete);
                    }
                }
                info.setUseCompoundFile(true);
            }
            success = false;
            try {
                this.codec.segmentInfoFormat().getSegmentInfoWriter().write(trackingDir, info, mergeState.fieldInfos, context);
                success = true;
            }
            finally {
                if (!success) {
                    indexWriter = this;
                    synchronized (indexWriter) {
                        this.deleter.refresh(info.name);
                    }
                }
            }
            info.addFiles(trackingDir.getCreatedFiles());
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleter.deleteNewFiles(info.files());
                    return;
                }
                this.ensureOpen();
                this.segmentInfos.add(infoPerCommit);
                this.checkpoint();
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, SOURCE_ADDINDEXES_READERS);
        }
        this.maybeMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentCommitInfo copySegmentAsIs(SegmentCommitInfo info, String segName, Map<String, String> dsNames, Set<String> dsFilesCopied, IOContext context, Set<String> copiedFiles) throws IOException {
        TrackingDirectoryWrapper trackingDir;
        SegmentCommitInfo newInfoPerCommit;
        SegmentInfo newInfo;
        Set<String> docStoreFiles3xOnly;
        String newDsName;
        block21: {
            String dsName = Lucene3xSegmentInfoFormat.getDocStoreSegment(info.info);
            assert (dsName != null);
            if (dsNames.containsKey(dsName)) {
                newDsName = dsNames.get(dsName);
            } else {
                dsNames.put(dsName, segName);
                newDsName = segName;
            }
            FieldInfos fis = SegmentReader.readFieldInfos(info);
            docStoreFiles3xOnly = Lucene3xCodec.getDocStoreFiles(info.info);
            HashMap<Object, Object> attributes = info.info.attributes() == null ? new HashMap() : new HashMap<String, String>(info.info.attributes());
            if (docStoreFiles3xOnly != null) {
                attributes.put(Lucene3xSegmentInfoFormat.DS_NAME_KEY, newDsName);
            }
            newInfo = new SegmentInfo(this.directory, info.info.getVersion(), segName, info.info.getDocCount(), info.info.getUseCompoundFile(), info.info.getCodec(), info.info.getDiagnostics(), attributes);
            newInfoPerCommit = new SegmentCommitInfo(newInfo, info.getDelCount(), info.getDelGen(), info.getFieldInfosGen(), info.getDocValuesGen());
            HashSet<String> segFiles = new HashSet<String>();
            for (String file : info.files()) {
                String newFileName = docStoreFiles3xOnly != null && docStoreFiles3xOnly.contains(file) ? newDsName + IndexFileNames.stripSegmentName(file) : segName + IndexFileNames.stripSegmentName(file);
                segFiles.add(newFileName);
            }
            newInfo.setFiles(segFiles);
            trackingDir = new TrackingDirectoryWrapper(this.directory);
            Codec currentCodec = newInfo.getCodec();
            try {
                currentCodec.segmentInfoFormat().getSegmentInfoWriter().write(trackingDir, newInfo, fis, context);
            }
            catch (UnsupportedOperationException uoe) {
                if (currentCodec instanceof Lucene3xCodec) break block21;
                throw uoe;
            }
        }
        Set<String> siFiles = trackingDir.getCreatedFiles();
        boolean success = false;
        try {
            for (String file : info.files()) {
                String newFileName;
                if (docStoreFiles3xOnly != null && docStoreFiles3xOnly.contains(file)) {
                    newFileName = newDsName + IndexFileNames.stripSegmentName(file);
                    if (dsFilesCopied.contains(newFileName)) continue;
                    dsFilesCopied.add(newFileName);
                } else {
                    newFileName = segName + IndexFileNames.stripSegmentName(file);
                }
                if (siFiles.contains(newFileName)) continue;
                assert (!IndexWriter.slowFileExists(this.directory, newFileName)) : "file \"" + newFileName + "\" already exists; siFiles=" + siFiles;
                assert (!copiedFiles.contains(file)) : "file \"" + file + "\" is being copied more than once";
                copiedFiles.add(file);
                info.info.dir.copy(this.directory, file, newFileName, context);
            }
            success = true;
        }
        finally {
            if (!success) {
                for (String file : newInfo.files()) {
                    try {
                        this.directory.deleteFile(file);
                    }
                    catch (Throwable t) {}
                }
            }
        }
        return newInfoPerCommit;
    }

    protected void doAfterFlush() throws IOException {
    }

    protected void doBeforeFlush() throws IOException {
    }

    @Override
    public final void prepareCommit() throws IOException {
        this.ensureOpen();
        this.prepareCommitInternal(this.config.getMergePolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCommitInternal(MergePolicy mergePolicy) throws IOException {
        this.startCommitTime = System.nanoTime();
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "prepareCommit: flush");
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            if (this.tragedy != null) {
                throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
            }
            if (this.pendingCommit != null) {
                throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
            }
            this.doBeforeFlush();
            assert (this.testPoint("startDoFlush"));
            SegmentInfos toCommit = null;
            boolean anySegmentsFlushed = false;
            try {
                Object object2 = this.fullFlushLock;
                synchronized (object2) {
                    boolean flushSuccess = false;
                    boolean success = false;
                    try {
                        anySegmentsFlushed = this.docWriter.flushAllThreads(this);
                        if (!anySegmentsFlushed) {
                            this.flushCount.incrementAndGet();
                        }
                        this.processEvents(false, true);
                        flushSuccess = true;
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            this.maybeApplyDeletes(true);
                            this.readerPool.commit(this.segmentInfos);
                            toCommit = this.segmentInfos.clone();
                            this.pendingCommitChangeCount = this.changeCount;
                            this.filesToCommit = toCommit.files(this.directory, false);
                            this.deleter.incRef(this.filesToCommit);
                        }
                        success = true;
                    }
                    finally {
                        if (!success && this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during prepareCommit");
                        }
                        this.docWriter.finishFullFlush(flushSuccess);
                        this.doAfterFlush();
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                this.tragicEvent(oom, "prepareCommit");
            }
            boolean success = false;
            try {
                if (anySegmentsFlushed) {
                    this.maybeMerge(mergePolicy, MergeTrigger.FULL_FLUSH, -1);
                }
                this.startCommit(toCommit);
                success = true;
            }
            finally {
                if (!success) {
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        if (this.filesToCommit != null) {
                            this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            this.filesToCommit = null;
                        }
                    }
                }
            }
        }
    }

    public final synchronized void setCommitData(Map<String, String> commitUserData) {
        this.segmentInfos.setUserData(new HashMap<String, String>(commitUserData));
        ++this.changeCount;
    }

    public final synchronized Map<String, String> getCommitData() {
        return this.segmentInfos.getUserData();
    }

    @Override
    public final void commit() throws IOException {
        this.ensureOpen();
        this.commitInternal(this.config.getMergePolicy());
    }

    public final boolean hasUncommittedChanges() {
        return this.changeCount != this.lastCommitChangeCount || this.docWriter.anyChanges() || this.bufferedUpdatesStream.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitInternal(MergePolicy mergePolicy) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: enter lock");
            }
            if (this.pendingCommit == null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: now prepare");
                }
                this.prepareCommitInternal(mergePolicy);
            } else if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: already prepared");
            }
            this.finishCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishCommit() throws IOException {
        boolean commitCompleted = false;
        boolean finished = false;
        String committedSegmentsFileName = null;
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.pendingCommit != null) {
                    try {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: pendingCommit != null");
                        }
                        committedSegmentsFileName = this.pendingCommit.finishCommit(this.directory);
                        commitCompleted = true;
                        this.deleter.checkpoint(this.pendingCommit, true);
                        this.lastCommitChangeCount = this.pendingCommitChangeCount;
                        this.rollbackSegments = this.pendingCommit.createBackupSegmentInfos();
                        finished = true;
                    }
                    finally {
                        this.notifyAll();
                        try {
                            if (finished) {
                                this.deleter.decRef(this.filesToCommit);
                            } else if (!commitCompleted) {
                                this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            }
                        }
                        finally {
                            this.pendingCommit = null;
                            this.filesToCommit = null;
                        }
                    }
                }
                assert (this.filesToCommit == null);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: pendingCommit == null; skip");
                }
            }
        }
        catch (Throwable t) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during finishCommit: " + t.getMessage());
            }
            if (commitCompleted) {
                this.tragicEvent(t, "finishCommit");
            }
            IOUtils.reThrow(t);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commit: wrote segments file \"" + committedSegmentsFileName + "\"");
            this.infoStream.message("IW", String.format(Locale.ROOT, "commit: took %.1f msec", (double)(System.nanoTime() - this.startCommitTime) / 1000000.0));
            this.infoStream.message("IW", "commit: done");
        }
    }

    boolean holdsFullFlushLock() {
        return Thread.holdsLock(this.fullFlushLock);
    }

    protected final void flush(boolean triggerMerge, boolean applyAllDeletes) throws IOException {
        this.ensureOpen(false);
        if (this.doFlush(applyAllDeletes) && triggerMerge) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(boolean applyAllDeletes) throws IOException {
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot flush", this.tragedy);
        }
        this.doBeforeFlush();
        assert (this.testPoint("startDoFlush"));
        boolean success = false;
        try {
            boolean anySegmentFlushed;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "  start flush: applyAllDeletes=" + applyAllDeletes);
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            Object object = this.fullFlushLock;
            synchronized (object) {
                boolean flushSuccess = false;
                try {
                    anySegmentFlushed = this.docWriter.flushAllThreads(this);
                    flushSuccess = true;
                }
                finally {
                    this.docWriter.finishFullFlush(flushSuccess);
                    this.processEvents(false, true);
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.maybeApplyDeletes(applyAllDeletes);
                    this.doAfterFlush();
                    if (!anySegmentFlushed) {
                        this.flushCount.incrementAndGet();
                    }
                    success = true;
                    boolean bl = anySegmentFlushed;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (OutOfMemoryError oom) {
                        this.tragicEvent(oom, "doFlush");
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            if (!success && this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during flush");
            }
        }
    }

    final synchronized void maybeApplyDeletes(boolean applyAllDeletes) throws IOException {
        if (applyAllDeletes) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "apply all deletes during flush");
            }
            this.applyAllDeletesAndUpdates();
        } else if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "don't apply deletes now delTermCount=" + this.bufferedUpdatesStream.numTerms() + " bytesUsed=" + this.bufferedUpdatesStream.ramBytesUsed());
        }
    }

    final synchronized void applyAllDeletesAndUpdates() throws IOException {
        this.flushDeletesCount.incrementAndGet();
        BufferedUpdatesStream.ApplyDeletesResult result = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, this.segmentInfos.asList());
        if (result.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && result.allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + this.segString(result.allDeleted));
            }
            for (SegmentCommitInfo info : result.allDeleted) {
                if (this.mergingSegments.contains(info)) continue;
                this.segmentInfos.remove(info);
                this.pendingNumDocs.addAndGet(-info.info.getDocCount());
                this.readerPool.drop(info);
            }
            this.checkpoint();
        }
        this.bufferedUpdatesStream.prune(this.segmentInfos);
    }

    @Deprecated
    public final long ramSizeInBytes() {
        return this.ramBytesUsed();
    }

    DocumentsWriter getDocsWriter() {
        boolean test = false;
        if (!$assertionsDisabled) {
            test = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return test ? this.docWriter : null;
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocs();
    }

    private synchronized void ensureValidMerge(MergePolicy.OneMerge merge) {
        for (SegmentCommitInfo info : merge.segments) {
            if (this.segmentInfos.contains(info)) continue;
            throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info.info.name + ") that is not in the current index " + this.segString(), this.directory);
        }
    }

    private void skipDeletedDoc(DocValuesFieldUpdates.Iterator[] updatesIters, int deletedDoc) {
        for (DocValuesFieldUpdates.Iterator iter : updatesIters) {
            if (iter.doc() == deletedDoc) {
                iter.nextDoc();
            }
            assert (iter.doc() > deletedDoc) : "updateDoc=" + iter.doc() + " deletedDoc=" + deletedDoc;
        }
    }

    private void maybeApplyMergedDVUpdates(MergePolicy.OneMerge merge, MergeState mergeState, int docUpto, MergedDeletesAndUpdates holder, String[] mergingFields, DocValuesFieldUpdates[] dvFieldUpdates, DocValuesFieldUpdates.Iterator[] updatesIters, int curDoc) throws IOException {
        int newDoc = -1;
        for (int idx = 0; idx < mergingFields.length; ++idx) {
            DocValuesFieldUpdates.Iterator updatesIter = updatesIters[idx];
            if (updatesIter.doc() == curDoc) {
                if (holder.mergedDeletesAndUpdates == null) {
                    holder.init(this.readerPool, merge, mergeState, false);
                }
                if (newDoc == -1) {
                    newDoc = holder.docMap.map(docUpto);
                }
                DocValuesFieldUpdates dvUpdates = dvFieldUpdates[idx];
                dvUpdates.add(newDoc, updatesIter.value());
                updatesIter.nextDoc();
                continue;
            }
            assert (updatesIter.doc() > curDoc) : "field=" + mergingFields[idx] + " updateDoc=" + updatesIter.doc() + " curDoc=" + curDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ReadersAndUpdates commitMergedDeletesAndUpdates(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        assert (this.testPoint("startCommitMergeDeletes"));
        List<SegmentCommitInfo> sourceSegments = merge.segments;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMergeDeletes " + this.segString(merge.segments));
        }
        int docUpto = 0;
        long minGen = Long.MAX_VALUE;
        MergedDeletesAndUpdates holder = new MergedDeletesAndUpdates();
        DocValuesFieldUpdates.Container mergedDVUpdates = new DocValuesFieldUpdates.Container();
        for (int i = 0; i < sourceSegments.size(); ++i) {
            int j;
            DocValuesFieldUpdates[] dvFieldUpdates;
            DocValuesFieldUpdates.Iterator[] updatesIters;
            String[] mergingFields;
            SegmentCommitInfo info = sourceSegments.get(i);
            minGen = Math.min(info.getBufferedDeletesGen(), minGen);
            int docCount = info.info.getDocCount();
            Bits prevLiveDocs = merge.readers.get(i).getLiveDocs();
            ReadersAndUpdates rld = this.readerPool.get(info, false);
            assert (rld != null) : "seg=" + info.info.name;
            Bits currentLiveDocs = rld.getLiveDocs();
            Map<String, DocValuesFieldUpdates> mergingFieldUpdates = rld.getMergingFieldUpdates();
            if (mergingFieldUpdates.isEmpty()) {
                mergingFields = null;
                updatesIters = null;
                dvFieldUpdates = null;
            } else {
                mergingFields = new String[mergingFieldUpdates.size()];
                dvFieldUpdates = new DocValuesFieldUpdates[mergingFieldUpdates.size()];
                updatesIters = new DocValuesFieldUpdates.Iterator[mergingFieldUpdates.size()];
                int idx = 0;
                for (Map.Entry<String, DocValuesFieldUpdates> e : mergingFieldUpdates.entrySet()) {
                    String field = e.getKey();
                    DocValuesFieldUpdates updates = e.getValue();
                    mergingFields[idx] = field;
                    dvFieldUpdates[idx] = mergedDVUpdates.getUpdates(field, updates.type);
                    if (dvFieldUpdates[idx] == null) {
                        dvFieldUpdates[idx] = mergedDVUpdates.newUpdates(field, updates.type, mergeState.segmentInfo.getDocCount());
                    }
                    updatesIters[idx] = updates.iterator();
                    updatesIters[idx].nextDoc();
                    ++idx;
                }
            }
            if (prevLiveDocs != null) {
                assert (currentLiveDocs != null);
                assert (prevLiveDocs.length() == docCount);
                assert (currentLiveDocs.length() == docCount);
                if (currentLiveDocs != prevLiveDocs) {
                    for (j = 0; j < docCount; ++j) {
                        if (!prevLiveDocs.get(j)) {
                            assert (!currentLiveDocs.get(j));
                            continue;
                        }
                        if (!currentLiveDocs.get(j)) {
                            if (holder.mergedDeletesAndUpdates == null || !holder.initializedWritableLiveDocs) {
                                holder.init(this.readerPool, merge, mergeState, true);
                            }
                            holder.mergedDeletesAndUpdates.delete(holder.docMap.map(docUpto));
                            if (mergingFields != null) {
                                this.skipDeletedDoc(updatesIters, j);
                            }
                        } else if (mergingFields != null) {
                            this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                        }
                        ++docUpto;
                    }
                    continue;
                }
                if (mergingFields != null) {
                    for (j = 0; j < docCount; ++j) {
                        if (prevLiveDocs.get(j)) {
                            this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                            ++docUpto;
                            continue;
                        }
                        this.skipDeletedDoc(updatesIters, j);
                    }
                    continue;
                }
                docUpto += info.info.getDocCount() - info.getDelCount() - rld.getPendingDeleteCount();
                continue;
            }
            if (currentLiveDocs != null) {
                assert (currentLiveDocs.length() == docCount);
                for (j = 0; j < docCount; ++j) {
                    if (!currentLiveDocs.get(j)) {
                        if (holder.mergedDeletesAndUpdates == null || !holder.initializedWritableLiveDocs) {
                            holder.init(this.readerPool, merge, mergeState, true);
                        }
                        holder.mergedDeletesAndUpdates.delete(holder.docMap.map(docUpto));
                        if (mergingFields != null) {
                            this.skipDeletedDoc(updatesIters, j);
                        }
                    } else if (mergingFields != null) {
                        this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                    }
                    ++docUpto;
                }
                continue;
            }
            if (mergingFields != null) {
                for (j = 0; j < docCount; ++j) {
                    this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                    ++docUpto;
                }
                continue;
            }
            docUpto += info.info.getDocCount();
        }
        assert (docUpto == merge.info.info.getDocCount());
        if (mergedDVUpdates.any()) {
            boolean success = false;
            try {
                holder.mergedDeletesAndUpdates.writeFieldUpdates(this.directory, mergedDVUpdates);
                success = true;
            }
            finally {
                if (!success) {
                    holder.mergedDeletesAndUpdates.dropChanges();
                    this.readerPool.drop(merge.info);
                }
            }
        }
        if (this.infoStream.isEnabled("IW")) {
            if (holder.mergedDeletesAndUpdates == null) {
                this.infoStream.message("IW", "no new deletes or field updates since merge started");
            } else {
                String msg = holder.mergedDeletesAndUpdates.getPendingDeleteCount() + " new deletes";
                if (mergedDVUpdates.any()) {
                    msg = msg + " and " + mergedDVUpdates.size() + " new field updates";
                }
                msg = msg + " since merge started";
                this.infoStream.message("IW", msg);
            }
        }
        merge.info.setBufferedDeletesGen(minGen);
        return holder.mergedDeletesAndUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean commitMerge(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        boolean dropSegment;
        boolean allDeleted;
        ReadersAndUpdates mergedUpdates;
        assert (this.testPoint("startCommitMerge"));
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete merge", this.tragedy);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMerge: " + this.segString(merge.segments) + " index=" + this.segString());
        }
        assert (merge.registerDone);
        if (merge.isAborted()) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commitMerge: skip: it was aborted");
            }
            this.readerPool.drop(merge.info);
            this.deleter.deleteNewFiles(merge.info.files());
            return false;
        }
        ReadersAndUpdates readersAndUpdates = mergedUpdates = merge.info.info.getDocCount() == 0 ? null : this.commitMergedDeletesAndUpdates(merge, mergeState);
        assert (!this.segmentInfos.contains(merge.info));
        boolean bl = allDeleted = merge.segments.size() == 0 || merge.info.info.getDocCount() == 0 || mergedUpdates != null && mergedUpdates.getPendingDeleteCount() == merge.info.info.getDocCount();
        if (this.infoStream.isEnabled("IW") && allDeleted) {
            this.infoStream.message("IW", "merged segment " + merge.info + " is 100% deleted" + (this.keepFullyDeletedSegments ? "" : "; skipping insert"));
        }
        boolean bl2 = dropSegment = allDeleted && !this.keepFullyDeletedSegments;
        assert (merge.segments.size() > 0 || dropSegment);
        assert (merge.info.info.getDocCount() != 0 || this.keepFullyDeletedSegments || dropSegment);
        if (mergedUpdates != null) {
            boolean success = false;
            try {
                if (dropSegment) {
                    mergedUpdates.dropChanges();
                }
                this.readerPool.release(mergedUpdates, false);
                success = true;
            }
            finally {
                if (!success) {
                    mergedUpdates.dropChanges();
                    this.readerPool.drop(merge.info);
                }
            }
        }
        this.segmentInfos.applyMergeChanges(merge, dropSegment);
        int delDocCount = merge.totalDocCount - merge.info.info.getDocCount();
        assert (delDocCount >= 0);
        this.pendingNumDocs.addAndGet(-delDocCount);
        if (dropSegment) {
            assert (!this.segmentInfos.contains(merge.info));
            this.readerPool.drop(merge.info);
            this.deleter.deleteNewFiles(merge.info.files());
        }
        boolean success = false;
        try {
            this.closeMergeReaders(merge, false);
            success = true;
        }
        finally {
            if (success) {
                this.checkpoint();
            } else {
                try {
                    this.checkpoint();
                }
                catch (Throwable t) {}
            }
        }
        this.deleter.deletePendingFiles();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "after commitMerge: " + this.segString());
        }
        if (merge.maxNumSegments != -1 && !dropSegment && !this.segmentsToMerge.containsKey(merge.info)) {
            this.segmentsToMerge.put(merge.info, Boolean.FALSE);
        }
        return true;
    }

    private final void handleMergeException(Throwable t, MergePolicy.OneMerge merge) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "handleMergeException: merge=" + this.segString(merge.segments) + " exc=" + t);
        }
        merge.setException(t);
        this.addMergeException(merge);
        if (t instanceof MergePolicy.MergeAbortedException) {
            if (merge.isExternal) {
                throw (MergePolicy.MergeAbortedException)t;
            }
        } else {
            IOUtils.reThrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        long t0 = System.currentTimeMillis();
        MergePolicy mergePolicy = this.config.getMergePolicy();
        try {
            try {
                try {
                    this.mergeInit(merge);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "now merge\n  merge=" + this.segString(merge.segments) + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(merge, mergePolicy);
                    this.mergeSuccess(merge);
                    success = true;
                }
                catch (Throwable t) {
                    this.handleMergeException(t, merge);
                }
            }
            finally {
                IndexWriter t = this;
                synchronized (t) {
                    this.mergeFinish(merge);
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during merge");
                        }
                        if (merge.info != null && !this.segmentInfos.contains(merge.info)) {
                            this.deleter.refresh(merge.info.info.name);
                        }
                    }
                    if (success && !merge.isAborted() && (merge.maxNumSegments != -1 || !this.closed && !this.closing)) {
                        this.updatePendingMerges(mergePolicy, MergeTrigger.MERGE_FINISHED, merge.maxNumSegments);
                    }
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, SOURCE_MERGE);
        }
        if (merge.info != null && !merge.isAborted() && this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge time " + (System.currentTimeMillis() - t0) + " msec for " + merge.info.info.getDocCount() + " docs");
        }
    }

    void mergeSuccess(MergePolicy.OneMerge merge) {
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge merge) throws IOException {
        if (merge.registerDone) {
            return true;
        }
        assert (merge.segments.size() > 0);
        if (this.stopMerges) {
            merge.abort();
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + this.segString(merge.segments));
        }
        boolean isExternal = false;
        for (SegmentCommitInfo info : merge.segments) {
            if (this.mergingSegments.contains(info)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(info) + " is already marked for merge");
                }
                return false;
            }
            if (!this.segmentInfos.contains(info)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(info) + " does not exist in live infos");
                }
                return false;
            }
            if (info.info.dir != this.directory) {
                isExternal = true;
            }
            if (!this.segmentsToMerge.containsKey(info)) continue;
            merge.maxNumSegments = this.mergeMaxNumSegments;
        }
        this.ensureValidMerge(merge);
        this.pendingMerges.add(merge);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "add merge to pendingMerges: " + this.segString(merge.segments) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge.mergeGen = this.mergeGen;
        merge.isExternal = isExternal;
        if (this.infoStream.isEnabled("IW")) {
            StringBuilder builder = new StringBuilder("registerMerge merging= [");
            for (SegmentCommitInfo info : this.mergingSegments) {
                builder.append(info.info.name).append(", ");
            }
            builder.append("]");
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", builder.toString());
            }
        }
        for (SegmentCommitInfo info : merge.segments) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "registerMerge info=" + this.segString(info));
            }
            this.mergingSegments.add(info);
        }
        assert (merge.estimatedMergeBytes == 0L);
        assert (merge.totalMergeBytes == 0L);
        for (SegmentCommitInfo info : merge.segments) {
            if (info.info.getDocCount() <= 0) continue;
            int delCount = this.numDeletedDocs(info);
            assert (delCount <= info.info.getDocCount());
            double delRatio = (double)delCount / (double)info.info.getDocCount();
            merge.estimatedMergeBytes = (long)((double)merge.estimatedMergeBytes + (double)info.sizeInBytes() * (1.0 - delRatio));
            merge.totalMergeBytes += info.sizeInBytes();
        }
        merge.registerDone = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        try {
            this._mergeInit(merge);
            success = true;
        }
        finally {
            if (!success) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception in mergeInit");
                }
                this.mergeFinish(merge);
            }
        }
    }

    private synchronized void _mergeInit(MergePolicy.OneMerge merge) throws IOException {
        assert (this.testPoint("startMergeInit"));
        assert (merge.registerDone);
        assert (merge.maxNumSegments == -1 || merge.maxNumSegments > 0);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot merge", this.tragedy);
        }
        if (merge.info != null) {
            return;
        }
        if (merge.isAborted()) {
            return;
        }
        BufferedUpdatesStream.ApplyDeletesResult result = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, merge.segments);
        if (result.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && result.allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + result.allDeleted);
            }
            for (SegmentCommitInfo info : result.allDeleted) {
                this.segmentInfos.remove(info);
                this.pendingNumDocs.addAndGet(-info.info.getDocCount());
                if (merge.segments.contains(info)) {
                    this.mergingSegments.remove(info);
                    merge.segments.remove(info);
                }
                this.readerPool.drop(info);
            }
            this.checkpoint();
        }
        String mergeSegmentName = this.newSegmentName();
        SegmentInfo si = new SegmentInfo(this.directory, Version.LATEST, mergeSegmentName, -1, false, this.codec, null);
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("mergeMaxNumSegments", "" + merge.maxNumSegments);
        details.put("mergeFactor", Integer.toString(merge.segments.size()));
        IndexWriter.setDiagnostics(si, SOURCE_MERGE, details);
        merge.setInfo(new SegmentCommitInfo(si, 0, -1L, -1L, -1L));
        this.bufferedUpdatesStream.prune(this.segmentInfos);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge seg=" + merge.info.info.name + " " + this.segString(merge.segments));
        }
    }

    static void setDiagnostics(SegmentInfo info, String source) {
        IndexWriter.setDiagnostics(info, source, null);
    }

    private static void setDiagnostics(SegmentInfo info, String source, Map<String, String> details) {
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put(SOURCE, source);
        diagnostics.put("lucene.version", Version.LATEST.toString());
        diagnostics.put("os", Constants.OS_NAME);
        diagnostics.put("os.arch", Constants.OS_ARCH);
        diagnostics.put("os.version", Constants.OS_VERSION);
        diagnostics.put("java.version", Constants.JAVA_VERSION);
        diagnostics.put("java.vendor", Constants.JAVA_VENDOR);
        diagnostics.put("timestamp", Long.toString(new Date().getTime()));
        if (details != null) {
            diagnostics.putAll(details);
        }
        info.setDiagnostics(diagnostics);
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge merge) {
        this.notifyAll();
        if (merge.registerDone) {
            List<SegmentCommitInfo> sourceSegments = merge.segments;
            for (SegmentCommitInfo info : sourceSegments) {
                this.mergingSegments.remove(info);
            }
            merge.registerDone = false;
        }
        this.runningMerges.remove(merge);
    }

    private final synchronized void closeMergeReaders(MergePolicy.OneMerge merge, boolean suppressExceptions) throws IOException {
        int numSegments = merge.readers.size();
        Throwable th = null;
        boolean drop = !suppressExceptions;
        for (int i = 0; i < numSegments; ++i) {
            block8: {
                SegmentReader sr = merge.readers.get(i);
                if (sr == null) continue;
                try {
                    ReadersAndUpdates rld = this.readerPool.get(sr.getSegmentInfo(), false);
                    assert (rld != null);
                    if (drop) {
                        rld.dropChanges();
                    } else {
                        rld.dropMergingUpdates();
                    }
                    rld.release(sr);
                    this.readerPool.release(rld);
                    if (drop) {
                        this.readerPool.drop(rld.info);
                    }
                }
                catch (Throwable t) {
                    if (th != null) break block8;
                    th = t;
                }
            }
            merge.readers.set(i, null);
        }
        if (!suppressExceptions) {
            IOUtils.reThrow(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int mergeMiddle(MergePolicy.OneMerge merge, MergePolicy mergePolicy) throws IOException {
        merge.checkAborted(this.directory);
        String mergedName = merge.info.info.name;
        List<SegmentCommitInfo> sourceSegments = merge.segments;
        IOContext context = new IOContext(merge.getMergeInfo());
        MergeState.CheckAbort checkAbort = new MergeState.CheckAbort(merge, this.directory);
        TrackingDirectoryWrapper dirWrapper = new TrackingDirectoryWrapper(this.directory);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merging " + this.segString(merge.segments));
        }
        merge.readers = new ArrayList<SegmentReader>();
        boolean success = false;
        try {
            MergeState mergeState;
            Object liveDocs;
            for (int segUpto = 0; segUpto < sourceSegments.size(); ++segUpto) {
                SegmentCommitInfo info = sourceSegments.get(segUpto);
                ReadersAndUpdates rld = this.readerPool.get(info, true);
                IndexWriter indexWriter = this;
                // MONITORENTER : indexWriter
                SegmentReader reader = rld.getReaderForMerge(context);
                liveDocs = rld.getReadOnlyLiveDocs();
                int delCount = rld.getPendingDeleteCount() + info.getDelCount();
                assert (reader != null);
                assert (rld.verifyDocCounts());
                if (this.infoStream.isEnabled("IW")) {
                    if (rld.getPendingDeleteCount() != 0) {
                        this.infoStream.message("IW", "seg=" + this.segString(info) + " delCount=" + info.getDelCount() + " pendingDelCount=" + rld.getPendingDeleteCount());
                    } else if (info.getDelCount() != 0) {
                        this.infoStream.message("IW", "seg=" + this.segString(info) + " delCount=" + info.getDelCount());
                    } else {
                        this.infoStream.message("IW", "seg=" + this.segString(info) + " no deletes");
                    }
                }
                // MONITOREXIT : indexWriter
                if (reader.numDeletedDocs() != delCount) {
                    assert (delCount > reader.numDeletedDocs());
                    SegmentReader segmentReader = new SegmentReader(info, reader, (Bits)liveDocs, info.info.getDocCount() - delCount);
                    boolean released = false;
                    try {
                        rld.release(reader);
                        released = true;
                    }
                    finally {
                        if (!released) {
                            segmentReader.decRef();
                        }
                    }
                    reader = segmentReader;
                }
                merge.readers.add(reader);
                assert (delCount <= info.info.getDocCount()) : "delCount=" + delCount + " info.docCount=" + info.info.getDocCount() + " rld.pendingDeleteCount=" + rld.getPendingDeleteCount() + " info.getDelCount()=" + info.getDelCount();
            }
            SegmentMerger merger = new SegmentMerger(merge.getMergeReaders(), merge.info.info, this.infoStream, dirWrapper, this.config.getTermIndexInterval(), checkAbort, this.globalFieldNumberMap, context, this.config.getCheckIntegrityAtMerge());
            merge.checkAborted(this.directory);
            boolean success3 = false;
            try {
                mergeState = !merger.shouldMerge() ? new MergeState(new ArrayList<AtomicReader>(), merge.info.info, this.infoStream, checkAbort) : merger.merge();
                success3 = true;
            }
            finally {
                if (!success3) {
                    liveDocs = this;
                }
            }
            assert (mergeState.segmentInfo == merge.info.info);
            merge.info.info.setFiles(new HashSet<String>(dirWrapper.getCreatedFiles()));
            if (this.infoStream.isEnabled("IW")) {
                if (merge.info.info.getDocCount() == 0) {
                    this.infoStream.message("IW", "merge away fully deleted segments");
                } else {
                    this.infoStream.message("IW", "merge codec=" + this.codec + " docCount=" + merge.info.info.getDocCount() + "; merged segment has " + (mergeState.fieldInfos.hasVectors() ? "vectors" : "no vectors") + "; " + (mergeState.fieldInfos.hasNorms() ? "norms" : "no norms") + "; " + (mergeState.fieldInfos.hasDocValues() ? "docValues" : "no docValues") + "; " + (mergeState.fieldInfos.hasProx() ? "prox" : "no prox") + "; " + (mergeState.fieldInfos.hasProx() ? "freqs" : "no freqs"));
                }
            }
            IndexWriter delCount = this;
            // MONITORENTER : delCount
            boolean useCompoundFile = mergePolicy.useCompoundFile(this.segmentInfos, merge.info, this);
            // MONITOREXIT : delCount
            if (useCompoundFile) {
                Collection<String> filesToRemove;
                block85: {
                    success = false;
                    filesToRemove = merge.info.files();
                    try {
                        filesToRemove = IndexWriter.createCompoundFile(this.infoStream, this.directory, checkAbort, merge.info.info, context);
                        success = true;
                    }
                    catch (IOException iOException) {
                        IndexWriter released = this;
                        // MONITORENTER : released
                        if (!merge.isAborted()) {
                            this.handleMergeException(iOException, merge);
                        }
                        // MONITOREXIT : released
                    }
                    catch (Throwable throwable) {
                        this.handleMergeException(throwable, merge);
                        if (success) break block85;
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception creating compound file during merge");
                        }
                        IndexWriter indexWriter = this;
                        this.deleter.deleteFile(IndexFileNames.segmentFileName(mergedName, "", "cfs"));
                        this.deleter.deleteFile(IndexFileNames.segmentFileName(mergedName, "", "cfe"));
                        this.deleter.deleteNewFiles(merge.info.files());
                        // MONITOREXIT : indexWriter
                    }
                    finally {
                        if (success) {
                        }
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception creating compound file during merge");
                        }
                        IndexWriter indexWriter = this;
                    }
                }
                success = false;
                IndexWriter indexWriter = this;
                // MONITORENTER : indexWriter
                this.deleter.deleteNewFiles(filesToRemove);
                if (merge.isAborted()) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "abort merge after building CFS");
                    }
                    this.deleter.deleteFile(IndexFileNames.segmentFileName(mergedName, "", "cfs"));
                    this.deleter.deleteFile(IndexFileNames.segmentFileName(mergedName, "", "cfe"));
                    int released = 0;
                    // MONITOREXIT : indexWriter
                    return released;
                }
                // MONITOREXIT : indexWriter
                merge.info.info.setUseCompoundFile(true);
            } else {
                success = false;
            }
            boolean success2 = false;
            try {
                this.codec.segmentInfoFormat().getSegmentInfoWriter().write(this.directory, merge.info.info, mergeState.fieldInfos, context);
                success2 = true;
            }
            finally {
                if (!success2) {
                    IndexWriter indexWriter = this;
                }
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", String.format(Locale.ROOT, "merged segment size=%.3f MB vs estimate=%.3f MB", (double)merge.info.sizeInBytes() / 1024.0 / 1024.0, (double)(merge.estimatedMergeBytes / 1024L) / 1024.0));
            }
            IndexReaderWarmer indexReaderWarmer = this.config.getMergedSegmentWarmer();
            if (this.poolReaders && indexReaderWarmer != null && merge.info.info.getDocCount() != 0) {
                ReadersAndUpdates rld = this.readerPool.get(merge.info, true);
                SegmentReader sr = rld.getReader(IOContext.READ);
                try {
                    indexReaderWarmer.warm(sr);
                    IndexWriter indexWriter = this;
                }
                catch (Throwable throwable) {
                    IndexWriter indexWriter = this;
                    // MONITORENTER : indexWriter
                    rld.release(sr);
                    this.readerPool.release(rld);
                    // MONITOREXIT : indexWriter
                    throw throwable;
                }
                rld.release(sr);
                this.readerPool.release(rld);
                // MONITOREXIT : indexWriter
            }
            if (!this.commitMerge(merge, mergeState)) {
                int n = 0;
                return n;
            }
            success = true;
            return merge.info.info.getDocCount();
        }
        finally {
            if (!success) {
                this.closeMergeReaders(merge, true);
            }
        }
    }

    synchronized void addMergeException(MergePolicy.OneMerge merge) {
        assert (merge.getException() != null);
        if (!this.mergeExceptions.contains(merge) && this.mergeGen == merge.mergeGen) {
            this.mergeExceptions.add(merge);
        }
    }

    final int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTermsSize();
    }

    final int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    synchronized SegmentCommitInfo newestSegment() {
        return this.segmentInfos.size() > 0 ? this.segmentInfos.info(this.segmentInfos.size() - 1) : null;
    }

    public synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    public synchronized String segString(Iterable<SegmentCommitInfo> infos) {
        StringBuilder buffer = new StringBuilder();
        for (SegmentCommitInfo info : infos) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(this.segString(info));
        }
        return buffer.toString();
    }

    public synchronized String segString(SegmentCommitInfo info) {
        return info.toString(info.info.dir, this.numDeletedDocs(info) - info.getDelCount());
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
    }

    void setKeepFullyDeletedSegments(boolean v) {
        this.keepFullyDeletedSegments = v;
    }

    boolean getKeepFullyDeletedSegments() {
        return this.keepFullyDeletedSegments;
    }

    private boolean filesExist(SegmentInfos toSync) throws IOException {
        Collection<String> files = toSync.files(this.directory, false);
        for (String fileName : files) {
            assert (IndexWriter.slowFileExists(this.directory, fileName)) : "file " + fileName + " does not exist; files=" + Arrays.toString(this.directory.listAll());
            assert (this.deleter.exists(fileName)) : "IndexFileDeleter doesn't know about file " + fileName;
        }
        return true;
    }

    synchronized SegmentInfos toLiveInfos(SegmentInfos sis) {
        SegmentInfos newSIS = new SegmentInfos();
        HashMap<SegmentCommitInfo, SegmentCommitInfo> liveSIS = new HashMap<SegmentCommitInfo, SegmentCommitInfo>();
        for (SegmentCommitInfo info : this.segmentInfos) {
            liveSIS.put(info, info);
        }
        for (SegmentCommitInfo info : sis) {
            SegmentCommitInfo liveInfo = (SegmentCommitInfo)liveSIS.get(info);
            if (liveInfo != null) {
                info = liveInfo;
            }
            newSIS.add(info);
        }
        return newSIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(SegmentInfos toSync) throws IOException {
        assert (this.testPoint("startStartCommit"));
        assert (this.pendingCommit == null);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
        }
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "startCommit(): start");
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                assert (this.lastCommitChangeCount <= this.changeCount) : "lastCommitChangeCount=" + this.lastCommitChangeCount + " changeCount=" + this.changeCount;
                if (this.pendingCommitChangeCount == this.lastCommitChangeCount) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "  skip startCommit(): no changes pending");
                    }
                    try {
                        this.deleter.decRef(this.filesToCommit);
                    }
                    finally {
                        this.filesToCommit = null;
                    }
                    return;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "startCommit index=" + this.segString(this.toLiveInfos(toSync)) + " changeCount=" + this.changeCount);
                }
                assert (this.filesExist(toSync));
            }
            assert (this.testPoint("midStartCommit"));
            boolean pendingCommitSet = false;
            try {
                Collection<String> filesToSync;
                assert (this.testPoint("midStartCommit2"));
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    assert (this.pendingCommit == null);
                    assert (this.segmentInfos.getGeneration() == toSync.getGeneration());
                    toSync.prepareCommit(this.directory);
                    pendingCommitSet = true;
                    this.pendingCommit = toSync;
                }
                boolean success = false;
                try {
                    filesToSync = toSync.files(this.directory, false);
                    this.directory.sync(filesToSync);
                    success = true;
                }
                finally {
                    if (!success) {
                        pendingCommitSet = false;
                        this.pendingCommit = null;
                        toSync.rollbackCommit(this.directory);
                    }
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "done all syncs: " + filesToSync);
                }
                assert (this.testPoint("midStartCommitSuccess"));
            }
            finally {
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    this.segmentInfos.updateGeneration(toSync);
                    if (!pendingCommitSet) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception committing segments file");
                        }
                        this.deleter.decRefWhileHandlingException(this.filesToCommit);
                        this.filesToCommit = null;
                    }
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "startCommit");
        }
        assert (this.testPoint("finishStartCommit"));
    }

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock(WRITE_LOCK_NAME).isLocked();
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock(WRITE_LOCK_NAME).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tragicEvent(Throwable tragedy, String location) {
        assert (!Thread.holdsLock(this));
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "hit " + tragedy.getClass().getSimpleName() + " inside " + location);
        }
        Object object = this;
        synchronized (object) {
            if (this.tragedy == null) {
                this.tragedy = tragedy;
            }
        }
        object = this.commitLock;
        synchronized (object) {
            if (!this.closing) {
                try {
                    this.rollback();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
        }
        IOUtils.reThrowUnchecked(tragedy);
    }

    private final boolean testPoint(String message) {
        if (this.infoStream.isEnabled("TP")) {
            this.infoStream.message("TP", message);
        }
        return true;
    }

    synchronized boolean nrtIsCurrent(SegmentInfos infos) {
        this.ensureOpen();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "nrtIsCurrent: infoVersion matches: " + (infos.version == this.segmentInfos.version) + "; DW changes: " + this.docWriter.anyChanges() + "; BD changes: " + this.bufferedUpdatesStream.any());
        }
        return infos.version == this.segmentInfos.version && !this.docWriter.anyChanges() && !this.bufferedUpdatesStream.any();
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void deleteUnusedFiles() throws IOException {
        this.ensureOpen(false);
        this.deleter.deletePendingFiles();
        this.deleter.revisitPolicy();
    }

    private synchronized void deletePendingFiles() throws IOException {
        this.deleter.deletePendingFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Collection<String> createCompoundFile(InfoStream infoStream, Directory directory, MergeState.CheckAbort checkAbort, SegmentInfo info, IOContext context) throws IOException {
        Set<String> files;
        String fileName;
        block16: {
            CompoundFileDirectory cfsDir;
            block15: {
                fileName = IndexFileNames.segmentFileName(info.name, "", "cfs");
                if (infoStream.isEnabled("IW")) {
                    infoStream.message("IW", "create compound file " + fileName);
                }
                assert (Lucene3xSegmentInfoFormat.getDocStoreOffset(info) == -1);
                files = info.files();
                cfsDir = new CompoundFileDirectory(directory, fileName, context, true);
                boolean success = false;
                try {
                    for (String file : files) {
                        directory.copy(cfsDir, file, file, context);
                        checkAbort.work(directory.fileLength(file));
                    }
                    success = true;
                    if (!success) break block15;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(cfsDir);
                    } else {
                        IOUtils.closeWhileHandlingException(cfsDir);
                        try {
                            directory.deleteFile(fileName);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            directory.deleteFile(IndexFileNames.segmentFileName(info.name, "", "cfe"));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                IOUtils.close(cfsDir);
                break block16;
            }
            IOUtils.closeWhileHandlingException(cfsDir);
            try {
                directory.deleteFile(fileName);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                directory.deleteFile(IndexFileNames.segmentFileName(info.name, "", "cfe"));
            }
            catch (Throwable t) {}
        }
        HashSet<String> siFiles = new HashSet<String>();
        siFiles.add(fileName);
        siFiles.add(IndexFileNames.segmentFileName(info.name, "", "cfe"));
        info.setFiles(siFiles);
        return files;
    }

    final synchronized void deleteNewFiles(Collection<String> files) throws IOException {
        this.deleter.deleteNewFiles(files);
    }

    final synchronized void flushFailed(SegmentInfo info) throws IOException {
        this.deleter.refresh(info.name);
    }

    final int purge(boolean forced) throws IOException {
        return this.docWriter.purgeBuffer(this, forced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void applyDeletesAndPurge(boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            this.applyAllDeletesAndUpdates();
            this.flushCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doAfterSegmentFlushed(boolean triggerMerge, boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            if (triggerMerge) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            }
        }
    }

    synchronized void incRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.incRef(segmentInfos, false);
    }

    synchronized void decRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.decRef(segmentInfos);
    }

    private boolean processEvents(boolean triggerMerge, boolean forcePurge) throws IOException {
        return this.processEvents(this.eventQueue, triggerMerge, forcePurge);
    }

    private boolean processEvents(Queue<Event> queue, boolean triggerMerge, boolean forcePurge) throws IOException {
        Event event;
        boolean processed = false;
        while ((event = queue.poll()) != null) {
            processed = true;
            event.process(this, triggerMerge, forcePurge);
        }
        return processed;
    }

    private static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    private void reserveDocs(int numDocs) {
        if (this.pendingNumDocs.addAndGet(numDocs) > (long)actualMaxDocs) {
            this.pendingNumDocs.addAndGet(-numDocs);
            throw new IllegalStateException("number of documents in the index cannot exceed " + actualMaxDocs);
        }
    }

    static interface Event {
        public void process(IndexWriter var1, boolean var2, boolean var3) throws IOException;
    }

    public static abstract class IndexReaderWarmer {
        protected IndexReaderWarmer() {
        }

        public abstract void warm(AtomicReader var1) throws IOException;
    }

    private static class MergedDeletesAndUpdates {
        ReadersAndUpdates mergedDeletesAndUpdates = null;
        MergePolicy.DocMap docMap = null;
        boolean initializedWritableLiveDocs = false;

        MergedDeletesAndUpdates() {
        }

        final void init(ReaderPool readerPool, MergePolicy.OneMerge merge, MergeState mergeState, boolean initWritableLiveDocs) throws IOException {
            if (this.mergedDeletesAndUpdates == null) {
                this.mergedDeletesAndUpdates = readerPool.get(merge.info, true);
                this.docMap = merge.getDocMap(mergeState);
                assert (this.docMap.isConsistent(merge.info.info.getDocCount()));
            }
            if (initWritableLiveDocs && !this.initializedWritableLiveDocs) {
                this.mergedDeletesAndUpdates.initWritableLiveDocs();
                this.initializedWritableLiveDocs = true;
            }
        }
    }

    class ReaderPool
    implements Closeable {
        private final Map<SegmentCommitInfo, ReadersAndUpdates> readerMap = new HashMap<SegmentCommitInfo, ReadersAndUpdates>();

        ReaderPool() {
        }

        public synchronized boolean infoIsLive(SegmentCommitInfo info) {
            int idx = IndexWriter.this.segmentInfos.indexOf(info);
            assert (idx != -1) : "info=" + info + " isn't live";
            assert (IndexWriter.this.segmentInfos.info(idx) == info) : "info=" + info + " doesn't match live info in segmentInfos";
            return true;
        }

        public synchronized void drop(SegmentCommitInfo info) throws IOException {
            ReadersAndUpdates rld = this.readerMap.get(info);
            if (rld != null) {
                assert (info == rld.info);
                this.readerMap.remove(info);
                rld.dropReaders();
            }
        }

        public synchronized boolean anyPendingDeletes() {
            for (ReadersAndUpdates rld : this.readerMap.values()) {
                if (rld.getPendingDeleteCount() == 0) continue;
                return true;
            }
            return false;
        }

        public synchronized void release(ReadersAndUpdates rld) throws IOException {
            this.release(rld, true);
        }

        public synchronized void release(ReadersAndUpdates rld, boolean assertInfoLive) throws IOException {
            rld.decRef();
            assert (rld.refCount() >= 1);
            if (!IndexWriter.this.poolReaders && rld.refCount() == 1) {
                if (rld.writeLiveDocs(IndexWriter.this.directory)) {
                    assert (!assertInfoLive || this.infoIsLive(rld.info));
                    IndexWriter.this.checkpointNoSIS();
                }
                rld.dropReaders();
                this.readerMap.remove(rld.info);
            }
        }

        @Override
        public void close() throws IOException {
            this.dropAll(false);
        }

        synchronized void dropAll(boolean doSave) throws IOException {
            Throwable priorE = null;
            Iterator<Map.Entry<SegmentCommitInfo, ReadersAndUpdates>> it = this.readerMap.entrySet().iterator();
            while (it.hasNext()) {
                ReadersAndUpdates rld;
                block10: {
                    rld = it.next().getValue();
                    try {
                        if (doSave && rld.writeLiveDocs(IndexWriter.this.directory)) {
                            assert (this.infoIsLive(rld.info));
                            IndexWriter.this.checkpointNoSIS();
                        }
                    }
                    catch (Throwable t) {
                        if (doSave) {
                            IOUtils.reThrow(t);
                        }
                        if (priorE != null) break block10;
                        priorE = t;
                    }
                }
                it.remove();
                try {
                    rld.dropReaders();
                }
                catch (Throwable t) {
                    if (doSave) {
                        IOUtils.reThrow(t);
                        continue;
                    }
                    if (priorE != null) continue;
                    priorE = t;
                }
            }
            assert (this.readerMap.size() == 0);
            IOUtils.reThrow(priorE);
        }

        public synchronized void commit(SegmentInfos infos) throws IOException {
            for (SegmentCommitInfo info : infos) {
                ReadersAndUpdates rld = this.readerMap.get(info);
                if (rld == null) continue;
                assert (rld.info == info);
                if (!rld.writeLiveDocs(IndexWriter.this.directory)) continue;
                assert (this.infoIsLive(info));
                IndexWriter.this.checkpointNoSIS();
            }
        }

        public synchronized ReadersAndUpdates get(SegmentCommitInfo info, boolean create) {
            assert (info.info.dir == IndexWriter.this.directory) : "info.dir=" + info.info.dir + " vs " + IndexWriter.access$100(IndexWriter.this);
            ReadersAndUpdates rld = this.readerMap.get(info);
            if (rld == null) {
                if (!create) {
                    return null;
                }
                rld = new ReadersAndUpdates(IndexWriter.this, info);
                this.readerMap.put(info, rld);
            } else assert (rld.info == info) : "rld.info=" + rld.info + " info=" + info + " isLive?=" + this.infoIsLive(rld.info) + " vs " + this.infoIsLive(info);
            if (create) {
                rld.incRef();
            }
            assert (this.noDups());
            return rld;
        }

        private boolean noDups() {
            HashSet<String> seen = new HashSet<String>();
            for (SegmentCommitInfo info : this.readerMap.keySet()) {
                assert (!seen.contains(info.info.name));
                seen.add(info.info.name);
            }
            return true;
        }
    }
}

