/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.EliasFanoDecoder;
import org.apache.lucene.util.packed.EliasFanoEncoder;

public class EliasFanoDocIdSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(EliasFanoDocIdSet.class);
    final EliasFanoEncoder efEncoder;

    public EliasFanoDocIdSet(int numValues, int upperBound) {
        this.efEncoder = new EliasFanoEncoder(numValues, upperBound);
    }

    public static boolean sufficientlySmallerThanBitSet(long numValues, long upperBound) {
        return EliasFanoEncoder.sufficientlySmallerThanBitSet(numValues, upperBound);
    }

    public void encodeFromDisi(DocIdSetIterator disi) throws IOException {
        while (this.efEncoder.numEncoded < this.efEncoder.numValues) {
            int x = disi.nextDoc();
            if (x == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("disi: " + disi.toString() + "\nhas " + this.efEncoder.numEncoded + " docs, but at least " + this.efEncoder.numValues + " are required.");
            }
            this.efEncoder.encodeNext(x);
        }
    }

    @Override
    public DocIdSetIterator iterator() {
        if (this.efEncoder.lastEncoded >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Highest encoded value too high for DocIdSetIterator.NO_MORE_DOCS: " + this.efEncoder.lastEncoded);
        }
        return new DocIdSetIterator(){
            private int curDocId = -1;
            private final EliasFanoDecoder efDecoder;
            {
                this.efDecoder = EliasFanoDocIdSet.this.efEncoder.getDecoder();
            }

            @Override
            public int docID() {
                return this.curDocId;
            }

            private int setCurDocID(long value) {
                this.curDocId = value == -1L ? Integer.MAX_VALUE : (int)value;
                return this.curDocId;
            }

            @Override
            public int nextDoc() {
                return this.setCurDocID(this.efDecoder.nextValue());
            }

            @Override
            public int advance(int target) {
                return this.setCurDocID(this.efDecoder.advanceToValue((long)target));
            }

            @Override
            public long cost() {
                return this.efDecoder.numEncoded();
            }
        };
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public boolean equals(Object other) {
        return other instanceof EliasFanoDocIdSet && this.efEncoder.equals(((EliasFanoDocIdSet)other).efEncoder);
    }

    public int hashCode() {
        return this.efEncoder.hashCode() ^ this.getClass().hashCode();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.efEncoder.ramBytesUsed();
    }
}

