/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.ProductLevel;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;

public class NetDatabaseMetaData
extends DatabaseMetaData {
    private boolean supportsQryclsimp_;
    private boolean supportsLayerBStreaming_;
    private boolean supportsSessionDataCaching_;

    public NetDatabaseMetaData(NetAgent netAgent, NetConnection netConnection) {
        super(netAgent, netConnection, new ProductLevel(netConnection.productID_, netConnection.targetSrvclsnm_, netConnection.targetSrvrlslv_));
    }

    public String getURL_() throws SqlException {
        String urlProtocol = "jdbc:derby://";
        return urlProtocol + this.connection_.serverNameIP_ + ":" + this.connection_.portNumber_ + "/" + this.connection_.databaseName_;
    }

    protected void computeFeatureSet_() {
        this.supportsQryclsimp_ = this.productLevel_.greaterThanOrEqualTo(10, 2, 0);
        this.supportsLayerBStreaming_ = this.productLevel_.greaterThanOrEqualTo(10, 3, 0);
        this.supportsSessionDataCaching_ = this.productLevel_.greaterThanOrEqualTo(10, 4, 0);
    }

    final boolean serverSupportsQryclsimp() {
        return this.supportsQryclsimp_;
    }

    final boolean serverSupportsLayerBStreaming() {
        return this.supportsLayerBStreaming_;
    }

    final boolean serverSupportsSessionDataCaching() {
        return this.supportsSessionDataCaching_;
    }
}

