/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;

public class HttpClientUtil {
    public static void formUrlEncode(String s, StringBuilder buf) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                buf.append('+');
                continue;
            }
            char cInt = c;
            if (cInt >= '0' && cInt <= '9' || cInt >= 'A' && cInt <= 'Z' || cInt >= 'a' && cInt <= 'z') {
                buf.append(c);
                continue;
            }
            buf.append('%');
            String hexVal = Integer.toHexString(c);
            if (hexVal.length() == 1) {
                buf.append('0');
            }
            buf.append(hexVal);
        }
    }

    public static String formUrlEncode(String s) {
        StringBuilder result = new StringBuilder(s.length() + 10);
        HttpClientUtil.formUrlEncode(s, result);
        return result.toString();
    }

    public static final String appendParameter(String url, String parameterName, String parameterValue) {
        StringBuilder result = new StringBuilder(url);
        if (url.indexOf(63) >= 0) {
            result.append('&');
        } else {
            result.append('?');
        }
        result.append(HttpClientUtil.encodeParameter(parameterName, parameterValue));
        return result.toString();
    }

    public static String encodeParameter(String parameterName, String parameterValue) {
        StringBuilder result = new StringBuilder();
        try {
            result.append(URLEncoder.encode(parameterName, "UTF-8"));
            result.append('=');
            result.append(URLEncoder.encode(parameterValue, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result.toString();
    }

    public static void setAcceptGZIPEncoding(URLConnection conn) {
        conn.setRequestProperty("Accept-Encoding", "gzip");
    }

    public static InputStream getInputStream(URLConnection conn) throws IOException {
        InputStream responseStream = conn.getInputStream();
        String contentEncoding = conn.getContentEncoding();
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            responseStream = new GZIPInputStream(responseStream);
        }
        return responseStream;
    }

    public static boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

