/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPSyntaxSchema
extends LDAPSchemaElement
implements Externalizable {
    public LDAPSyntaxSchema() {
        super(LDAPSchema.schemaTypeNames[2]);
    }

    public LDAPSyntaxSchema(String string) {
        super(LDAPSchema.schemaTypeNames[2]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public LDAPSyntaxSchema(String string, String string2) {
        super(LDAPSchema.schemaTypeNames[2]);
        this.oid = string;
        this.description = string2;
        super.setValue(this.formatString());
    }

    protected String formatString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray = this.getQualifier(string2);
                if (stringArray == null || stringArray.length <= 1) continue;
                stringBuffer.append("( ");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray[i] + "'");
                }
                if (stringArray.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPSyntaxSchema lDAPSyntaxSchema = (LDAPSyntaxSchema)LDAPSyntaxSchema.readDSML(bufferedInputStream);
        this.oid = lDAPSyntaxSchema.oid;
        this.names = lDAPSyntaxSchema.getNames();
        this.obsolete = lDAPSyntaxSchema.obsolete;
        this.description = lDAPSyntaxSchema.description;
        Enumeration enumeration = lDAPSyntaxSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPSyntaxSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        super.setValue(this.formatString());
        lDAPSyntaxSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.getID();
        Enumeration enumeration = this.getQualifierNames();
        String string2 = (String)enumeration.nextElement();
        String[] stringArray = this.getQualifier(string2);
        String string3 = "( " + string + " " + string2 + " '" + stringArray[0] + "' )";
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string3);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.getID();
        Enumeration enumeration = this.getQualifierNames();
        String string2 = (String)enumeration.nextElement();
        String[] stringArray = this.getQualifier(string2);
        String string3 = "( " + string + " " + string2 + " '" + stringArray[0] + "' )";
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string3);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPSyntaxSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPSyntaxSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPSyntaxSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPSyntaxSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPSyntaxSchema lDAPSyntaxSchema = new LDAPSyntaxSchema(this.attrName);
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    if (schemaParser.getID() != null) {
                        lDAPSyntaxSchema.oid = schemaParser.getID();
                    }
                    if (schemaParser.getDescription() != null) {
                        lDAPSyntaxSchema.description = schemaParser.getDescription();
                    }
                    Enumeration enumeration = schemaParser.getQualifiers();
                    while (enumeration.hasMoreElements()) {
                        AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                        lDAPSyntaxSchema.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
                    }
                    lDAPSyntaxSchema.setValue(lDAPSyntaxSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPSyntaxSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }
}

