/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.BpelInstanceWorkerCache;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.DbBackedMessageImpl;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.InterceptorContextImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeCache;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.NStateLatch;
import org.apache.ode.bpel.engine.PartnerLinkMyRoleImpl;
import org.apache.ode.bpel.engine.PartnerLinkPartnerRoleImpl;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ReliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.engine.TransactedMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.UnreliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.engine.extvar.ExternalVariableConf;
import org.apache.ode.bpel.engine.extvar.ExternalVariableManager;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.FailMessageExchangeException;
import org.apache.ode.bpel.intercept.FaultMessageExchangeException;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.rapi.ConstantsModel;
import org.apache.ode.bpel.rapi.FaultInfo;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRuntime;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.Serializer;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODEProcess {
    static final Log __log = LogFactory.getLog(ODEProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private volatile Map<PartnerLinkModel, PartnerLinkPartnerRoleImpl> _partnerRoles;
    private volatile Map<PartnerLinkModel, PartnerLinkMyRoleImpl> _myRoles;
    private volatile Map<Endpoint, PartnerLinkMyRoleImpl> _endpointToMyRoleMap;
    private Map<Endpoint, EndpointReference> _myEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, EndpointReference> _partnerEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, PartnerRoleChannel> _partnerChannels = new HashMap<Endpoint, PartnerRoleChannel>();
    private SharedEndpoints _sharedEps;
    final QName _pid;
    private volatile ProcessModel _processModel;
    private boolean _hydratedOnce = false;
    private volatile long _lastUsed;
    volatile OdeRuntime _runtime;
    DebuggerSupport _debugger;
    final ProcessConf _pconf;
    private final List<MessageExchangeInterceptor> _mexInterceptors = new ArrayList<MessageExchangeInterceptor>();
    HydrationLatch _hydrationLatch;
    protected Contexts _contexts;
    final BpelInstanceWorkerCache _instanceWorkerCache = new BpelInstanceWorkerCache(this);
    private final Set<InvocationStyle> _invocationStyles;
    private final BpelDAOConnectionFactoryImpl _inMemDao;
    final BpelServerImpl _server;
    private MyRoleMessageExchangeCache _myRoleMexCache;
    private ExternalVariableConf _extVarConf;
    private ExternalVariableManager _evm;

    ODEProcess(BpelServerImpl bpelServerImpl, ProcessConf processConf, BpelEventListener bpelEventListener, MyRoleMessageExchangeCache myRoleMessageExchangeCache) {
        this._server = bpelServerImpl;
        this._pid = processConf.getProcessId();
        this._pconf = processConf;
        this._hydrationLatch = new HydrationLatch();
        this._contexts = bpelServerImpl._contexts;
        this._inMemDao = new BpelDAOConnectionFactoryImpl(this._contexts.txManager);
        this._myRoleMexCache = myRoleMessageExchangeCache;
        HashSet<InvocationStyle> hashSet = new HashSet<InvocationStyle>();
        hashSet.add(InvocationStyle.UNRELIABLE);
        if (!processConf.isTransient()) {
            hashSet.add(InvocationStyle.RELIABLE);
        } else {
            hashSet.add(InvocationStyle.TRANSACTED);
        }
        this._invocationStyles = Collections.unmodifiableSet(hashSet);
    }

    public URI getBaseResourceURI() {
        return this._pconf.getBaseURI();
    }

    void initExternalVariables() {
        List list = this._pconf.getExtensionElement(ExternalVariableConf.EXTVARCONF_ELEMENT);
        this._extVarConf = new ExternalVariableConf(list);
        this._evm = new ExternalVariableManager(this._pid, this._extVarConf, this._contexts.externalVariableEngines);
    }

    public OdeConfigProperties getProperties() {
        return this._server.getConfigProperties();
    }

    public String toString() {
        return "ODEProcess[" + this._pid + "]";
    }

    public ExternalVariableManager getEVM() {
        return this._evm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverActivity(ProcessInstanceDAO processInstanceDAO, final String string, final long l, final String string2, final FaultInfo faultInfo) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Recovering activity in process " + processInstanceDAO.getInstanceId() + " with action " + string2));
        }
        this._hydrationLatch.latch(1);
        try {
            this.markused();
            BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(processInstanceDAO.getInstanceId());
            OdeRTInstance odeRTInstance = this._runtime.newInstance(this.getState(bpelInstanceWorker, processInstanceDAO));
            final BpelRuntimeContextImpl bpelRuntimeContextImpl = new BpelRuntimeContextImpl(bpelInstanceWorker, processInstanceDAO, odeRTInstance);
            try {
                bpelInstanceWorker.execInCurrentThread(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        bpelRuntimeContextImpl.recoverActivity(string, l, string2, faultInfo);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                throw new BpelEngineException((Throwable)exception);
            }
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeProcess(final MessageExchangeDAO messageExchangeDAO) {
        block30: {
            Document document;
            Object object;
            InvocationStyle invocationStyle = messageExchangeDAO.getInvocationStyle();
            ConstantsModel constantsModel = null;
            this._hydrationLatch.latch(1);
            try {
                PartnerLinkMyRoleImpl partnerLinkMyRoleImpl = this.getMyRoleForService(messageExchangeDAO.getCallee());
                constantsModel = partnerLinkMyRoleImpl._process.getProcessModel().getConstantsModel();
                object = messageExchangeDAO.getStatus();
                if (partnerLinkMyRoleImpl == null) {
                    String string = __msgs.msgMyRoleRoutingFailure(messageExchangeDAO.getMessageExchangeId());
                    __log.error((Object)string);
                    MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.UNKNOWN_ENDPOINT, string);
                    this.onMyRoleMexAck(messageExchangeDAO, (MessageExchange.Status)object);
                    return;
                }
                document = partnerLinkMyRoleImpl._plinkDef.getMyRoleOperation(messageExchangeDAO.getOperation());
                if (document == null) {
                    String string = __msgs.msgMyRoleRoutingFailure(messageExchangeDAO.getMessageExchangeId());
                    __log.error((Object)string);
                    MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.UNKNOWN_OPERATION, string);
                    this.onMyRoleMexAck(messageExchangeDAO, (MessageExchange.Status)object);
                    return;
                }
                messageExchangeDAO.setPattern(document.getOutput() == null ? MessageExchange.MessageExchangePattern.REQUEST_ONLY : MessageExchange.MessageExchangePattern.REQUEST_RESPONSE);
                if (!this.processInterceptors(messageExchangeDAO, InterceptorInvoker.__onProcessInvoked)) {
                    __log.debug((Object)("Aborting processing of mex " + messageExchangeDAO.getMessageExchangeId() + " due to interceptors."));
                    this.onMyRoleMexAck(messageExchangeDAO, (MessageExchange.Status)object);
                    return;
                }
                if (document.getOutput() == null) {
                    messageExchangeDAO.setStatus(MessageExchange.Status.ACK);
                    messageExchangeDAO.setAckType(MessageExchange.AckType.ONEWAY);
                    this.onMyRoleMexAck(messageExchangeDAO, (MessageExchange.Status)object);
                }
                messageExchangeDAO.setProcess(this.getProcessDAO());
                this.markused();
                MyRoleMessageExchange.CorrelationStatus correlationStatus = partnerLinkMyRoleImpl.invokeMyRole(messageExchangeDAO);
                if (correlationStatus == null) {
                } else if (correlationStatus == MyRoleMessageExchange.CorrelationStatus.CREATE_INSTANCE) {
                    this.doInstanceWork(messageExchangeDAO.getInstance().getInstanceId(), new Callable<Void>(){

                        @Override
                        public Void call() {
                            ODEProcess.this.executeCreateInstance(messageExchangeDAO);
                            return null;
                        }
                    });
                } else if (correlationStatus == MyRoleMessageExchange.CorrelationStatus.MATCHED) {
                    if (this.isInMemory()) {
                        __log.warn((Object)("In-memory process " + this._pid + " is participating in a non-createinstance exchange!"));
                    }
                    if (invocationStyle == InvocationStyle.TRANSACTED) {
                        this.doInstanceWork(messageExchangeDAO.getInstance().getInstanceId(), new Callable<Void>(){

                            @Override
                            public Void call() {
                                ODEProcess.this.executeContinueInstanceMyRoleRequestReceived(messageExchangeDAO);
                                return null;
                            }
                        });
                    } else if (invocationStyle == InvocationStyle.P2P_TRANSACTED) {
                        this.executeContinueInstanceMyRoleRequestReceived(messageExchangeDAO);
                    } else {
                        WorkEvent workEvent = new WorkEvent();
                        workEvent.setType(WorkEvent.Type.MYROLE_INVOKE);
                        workEvent.setIID(messageExchangeDAO.getInstance().getInstanceId());
                        workEvent.setMexId(messageExchangeDAO.getMessageExchangeId());
                        workEvent.setProcessId(messageExchangeDAO.getInstance().getProcess().getProcessId());
                        this.scheduleWorkEvent(workEvent, null);
                    }
                } else if (correlationStatus == MyRoleMessageExchange.CorrelationStatus.QUEUED) {
                    // empty if block
                }
            }
            catch (InvalidProcessException invalidProcessException) {
                object = null;
                if (constantsModel != null) {
                    document = DOMUtils.newDocument();
                    Element element = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                    Element element2 = document.createElementNS("http://www.apache.org/ode/type/extension", "fault");
                    element.appendChild(element2);
                    switch (invalidProcessException.getCauseCode()) {
                        case 2: {
                            object = constantsModel.getDuplicateInstance();
                            element2.setTextContent("Found a duplicate instance with the same message key");
                            break;
                        }
                        case 1: {
                            object = constantsModel.getRetiredProcess();
                            element2.setTextContent("The process you're trying to instantiate has been retired");
                            break;
                        }
                        default: {
                            object = constantsModel.getUnknownFault();
                        }
                    }
                    MexDaoUtil.setFaulted(messageExchangeDAO, (QName)object, element);
                }
            }
            finally {
                this._hydrationLatch.release(1);
                if (messageExchangeDAO.getStatus() != MessageExchange.Status.ACK) {
                    messageExchangeDAO.setStatus(MessageExchange.Status.ASYNC);
                }
                if ($assertionsDisabled || messageExchangeDAO.getStatus() == MessageExchange.Status.ACK || messageExchangeDAO.getStatus() == MessageExchange.Status.ASYNC) break block30;
                throw new AssertionError();
            }
        }
    }

    void executeCreateInstance(MessageExchangeDAO messageExchangeDAO) {
        assert (this._hydrationLatch.isLatched(1));
        BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(messageExchangeDAO.getInstance().getInstanceId());
        assert (bpelInstanceWorker.isWorkerThread());
        BpelRuntimeContextImpl bpelRuntimeContextImpl = new BpelRuntimeContextImpl(bpelInstanceWorker, messageExchangeDAO.getInstance(), this._runtime.newInstance(this.getState(bpelInstanceWorker, messageExchangeDAO.getInstance())));
        bpelRuntimeContextImpl.executeCreateInstance(messageExchangeDAO);
    }

    void executeContinueInstanceMyRoleRequestReceived(MessageExchangeDAO messageExchangeDAO) {
        assert (this._hydrationLatch.isLatched(1));
        BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(messageExchangeDAO.getInstance().getInstanceId());
        assert (bpelInstanceWorker.isWorkerThread());
        OdeRTInstance odeRTInstance = this._runtime.newInstance(this.getState(bpelInstanceWorker, messageExchangeDAO.getInstance()));
        BpelRuntimeContextImpl bpelRuntimeContextImpl = new BpelRuntimeContextImpl(bpelInstanceWorker, messageExchangeDAO.getInstance(), odeRTInstance);
        int n = messageExchangeDAO.getChannel().indexOf(38);
        String string = messageExchangeDAO.getChannel().substring(0, n);
        int n2 = Integer.valueOf(messageExchangeDAO.getChannel().substring(n + 1));
        bpelRuntimeContextImpl.injectMyRoleMessageExchange(string, n2, messageExchangeDAO);
        bpelRuntimeContextImpl.execute();
    }

    void executeContinueInstanceResume(ProcessInstanceDAO processInstanceDAO, int n) {
        BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(processInstanceDAO.getInstanceId());
        assert (bpelInstanceWorker.isWorkerThread());
        OdeRTInstance odeRTInstance = this._runtime.newInstance(this.getState(bpelInstanceWorker, processInstanceDAO));
        BpelRuntimeContextImpl bpelRuntimeContextImpl = new BpelRuntimeContextImpl(bpelInstanceWorker, processInstanceDAO, odeRTInstance);
        bpelRuntimeContextImpl.setRetryCount(n);
        bpelRuntimeContextImpl.execute();
    }

    void executeContinueInstanceTimerReceived(ProcessInstanceDAO processInstanceDAO, String string) {
        BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(processInstanceDAO.getInstanceId());
        assert (bpelInstanceWorker.isWorkerThread());
        OdeRTInstance odeRTInstance = this._runtime.newInstance(this.getState(bpelInstanceWorker, processInstanceDAO));
        BpelRuntimeContextImpl bpelRuntimeContextImpl = new BpelRuntimeContextImpl(bpelInstanceWorker, processInstanceDAO, odeRTInstance);
        if (bpelRuntimeContextImpl.injectTimerEvent(string)) {
            bpelRuntimeContextImpl.execute();
        }
    }

    private void executeContinueInstanceMatcherEvent(ProcessInstanceDAO processInstanceDAO, String string, CorrelationKey correlationKey) {
        CorrelatorDAO correlatorDAO;
        MessageRouteDAO messageRouteDAO;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("MatcherEvent handling: correlatorId=" + string + ", ckey=" + correlationKey));
        }
        if ((messageRouteDAO = (correlatorDAO = processInstanceDAO.getProcess().getCorrelator(string)).findRoute(correlationKey)) == null) {
            __log.debug((Object)"MatcherEvent handling: nothing to do, route no longer in DB");
            return;
        }
        MessageExchangeDAO messageExchangeDAO = correlatorDAO.dequeueMessage(correlationKey);
        if (messageExchangeDAO != null) {
            __log.debug((Object)"MatcherEvent handling: found matching message in DB (i.e. message arrived before <receive>)");
            correlatorDAO.removeRoutes(messageRouteDAO.getGroupId(), processInstanceDAO);
            messageExchangeDAO.setInstance(processInstanceDAO);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("SELECT: " + messageRouteDAO.getGroupId() + ": matched to MESSAGE " + messageExchangeDAO + " on CKEY " + correlationKey));
            }
            BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(processInstanceDAO.getInstanceId());
            assert (bpelInstanceWorker.isWorkerThread());
            OdeRTInstance odeRTInstance = this._runtime.newInstance(this.getState(bpelInstanceWorker, messageExchangeDAO.getInstance()));
            BpelRuntimeContextImpl bpelRuntimeContextImpl = new BpelRuntimeContextImpl(bpelInstanceWorker, processInstanceDAO, odeRTInstance);
            bpelRuntimeContextImpl.injectMyRoleMessageExchange(messageRouteDAO.getGroupId(), messageRouteDAO.getIndex(), messageExchangeDAO);
            bpelRuntimeContextImpl.execute();
        } else {
            __log.debug((Object)"MatcherEvent handling: nothing to do, no matching message in DB");
        }
    }

    void executeContinueInstancePartnerRoleResponseReceived(MessageExchangeDAO messageExchangeDAO) {
        assert (this._hydrationLatch.isLatched(1));
        ProcessInstanceDAO processInstanceDAO = messageExchangeDAO.getInstance();
        if (processInstanceDAO == null) {
            throw new BpelEngineException("InternalError: No instance for partner mex " + messageExchangeDAO);
        }
        BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(messageExchangeDAO.getInstance().getInstanceId());
        assert (bpelInstanceWorker.isWorkerThread());
        OdeRTInstance odeRTInstance = this._runtime.newInstance(this.getState(bpelInstanceWorker, messageExchangeDAO.getInstance()));
        BpelRuntimeContextImpl bpelRuntimeContextImpl = new BpelRuntimeContextImpl(bpelInstanceWorker, messageExchangeDAO.getInstance(), odeRTInstance);
        String string = messageExchangeDAO.getProperty("invokeCheckJobId");
        this._contexts.scheduler.cancelJob(string);
        bpelRuntimeContextImpl.injectPartnerResponse(messageExchangeDAO.getMessageExchangeId(), messageExchangeDAO.getChannel());
        bpelRuntimeContextImpl.execute();
    }

    void enqueueInstanceTransaction(Long l, Runnable runnable) {
        if (l == null) {
            throw new NullPointerException("instanceId was null!");
        }
        BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(l);
        BpelServerImpl bpelServerImpl = this._server;
        bpelServerImpl.getClass();
        bpelInstanceWorker.enqueue(bpelServerImpl.new BpelServerImpl.TransactedRunnable(runnable));
    }

    private <T> T doInstanceWork(Long l, Callable<T> callable) {
        try {
            BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(l);
            return bpelInstanceWorker.execInCurrentThread(new ProcessCallable<T>(callable));
        }
        catch (Exception exception) {
            throw new BpelEngineException((Throwable)exception);
        }
    }

    private PartnerLinkMyRoleImpl getMyRoleForService(QName qName) {
        assert (this._hydrationLatch.isLatched(1));
        for (Map.Entry<Endpoint, PartnerLinkMyRoleImpl> entry : this._endpointToMyRoleMap.entrySet()) {
            if (!entry.getKey().serviceName.equals(qName)) continue;
            return entry.getValue();
        }
        return null;
    }

    boolean processInterceptors(MessageExchangeDAO messageExchangeDAO, InterceptorInvoker interceptorInvoker) {
        InterceptorContextImpl interceptorContextImpl = new InterceptorContextImpl(this._contexts.dao.getConnection(), messageExchangeDAO, this.getProcessDAO(), this._pconf);
        try {
            for (MessageExchangeInterceptor messageExchangeInterceptor : this._mexInterceptors) {
                interceptorInvoker.invoke(messageExchangeInterceptor, interceptorContextImpl);
            }
            for (MessageExchangeInterceptor messageExchangeInterceptor : this._server._contexts.globalIntereceptors) {
                interceptorInvoker.invoke(messageExchangeInterceptor, interceptorContextImpl);
            }
        }
        catch (FailMessageExchangeException failMessageExchangeException) {
            MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.ABORTED, failMessageExchangeException.getMessage());
            return false;
        }
        catch (FaultMessageExchangeException faultMessageExchangeException) {
            MexDaoUtil.setFaulted(messageExchangeDAO, faultMessageExchangeException.getFaultName(), faultMessageExchangeException.getFaultData());
            return false;
        }
        return true;
    }

    void handleWorkEvent(final Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        assert (!this._contexts.isTransacted()) : "work events must be received outside of a transaction";
        this.markused();
        final WorkEvent workEvent = new WorkEvent(jobInfo.jobDetail);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)ObjectPrinter.stringifyMethodEnter((String)"handleWorkEvent", (Object[])new Object[]{"jobInfo", jobInfo}));
        }
        this.enqueueInstanceTransaction(workEvent.getIID(), new Runnable(){

            public void run() {
                ODEProcess.this._contexts.scheduler.jobCompleted(jobInfo.jobName);
                ODEProcess.this.execInstanceEvent(workEvent);
            }
        });
    }

    <T> Future<T> enqueueTransaction(Callable<T> callable) {
        return this._server.enqueueTransaction(new ProcessCallable<T>(callable));
    }

    private Object getState(BpelInstanceWorker bpelInstanceWorker, ProcessInstanceDAO processInstanceDAO) {
        ExecutionQueueImpl executionQueueImpl = (ExecutionQueueImpl)bpelInstanceWorker.getCachedState(processInstanceDAO.getExecutionStateCounter());
        if (executionQueueImpl != null) {
            return executionQueueImpl;
        }
        if (this.isInMemory()) {
            ProcessInstanceDaoImpl processInstanceDaoImpl = (ProcessInstanceDaoImpl)processInstanceDAO;
            if (processInstanceDaoImpl.getSoup() != null) {
                executionQueueImpl = (ExecutionQueueImpl)processInstanceDaoImpl.getSoup();
            }
        } else {
            byte[] byArray = processInstanceDAO.getExecutionState();
            if (byArray != null) {
                executionQueueImpl = new ExecutionQueueImpl(this.getClass().getClassLoader());
                executionQueueImpl.setReplacementMap((ReplacementMap)this._runtime.getReplacementMap(processInstanceDAO.getProcess().getProcessId()));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    executionQueueImpl.read((InputStream)byteArrayInputStream);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        return executionQueueImpl;
    }

    private void execInstanceEvent(WorkEvent workEvent) {
        MessageExchangeDAO messageExchangeDAO;
        BpelInstanceWorker bpelInstanceWorker = this._instanceWorkerCache.get(workEvent.getIID());
        assert (bpelInstanceWorker.isWorkerThread());
        ProcessInstanceDAO processInstanceDAO = this.getProcessDAO().getInstance(workEvent.getIID());
        MessageExchangeDAO messageExchangeDAO2 = messageExchangeDAO = workEvent.getMexId() == null ? null : this.loadMexDao(workEvent.getMexId());
        if (processInstanceDAO == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("handleWorkEvent: no ProcessInstance found with iid " + workEvent.getIID() + "; ignoring."));
            }
            return;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("handleWorkEvent: " + (Object)((Object)workEvent.getType()) + " event for process instance " + workEvent.getIID()));
        }
        switch (workEvent.getType()) {
            case MYROLE_INVOKE: {
                this.executeContinueInstanceMyRoleRequestReceived(messageExchangeDAO);
                break;
            }
            case TIMER: {
                this.executeContinueInstanceTimerReceived(processInstanceDAO, workEvent.getChannel());
                break;
            }
            case RESUME: {
                this.executeContinueInstanceResume(processInstanceDAO, workEvent.getRetryCount());
                break;
            }
            case PARTNER_RESPONSE: {
                this.executeContinueInstancePartnerRoleResponseReceived(messageExchangeDAO);
                break;
            }
            case MATCHER: {
                this.executeContinueInstanceMatcherEvent(processInstanceDAO, workEvent.getCorrelatorId(), workEvent.getCorrelationKey());
            }
        }
    }

    MessageExchangeDAO loadMexDao(String string) {
        return this.isInMemory() ? this._inMemDao.getConnection().getMessageExchange(string) : this._contexts.dao.getConnection().getMessageExchange(string);
    }

    private void setRoles(ProcessModel processModel) {
        PartnerLinkModel partnerLinkModel;
        this._partnerRoles = new HashMap<PartnerLinkModel, PartnerLinkPartnerRoleImpl>();
        this._myRoles = new HashMap<PartnerLinkModel, PartnerLinkMyRoleImpl>();
        this._endpointToMyRoleMap = new HashMap<Endpoint, PartnerLinkMyRoleImpl>();
        HashMap hashMap = new HashMap();
        for (Map.Entry object : this._pconf.getProvideEndpoints().entrySet()) {
            partnerLinkModel = processModel.getPartnerLink((String)object.getKey());
            if (partnerLinkModel == null) {
                String string = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)object.getKey();
                __log.error((Object)string);
                throw new BpelEngineException(string);
            }
            hashMap.put(partnerLinkModel, object.getValue());
        }
        for (Map.Entry entry : this._pconf.getInvokeEndpoints().entrySet()) {
            partnerLinkModel = processModel.getPartnerLink((String)entry.getKey());
            if (partnerLinkModel == null) {
                String string = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)entry.getKey();
                __log.error((Object)string);
                throw new BpelEngineException(string);
            }
            __log.debug((Object)("Processing <invoke> element for process " + this._pid + ": partnerlink " + (String)entry.getKey() + " --> " + entry.getValue()));
        }
        for (PartnerLinkModel partnerLinkModel2 : processModel.getAllPartnerLinks()) {
            PartnerLinkRoleImpl partnerLinkRoleImpl;
            if (partnerLinkModel2.hasMyRole()) {
                partnerLinkModel = (Endpoint)hashMap.get(partnerLinkModel2);
                if (partnerLinkModel == null) {
                    throw new IllegalArgumentException("No service name for myRole plink " + partnerLinkModel2.getName());
                }
                partnerLinkRoleImpl = new PartnerLinkMyRoleImpl(this, partnerLinkModel2, (Endpoint)partnerLinkModel);
                this._myRoles.put(partnerLinkModel2, (PartnerLinkMyRoleImpl)partnerLinkRoleImpl);
                this._endpointToMyRoleMap.put((Endpoint)partnerLinkModel, (PartnerLinkMyRoleImpl)partnerLinkRoleImpl);
            }
            if (!partnerLinkModel2.hasPartnerRole()) continue;
            partnerLinkModel = (Endpoint)this._pconf.getInvokeEndpoints().get(partnerLinkModel2.getName());
            if (partnerLinkModel == null && partnerLinkModel2.isInitializePartnerRoleSet()) {
                throw new IllegalArgumentException(partnerLinkModel2.getName() + " must be bound to an endpoint in deloy.xml");
            }
            partnerLinkRoleImpl = new PartnerLinkPartnerRoleImpl(this, partnerLinkModel2, (Endpoint)partnerLinkModel);
            this._partnerRoles.put(partnerLinkModel2, (PartnerLinkPartnerRoleImpl)partnerLinkRoleImpl);
        }
    }

    ProcessDAO getProcessDAO() {
        return this.isInMemory() ? this._inMemDao.getConnection().getProcess(this._pid) : this._contexts.dao.getConnection().getProcess(this._pid);
    }

    static String genCorrelatorId(PartnerLinkModel partnerLinkModel, String string) {
        return partnerLinkModel.getId() + "." + string;
    }

    public Set<Endpoint> getServiceNames() {
        HashSet<Endpoint> hashSet = new HashSet<Endpoint>();
        for (Endpoint endpoint : this._pconf.getProvideEndpoints().values()) {
            hashSet.add(endpoint);
        }
        return hashSet;
    }

    void activate(Contexts contexts) {
        this._contexts = contexts;
        this._debugger = new DebuggerSupport(this);
        __log.debug((Object)("Activating " + this._pid));
        for (Map.Entry entry : this._pconf.getProvideEndpoints().entrySet()) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            EndpointReference endpointReference = null;
            if (this.isShareable(endpoint)) {
                endpointReference = this._sharedEps.getEndpointReference(endpoint);
                if (endpointReference == null) {
                    endpointReference = this._contexts.bindingContext.activateMyRoleEndpoint(this._pid, (Endpoint)entry.getValue());
                    this._sharedEps.addEndpoint(endpoint, endpointReference);
                    __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + endpointReference));
                }
                this._sharedEps.incrementReferenceCount(endpoint);
            } else {
                endpointReference = this._contexts.bindingContext.activateMyRoleEndpoint(this._pid, (Endpoint)entry.getValue());
                __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + endpointReference));
            }
            this._myEprs.put(endpoint, endpointReference);
        }
        __log.debug((Object)("Activated " + this._pid));
        this.markused();
    }

    void deactivate() {
        for (Endpoint endpoint : this._myEprs.keySet()) {
            if (this.isShareable(endpoint)) {
                __log.debug((Object)("deactivating shared endpoint " + endpoint));
                if (this._sharedEps.decrementReferenceCount(endpoint)) continue;
                this._contexts.bindingContext.deactivateMyRoleEndpoint(endpoint);
                this._sharedEps.removeEndpoint(endpoint);
                continue;
            }
            __log.debug((Object)("deactivating non-shared endpoint " + endpoint));
            this._contexts.bindingContext.deactivateMyRoleEndpoint(endpoint);
        }
    }

    private boolean isShareable(Endpoint endpoint) {
        if (!this._pconf.isSharedService(endpoint.serviceName)) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndpointReference getInitialPartnerRoleEPR(PartnerLinkModel partnerLinkModel) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(partnerLinkModel);
            if (partnerLinkPartnerRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + partnerLinkModel);
            }
            EndpointReference endpointReference = partnerLinkPartnerRoleImpl.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Endpoint getInitialPartnerRoleEndpoint(PartnerLinkModel partnerLinkModel) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(partnerLinkModel);
            if (partnerLinkPartnerRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + partnerLinkModel);
            }
            Endpoint endpoint = partnerLinkPartnerRoleImpl._initialPartner;
            return endpoint;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndpointReference getInitialMyRoleEPR(PartnerLinkModel partnerLinkModel) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkMyRoleImpl partnerLinkMyRoleImpl = this._myRoles.get(partnerLinkModel);
            if (partnerLinkMyRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + partnerLinkModel);
            }
            EndpointReference endpointReference = partnerLinkMyRoleImpl.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    QName getPID() {
        return this._pid;
    }

    QName getProcessType() {
        return this._pconf.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartnerRoleChannel getPartnerRoleChannel(PartnerLinkModel partnerLinkModel) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(partnerLinkModel);
            if (partnerLinkPartnerRoleImpl == null) {
                throw new IllegalStateException("Unknown partner link " + partnerLinkModel);
            }
            PartnerRoleChannel partnerRoleChannel = partnerLinkPartnerRoleImpl._channel;
            return partnerRoleChannel;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public void saveEvent(ProcessInstanceEvent processInstanceEvent, ProcessInstanceDAO processInstanceDAO) {
        this.saveEvent(processInstanceEvent, processInstanceDAO, null);
    }

    public void saveEvent(ProcessInstanceEvent processInstanceEvent, ProcessInstanceDAO processInstanceDAO, List<String> list) {
        this.markused();
        if (this._pconf.isEventEnabled(list, processInstanceEvent.getType())) {
            this._server.fireEvent((BpelEvent)processInstanceEvent);
            if (processInstanceDAO != null) {
                processInstanceDAO.insertBpelEvent(processInstanceEvent);
            } else {
                __log.debug((Object)"Couldn't find instance to save event, no event generated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dehydrate() {
        this._hydrationLatch.latch(0);
        this._hydrationLatch.release(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hydrate() {
        this._hydrationLatch.latch(1);
        this._hydrationLatch.release(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessModel getProcessModel() {
        this._hydrationLatch.latch(1);
        try {
            ProcessModel processModel = this._processModel;
            return processModel;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    private MyRoleMessageExchangeImpl newMyRoleMex(InvocationStyle invocationStyle, String string, QName qName, PartnerLinkModel partnerLinkModel, Operation operation) {
        MyRoleMessageExchangeImpl myRoleMessageExchangeImpl;
        switch (invocationStyle) {
            case RELIABLE: {
                myRoleMessageExchangeImpl = new ReliableMyRoleMessageExchangeImpl(this, string, partnerLinkModel, operation, qName);
                break;
            }
            case TRANSACTED: {
                myRoleMessageExchangeImpl = new TransactedMyRoleMessageExchangeImpl(this, string, partnerLinkModel, operation, qName);
                break;
            }
            case UNRELIABLE: {
                myRoleMessageExchangeImpl = new UnreliableMyRoleMessageExchangeImpl(this, string, partnerLinkModel, operation, qName);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected invocation style: " + invocationStyle));
            }
        }
        this._myRoleMexCache.put(myRoleMessageExchangeImpl);
        return myRoleMessageExchangeImpl;
    }

    MyRoleMessageExchangeImpl lookupMyRoleMex(MessageExchangeDAO messageExchangeDAO) {
        return this._myRoleMexCache.get(messageExchangeDAO, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MyRoleMessageExchangeImpl recreateMyRoleMex(MessageExchangeDAO messageExchangeDAO) {
        InvocationStyle invocationStyle = messageExchangeDAO.getInvocationStyle();
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkModel partnerLinkModel = this._processModel.getPartnerLink(messageExchangeDAO.getPartnerLinkModelId());
            if (partnerLinkModel == null) {
                String string = __msgs.msgDbConsistencyError("MexDao #" + messageExchangeDAO.getMessageExchangeId() + " referenced unknown pLinkModelId " + messageExchangeDAO.getPartnerLinkModelId());
                __log.error((Object)string);
                throw new BpelEngineException(string);
            }
            Operation operation = partnerLinkModel.getMyRoleOperation(messageExchangeDAO.getOperation());
            if (operation == null) {
                String string = __msgs.msgDbConsistencyError("MexDao #" + messageExchangeDAO.getMessageExchangeId() + " referenced unknown operation " + messageExchangeDAO.getOperation());
                __log.error((Object)string);
                throw new BpelEngineException(string);
            }
            PartnerLinkMyRoleImpl partnerLinkMyRoleImpl = this._myRoles.get(partnerLinkModel);
            if (partnerLinkMyRoleImpl == null) {
                String string = __msgs.msgDbConsistencyError("MexDao #" + messageExchangeDAO.getMessageExchangeId() + " referenced non-existant myrole");
                __log.error((Object)string);
                throw new BpelEngineException(string);
            }
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = this.newMyRoleMex(invocationStyle, messageExchangeDAO.getMessageExchangeId(), partnerLinkMyRoleImpl._endpoint.serviceName, partnerLinkModel, operation);
            myRoleMessageExchangeImpl.load(messageExchangeDAO);
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl2 = myRoleMessageExchangeImpl;
            return myRoleMessageExchangeImpl2;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartnerRoleMessageExchangeImpl createPartnerRoleMex(MessageExchangeDAO messageExchangeDAO) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkModel partnerLinkModel = this._processModel.getPartnerLink(messageExchangeDAO.getPartnerLinkModelId());
            PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(partnerLinkModel);
            PartnerRoleMessageExchangeImpl partnerRoleMessageExchangeImpl = partnerLinkPartnerRoleImpl.createPartnerRoleMex(messageExchangeDAO);
            return partnerRoleMessageExchangeImpl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    Set<InvocationStyle> getSupportedInvocationStyle(QName qName) {
        return this._invocationStyles;
    }

    private PartnerLinkMyRoleImpl getPartnerLinkForService(QName qName) {
        assert (this._hydrationLatch.isLatched(1));
        PartnerLinkMyRoleImpl partnerLinkMyRoleImpl = null;
        for (Endpoint endpoint : this._endpointToMyRoleMap.keySet()) {
            if (!endpoint.serviceName.equals(qName)) continue;
            partnerLinkMyRoleImpl = this._endpointToMyRoleMap.get(endpoint);
        }
        return partnerLinkMyRoleImpl;
    }

    public boolean isInMemory() {
        return this._pconf.isTransient();
    }

    public long getLastUsed() {
        return this._lastUsed;
    }

    public boolean hintIsHydrated() {
        return this._processModel != null;
    }

    private final void markused() {
        this._lastUsed = System.currentTimeMillis();
    }

    private void bounceProcessDAO(BpelDAOConnection bpelDAOConnection, QName qName, long l, ProcessModel processModel) {
        this.deleteProcessDAO(bpelDAOConnection, qName, l, processModel);
        this.createProcessDAO(bpelDAOConnection, qName, l, processModel);
    }

    private void deleteProcessDAO(BpelDAOConnection bpelDAOConnection, QName qName, long l, ProcessModel processModel) {
        __log.debug((Object)("Creating process DAO for " + qName + " (guid=" + processModel.getGuid() + ")"));
        try {
            ProcessDAO processDAO = bpelDAOConnection.getProcess(qName);
            if (processDAO != null) {
                __log.debug((Object)("Found ProcessDAO for " + qName + " with GUID " + processDAO.getGuid()));
                if (processModel.getGuid() != null && !processDAO.getGuid().equals(processModel.getGuid())) {
                    String string = "ProcessDAO GUID " + processDAO.getGuid() + " does not match " + processModel.getGuid() + "; replacing.";
                    __log.debug((Object)string);
                    processDAO.delete();
                }
            }
        }
        catch (BpelEngineException bpelEngineException) {
            throw bpelEngineException;
        }
        catch (Exception exception) {
            __log.error((Object)"DbError", (Throwable)exception);
            throw new BpelEngineException("DbError", (Throwable)exception);
        }
    }

    private void createProcessDAO(BpelDAOConnection bpelDAOConnection, QName qName, long l, ProcessModel processModel) {
        __log.debug((Object)("Creating process DAO for " + qName + " (guid=" + processModel.getGuid() + ")"));
        try {
            Object object;
            boolean bl = true;
            ProcessDAO processDAO = bpelDAOConnection.getProcess(qName);
            if (processDAO != null) {
                __log.debug((Object)("Found ProcessDAO for " + qName + " with GUID " + processDAO.getGuid()));
                if (processModel.getGuid() == null) {
                    bl = false;
                } else if (processDAO.getGuid().equals(processModel.getGuid())) {
                    bl = false;
                } else {
                    object = "ProcessDAO GUID " + processDAO.getGuid() + " does not match " + processModel.getGuid() + "; replacing.";
                    __log.debug(object);
                }
            }
            if (bl) {
                object = bpelDAOConnection.createProcess(qName, processModel.getQName(), processModel.getGuid(), (long)((int)l));
                for (String string : processModel.getCorrelators()) {
                    object.addCorrelator(string);
                }
            }
        }
        catch (BpelEngineException bpelEngineException) {
            throw bpelEngineException;
        }
        catch (Exception exception) {
            __log.error((Object)"DbError", (Throwable)exception);
            throw new BpelEngineException("DbError", (Throwable)exception);
        }
    }

    MessageExchangeDAO createMessageExchange(String string, char c) {
        if (this.isInMemory()) {
            return this._inMemDao.getConnection().createMessageExchange(string, c);
        }
        return this._contexts.dao.getConnection().createMessageExchange(string, c);
    }

    MessageExchangeDAO getInMemMexDAO(String string) {
        return this._inMemDao.getConnection().getMessageExchange(string);
    }

    public void releaseMessageExchange(String string) {
        if (this.isInMemory()) {
            this._inMemDao.getConnection().releaseMessageExchange(string);
        }
    }

    void scheduleRunnable(Runnable runnable) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("schedulingRunnable for process " + this._pid + ": " + runnable));
        }
        this._server.scheduleRunnable(new ProcessRunnable(runnable));
    }

    void enqueueRunnable(BpelInstanceWorker bpelInstanceWorker) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("enqueuRunnable for process " + this._pid + ": " + bpelInstanceWorker));
        }
        this._server.enqueueRunnable(new ProcessRunnable(bpelInstanceWorker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MyRoleMessageExchange createNewMyRoleMex(InvocationStyle invocationStyle, QName qName, String string) {
        String string2 = new GUID().toString();
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkMyRoleImpl partnerLinkMyRoleImpl = this.getPartnerLinkForService(qName);
            if (partnerLinkMyRoleImpl == null) {
                throw new BpelEngineException("NoSuchService: " + qName);
            }
            Operation operation = partnerLinkMyRoleImpl._plinkDef.getMyRoleOperation(string);
            if (operation == null) {
                throw new BpelEngineException("NoSuchOperation: " + string);
            }
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = this.newMyRoleMex(invocationStyle, string2, partnerLinkMyRoleImpl._endpoint.serviceName, partnerLinkMyRoleImpl._plinkDef, operation);
            return myRoleMessageExchangeImpl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    void onMyRoleMexAck(MessageExchangeDAO messageExchangeDAO, MessageExchange.Status status) {
        if (messageExchangeDAO.getPipedMessageExchangeId() != null) {
            boolean bl;
            ODEProcess oDEProcess = this._server.getBpelProcess(messageExchangeDAO.getPipedPID());
            if (oDEProcess == null) {
                return;
            }
            MessageExchangeDAO messageExchangeDAO2 = oDEProcess.loadMexDao(messageExchangeDAO.getPipedMessageExchangeId());
            if (messageExchangeDAO2 == null) {
                return;
            }
            boolean bl2 = bl = !(oDEProcess.isInMemory() ^ this.isInMemory());
            if (bl) {
                messageExchangeDAO2.setResponse(messageExchangeDAO.getResponse());
            } else {
                MessageDAO messageDAO = messageExchangeDAO2.createMessage(messageExchangeDAO.getResponse().getType());
                messageDAO.setData(messageExchangeDAO.getResponse().getData());
                messageDAO.setHeader(messageExchangeDAO.getResponse().getHeader());
                messageExchangeDAO2.setResponse(messageDAO);
            }
            messageExchangeDAO2.setFault(messageExchangeDAO.getFault());
            messageExchangeDAO2.setStatus(messageExchangeDAO.getStatus());
            messageExchangeDAO2.setAckType(messageExchangeDAO.getAckType());
            messageExchangeDAO2.setFailureType(messageExchangeDAO.getFailureType());
            if (status == MessageExchange.Status.ASYNC) {
                oDEProcess.p2pWakeup(messageExchangeDAO2);
            }
        } else if (status == MessageExchange.Status.ASYNC) {
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = this._myRoleMexCache.get(messageExchangeDAO, this);
            myRoleMessageExchangeImpl.onAsyncAck(messageExchangeDAO);
            try {
                this._contexts.mexContext.onMyRoleMessageExchangeStateChanged((MyRoleMessageExchange)myRoleMessageExchangeImpl);
            }
            catch (Throwable throwable) {
                __log.error((Object)"Integration layer threw an unexepcted exception.", throwable);
            }
        }
    }

    private ProcessModel deserializeCompiledProcess(InputStream inputStream) throws IOException, ClassNotFoundException {
        Serializer serializer = new Serializer(inputStream);
        ProcessModel processModel = serializer.readPModel();
        return processModel;
    }

    public String scheduleWorkEvent(WorkEvent workEvent, Date date) {
        return this._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokePartner(MessageExchangeDAO messageExchangeDAO) {
        PartnerLinkModel partnerLinkModel = this._processModel.getPartnerLink(messageExchangeDAO.getPartnerLinkModelId());
        PartnerLinkPartnerRoleImpl partnerLinkPartnerRoleImpl = this._partnerRoles.get(partnerLinkModel);
        Endpoint endpoint = this.getInitialPartnerRoleEndpoint(partnerLinkModel);
        List<ODEProcess> list = null;
        if (endpoint != null) {
            list = this._server.route(endpoint.serviceName, new DbBackedMessageImpl(messageExchangeDAO.getRequest()));
        }
        Operation operation = partnerLinkModel.getPartnerRoleOperation(messageExchangeDAO.getOperation());
        if (!this.processInterceptors(messageExchangeDAO, InterceptorInvoker.__onPartnerInvoked)) {
            __log.debug((Object)"Partner invocation intercepted.");
            return;
        }
        messageExchangeDAO.setStatus(MessageExchange.Status.REQ);
        try {
            if (list != null && list.size() != 0) {
                MessageDAO messageDAO = messageExchangeDAO.getRequest();
                for (ODEProcess oDEProcess : list) {
                    MessageDAO messageDAO2 = messageExchangeDAO.createMessage(messageDAO.getType());
                    messageDAO2.setData((Element)messageDAO.getData().cloneNode(true));
                    messageDAO2.setHeader((Element)messageDAO.getHeader().cloneNode(true));
                    messageExchangeDAO.setRequest(messageDAO2);
                    this.invokeP2P(oDEProcess, endpoint.serviceName, operation, messageExchangeDAO);
                }
            } else {
                partnerLinkPartnerRoleImpl.invokeIL(messageExchangeDAO);
                this.scheduleInvokeCheck(messageExchangeDAO);
            }
        }
        finally {
            if (messageExchangeDAO.getStatus() != MessageExchange.Status.ACK) {
                messageExchangeDAO.setStatus(MessageExchange.Status.ASYNC);
            }
        }
        assert (messageExchangeDAO.getStatus() == MessageExchange.Status.ACK || messageExchangeDAO.getStatus() == MessageExchange.Status.ASYNC);
    }

    private void scheduleInvokeCheck(MessageExchangeDAO messageExchangeDAO) {
        boolean bl;
        boolean bl2 = bl = messageExchangeDAO.getPattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (!this.isInMemory() && bl) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Creating invocation check event for mexid " + messageExchangeDAO.getMessageExchangeId()));
            }
            WorkEvent workEvent = new WorkEvent();
            workEvent.setMexId(messageExchangeDAO.getMessageExchangeId());
            workEvent.setProcessId(this.getPID());
            workEvent.setType(WorkEvent.Type.INVOKE_CHECK);
            Date date = new Date(System.currentTimeMillis() + 180000L);
            String string = this.scheduleWorkEvent(workEvent, date);
            messageExchangeDAO.setProperty("invokeCheckJobId", string);
        }
    }

    private void invokeP2P(ODEProcess oDEProcess, QName qName, Operation operation, MessageExchangeDAO messageExchangeDAO) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Invoking in a p2p interaction, partnerrole " + messageExchangeDAO.getMessageExchangeId() + " target=" + oDEProcess));
        }
        messageExchangeDAO.setInvocationStyle(Boolean.parseBoolean(messageExchangeDAO.getProperty("org.apache.ode.bpel.myRoleTransacted")) ? InvocationStyle.P2P_TRANSACTED : InvocationStyle.P2P);
        MessageExchangeDAO messageExchangeDAO2 = oDEProcess.createMessageExchange(new GUID().toString(), 'M');
        messageExchangeDAO2.setStatus(MessageExchange.Status.REQ);
        messageExchangeDAO2.setCallee(qName);
        messageExchangeDAO2.setOperation(messageExchangeDAO.getOperation());
        messageExchangeDAO2.setPattern(messageExchangeDAO.getPattern());
        messageExchangeDAO2.setTimeout(messageExchangeDAO.getTimeout());
        messageExchangeDAO2.setRequest(messageExchangeDAO.getRequest());
        messageExchangeDAO2.setInvocationStyle(messageExchangeDAO.getInvocationStyle());
        messageExchangeDAO2.setPipedMessageExchangeId(messageExchangeDAO.getMessageExchangeId());
        messageExchangeDAO2.setPipedPID(this.getPID());
        messageExchangeDAO.setPipedPID(oDEProcess.getPID());
        messageExchangeDAO.setPipedMessageExchangeId(messageExchangeDAO2.getMessageExchangeId());
        this.setStatefulEPRs(messageExchangeDAO, messageExchangeDAO2);
        oDEProcess.invokeProcess(messageExchangeDAO2);
    }

    private OdeRuntime buildRuntime(int n) {
        String string = "org.apache.ode.bpel.rtrep.v" + n + ".RuntimeImpl";
        try {
            OdeRuntime odeRuntime = (OdeRuntime)Class.forName(string).newInstance();
            odeRuntime.setExtensionRegistry(this._contexts.extensionRegistry);
            return odeRuntime;
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't instantiate ODE runtime version " + n + ", either your process definition version is outdated or we have a bug.");
        }
    }

    void setStatefulEPRs(MessageExchangeDAO messageExchangeDAO) {
        this.setStatefulEPRs(messageExchangeDAO, null);
    }

    private void setStatefulEPRs(MessageExchangeDAO messageExchangeDAO, MessageExchangeDAO messageExchangeDAO2) {
        String string = messageExchangeDAO.getPartnerLink().getMySessionId();
        String string2 = messageExchangeDAO.getPartnerLink().getPartnerSessionId();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Setting myRoleMex session ids for p2p interaction, mySession " + string2 + " - partnerSess " + string));
        }
        if (string != null) {
            messageExchangeDAO.setProperty("org.apache.ode.bpel.myRoleSessionId", string);
            if (messageExchangeDAO2 != null) {
                messageExchangeDAO2.setProperty("org.apache.ode.bpel.partnerRoleSessionId", string);
            }
        }
        if (string2 != null) {
            messageExchangeDAO.setProperty("org.apache.ode.bpel.partnerRoleSessionId", string2);
            if (messageExchangeDAO2 != null) {
                messageExchangeDAO2.setProperty("org.apache.ode.bpel.myRoleSessionId", string2);
            }
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INVOKE PARTNER (SEP): sessionId=" + string + " partnerSessionId=" + string2));
        }
    }

    private void p2pWakeup(final MessageExchangeDAO messageExchangeDAO) {
        try {
            this.doInstanceWork(messageExchangeDAO.getInstance().getInstanceId(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ODEProcess.this.executeContinueInstancePartnerRoleResponseReceived(messageExchangeDAO);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new BpelEngineException((Throwable)exception);
        }
    }

    public Node getProcessProperty(QName qName) {
        Map map = this._pconf.getProcessProperties();
        if (map != null) {
            return (Node)map.get(qName);
        }
        return null;
    }

    class HydrationLatch
    extends NStateLatch {
        HydrationLatch() {
            super(new Runnable[2]);
            this._transitions[0] = new Runnable(){

                public void run() {
                    HydrationLatch.this.doDehydrate();
                }
            };
            this._transitions[1] = new Runnable(){

                public void run() {
                    HydrationLatch.this.doHydrate();
                }
            };
        }

        private void doDehydrate() {
            ODEProcess.this._processModel = null;
            ODEProcess.this._partnerRoles = null;
            ODEProcess.this._myRoles = null;
            ODEProcess.this._endpointToMyRoleMap = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doHydrate() {
            ODEProcess.this.markused();
            try {
                Iterator iterator = ODEProcess.this._pconf.getCBPInputStream();
                try {
                    ODEProcess.this._processModel = ODEProcess.this.deserializeCompiledProcess((InputStream)((Object)iterator));
                }
                finally {
                    ((InputStream)((Object)iterator)).close();
                }
            }
            catch (Exception exception) {
                String string = "Error reloading compiled process " + ODEProcess.this._pconf.getProcessId() + "; the file appears to be corrupted.";
                __log.error((Object)string);
                throw new BpelEngineException(string, (Throwable)exception);
            }
            ODEProcess.this._runtime = ODEProcess.this.buildRuntime(ODEProcess.this._processModel.getModelVersion());
            ODEProcess.this._runtime.init(ODEProcess.this._pconf, ODEProcess.this._processModel);
            ODEProcess.this.setRoles(ODEProcess.this._processModel);
            ODEProcess.this.initExternalVariables();
            if (!ODEProcess.this._hydratedOnce) {
                for (Object object : ODEProcess.this._partnerRoles.values()) {
                    PartnerRoleChannel partnerRoleChannel;
                    if (((PartnerLinkPartnerRoleImpl)object)._initialPartner == null) continue;
                    ((PartnerLinkPartnerRoleImpl)object)._channel = partnerRoleChannel = ODEProcess.this._contexts.bindingContext.createPartnerRoleChannel(ODEProcess.this._pid, ((PartnerLinkPartnerRoleImpl)object)._plinkDef.getPartnerRolePortType(), ((PartnerLinkPartnerRoleImpl)object)._initialPartner);
                    ODEProcess.this._partnerChannels.put(((PartnerLinkPartnerRoleImpl)object)._initialPartner, ((PartnerLinkPartnerRoleImpl)object)._channel);
                    EndpointReference endpointReference = partnerRoleChannel.getInitialEndpointReference();
                    if (endpointReference != null) {
                        ((PartnerLinkPartnerRoleImpl)object)._initialEPR = endpointReference;
                        ODEProcess.this._partnerEprs.put(((PartnerLinkPartnerRoleImpl)object)._initialPartner, endpointReference);
                    }
                    __log.debug((Object)("Activated " + ODEProcess.this._pid + " partnerrole " + ((PartnerLinkRoleImpl)object).getPartnerLinkName() + ": EPR is " + ((PartnerLinkPartnerRoleImpl)object)._initialEPR));
                }
                ODEProcess.this._hydratedOnce = true;
            }
            for (Object object : ODEProcess.this._myRoles.values()) {
                ((PartnerLinkMyRoleImpl)object)._initialEPR = (EndpointReference)ODEProcess.this._myEprs.get(((PartnerLinkMyRoleImpl)object)._endpoint);
            }
            for (Object object : ODEProcess.this._partnerRoles.values()) {
                ((PartnerLinkPartnerRoleImpl)object)._channel = (PartnerRoleChannel)ODEProcess.this._partnerChannels.get(((PartnerLinkPartnerRoleImpl)object)._initialPartner);
                if (ODEProcess.this._partnerEprs.get(((PartnerLinkPartnerRoleImpl)object)._initialPartner) == null) continue;
                ((PartnerLinkPartnerRoleImpl)object)._initialEPR = (EndpointReference)ODEProcess.this._partnerEprs.get(((PartnerLinkPartnerRoleImpl)object)._initialPartner);
            }
            if (ODEProcess.this.isInMemory()) {
                ODEProcess.this.bounceProcessDAO(ODEProcess.this._inMemDao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
            } else if (ODEProcess.this._contexts.isTransacted()) {
                ODEProcess.this.bounceProcessDAO(ODEProcess.this._contexts.dao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
            } else {
                try {
                    ODEProcess.this._contexts.execTransaction(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ODEProcess.this.deleteProcessDAO(ODEProcess.this._contexts.dao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
                            return null;
                        }
                    });
                    ODEProcess.this._contexts.execTransaction(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ODEProcess.this.createProcessDAO(ODEProcess.this._contexts.dao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    Object object;
                    object = "DbError";
                    __log.error(object, (Throwable)exception);
                    throw new BpelEngineException((String)object, (Throwable)exception);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessCallable<T>
    implements Callable<T> {
        Callable<T> _work;

        ProcessCallable(Callable<T> callable) {
            this._work = callable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            ODEProcess.this._hydrationLatch.latch(1);
            try {
                T t = this._work.call();
                return t;
            }
            finally {
                ODEProcess.this._hydrationLatch.release(1);
            }
        }
    }

    class ProcessRunnable
    implements Runnable {
        Runnable _work;

        ProcessRunnable(Runnable runnable) {
            this._work = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ODEProcess.this._hydrationLatch.latch(1);
            try {
                this._work.run();
            }
            finally {
                ODEProcess.this._hydrationLatch.release(1);
            }
        }
    }
}

