/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.InvalidMessageException;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationMatchEvent;
import org.apache.ode.bpel.evt.CorrelationNoMatchEvent;
import org.apache.ode.bpel.evt.NewProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.rapi.CorrelationSetModel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rapi.PropertyExtractor;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

class PartnerLinkMyRoleImpl
extends PartnerLinkRoleImpl {
    private static final Log __log = LogFactory.getLog(ODEProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    public Endpoint _endpoint;

    PartnerLinkMyRoleImpl(ODEProcess oDEProcess, PartnerLinkModel partnerLinkModel, Endpoint endpoint) {
        super(oDEProcess, partnerLinkModel);
        this._endpoint = endpoint;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{PartnerLinkRole-");
        stringBuffer.append(this._plinkDef.getName());
        stringBuffer.append('.');
        stringBuffer.append(this._plinkDef.getMyRoleName());
        stringBuffer.append(" on ");
        stringBuffer.append(this._endpoint);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public MyRoleMessageExchange.CorrelationStatus invokeMyRole(MessageExchangeDAO messageExchangeDAO) {
        ProcessInstanceDAO processInstanceDAO;
        CorrelationKey[] correlationKeyArray;
        ProcessInstanceDAO processInstanceDAO2;
        Operation operation;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)(this + ":inputMsgRcvd"), (Object[])new Object[]{"messageExchange", messageExchangeDAO}));
        }
        if ((operation = this.getMyRoleOperation(messageExchangeDAO.getOperation())) == null) {
            __log.error((Object)__msgs.msgUnknownOperation(messageExchangeDAO.getOperation(), this._plinkDef.getMyRolePortType().getQName()));
            MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.UNKNOWN_OPERATION, messageExchangeDAO.getOperation());
            return null;
        }
        boolean bl = this._plinkDef.isCreateInstanceOperation(operation);
        String string = ODEProcess.genCorrelatorId(this._plinkDef, operation.getName());
        CorrelatorDAO correlatorDAO = this._process.getProcessDAO().getCorrelator(string);
        MessageRouteDAO messageRouteDAO = null;
        try {
            processInstanceDAO2 = this.computeCorrelationKeys(messageExchangeDAO, operation);
            correlationKeyArray = this.computeUniqueCorrelationKeys(messageExchangeDAO, operation);
        }
        catch (InvalidMessageException invalidMessageException) {
            __log.debug((Object)"Unable to evaluate correlation keys, invalid message format. ", (Throwable)invalidMessageException);
            MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.FORMAT_ERROR, invalidMessageException.getMessage());
            return null;
        }
        String string2 = messageExchangeDAO.getProperty("org.apache.ode.bpel.myRoleSessionId");
        String string3 = messageExchangeDAO.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + string + ": MSG RCVD keys=" + CollectionUtils.makeCollection(HashSet.class, (Object[])processInstanceDAO2) + " mySessionId=" + string2 + " partnerSessionId=" + string3));
        }
        Object object = null;
        for (Object object2 : processInstanceDAO2) {
            messageRouteDAO = correlatorDAO.findRoute((CorrelationKey)object2);
            if (messageRouteDAO == null) continue;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("INPUTMSG: " + string + ": ckey " + object2 + " ROUTED TO (grp,index,iid) = (" + messageRouteDAO.getGroupId() + "," + messageRouteDAO.getIndex() + ", " + messageRouteDAO.getTargetInstance().getInstanceId() + ")"));
            }
            object = object2;
            break;
        }
        if (messageRouteDAO == null && bl) {
            this.invokeMyRoleCreateInstance(messageExchangeDAO, operation, string, correlatorDAO, correlationKeyArray);
        } else if (messageRouteDAO != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("INPUTMSG: " + string + ": ROUTING to instance " + messageRouteDAO.getTargetInstance().getInstanceId()));
            }
            processInstanceDAO = messageRouteDAO.getTargetInstance();
            ProcessDAO processDAO = processInstanceDAO.getProcess();
            this.enforceUniqueConstraint(processDAO, correlationKeyArray);
            correlatorDAO.removeRoutes(messageRouteDAO.getGroupId(), processInstanceDAO);
            CorrelationMatchEvent correlationMatchEvent = new CorrelationMatchEvent(this._process.getProcessModel().getQName(), this._process.getProcessDAO().getProcessId(), processInstanceDAO.getInstanceId(), (CorrelationKey)object);
            correlationMatchEvent.setPortType(messageExchangeDAO.getPortType());
            correlationMatchEvent.setOperation(operation.getName());
            correlationMatchEvent.setMexId(messageExchangeDAO.getMessageExchangeId());
            this._process._debugger.onEvent((BpelEvent)correlationMatchEvent);
            this._process.saveEvent((ProcessInstanceEvent)correlationMatchEvent, processInstanceDAO);
            messageExchangeDAO.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.MATCHED.toString());
            messageExchangeDAO.setInstance(messageRouteDAO.getTargetInstance());
            messageExchangeDAO.setChannel(messageRouteDAO.getGroupId() + "&" + messageRouteDAO.getIndex());
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("INPUTMSG: " + string + ": SAVING to DB (no match) "));
            }
            processInstanceDAO = new CorrelationNoMatchEvent(messageExchangeDAO.getPortType(), messageExchangeDAO.getOperation(), messageExchangeDAO.getMessageExchangeId(), (CorrelationKey[])processInstanceDAO2);
            processInstanceDAO.setProcessId(this._process.getProcessDAO().getProcessId());
            processInstanceDAO.setProcessName(this._process.getProcessModel().getQName());
            this._process._debugger.onEvent((BpelEvent)processInstanceDAO);
            messageExchangeDAO.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.QUEUED.toString());
            correlatorDAO.enqueueMessage(messageExchangeDAO, (CorrelationKey[])processInstanceDAO2);
        }
        return MyRoleMessageExchange.CorrelationStatus.valueOf((String)messageExchangeDAO.getCorrelationStatus());
    }

    private void invokeMyRoleCreateInstance(MessageExchangeDAO messageExchangeDAO, Operation operation, String string, CorrelatorDAO correlatorDAO, CorrelationKey[] correlationKeyArray) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + string + ": routing failed, CREATING NEW INSTANCE"));
        }
        ProcessDAO processDAO = this._process.getProcessDAO();
        if (this._process._pconf.getState() == ProcessState.RETIRED) {
            throw new InvalidProcessException("Process is retired.", 1);
        }
        this.enforceUniqueConstraint(processDAO, correlationKeyArray);
        ProcessInstanceDAO processInstanceDAO = processDAO.createInstance(correlatorDAO);
        NewProcessInstanceEvent newProcessInstanceEvent = new NewProcessInstanceEvent(this._process.getProcessModel().getQName(), processDAO.getProcessId(), processInstanceDAO.getInstanceId());
        newProcessInstanceEvent.setPortType(messageExchangeDAO.getPortType());
        newProcessInstanceEvent.setOperation(operation.getName());
        newProcessInstanceEvent.setMexId(messageExchangeDAO.getMessageExchangeId());
        this._process._debugger.onEvent((BpelEvent)newProcessInstanceEvent);
        this._process.saveEvent((ProcessInstanceEvent)newProcessInstanceEvent, processInstanceDAO);
        messageExchangeDAO.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.CREATE_INSTANCE.toString());
        messageExchangeDAO.setInstance(processInstanceDAO);
    }

    private void enforceUniqueConstraint(ProcessDAO processDAO, CorrelationKey[] correlationKeyArray) {
        for (CorrelationKey correlationKey : correlationKeyArray) {
            Collection collection;
            if (!correlationKey.isUnique() || (collection = processDAO.findInstance(correlationKey, false)).size() == 0) continue;
            __log.debug((Object)("Not creating a new instance for process " + processDAO.getProcessId() + "; unique correlation constraint would be violated!"));
            throw new InvalidProcessException("Unique process constraint violated", 2);
        }
    }

    private Operation getMyRoleOperation(String string) {
        return this._plinkDef.getMyRoleOperation(string);
    }

    private CorrelationKey[] computeCorrelationKeys(MessageExchangeDAO messageExchangeDAO, Operation operation) {
        Element element = messageExchangeDAO.getRequest().getData();
        Message message = operation.getInput().getMessage();
        ArrayList<CorrelationKey> arrayList = new ArrayList<CorrelationKey>();
        Set set = this._plinkDef.getCorrelationSetsForOperation(operation);
        for (CorrelationSetModel correlationSetModel : set) {
            CorrelationKey correlationKey = this.computeCorrelationKey(correlationSetModel, message.getQName(), element);
            arrayList.add(correlationKey);
        }
        String string = messageExchangeDAO.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (string != null) {
            arrayList.add(new CorrelationKey(-1, new String[]{string}));
        }
        return arrayList.toArray(new CorrelationKey[arrayList.size()]);
    }

    private CorrelationKey[] computeUniqueCorrelationKeys(MessageExchangeDAO messageExchangeDAO, Operation operation) {
        Element element = messageExchangeDAO.getRequest().getData();
        Message message = operation.getInput().getMessage();
        ArrayList<CorrelationKey> arrayList = new ArrayList<CorrelationKey>();
        Set set = this._plinkDef.getUniqueCorrelationSetsForOperation(operation);
        for (CorrelationSetModel correlationSetModel : set) {
            CorrelationKey correlationKey = this.computeCorrelationKey(correlationSetModel, message.getQName(), element);
            arrayList.add(correlationKey);
        }
        String string = messageExchangeDAO.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (string != null) {
            arrayList.add(new CorrelationKey(-1, new String[]{string}));
        }
        return arrayList.toArray(new CorrelationKey[arrayList.size()]);
    }

    private CorrelationKey computeCorrelationKey(CorrelationSetModel correlationSetModel, QName qName, Element element) {
        String[] stringArray;
        List list;
        if (correlationSetModel.getExtractors().isEmpty()) {
            list = correlationSetModel.getAliases(qName);
            stringArray = new String[list.size()];
            int n = 0;
            for (PropertyAliasModel propertyAliasModel : list) {
                String string;
                try {
                    string = this._process._runtime.extractProperty(element, propertyAliasModel, element.toString());
                }
                catch (FaultException faultException) {
                    String string2 = __msgs.msgPropertyAliasDerefFailedOnMessage(propertyAliasModel.getDescription(), faultException.getMessage());
                    __log.error((Object)string2, (Throwable)faultException);
                    throw new InvalidMessageException(string2, (Throwable)faultException);
                }
                stringArray[n++] = string;
            }
        } else {
            list = correlationSetModel.getExtractors();
            stringArray = new String[list.size()];
            int n = 0;
            for (PropertyExtractor propertyExtractor : list) {
                try {
                    stringArray[n++] = this._process._runtime.extractMatch(element, propertyExtractor);
                }
                catch (FaultException faultException) {
                    String string = __msgs.msgPropertyAliasDerefFailedOnMessage(propertyExtractor.toString(), faultException.getMessage());
                    __log.error((Object)string, (Throwable)faultException);
                    throw new InvalidMessageException(string, (Throwable)faultException);
                }
            }
        }
        list = new CorrelationKey(correlationSetModel.getId(), stringArray);
        list.setUnique(correlationSetModel.isUnique());
        return list;
    }

    public boolean isOneWayOnly() {
        PortType portType = this._plinkDef.getMyRolePortType();
        if (portType == null) {
            return false;
        }
        for (Operation operation : portType.getOperations()) {
            if (operation.getOutput() == null) continue;
            return false;
        }
        return true;
    }
}

