var detectMimeTypePipelet = pipelets.create("org.eclipse.smila.processing.pipelets.MimeTypeIdentifyPipelet", {
  "FileExtensionAttribute" : "Extension",
  "MetaDataAttribute" : "MetaData",
  "MimeTypeAttribute" : "MimeType"
});

var htmlToTextPipelet = pipelets.create("org.eclipse.smila.processing.pipelets.HtmlToTextPipelet", {
  "inputType" : "ATTACHMENT",
  "outputType" : "ATTRIBUTE",
  "inputName" : "Content",
  "outputName" : "Content",
  "meta:title" : "Title",
  "tag:title" : "Title"
});

var copyTextPipelet = pipelets.create("org.eclipse.smila.processing.pipelets.CopyPipelet", {
  "inputType" : "ATTACHMENT",
  "outputType" : "ATTRIBUTE",
  "inputName" : "Content",
  "outputName" : "Content",
  "mode" : "COPY"
});

var tikaPipelet = pipelets.create("org.eclipse.smila.tika.TikaPipelet", {
  "inputType" : "ATTACHMENT",
  "outputType" : "ATTRIBUTE",
  "inputName" : "Content",
  "outputName" : "Content",
  "contentTypeAttribute" : "MimeType",
  "fileNameAttribute" : "Filename",
  "exportAsHtml" : false,
  "pageBreak" : false,
  "keepHyphens" : false,
  "maxLength" : "-1",
  "extractProperties" : [ {
    "metadataName" : "creator",
    "targetAttribute" : "Author",
    "singleResult" : false
  }, {
    "metadataName" : "title",
    "targetAttribute" : "Title",
    "singleResult" : true
  } ]
});

var solrIndexPipelet = pipelets.create("org.eclipse.smila.solr.update.SolrUpdatePipelet", {
  "indexname" : "collection1",
  "update" : {
  	"operation" : "ADD",
  	"commitWithinMs" : "1000",
  	"mapping" : {
  		"_source" : "",
  		"Path" : "",
  		"Url" : "",
  		"Filename" : "",
  		"MimeType" : "",
  		"Size" : "",
  		"LastModifiedDate" : "",
  		"Content" : "",
  		"Extension" : "",
  		"Title" : "",
  		"Author" : ""
  	}
  }
});


/* called by worker: initialize for task. */
function prepare(parameters) {
}

/* called by worker: process single record from bulk. */
function processRecord(record) {

  // 1. detect MimeType
  if (!("MimeType" in record)) {
    detectMimeTypePipelet.process(record);
  }

  // 2. transform (attachment) content to plain text
  var mimeType = record.MimeType
  if ((mimeType != null) && mimeType.indexOf("text/") == 0) {

    if (mimeType == "text/xml" || mimeType == "text/html") {
      htmlToTextPipelet.process(record); // XML/HTML attachment -> text
    } else {
      copyTextPipelet.process(record); // text attachment -> text
    }

  } else {
    tikaPipelet.process(record); // Binary content -> text
  }

  // 3. index
  return solrIndexPipelet.process(record);
}

/* called by /smila/script: add a single record without task context */
function process(record) {
  prepare({});
  return processRecord(record);
}
