/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.common.test;

import junit.framework.TestCase;

import org.eclipse.smila.common.definitions.NameValidator;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;

/** Test cases for {@link NameValidator}. */
public class TestNameValidator extends TestCase {
  /** test if null name is rejected. */
  public void testRejectNullName() throws Exception {
    try {
      NameValidator.checkName(null);
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
  }

  /** test if empty name is rejected. */
  public void testRejectEmptyName() throws Exception {
    try {
      NameValidator.checkName("");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
  }

  /** test if some valid names are accepted. */
  public void testValid1CharNames() throws Exception {
    NameValidator.checkName("a");
    NameValidator.checkName("A");
    NameValidator.checkName("0");
    NameValidator.checkName("-");
    NameValidator.checkName("_");
    NameValidator.checkName(".");
  }

  /** test if some valid names are accepted. */
  public void testValidLongerNames() throws Exception {
    NameValidator.checkName("lowercase");
    NameValidator.checkName("UPPERCASE");
    NameValidator.checkName("CamelCase");
    NameValidator.checkName("0Name1With2Numbers9");
    NameValidator.checkName("hyphenated-name");
    NameValidator.checkName("name_with_underscores");
    NameValidator.checkName("dotted.name");
    NameValidator.checkName("EveryThing-1234.mixed_UP");
  }

  /** test if name with characters causing problems in URL is rejected. */
  public void testRejectNameWithProblematicUrlCharacters() throws Exception {
    try {
      NameValidator.checkName("abc+def");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
    try {
      NameValidator.checkName("abc/def");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
    try {
      NameValidator.checkName("abc def");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
    try {
      NameValidator.checkName("abc=def");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
    try {
      NameValidator.checkName("abc?def");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
  }

  /** test if name with diacritic charaters. */
  public void testRejectNameWithDiacriticCharacters() throws Exception {
    try {
      NameValidator.checkName("äbcdef");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
    try {
      NameValidator.checkName("abcdéf");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
    try {
      NameValidator.checkName("abßdef");
      fail("should not work");
    } catch (final InvalidDefinitionException ex) {
      ; // ok.
    }
  }
}
