/***********************************************************************************************************************
 * Copyright (c) 2008,2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial API
 **********************************************************************************************************************/
package org.eclipse.smila.common.language;

import java.io.Serializable;

/**
 * result object of the {@link LanguageIdentifyService} service. Contains the ISO-639 code of the detected language, an
 * alternative name (e.g. the english name of the language) and a flag that denotes that the identifier is certain about
 * the detected language or that there are doubts about the result.
 */
public class Language implements Serializable {
  private static final long serialVersionUID = 1L;

  private final String _isoLanguage;

  private final String _alternativeName;

  private final boolean _isCertain;

  /** create result object. */
  public Language(final String isoLanguage, final String alternativeName, final boolean isCertain) {
    super();
    _isoLanguage = isoLanguage;
    _alternativeName = alternativeName;
    _isCertain = isCertain;
  }

  /** @return the ISO language code. */
  public String getIsoLanguage() {
    return _isoLanguage;
  }

  /** @return an alternative name of the detected language. May be null if not supported by the service. */
  public String getAlternativeName() {
    return _alternativeName;
  }

  /** @return true if the service is certain about the result. */
  public boolean isCertain() {
    return _isCertain;
  }

  @Override
  public String toString() {
    final StringBuilder builder = new StringBuilder(_isoLanguage);
    if (_alternativeName != null) {
      builder.append("/").append(_alternativeName);
    }
    if (_isCertain) {
      builder.append("!");
    } else {
      builder.append("?");
    }
    return builder.toString();
  }
}
