/***********************************************************************************************************************
 * Copyright (c) 2008,2011 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation               
 **********************************************************************************************************************/

package org.eclipse.smila.datamodel.ipc.test;

import junit.framework.TestCase;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.ipc.bon.BinaryToken;

/**
 * Test class for {@link IpcAnyWriter} class.
 * 
 * @author aweber
 */
public class TestIpcAnyWriter extends TestCase {

  private final IpcAnyWriter _ipcAnyWriter = new IpcAnyWriter();

  /** AnyMap -> JSON. */
  public void testWriteEmptyAnyMapToJson() throws Exception {
    final AnyMap testAny = DataFactory.DEFAULT.createAnyMap();
    final String json = _ipcAnyWriter.writeJsonObject(testAny);
    assertEquals("{}", json);
  }

  /** AnySeq -> JSON. */
  public void testWriteEmptyAnySeqToJson() throws Exception {
    final AnySeq testAny = DataFactory.DEFAULT.createAnySeq();
    final String json = _ipcAnyWriter.writeJsonObject(testAny);
    assertEquals("[]", json);
  }

  /** Value -> JSON. */
  public void testWriteSingleValueToJson() throws Exception {
    final Any testAny = DataFactory.DEFAULT.createStringValue("test");
    final String json = _ipcAnyWriter.writeJsonObject(testAny);
    assertEquals("\"test\"", json); // conversion works although json string is no valid JSON!
  }

  /** AnyMap -> BON. */
  public void testWriteEmptyAnyMapToBinary() throws Exception {
    final AnyMap testAny = DataFactory.DEFAULT.createAnyMap();
    final byte[] bon = _ipcAnyWriter.writeBinaryObject(testAny);
    assertEquals(BinaryToken.OBJECT_START.byteValue(), bon[0]);
    assertEquals(BinaryToken.MAPPING_START.byteValue(), bon[1]);
    assertEquals(BinaryToken.MAPPING_END.byteValue(), bon[2]);
    assertEquals(BinaryToken.OBJECT_END.byteValue(), bon[3]);
  }

  /** AnySeq -> BON. */
  public void testWriteEmptyAnySeqToBinary() throws Exception {
    final AnySeq testAny = DataFactory.DEFAULT.createAnySeq();
    final byte[] bon = _ipcAnyWriter.writeBinaryObject(testAny);
    assertEquals(BinaryToken.OBJECT_START.byteValue(), bon[0]);
    assertEquals(BinaryToken.SEQUENCE_START.byteValue(), bon[1]);
    assertEquals(BinaryToken.SEQUENCE_END.byteValue(), bon[2]);
    assertEquals(BinaryToken.OBJECT_END.byteValue(), bon[3]);
  }

  /** Value -> BON. */
  public void testWriteSingleValueToBinary() throws Exception {
    final Any testAny = DataFactory.DEFAULT.createBooleanValue(true);
    final byte[] bon = _ipcAnyWriter.writeBinaryObject(testAny);
    assertEquals(BinaryToken.OBJECT_START.byteValue(), bon[0]);
    assertEquals(BinaryToken.SCALAR_BOOL_TRUE.byteValue(), bon[1]);
    assertEquals(BinaryToken.OBJECT_END.byteValue(), bon[2]);
  }
}
