/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.test;

import junit.framework.TestCase;

import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.eclipse.smila.http.client.util.HttpClientUtil;

/**
 * Test class for the {@link HttpClientUtil}.
 */
public class TestHttpClientUtil extends TestCase {

  /** {@inheritDoc} */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
  }

  /** {@inheritDoc} */
  @Override
  protected void tearDown() throws Exception {
    super.tearDown();
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.util.HttpClientUtil#createInstance()}.
   */
  public void testCreateInstance() {
    final HttpClient client = HttpClientUtil.createInstance();
    assertNotNull(client);
    final ClientConnectionManager conn = client.getConnectionManager();
    assertTrue(conn instanceof BasicClientConnectionManager);
  }

  /**
   * Test method for HttpClientUtil#createInstance(org.apache.http.conn.ClientConnectionManager) .
   */
  public void testCreateInstanceClientConnectionManager() {
    final ClientConnectionManager conn = new PoolingClientConnectionManager();
    final HttpClient client = HttpClientUtil.createInstance(conn);
    assertEquals(conn, client.getConnectionManager());
  }

}
