/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.test;

import junit.framework.TestCase;

import org.eclipse.smila.http.client.ResourceHelper;

/**
 * Test class for {@link ResourceHelper}.
 */
public class TestResourceHelper extends TestCase {

  private static final String SMILA = "/smila/";

  private ResourceHelper _helper;

  /** {@inheritDoc} */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _helper = new ResourceHelper();
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#UriHelper(java.lang.String)}.
   */
  public void testConstructor() {
    final String rootStores = "/root/store/";
    ResourceHelper uriHelper = new ResourceHelper("root");
    assertEquals(rootStores, uriHelper.getStoresResource());
    uriHelper = new ResourceHelper("root/");
    assertEquals(rootStores, uriHelper.getStoresResource());
    uriHelper = new ResourceHelper("/root");
    assertEquals(rootStores, uriHelper.getStoresResource());
    uriHelper = new ResourceHelper("/root/");
    assertEquals(rootStores, uriHelper.getStoresResource());
    try {
      new ResourceHelper(null);
      fail("null root context");
    } catch (final NullPointerException e) {
      ;//
    }
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getPipeletsRersource()}.
   */
  public void testGetPipeletsPath() {
    assertEquals(SMILA + "pipelets/", _helper.getPipeletsRersource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getPipeletResource(java.lang.String)}.
   */
  public void testGetPipeletPath() {
    assertEquals(SMILA + "pipelets/x/", _helper.getPipeletResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getPipelinesResource()}.
   */
  public void testGetPipelinesPath() {
    assertEquals(SMILA + "pipeline/", _helper.getPipelinesResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getPipelineResource(java.lang.String)}.
   */
  public void testGetPipelinePath() {
    assertEquals(SMILA + "pipeline/x/", _helper.getPipelineResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getJobManagerResource()}.
   */
  public void testGetJobManagerBasePath() {
    assertEquals(SMILA + "jobmanager/", _helper.getJobManagerResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getDataObjectTypesResource()}.
   */
  public void testGetDataObjectTypesPath() {
    assertEquals(SMILA + "jobmanager/dataobjecttypes/", _helper.getDataObjectTypesResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getDataObjectTypeResource(java.lang.String)}.
   */
  public void testGetDataObjectTypePath() {
    assertEquals(SMILA + "jobmanager/dataobjecttypes/x/", _helper.getDataObjectTypeResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getBucketsResource()}.
   */
  public void testGetBucketsPath() {
    assertEquals(SMILA + "jobmanager/buckets/", _helper.getBucketsResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getBucketResource(java.lang.String)}.
   */
  public void testGetBucketPath() {
    assertEquals(SMILA + "jobmanager/buckets/x/", _helper.getBucketResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getWorkersResource()}.
   */
  public void testGetWorkersPath() {
    assertEquals(SMILA + "jobmanager/workers/", _helper.getWorkersResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getWorkerResource(java.lang.String)}.
   */
  public void testGetWorkerPath() {
    assertEquals(SMILA + "jobmanager/workers/x/", _helper.getWorkerResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getWorkflowsResource()}.
   */
  public void testGetWorkflowsPath() {
    assertEquals(SMILA + "jobmanager/workflows/", _helper.getWorkflowsResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getWorkflowResource(java.lang.String)}.
   */
  public void testGetWorkflowPath() {
    assertEquals(SMILA + "jobmanager/workflows/x/", _helper.getWorkflowResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getJobsResource()}.
   */
  public void testGetJobsPath() {
    assertEquals(SMILA + "jobmanager/jobs/", _helper.getJobsResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getJobResource(java.lang.String)}.
   */
  public void testGetJobPath() {
    assertEquals(SMILA + "jobmanager/jobs/x/", _helper.getJobResource("x"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getJobRunResource(java.lang.String, java.lang.String)}.
   */
  public void testGetJobRunPath() {
    assertEquals(SMILA + "jobmanager/jobs/x/y/", _helper.getJobRunResource("x", "y"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getJobRunFinishResource(java.lang.String, java.lang.String)} .
   */
  public void testGetJobRunFinishPath() {
    assertEquals(SMILA + "jobmanager/jobs/x/y/finish/", _helper.getJobRunFinishResource("x", "y"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getJobRunCancelResource(java.lang.String, java.lang.String)} .
   */
  public void testGetJobRunCancelPath() {
    assertEquals(SMILA + "jobmanager/jobs/x/y/cancel/", _helper.getJobRunCancelResource("x", "y"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getPushToJobBaseResource(java.lang.String)}.
   */
  public void testGetJobPushBasePath() {
    assertEquals(SMILA + "job/x/", _helper.getPushToJobBaseResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getPushRecordToJobResource(java.lang.String)}.
   */
  public void testGetJobPushRecordPath() {
    assertEquals(SMILA + "job/x/record/", _helper.getPushRecordToJobResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getPushBulkToJobResource(java.lang.String)}.
   */
  public void testGetJobPushBulkPath() {
    assertEquals(SMILA + "job/x/bulk/", _helper.getPushBulkToJobResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getTasksResource()}.
   */
  public void testGetTasksPath() {
    assertEquals(SMILA + "tasks/", _helper.getTasksResource());
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getTasksForWorkerResource(java.lang.String, java.lang.String)}
   * .
   */
  public void testGetTaskPath() {
    assertEquals(SMILA + "tasks/x/y/", _helper.getTasksForWorkerResource("x", "y"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getTasksInProgressForWorkerResource(java.lang.String)}.
   */
  public void testGetTaskInProgressPathString() {
    assertEquals(SMILA + "tasks/x/inprogress/", _helper.getTasksInProgressForWorkerResource("x"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getTasksToDoForWorkerResource(java.lang.String)}.
   */
  public void testGetTaskToDoPathString() {
    assertEquals(SMILA + "tasks/x/todo/", _helper.getTasksToDoForWorkerResource("x"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getTaskInProgressResource(java.lang.String, java.lang.String)}
   * .
   */
  public void testGetTaskInProgressPathStringString() {
    assertEquals(SMILA + "tasks/x/inprogress/y/", _helper.getTaskInProgressResource("x", "y"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getTaskToDoResource(java.lang.String, java.lang.String)}.
   */
  public void testGetTaskToDoPathStringString() {
    assertEquals(SMILA + "tasks/x/todo/y/", _helper.getTaskToDoResource("x", "y"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getImportingResource()}.
   */
  public void testGetImportingBasePath() {
    assertEquals(SMILA + "importing/", _helper.getImportingResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getDeltaServicesResource()}.
   */
  public void testGetDeltaServicePath() {
    assertEquals(SMILA + "importing/delta/", _helper.getDeltaServicesResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getDeltaServiceResource(java.lang.String)} .
   */
  public void testGetDeltaServicePathString() {
    assertEquals(SMILA + "importing/delta/x/", _helper.getDeltaServiceResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getVisitedLinksResource()}.
   */
  public void testGetVisitedLinksPath() {
    assertEquals(SMILA + "importing/visitedlinks/", _helper.getVisitedLinksResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getVisitedLinksResource(java.lang.String)} .
   */
  public void testGetVisitedLinksPathString() {
    assertEquals(SMILA + "importing/visitedlinks/x/", _helper.getVisitedLinksResource("x"));
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getStoresResource()}.
   */
  public void testGetStoresPath() {
    assertEquals(SMILA + "store/", _helper.getStoresResource());
  }

  /**
   * Test method for {@link org.eclipse.smila.http.client.ResourceHelper#getStoreResource(java.lang.String)}.
   */
  public void testGetStorePath() {
    assertEquals(SMILA + "store/x/", _helper.getStoreResource("x"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.ResourceHelper#getStoreObjectResource(java.lang.String, java.lang.String)} .
   */
  public void testGetStoreObjectPath() {
    assertEquals(SMILA + "store/x/y/", _helper.getStoreObjectResource("x", "y"));
  }

}
